/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.facade;

import br.com.elotech.commandLayer.Command;
import br.com.elotech.commandLayer.CommandTransactional;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.facadeLayer.Facade;
import br.com.elotech.portalarrecadacao.command.CommandGeraBloqueto;
import br.com.elotech.portalarrecadacao.command.CommandGeraCarneAlvaraOnline;
import br.com.elotech.portalarrecadacao.command.CommandGerarDebito;
import br.com.elotech.portalarrecadacao.command.CommandGerarDebitoWeb;
import br.com.elotech.portalarrecadacao.command.CommandLoginTotem;
import br.com.elotech.portalarrecadacao.ws.oxm.GeraDebito;
import br.com.elotech.portalarrecadacao.ws.oxm.GeraDebitoWeb;
import br.com.elotech.portalarrecadacao.ws.oxm.GeraDebitoWebEnvio;
import br.com.elotech.tributacao.command.CommandCarregaDebito;
import br.com.elotech.tributacao.command.CommandCarregaGuiaRecolhimentoAlvara;
import br.com.elotech.tributacao.command.CommandCarregaReceitaAlvara;
import br.com.elotech.tributacao.domain.aise.DebitoEntity;
import br.com.elotech.tributacao.domain.aise.DebitoParcelaEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import br.com.elotech.tributacao.domain.aise.GuiaRecolhimentoEntity;
import br.com.elotech.tributacao.domain.aise.ReceitaEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import java.util.Date;
import java.util.List;

public abstract class FacadeDebitos
extends Facade {
    private static final long serialVersionUID = 1L;

    protected abstract CommandGerarDebito getCommandGerarDebito();

    protected abstract CommandGerarDebitoWeb getCommandGerarDebitoWeb();

    protected abstract CommandCarregaGuiaRecolhimentoAlvara getCommandCarregaGuiaRecolhimentoAlvara();

    protected abstract CommandCarregaReceitaAlvara getCommandCarregaReceitaAlvara();

    protected abstract CommandCarregaDebito getCommandCarregaDebito();

    protected abstract CommandGeraBloqueto getCommandGeraBloqueto();

    protected abstract CommandLoginTotem getCommandLoginTotem();

    protected abstract CommandGeraCarneAlvaraOnline getGeraCarneAlvaraOnline();

    public GuiaRecolhimentoEntity carregaGuiaRecolhimentoAlvara(EntidadeTributacaoEntity entidadeTributacao) throws BaseException {
        Long entidade = entidadeTributacao.getId().getEntidade().getId();
        Long exercicio = entidadeTributacao.getId().getExercicioTributacao().getExercicio();
        CommandCarregaGuiaRecolhimentoAlvara command = this.getCommandCarregaGuiaRecolhimentoAlvara();
        command.setEntidade(entidade);
        command.setExercicio(exercicio);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getGuiaRecolhimento();
    }

    public ReceitaEntity carregaReceitaAlvara(EntidadeTributacaoEntity entidadeTributacao) throws BaseException {
        Long entidade = entidadeTributacao.getId().getEntidade().getId();
        Long exercicio = entidadeTributacao.getId().getExercicioTributacao().getExercicio();
        CommandCarregaReceitaAlvara command = this.getCommandCarregaReceitaAlvara();
        command.setEntidade(entidade);
        command.setExercicio(exercicio);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getReceita();
    }

    public DebitoEntity carregaDebito(Long idDebito) throws BaseException {
        CommandCarregaDebito command = this.getCommandCarregaDebito();
        command.setIdDebito(idDebito);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getDebito();
    }

    public GeraDebito geraDebito(String usuario, String senha, Long exercicio, Long tipoCadastro, Long cadastroGeral, String cnpjCpf, Integer guiaRecolhimento, String receita, Double valorPrincipal, String telaOrigem, String observacao, Date dataVencimento) throws BaseException {
        CommandGerarDebito command = this.getCommandGerarDebito();
        command.setUsuario(usuario);
        command.setSenha(senha);
        command.setExercicio(exercicio);
        command.setTipoCadastro(tipoCadastro);
        command.setCadastroGeral(cadastroGeral);
        command.setCnpjCpf(cnpjCpf);
        command.setGuiaRecolhimento(guiaRecolhimento);
        command.setReceita(receita);
        command.setValorPrincipal(valorPrincipal);
        command.setTelaOrigem(telaOrigem);
        command.setObservacao(observacao);
        command.setDataVencimento(dataVencimento);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getGerarDebito();
    }

    public GeraDebitoWeb gerarDebitoWeb(String usuario, String senha, GeraDebitoWebEnvio envio) throws BaseException {
        CommandGerarDebitoWeb command = this.getCommandGerarDebitoWeb();
        command.setUsuario(usuario);
        command.setSenha(senha);
        command.setEnvio(envio);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getGerarDebito();
    }

    public Integer geraBloqueto(UsuarioEntity usuario, List<DebitoParcelaEntity> parcelas) throws BaseException {
        CommandGeraBloqueto command = this.getCommandGeraBloqueto();
        command.setUsuario(usuario);
        command.setParcelas(parcelas);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getIdBloqueto();
    }

    public String loginWeb() throws BaseException {
        CommandLoginTotem command = this.getCommandLoginTotem();
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getUserKey();
    }

    public String geraCarneAlvaraOnline(String debito, Boolean emiteCotaUnica) throws BaseException {
        CommandGeraCarneAlvaraOnline command = this.getGeraCarneAlvaraOnline();
        command.setDebito(debito);
        command.setEmiteCotaUnica(emiteCotaUnica);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getCarne();
    }
}

