/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.facade;

import br.com.elotech.commandLayer.Command;
import br.com.elotech.commandLayer.CommandTransactional;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.facadeLayer.Facade;
import br.com.elotech.portalarrecadacao.command.CommandAtribuiValoresSolicitacaoAtividade;
import br.com.elotech.portalarrecadacao.command.CommandBuscaImobiliarioTestadaPrincipalByCodImob;
import br.com.elotech.portalarrecadacao.command.CommandBuscarTestadaGenericaPrincipal;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaAtividadeMei;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaAtividadeMeiPorMobiliario;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaAtividadesCbo;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaAtividadesCboPorDescricao;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaAtividadesCnae;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaAtividadesCnaePorMobiliario;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaAtividadesMeiNaoPermitidas;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaCboNaoPermitido;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaCnaePorDescricao;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaCnaesNaoPermitidos;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaMeiPorDescricao;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaMobiliarioCboPorMobiliario;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaMobiliarioMeiPorMobiliario;
import br.com.elotech.portalarrecadacao.command.CommandCarregaMobiliarioCnaePorCnae;
import br.com.elotech.portalarrecadacao.command.CommandCarregaTabelaAtividadesAtuais;
import br.com.elotech.portalarrecadacao.command.CommandConsultaAtividade;
import br.com.elotech.portalarrecadacao.command.CommandConsultaAtividadeCnaeWS;
import br.com.elotech.portalarrecadacao.command.CommandConsultaAtividadeMeiPorCnae;
import br.com.elotech.portalarrecadacao.command.CommandConsultaAtividadeMeiPorId;
import br.com.elotech.portalarrecadacao.command.CommandConsultaAtividadePorCodigo;
import br.com.elotech.portalarrecadacao.command.CommandConsultaCboPorCodigo;
import br.com.elotech.portalarrecadacao.command.CommandGetCodTaxaLocalizacao;
import br.com.elotech.portalarrecadacao.command.CommandRemoverAtividadeNumeroConselho;
import br.com.elotech.portalarrecadacao.command.CommandSalvarAtividadesSolicitacao;
import br.com.elotech.portalarrecadacao.command.CommandVerificaCboNaConfiguracaoAtividade;
import br.com.elotech.portalarrecadacao.command.CommandVerificaCnaeNaConfiguracaoAtividade;
import br.com.elotech.portalarrecadacao.command.CommandVerificaCnaePrestadorServico;
import br.com.elotech.portalarrecadacao.command.CommandVerificaMeiNaConfiguracaoAtividade;
import br.com.elotech.portalarrecadacao.command.CommandVerificarCnaePermitidoMeiPrestador;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraNumConselhoEntity;
import br.com.elotech.portalarrecadacao.domain.vo.ConsultaAtividadeVo;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.ConsultaAtividadeEnvio;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RetornaAtividadeResponse;
import br.com.elotech.tributacao.domain.aise.AtividadeMeiEntity;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAisePK;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioTestadaEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioTestadaGenericaEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioAtividadeMeiEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioCboEntity;
import br.com.elotech.tributacao.domain.aise.CnaeEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioCnaeEntity;
import br.com.elotech.tributacao.domain.aise.RhCboEntity;
import br.com.elotech.tributacao.interfaces.Atividade;
import java.util.ArrayList;
import java.util.List;

public abstract class FacadeAlteracaoAtividades
extends Facade {
    private static final long serialVersionUID = 1L;

    protected abstract CommandCarregaListaAtividadesCbo getCommandCarregaListaAtividadesCbo();

    protected abstract CommandCarregaListaAtividadesCnae getCommandCarregaListaAtividadesCnae();

    protected abstract CommandCarregaListaAtividadesCnaePorMobiliario getCommandCarregaListaAtividadesCnaePorMobiliario();

    protected abstract CommandCarregaMobiliarioCnaePorCnae getCommandCarregaMobiliarioCnaePorCnae();

    protected abstract CommandCarregaListaAtividadeMeiPorMobiliario getCommandCarregaListaAtividadeMeiPorMobiliario();

    protected abstract CommandCarregaListaAtividadeMei getCommandCarregaListaAtividadeMei();

    protected abstract CommandCarregaListaCboNaoPermitido getCommandCarregaListaCboNaoPermitido();

    protected abstract CommandCarregaListaCnaesNaoPermitidos getCommandCarregaListaCnaesNaoPermitidos();

    protected abstract CommandCarregaListaAtividadesMeiNaoPermitidas getCommandCarregaListaAtividadesMeiNaoPermitidas();

    protected abstract CommandCarregaListaAtividadesCboPorDescricao getCommandCarregaListaAtividadesCboPorDescricao();

    protected abstract CommandVerificaCboNaConfiguracaoAtividade getCommandVerificaCboNaConfiguracaoAtividade();

    protected abstract CommandCarregaListaMeiPorDescricao getCommandCarregaListaMeiPorDescricao();

    protected abstract CommandVerificaMeiNaConfiguracaoAtividade getCommandVerificaMeiNaConfiguracaoAtividade();

    protected abstract CommandVerificaCnaeNaConfiguracaoAtividade getCommandVerificaCnaeNaConfiguracaoAtividade();

    protected abstract CommandCarregaListaCnaePorDescricao getCommandCarregaListaCnaePorDescricao();

    protected abstract CommandCarregaListaMobiliarioCboPorMobiliario getCommandCarregaListaMobiliarioCboPorMobiliario();

    protected abstract CommandCarregaListaMobiliarioMeiPorMobiliario getCommandCarregaListaMobiliarioMeiPorMobiliario();

    protected abstract CommandConsultaCboPorCodigo getCommandConsultaCboPorCodigo();

    protected abstract CommandConsultaAtividadeMeiPorCnae getCommandConsultaAtividadeMeiPorCnae();

    protected abstract CommandConsultaAtividadeMeiPorId getCommandConsultaAtividadeMeiPorId();

    protected abstract CommandConsultaAtividadeCnaeWS getCommandConsultaAtividadeCnaeWS();

    protected abstract CommandBuscaImobiliarioTestadaPrincipalByCodImob getCommandBuscaImobiliarioTestadabyCodImob();

    protected abstract CommandVerificaCnaePrestadorServico getCommandVerificaCnaePrestadorServico();

    protected abstract CommandSalvarAtividadesSolicitacao getCommandSalvarAtividadesSolicitacao();

    protected abstract CommandConsultaAtividade getCommandConsultaAtividade();

    protected abstract CommandCarregaTabelaAtividadesAtuais getCommandCarregaTabelaAtividadesAtuais();

    protected abstract CommandConsultaAtividadePorCodigo getCommandConsultaAtividadePorCodigo();

    protected abstract CommandAtribuiValoresSolicitacaoAtividade getCommandAtribuiValoresSolicitacaoAtividade();

    protected abstract CommandGetCodTaxaLocalizacao getCommandGetCodTaxaLocalizacao();

    protected abstract CommandRemoverAtividadeNumeroConselho getCommandRemoverAtividadeNumeroConselho();

    protected abstract CommandBuscarTestadaGenericaPrincipal getCommandBuscarTestadaGenericaPrincipal();

    protected abstract CommandVerificarCnaePermitidoMeiPrestador getCommandVerificarCnaePermitidoMeiPrestador();

    public List<RhCboEntity> carregaListaAtividadeCbo(CadastroGeralAisePK cadastroGeralPK) throws BaseException {
        CommandCarregaListaAtividadesCbo command = this.getCommandCarregaListaAtividadesCbo();
        command.setCadastroGeralPK(cadastroGeralPK);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getListaAtividadesCbo();
    }

    public List<CnaeEntity> carregaListaAtividadeCnae(CadastroGeralAisePK cadastroGeralPK) throws BaseException {
        CommandCarregaListaAtividadesCnae command = this.getCommandCarregaListaAtividadesCnae();
        command.setCadastroGeralPK(cadastroGeralPK);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getListaAtividadesCnae();
    }

    public List<MobiliarioCnaeEntity> carregaListaAtividadesCnaePorMobiliario(Long codigo) throws BaseException {
        CommandCarregaListaAtividadesCnaePorMobiliario command = this.getCommandCarregaListaAtividadesCnaePorMobiliario();
        command.setCodigo(codigo);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getListaAtividadesCnaePorMobiliario();
    }

    public List<AtividadeMeiEntity> carregaListaAtividadeMei(CadastroGeralAisePK cadastroGeralPK) throws BaseException {
        CommandCarregaListaAtividadeMei command = this.getCommandCarregaListaAtividadeMei();
        command.setCadastroGeralPK(cadastroGeralPK);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getAtividadesMei();
    }

    public List<AtividadeMeiEntity> carregaListaAtividadeMeiPorMobiliario(Long codigo) throws BaseException {
        CommandCarregaListaAtividadeMeiPorMobiliario command = this.getCommandCarregaListaAtividadeMeiPorMobiliario();
        command.setCodigo(codigo);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getListaAtividadeMei();
    }

    public MobiliarioCnaeEntity carregaMobiliarioCnaePorCnae(String cnae, Long cadastroGeral) throws BaseException {
        CommandCarregaMobiliarioCnaePorCnae command = this.getCommandCarregaMobiliarioCnaePorCnae();
        command.setCnae(cnae);
        command.setCadastroGeral(cadastroGeral);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getCarregaMobiliarioCnaePorCnae(cnae);
    }

    public List<RhCboEntity> carregaListaCboNaoPermitido(CadastroGeralAisePK cadastroGeralPK) throws BaseException {
        CommandCarregaListaCboNaoPermitido command = this.getCommandCarregaListaCboNaoPermitido();
        command.setCadastroGeralPK(cadastroGeralPK);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getCbosNaoPermitidos();
    }

    public List<CnaeEntity> carregaListaCnaesNaoPermitidos(CadastroGeralAisePK cadastroGeralPK) throws BaseException {
        CommandCarregaListaCnaesNaoPermitidos command = this.getCommandCarregaListaCnaesNaoPermitidos();
        command.setCadastroGeralPK(cadastroGeralPK);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getCnaesNaoPermitidos();
    }

    public List<AtividadeMeiEntity> carregaListaAtividadesMeiNaoPermitidas(CadastroGeralAisePK cadastroGeralPK) throws BaseException {
        CommandCarregaListaAtividadesMeiNaoPermitidas command = this.getCommandCarregaListaAtividadesMeiNaoPermitidas();
        command.setCadastroGeralPK(cadastroGeralPK);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getAtividadesNaoPermitidas();
    }

    public List<RhCboEntity> carregaListaAtividadesCboPorDescricao(String descricao) throws BaseException {
        CommandCarregaListaAtividadesCboPorDescricao command = this.getCommandCarregaListaAtividadesCboPorDescricao();
        command.setDescricao(descricao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getListaAtividadesCbo();
    }

    public boolean verificarCboExisteNaConfiguracaoAtividade(CadastroGeralAisePK cadastroGeralPK, String codCbo) throws BaseException {
        CommandVerificaCboNaConfiguracaoAtividade command = this.getCommandVerificaCboNaConfiguracaoAtividade();
        command.setCadastroGeralPK(cadastroGeralPK);
        command.setCodigoCbo(codCbo);
        this.getCommandContainer().executeCommand((Command)command);
        return command.verificarCbo();
    }

    public List<AtividadeMeiEntity> carregarListaMeiPorDescricao(String descricao, String prestador) throws BaseException {
        CommandCarregaListaMeiPorDescricao command = this.getCommandCarregaListaMeiPorDescricao();
        command.setDescricao(descricao);
        command.setPrestador(prestador);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getAtividadeMei();
    }

    public boolean verificarMeiNaConfiguracaoAtividade(CadastroGeralAisePK cadastroGeralPK, String codCnae) throws BaseException {
        CommandVerificaMeiNaConfiguracaoAtividade command = this.getCommandVerificaMeiNaConfiguracaoAtividade();
        command.setCadastroGeralPK(cadastroGeralPK);
        command.setCodigoCnae(codCnae);
        this.getCommandContainer().executeCommand((Command)command);
        return command.verificarMei();
    }

    public List<CnaeEntity> carregarListaCnaePorDescricao(String descricao) throws BaseException {
        CommandCarregaListaCnaePorDescricao command = this.getCommandCarregaListaCnaePorDescricao();
        command.setDescricao(descricao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getListaCnae();
    }

    public boolean verificarCnaeNaConfiguracaoAtividade(CadastroGeralAisePK cadastroGeralPK, String codCnae) throws BaseException {
        CommandVerificaCnaeNaConfiguracaoAtividade command = this.getCommandVerificaCnaeNaConfiguracaoAtividade();
        command.setCadastroGeralPK(cadastroGeralPK);
        command.setCodigoCnae(codCnae);
        this.getCommandContainer().executeCommand((Command)command);
        return command.verificarCnae();
    }

    public List<CadastroMobiliarioCboEntity> carregarListaMobiliarioCboPorMobiliario(Long cadastroGeral) throws BaseException {
        CommandCarregaListaMobiliarioCboPorMobiliario command = this.getCommandCarregaListaMobiliarioCboPorMobiliario();
        command.setCodigo(cadastroGeral);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getListaMobiliarioCbo();
    }

    public List<CadastroMobiliarioAtividadeMeiEntity> carregarListaMobiliarioMeiPorMobiliario(Long cadastroGeral) throws BaseException {
        CommandCarregaListaMobiliarioMeiPorMobiliario command = this.getCommandCarregaListaMobiliarioMeiPorMobiliario();
        command.setCodigo(cadastroGeral);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getMobiliarioMei();
    }

    public List<Atividade> consultaAtividadeMeiPorCnae(String codigoAtividade, String prestador) throws BaseException {
        CommandConsultaAtividadeMeiPorCnae command = this.getCommandConsultaAtividadeMeiPorCnae();
        command.setCodigoAtividade(codigoAtividade);
        command.setPrestador(prestador);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return new ArrayList<Atividade>(command.getAtividadeMei());
    }

    public Atividade consultaAtividadeMeiPorId(Long idAtividadeMei) throws BaseException {
        CommandConsultaAtividadeMeiPorId command = this.getCommandConsultaAtividadeMeiPorId();
        command.setIdAtividadeMei(idAtividadeMei);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getAtividadeMei();
    }

    public RetornaAtividadeResponse consultaAtividadeCnaeWS(ConsultaAtividadeEnvio envio) throws BaseException {
        CommandConsultaAtividadeCnaeWS command = this.getCommandConsultaAtividadeCnaeWS();
        command.setConsultaAtividadeEnvio(envio);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getConsultaAtividadeResposta();
    }

    public CadastroImobiliarioTestadaEntity buscarTestadaPrincipalByCodImob(Long codImobiliario) throws BaseException {
        CommandBuscaImobiliarioTestadaPrincipalByCodImob command = this.getCommandBuscaImobiliarioTestadabyCodImob();
        command.setCodImobiliario(codImobiliario);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getCadastroImobiliarioTestadaEntity();
    }

    public boolean verificaCnaePrestadorServico(Atividade atividade) throws BaseException {
        CommandVerificaCnaePrestadorServico command = this.getCommandVerificaCnaePrestadorServico();
        command.setAtividade(atividade);
        this.getCommandContainer().executeCommand((Command)command);
        return command.isPrestador();
    }

    public boolean verificaCnaePrestadorServico(List<String> codigos) throws BaseException {
        CommandVerificaCnaePrestadorServico command = this.getCommandVerificaCnaePrestadorServico();
        command.setCodigos(codigos);
        this.getCommandContainer().executeCommand((Command)command);
        return command.isPrestador();
    }

    public void salvarAtividadesSolicitacao(SolicitacaoAlvaraAtividadeEntity solicitacaoAlvaraAtividade) throws BaseException {
        CommandSalvarAtividadesSolicitacao command = this.getCommandSalvarAtividadesSolicitacao();
        command.setSolicitacaoAlvaraAtividade(solicitacaoAlvaraAtividade);
        this.getCommandContainer().executeCommand((Command)command);
    }

    public RetornaAtividadeResponse consultarAtividade(ConsultaAtividadeVo consultaAtividadeVo) throws BaseException {
        CommandConsultaAtividade command = this.getCommandConsultaAtividade();
        command.setConsultaAtividadeVo(consultaAtividadeVo);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getResposta();
    }

    public void carregarTabelaAtividadesAtuais(ConsultaAtividadeVo consultaAtividadeVo) throws BaseException {
        CommandCarregaTabelaAtividadesAtuais command = this.getCommandCarregaTabelaAtividadesAtuais();
        command.setConsultaAtividadeVo(consultaAtividadeVo);
        this.getCommandContainer().executeCommand((Command)command);
    }

    public Atividade consultaAtividadePorCodigo(ConsultaAtividadeVo consultaAtividadeVo) throws BaseException {
        CommandConsultaAtividadePorCodigo command = this.getCommandConsultaAtividadePorCodigo();
        command.consultaAtividadeVo(consultaAtividadeVo);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getAtividade();
    }

    public List<SolicitacaoAlvaraAtividadeEntity> atribuiValoresSolicitacaoAtividade(SolicitacaoAlvaraEntity solicitacao, List<Atividade> listaAtividade) throws BaseException {
        CommandAtribuiValoresSolicitacaoAtividade command = this.getCommandAtribuiValoresSolicitacaoAtividade();
        command.setAtividades(listaAtividade);
        command.setSolicitacao(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getListaSolicitacaoAlvaraAtividade();
    }

    public Integer getTaxaLocalizacao(SolicitacaoAlvaraEntity solicitacao, List<Atividade> listaAtividade) throws BaseException {
        CommandGetCodTaxaLocalizacao command = this.getCommandGetCodTaxaLocalizacao();
        command.setSolicitacao(solicitacao);
        command.setListaAtividade(listaAtividade);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getCodTaxaLocalizacao();
    }

    public void removerAtividadeNumeroConselho(SolicitacaoAlvaraNumConselhoEntity atividadeNumeroConselho) throws BaseException {
        CommandRemoverAtividadeNumeroConselho command = this.getCommandRemoverAtividadeNumeroConselho();
        command.setAtividadeNumeroConselho(atividadeNumeroConselho);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }

    public CadastroImobiliarioTestadaGenericaEntity buscarTestadaGenericaPrincipal(CadastroGeralAisePK cadastroGeralPK) throws BaseException {
        CommandBuscarTestadaGenericaPrincipal command = this.getCommandBuscarTestadaGenericaPrincipal();
        command.setCadastroGeralAisePK(cadastroGeralPK);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getTestadaPrincipal();
    }

    public boolean isCnaePermitidoParaMeiPrestador(String codigoCnae) throws BaseException {
        CommandVerificarCnaePermitidoMeiPrestador command = this.getCommandVerificarCnaePermitidoMeiPrestador();
        command.setCodigoCnae(codigoCnae);
        this.getCommandContainer().executeCommand((Command)command);
        return command.isCnaePermitidoParaMeiPrestador();
    }
}

