/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.enumerator;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public enum SituacaoConsultaPreviaRedeSimEnum implements Serializable
{
    AGUARDANDO_SOLICITACAO("AS", "Aguardando Solicita\u00e7\u00e3o"),
    ANALISE("AN", "An\u00e1lise"),
    DEFERIDO("DEF", "Deferido"),
    INDEFERIDO("IND", "Indeferido"),
    ERRO("ERR", "Erro"),
    EXIGENCIA("EX", "Exig\u00eancia"),
    RESP_EXIGENCIA("REX", "Resposta Exig\u00eancia"),
    ENCAMINHADO_VISTORIA("EV", "Encaminhado Vistoria"),
    DEBITOS_GERADOS("DG", "D\u00e9bitos Gerados"),
    DEBITOS_ENVIADOS("DE", "D\u00e9bitos Enviados"),
    DEBITO_PAGO("DP", "D\u00e9bito Pago"),
    CADASTRO_ANALISE("CA", "Cadastro em An\u00e1lise"),
    ALVARA_EMITIDO("AE", "Alvar\u00e1 Emitido"),
    ALVARA_FUNCIONAMENTO_PROVISORIO("AFP", "Alvar\u00e1 de Funcionamento Provis\u00f3rio"),
    ALVARA_PROVISORIO_LAUDO("APL", "Alvar\u00e1 Provis\u00f3rio Laudo"),
    LAUDOS_LIBERADOS("LL", "Laudos Liberados Definitivos"),
    ANULADO("ANU", "Anulado pelo sistema"),
    SUSPENSO("SUS", "Documento Suspenso"),
    ALVARA_ENVIADO("AV", "Alvar\u00e1 Enviado"),
    ALVARA_FUNCIONAMENTO_PROVISORIO_ENVIADO("AFV", "Alvar\u00e1 de Funcionamento Provis\u00f3rio Enviado"),
    SOLICITACAO_INCONSISTENTE("SI", "Solicita\u00e7\u00e3o Inconsistente"),
    CONSULTA_INDEFERIDA("CI", "Consulta Indeferida"),
    CONSULTA_INCONSISTENTE("CIN", "Consulta Inconsistente"),
    RESTRICAO_CADASTRAL("RC", "Restri\u00e7\u00e3o Cadastral"),
    INSCRICAO_ENVIADA("IE", "Inscri\u00e7\u00e3o Municipal Enviada"),
    INSCRICAO_GERADA("IG", "Inscri\u00e7\u00e3o Municipal Gerada"),
    CADASTRO_GERADO_LIBERDADE_ECONOMICA("CGL", "Cadastro Gerado para Liberdade Econ\u00f4mica"),
    CADASTRO_GERADO_MODO_SIMPLIFICADO("MS", "Cadastro Gerado/Atualizado pelo Modo Simplificado"),
    CADASTRO_GERADO_MEI("MEI", "Cadastro gerado para MEI"),
    NAO_PROCESSADO("NP", "Registro n\u00e3o processado"),
    AGUARDANDO_GERACAO_DEBITO("AGD", "Aguardando gera\u00e7\u00e3o do d\u00e9bito"),
    TERMO_DISPENSA_GERADO("TDG", "Termo de Dispensa Gerado"),
    TERMO_DISPENSA_ENVIADO("TDE", "Termo de Dispensa Enviado"),
    SOLICITACAO_BAIXA("BX", "Solicita\u00e7\u00e3o de Baixa"),
    SOLICITACAO_BAIXA_FINALIZADA("BXF", "Solicita\u00e7\u00e3o de Baixa Finalizada"),
    ENDERECO_ALTERADO("EA", "Endere\u00e7o Alterado"),
    ENDERECO_INCONSISTENTE("EI", "Endere\u00e7o Inconsistente");

    private String sigla;
    private String texto;

    private SituacaoConsultaPreviaRedeSimEnum(String sigla, String texto) {
        this.sigla = sigla;
        this.texto = texto;
    }

    public String getSigla() {
        return this.sigla;
    }

    public String getTexto() {
        return this.texto;
    }

    public static SituacaoConsultaPreviaRedeSimEnum fromString(String sigla) {
        if (sigla != null) {
            for (SituacaoConsultaPreviaRedeSimEnum situacao : SituacaoConsultaPreviaRedeSimEnum.values()) {
                if (!sigla.equalsIgnoreCase(situacao.sigla)) continue;
                return situacao;
            }
        }
        return null;
    }

    public static String getSiglaFromText(String text) {
        for (SituacaoConsultaPreviaRedeSimEnum situacao : SituacaoConsultaPreviaRedeSimEnum.values()) {
            if (!situacao.getTexto().equals(text)) continue;
            return situacao.getSigla();
        }
        return "";
    }

    public static String getTextFromSigla(String sigla) {
        for (SituacaoConsultaPreviaRedeSimEnum situacao : SituacaoConsultaPreviaRedeSimEnum.values()) {
            if (!sigla.equals(situacao.getSigla())) continue;
            return situacao.getTexto();
        }
        return "";
    }

    public static List<String> getSiglaFromText(List<String> text) {
        ArrayList<String> siglaFromText = new ArrayList<String>();
        for (String t : text) {
            siglaFromText.add(SituacaoConsultaPreviaRedeSimEnum.getSiglaFromText((String)t));
        }
        return siglaFromText;
    }

    public static List<SituacaoConsultaPreviaRedeSimEnum> getSituacoesConsultaRedeSim() {
        ArrayList<SituacaoConsultaPreviaRedeSimEnum> situacoes = new ArrayList<SituacaoConsultaPreviaRedeSimEnum>();
        situacoes.add(ANALISE);
        situacoes.add(DEFERIDO);
        situacoes.add(INDEFERIDO);
        return situacoes;
    }

    public static List<SituacaoConsultaPreviaRedeSimEnum> getSituacoesSolicitacaoRedeSim() throws BaseException {
        ArrayList<SituacaoConsultaPreviaRedeSimEnum> situacoes = new ArrayList<SituacaoConsultaPreviaRedeSimEnum>();
        situacoes.add(ANALISE);
        if (UtilsController.isIntegracaoSimplificadaRedeSim()) {
            situacoes.add(CADASTRO_GERADO_MODO_SIMPLIFICADO);
        } else {
            situacoes.add(ENCAMINHADO_VISTORIA);
            situacoes.add(CADASTRO_ANALISE);
        }
        situacoes.add(EXIGENCIA);
        situacoes.add(RESP_EXIGENCIA);
        situacoes.add(DEBITO_PAGO);
        situacoes.add(DEBITOS_GERADOS);
        situacoes.add(DEBITOS_ENVIADOS);
        situacoes.add(AGUARDANDO_SOLICITACAO);
        situacoes.add(LAUDOS_LIBERADOS);
        situacoes.add(ANULADO);
        situacoes.add(INDEFERIDO);
        situacoes.add(ALVARA_EMITIDO);
        situacoes.add(ALVARA_FUNCIONAMENTO_PROVISORIO);
        situacoes.add(SUSPENSO);
        situacoes.add(ALVARA_ENVIADO);
        situacoes.add(ALVARA_FUNCIONAMENTO_PROVISORIO_ENVIADO);
        situacoes.add(SOLICITACAO_INCONSISTENTE);
        situacoes.add(CONSULTA_INDEFERIDA);
        situacoes.add(CONSULTA_INCONSISTENTE);
        situacoes.add(RESTRICAO_CADASTRAL);
        situacoes.add(CADASTRO_GERADO_LIBERDADE_ECONOMICA);
        situacoes.add(INSCRICAO_GERADA);
        situacoes.add(NAO_PROCESSADO);
        situacoes.add(AGUARDANDO_GERACAO_DEBITO);
        situacoes.add(INSCRICAO_ENVIADA);
        situacoes.add(CADASTRO_GERADO_MEI);
        situacoes.add(TERMO_DISPENSA_GERADO);
        situacoes.add(TERMO_DISPENSA_ENVIADO);
        situacoes.add(ENDERECO_ALTERADO);
        situacoes.add(ENDERECO_INCONSISTENTE);
        return situacoes.stream().sorted(Comparator.comparing(SituacaoConsultaPreviaRedeSimEnum::getTexto)).collect(Collectors.toList());
    }

    public static List<String> getTiposSituacoesConsultaTexto() {
        ArrayList<String> tiposSituacoes = new ArrayList<String>();
        for (SituacaoConsultaPreviaRedeSimEnum situacaoEnum : SituacaoConsultaPreviaRedeSimEnum.getSituacoesConsultaRedeSim()) {
            tiposSituacoes.add(situacaoEnum.getTexto());
        }
        return tiposSituacoes;
    }

    public static List<String> getTiposSituacoesSolicitacaoTexto() throws BaseException {
        ArrayList<String> tiposSituacoes = new ArrayList<String>();
        for (SituacaoConsultaPreviaRedeSimEnum situacaoEnum : SituacaoConsultaPreviaRedeSimEnum.getSituacoesSolicitacaoRedeSim()) {
            tiposSituacoes.add(situacaoEnum.getTexto());
        }
        return tiposSituacoes;
    }
}

