/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dto.webiss;

import br.com.elotech.portalarrecadacao.dto.webiss.TipoEnderecoWebIssDTO;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAiseEntity;
import br.com.elotech.tributacao.domain.aise.LogradouroEntity;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Optional;

public class EnderecoWebIssDTO {
    @JsonProperty(value="Tipo")
    private String tipo;
    @JsonProperty(value="Logradouro")
    private String logradouro;
    @JsonProperty(value="CEP")
    private String cep;
    @JsonProperty(value="Numero")
    private String numero;
    @JsonProperty(value="Complemento")
    private String complemento;
    @JsonProperty(value="Referencia")
    private String referencia;

    public static EnderecoWebIssDTO from(CadastroGeralAiseEntity cadastroGeral, TipoEnderecoWebIssDTO tipoEndereco) {
        EnderecoWebIssDTO dto = new EnderecoWebIssDTO();
        dto.setCep((String)Optional.ofNullable(cadastroGeral.getCep()).map(BigDecimal::toString).orElse(null));
        dto.setComplemento(cadastroGeral.getComplemento());
        dto.setLogradouro((String)Optional.ofNullable(cadastroGeral.getLogradouro()).map(LogradouroEntity::getDescricao).orElse(null));
        dto.setNumero(cadastroGeral.getNumero());
        dto.setTipo(tipoEndereco.getDescricao());
        return dto;
    }

    public String getTipo() {
        return this.tipo;
    }

    public String getLogradouro() {
        return this.logradouro;
    }

    public String getCep() {
        return this.cep;
    }

    public String getNumero() {
        return this.numero;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public String getReferencia() {
        return this.referencia;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public void setReferencia(String referencia) {
        this.referencia = referencia;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnderecoWebIssDTO)) {
            return false;
        }
        EnderecoWebIssDTO other = (EnderecoWebIssDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$tipo = this.getTipo();
        String other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        String this$logradouro = this.getLogradouro();
        String other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro)) {
            return false;
        }
        String this$cep = this.getCep();
        String other$cep = other.getCep();
        if (this$cep == null ? other$cep != null : !this$cep.equals(other$cep)) {
            return false;
        }
        String this$numero = this.getNumero();
        String other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !this$numero.equals(other$numero)) {
            return false;
        }
        String this$complemento = this.getComplemento();
        String other$complemento = other.getComplemento();
        if (this$complemento == null ? other$complemento != null : !this$complemento.equals(other$complemento)) {
            return false;
        }
        String this$referencia = this.getReferencia();
        String other$referencia = other.getReferencia();
        return !(this$referencia == null ? other$referencia != null : !this$referencia.equals(other$referencia));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EnderecoWebIssDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        String $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        String $cep = this.getCep();
        result = result * 59 + ($cep == null ? 43 : $cep.hashCode());
        String $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : $numero.hashCode());
        String $complemento = this.getComplemento();
        result = result * 59 + ($complemento == null ? 43 : $complemento.hashCode());
        String $referencia = this.getReferencia();
        result = result * 59 + ($referencia == null ? 43 : $referencia.hashCode());
        return result;
    }

    public String toString() {
        return "EnderecoWebIssDTO(tipo=" + this.getTipo() + ", logradouro=" + this.getLogradouro() + ", cep=" + this.getCep() + ", numero=" + this.getNumero() + ", complemento=" + this.getComplemento() + ", referencia=" + this.getReferencia() + ")";
    }
}

