/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dto;

import br.com.elotech.portalarrecadacao.domain.ZoneamentoPermitidoEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.interfaces.Atividade;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Objects;

public class ZoneamentoPermitidoDTO {
    private String cnae;
    private Boolean exigeAnexo = Boolean.FALSE;
    private BigDecimal areaMax;
    private String secaoCnae;
    private String siglaZona;

    public static ZoneamentoPermitidoDTO from(ZoneamentoPermitidoEntity zoneamentoPermitidoEntity, Atividade atividade) {
        if (Objects.isNull(zoneamentoPermitidoEntity)) {
            return null;
        }
        ZoneamentoPermitidoDTO zoneamentoPermitidoDTO = new ZoneamentoPermitidoDTO();
        zoneamentoPermitidoDTO.setCnae(atividade.getCodigo());
        zoneamentoPermitidoDTO.setSecaoCnae(atividade.getSecao());
        zoneamentoPermitidoDTO.setAreaMax(zoneamentoPermitidoEntity.getAreaMax());
        zoneamentoPermitidoDTO.setSiglaZona(zoneamentoPermitidoEntity.getZoneamento().getSigla());
        zoneamentoPermitidoDTO.setExigeAnexo(SimNaoEnum.equalSim((String)zoneamentoPermitidoEntity.getExigeAnexo()));
        return zoneamentoPermitidoDTO;
    }

    public String getCnae() {
        return this.cnae;
    }

    public Boolean getExigeAnexo() {
        return this.exigeAnexo;
    }

    public BigDecimal getAreaMax() {
        return this.areaMax;
    }

    public String getSecaoCnae() {
        return this.secaoCnae;
    }

    public String getSiglaZona() {
        return this.siglaZona;
    }

    public void setCnae(String cnae) {
        this.cnae = cnae;
    }

    public void setExigeAnexo(Boolean exigeAnexo) {
        this.exigeAnexo = exigeAnexo;
    }

    public void setAreaMax(BigDecimal areaMax) {
        this.areaMax = areaMax;
    }

    public void setSecaoCnae(String secaoCnae) {
        this.secaoCnae = secaoCnae;
    }

    public void setSiglaZona(String siglaZona) {
        this.siglaZona = siglaZona;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZoneamentoPermitidoDTO)) {
            return false;
        }
        ZoneamentoPermitidoDTO other = (ZoneamentoPermitidoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$cnae = this.getCnae();
        String other$cnae = other.getCnae();
        if (this$cnae == null ? other$cnae != null : !this$cnae.equals(other$cnae)) {
            return false;
        }
        Boolean this$exigeAnexo = this.getExigeAnexo();
        Boolean other$exigeAnexo = other.getExigeAnexo();
        if (this$exigeAnexo == null ? other$exigeAnexo != null : !((Object)this$exigeAnexo).equals(other$exigeAnexo)) {
            return false;
        }
        BigDecimal this$areaMax = this.getAreaMax();
        BigDecimal other$areaMax = other.getAreaMax();
        if (this$areaMax == null ? other$areaMax != null : !((Object)this$areaMax).equals(other$areaMax)) {
            return false;
        }
        String this$secaoCnae = this.getSecaoCnae();
        String other$secaoCnae = other.getSecaoCnae();
        if (this$secaoCnae == null ? other$secaoCnae != null : !this$secaoCnae.equals(other$secaoCnae)) {
            return false;
        }
        String this$siglaZona = this.getSiglaZona();
        String other$siglaZona = other.getSiglaZona();
        return !(this$siglaZona == null ? other$siglaZona != null : !this$siglaZona.equals(other$siglaZona));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZoneamentoPermitidoDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cnae = this.getCnae();
        result = result * 59 + ($cnae == null ? 43 : $cnae.hashCode());
        Boolean $exigeAnexo = this.getExigeAnexo();
        result = result * 59 + ($exigeAnexo == null ? 43 : ((Object)$exigeAnexo).hashCode());
        BigDecimal $areaMax = this.getAreaMax();
        result = result * 59 + ($areaMax == null ? 43 : ((Object)$areaMax).hashCode());
        String $secaoCnae = this.getSecaoCnae();
        result = result * 59 + ($secaoCnae == null ? 43 : $secaoCnae.hashCode());
        String $siglaZona = this.getSiglaZona();
        result = result * 59 + ($siglaZona == null ? 43 : $siglaZona.hashCode());
        return result;
    }

    public String toString() {
        return "ZoneamentoPermitidoDTO(cnae=" + this.getCnae() + ", exigeAnexo=" + this.getExigeAnexo() + ", areaMax=" + this.getAreaMax() + ", secaoCnae=" + this.getSecaoCnae() + ", siglaZona=" + this.getSiglaZona() + ")";
    }

    @ConstructorProperties(value={"cnae", "exigeAnexo", "areaMax", "secaoCnae", "siglaZona"})
    public ZoneamentoPermitidoDTO(String cnae, Boolean exigeAnexo, BigDecimal areaMax, String secaoCnae, String siglaZona) {
        this.cnae = cnae;
        this.exigeAnexo = exigeAnexo;
        this.areaMax = areaMax;
        this.secaoCnae = secaoCnae;
        this.siglaZona = siglaZona;
    }

    public ZoneamentoPermitidoDTO() {
    }
}

