/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain.vo;

import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroConsultaRedeSim;
import br.com.elotech.portalarrecadacao.enumerator.GrauDeRiscoEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.math.EloNumberUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/*
 * Exception performing whole class analysis ignored.
 */
public class FiltroConsultaRedeSim
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Date dataInicial;
    private Date dataFinal;
    private String nomeArquivo;
    private List<String> situacao;
    private String protocolo;
    private String tipo;
    private Long numeroSolicitacao;
    private Long exercicioSolicitacao;
    private String indeferido;
    private String motivoIndeferimento;
    private String numeroExercicioSolicitacao;
    private String situacaoSolicitacao;
    private String grauRisco;
    private boolean maisAntigas;
    private TipoInscricaoAlvaraEntity tipoInscricao;
    private NaturezaSolicitacaoAlvaraEntity naturezaSolicitacao;
    private Long evento;
    private Boolean alvaraEnviado;
    private Boolean redeSim;
    private Boolean laudosLiberados;
    private Boolean debitosEnviados;
    private String cnpjEmpresa;
    private String cpfSolicitante;
    private String ativo;
    private String inscricaoEnviada;

    private FiltroConsultaRedeSim(FiltroConsultaRedeSimBuilder builder) {
        this.dataInicial = FiltroConsultaRedeSimBuilder.access$100((FiltroConsultaRedeSimBuilder)builder);
        this.dataFinal = FiltroConsultaRedeSimBuilder.access$200((FiltroConsultaRedeSimBuilder)builder);
        this.nomeArquivo = FiltroConsultaRedeSimBuilder.access$300((FiltroConsultaRedeSimBuilder)builder);
        this.situacao = FiltroConsultaRedeSimBuilder.access$400((FiltroConsultaRedeSimBuilder)builder);
        this.protocolo = FiltroConsultaRedeSimBuilder.access$500((FiltroConsultaRedeSimBuilder)builder);
        this.tipo = FiltroConsultaRedeSimBuilder.access$600((FiltroConsultaRedeSimBuilder)builder);
        this.numeroSolicitacao = FiltroConsultaRedeSimBuilder.access$700((FiltroConsultaRedeSimBuilder)builder);
        this.exercicioSolicitacao = FiltroConsultaRedeSimBuilder.access$800((FiltroConsultaRedeSimBuilder)builder);
        this.indeferido = FiltroConsultaRedeSimBuilder.access$900((FiltroConsultaRedeSimBuilder)builder);
        this.motivoIndeferimento = FiltroConsultaRedeSimBuilder.access$1000((FiltroConsultaRedeSimBuilder)builder);
        this.maisAntigas = FiltroConsultaRedeSimBuilder.access$1100((FiltroConsultaRedeSimBuilder)builder);
        this.tipoInscricao = FiltroConsultaRedeSimBuilder.access$1200((FiltroConsultaRedeSimBuilder)builder);
        this.naturezaSolicitacao = FiltroConsultaRedeSimBuilder.access$1300((FiltroConsultaRedeSimBuilder)builder);
        this.evento = FiltroConsultaRedeSimBuilder.access$1400((FiltroConsultaRedeSimBuilder)builder);
        this.grauRisco = Optional.ofNullable(FiltroConsultaRedeSimBuilder.access$1500((FiltroConsultaRedeSimBuilder)builder)).map(GrauDeRiscoEnum::getSigla).orElse(null);
        this.alvaraEnviado = FiltroConsultaRedeSimBuilder.access$1600((FiltroConsultaRedeSimBuilder)builder);
        this.redeSim = FiltroConsultaRedeSimBuilder.access$1700((FiltroConsultaRedeSimBuilder)builder);
        this.laudosLiberados = FiltroConsultaRedeSimBuilder.access$1800((FiltroConsultaRedeSimBuilder)builder);
        this.debitosEnviados = FiltroConsultaRedeSimBuilder.access$1900((FiltroConsultaRedeSimBuilder)builder);
        this.cnpjEmpresa = FiltroConsultaRedeSimBuilder.access$2000((FiltroConsultaRedeSimBuilder)builder);
        this.cpfSolicitante = FiltroConsultaRedeSimBuilder.access$2100((FiltroConsultaRedeSimBuilder)builder);
        this.ativo = FiltroConsultaRedeSimBuilder.access$2200((FiltroConsultaRedeSimBuilder)builder);
        this.inscricaoEnviada = FiltroConsultaRedeSimBuilder.access$2300((FiltroConsultaRedeSimBuilder)builder);
    }

    public Date getDataInicial() {
        return this.dataInicial;
    }

    public Date getDataFinal() {
        return this.dataFinal;
    }

    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    public List<String> getSituacao() {
        return this.situacao;
    }

    public String getProtocolo() {
        return this.protocolo;
    }

    public String getTipo() {
        return this.tipo;
    }

    public Long getNumeroSolicitacao() {
        return this.numeroSolicitacao;
    }

    public Long getExercicioSolicitacao() {
        return this.exercicioSolicitacao;
    }

    public String getIndeferido() {
        return this.indeferido;
    }

    public String getMotivoIndeferimento() {
        return this.motivoIndeferimento;
    }

    public Long getEvento() {
        return this.evento;
    }

    public String getAtivo() {
        return this.ativo;
    }

    public void limpar() {
        this.dataInicial = null;
        this.dataFinal = null;
        this.nomeArquivo = "";
        this.situacao = new ArrayList();
        this.tipo = "";
        this.numeroSolicitacao = null;
        this.exercicioSolicitacao = null;
        this.numeroExercicioSolicitacao = "";
        this.indeferido = "";
        this.motivoIndeferimento = "";
        this.maisAntigas = false;
        this.laudosLiberados = false;
        this.debitosEnviados = false;
        this.cpfSolicitante = "";
        this.cnpjEmpresa = "";
        this.ativo = null;
        this.setInscricaoEnviada(null);
    }

    public Boolean isFiltroValido() {
        Boolean valido = Boolean.TRUE;
        if (this.ativo != null) {
            return valido;
        }
        if (this.dataInicial != null) {
            if (this.dataFinal == null) {
                this.dataFinal = new Date();
            }
            return valido;
        }
        if (!EloStringUtils.isEmpty((String)this.protocolo)) {
            return valido;
        }
        if (!EloStringUtils.isEmpty((String)this.tipo)) {
            return valido;
        }
        if (!EloListUtils.safeIsEmpty((List)this.situacao).booleanValue()) {
            return valido;
        }
        if (!EloStringUtils.isEmpty((String)this.indeferido)) {
            return valido;
        }
        if (this.tipoInscricao != null) {
            return valido;
        }
        if (!EloStringUtils.isEmpty((String)this.cpfSolicitante)) {
            return valido;
        }
        if (!EloStringUtils.isEmpty((String)this.cnpjEmpresa)) {
            return valido;
        }
        if (Objects.nonNull(this.inscricaoEnviada)) {
            return valido;
        }
        if (UtilsController.isNumeroSolicitacaoValido((String)this.numeroExercicioSolicitacao).booleanValue()) {
            Long[] numeroExercicioSeparado = UtilsController.separarNumeroExercicioSolicitacao((String)this.numeroExercicioSolicitacao);
            if (numeroExercicioSeparado != null) {
                this.setNumeroSolicitacao(numeroExercicioSeparado[0]);
                this.setExercicioSolicitacao(numeroExercicioSeparado[1]);
            }
            if (EloNumberUtils.isBiggerThanZero((Number)this.numeroSolicitacao).booleanValue() && EloNumberUtils.isBiggerThanZero((Number)this.exercicioSolicitacao).booleanValue()) {
                return valido;
            }
        }
        return Boolean.FALSE;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }

    public void setSituacao(List<String> situacao) {
        this.situacao = situacao;
    }

    public void setProtocolo(String protocolo) {
        this.protocolo = protocolo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public void setNumeroSolicitacao(Long numeroSolicitacao) {
        this.numeroSolicitacao = numeroSolicitacao;
    }

    public void setExercicioSolicitacao(Long exercicioSolicitacao) {
        this.exercicioSolicitacao = exercicioSolicitacao;
    }

    public void setIndeferido(String indeferido) {
        this.indeferido = indeferido;
    }

    public void setMotivoIndeferimento(String motivoIndeferimento) {
        this.motivoIndeferimento = motivoIndeferimento;
    }

    public String getNumeroExercicioSolicitacao() {
        return this.numeroExercicioSolicitacao;
    }

    public void setNumeroExercicioSolicitacao(String numeroExercicioSolicitacao) {
        this.numeroExercicioSolicitacao = numeroExercicioSolicitacao;
    }

    public String getSituacaoSolicitacao() {
        return this.situacaoSolicitacao;
    }

    public void setSituacaoSolicitacao(String situacaoSolicitacao) {
        this.situacaoSolicitacao = SituacaoConsultaPreviaRedeSimEnum.getSiglaFromText((String)situacaoSolicitacao);
    }

    public String getGrauRisco() {
        return this.grauRisco;
    }

    public void setGrauRisco(String grauRisco) {
        this.grauRisco = grauRisco;
    }

    public boolean isMaisAntigas() {
        return this.maisAntigas;
    }

    public void setMaisAntigas(boolean maisAntigas) {
        this.maisAntigas = maisAntigas;
    }

    public TipoInscricaoAlvaraEntity getTipoInscricao() {
        return this.tipoInscricao;
    }

    public void setTipoInscricao(TipoInscricaoAlvaraEntity tipoInscricao) {
        this.tipoInscricao = tipoInscricao;
    }

    public NaturezaSolicitacaoAlvaraEntity getNaturezaSolicitacao() {
        return this.naturezaSolicitacao;
    }

    public void setNaturezaSolicitacao(NaturezaSolicitacaoAlvaraEntity naturezaSolicitacao) {
        this.naturezaSolicitacao = naturezaSolicitacao;
    }

    public void setEvento(Long evento) {
        this.evento = evento;
    }

    public Boolean getAlvaraEnviado() {
        return this.alvaraEnviado;
    }

    public void setAlvaraEnviado(Boolean alvaraEnviado) {
        this.alvaraEnviado = alvaraEnviado;
    }

    public Boolean getRedeSim() {
        return this.redeSim;
    }

    public void setRedeSim(Boolean redeSim) {
        this.redeSim = redeSim;
    }

    public String getCpfSolicitante() {
        return this.cpfSolicitante;
    }

    public void setCpfSolicitante(String cpfSolicitante) {
        this.cpfSolicitante = cpfSolicitante;
    }

    public String getCnpjEmpresa() {
        return this.cnpjEmpresa;
    }

    public void setCnpjEmpresa(String cnpjEmpresa) {
        this.cnpjEmpresa = cnpjEmpresa;
    }

    public void setAtivo(String ativo) {
        this.ativo = ativo;
    }

    public Boolean getLaudosLiberados() {
        return this.laudosLiberados;
    }

    public Boolean getDebitosEnviados() {
        return this.debitosEnviados;
    }

    public String getInscricaoEnviada() {
        return this.inscricaoEnviada;
    }

    public void setLaudosLiberados(Boolean laudosLiberados) {
        this.laudosLiberados = laudosLiberados;
    }

    public void setDebitosEnviados(Boolean debitosEnviados) {
        this.debitosEnviados = debitosEnviados;
    }

    public void setInscricaoEnviada(String inscricaoEnviada) {
        this.inscricaoEnviada = inscricaoEnviada;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroConsultaRedeSim)) {
            return false;
        }
        FiltroConsultaRedeSim other = (FiltroConsultaRedeSim)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Date this$dataInicial = this.getDataInicial();
        Date other$dataInicial = other.getDataInicial();
        if (this$dataInicial == null ? other$dataInicial != null : !((Object)this$dataInicial).equals(other$dataInicial)) {
            return false;
        }
        Date this$dataFinal = this.getDataFinal();
        Date other$dataFinal = other.getDataFinal();
        if (this$dataFinal == null ? other$dataFinal != null : !((Object)this$dataFinal).equals(other$dataFinal)) {
            return false;
        }
        String this$nomeArquivo = this.getNomeArquivo();
        String other$nomeArquivo = other.getNomeArquivo();
        if (this$nomeArquivo == null ? other$nomeArquivo != null : !this$nomeArquivo.equals(other$nomeArquivo)) {
            return false;
        }
        List this$situacao = this.getSituacao();
        List other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !((Object)this$situacao).equals(other$situacao)) {
            return false;
        }
        String this$protocolo = this.getProtocolo();
        String other$protocolo = other.getProtocolo();
        if (this$protocolo == null ? other$protocolo != null : !this$protocolo.equals(other$protocolo)) {
            return false;
        }
        String this$tipo = this.getTipo();
        String other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        Long this$numeroSolicitacao = this.getNumeroSolicitacao();
        Long other$numeroSolicitacao = other.getNumeroSolicitacao();
        if (this$numeroSolicitacao == null ? other$numeroSolicitacao != null : !((Object)this$numeroSolicitacao).equals(other$numeroSolicitacao)) {
            return false;
        }
        Long this$exercicioSolicitacao = this.getExercicioSolicitacao();
        Long other$exercicioSolicitacao = other.getExercicioSolicitacao();
        if (this$exercicioSolicitacao == null ? other$exercicioSolicitacao != null : !((Object)this$exercicioSolicitacao).equals(other$exercicioSolicitacao)) {
            return false;
        }
        String this$indeferido = this.getIndeferido();
        String other$indeferido = other.getIndeferido();
        if (this$indeferido == null ? other$indeferido != null : !this$indeferido.equals(other$indeferido)) {
            return false;
        }
        String this$motivoIndeferimento = this.getMotivoIndeferimento();
        String other$motivoIndeferimento = other.getMotivoIndeferimento();
        if (this$motivoIndeferimento == null ? other$motivoIndeferimento != null : !this$motivoIndeferimento.equals(other$motivoIndeferimento)) {
            return false;
        }
        String this$numeroExercicioSolicitacao = this.getNumeroExercicioSolicitacao();
        String other$numeroExercicioSolicitacao = other.getNumeroExercicioSolicitacao();
        if (this$numeroExercicioSolicitacao == null ? other$numeroExercicioSolicitacao != null : !this$numeroExercicioSolicitacao.equals(other$numeroExercicioSolicitacao)) {
            return false;
        }
        String this$situacaoSolicitacao = this.getSituacaoSolicitacao();
        String other$situacaoSolicitacao = other.getSituacaoSolicitacao();
        if (this$situacaoSolicitacao == null ? other$situacaoSolicitacao != null : !this$situacaoSolicitacao.equals(other$situacaoSolicitacao)) {
            return false;
        }
        String this$grauRisco = this.getGrauRisco();
        String other$grauRisco = other.getGrauRisco();
        if (this$grauRisco == null ? other$grauRisco != null : !this$grauRisco.equals(other$grauRisco)) {
            return false;
        }
        if (this.isMaisAntigas() != other.isMaisAntigas()) {
            return false;
        }
        TipoInscricaoAlvaraEntity this$tipoInscricao = this.getTipoInscricao();
        TipoInscricaoAlvaraEntity other$tipoInscricao = other.getTipoInscricao();
        if (this$tipoInscricao == null ? other$tipoInscricao != null : !this$tipoInscricao.equals(other$tipoInscricao)) {
            return false;
        }
        NaturezaSolicitacaoAlvaraEntity this$naturezaSolicitacao = this.getNaturezaSolicitacao();
        NaturezaSolicitacaoAlvaraEntity other$naturezaSolicitacao = other.getNaturezaSolicitacao();
        if (this$naturezaSolicitacao == null ? other$naturezaSolicitacao != null : !this$naturezaSolicitacao.equals(other$naturezaSolicitacao)) {
            return false;
        }
        Long this$evento = this.getEvento();
        Long other$evento = other.getEvento();
        if (this$evento == null ? other$evento != null : !((Object)this$evento).equals(other$evento)) {
            return false;
        }
        Boolean this$alvaraEnviado = this.getAlvaraEnviado();
        Boolean other$alvaraEnviado = other.getAlvaraEnviado();
        if (this$alvaraEnviado == null ? other$alvaraEnviado != null : !((Object)this$alvaraEnviado).equals(other$alvaraEnviado)) {
            return false;
        }
        Boolean this$redeSim = this.getRedeSim();
        Boolean other$redeSim = other.getRedeSim();
        if (this$redeSim == null ? other$redeSim != null : !((Object)this$redeSim).equals(other$redeSim)) {
            return false;
        }
        Boolean this$laudosLiberados = this.getLaudosLiberados();
        Boolean other$laudosLiberados = other.getLaudosLiberados();
        if (this$laudosLiberados == null ? other$laudosLiberados != null : !((Object)this$laudosLiberados).equals(other$laudosLiberados)) {
            return false;
        }
        Boolean this$debitosEnviados = this.getDebitosEnviados();
        Boolean other$debitosEnviados = other.getDebitosEnviados();
        if (this$debitosEnviados == null ? other$debitosEnviados != null : !((Object)this$debitosEnviados).equals(other$debitosEnviados)) {
            return false;
        }
        String this$cnpjEmpresa = this.getCnpjEmpresa();
        String other$cnpjEmpresa = other.getCnpjEmpresa();
        if (this$cnpjEmpresa == null ? other$cnpjEmpresa != null : !this$cnpjEmpresa.equals(other$cnpjEmpresa)) {
            return false;
        }
        String this$cpfSolicitante = this.getCpfSolicitante();
        String other$cpfSolicitante = other.getCpfSolicitante();
        if (this$cpfSolicitante == null ? other$cpfSolicitante != null : !this$cpfSolicitante.equals(other$cpfSolicitante)) {
            return false;
        }
        String this$ativo = this.getAtivo();
        String other$ativo = other.getAtivo();
        if (this$ativo == null ? other$ativo != null : !this$ativo.equals(other$ativo)) {
            return false;
        }
        String this$inscricaoEnviada = this.getInscricaoEnviada();
        String other$inscricaoEnviada = other.getInscricaoEnviada();
        return !(this$inscricaoEnviada == null ? other$inscricaoEnviada != null : !this$inscricaoEnviada.equals(other$inscricaoEnviada));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FiltroConsultaRedeSim;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Date $dataInicial = this.getDataInicial();
        result = result * 59 + ($dataInicial == null ? 43 : ((Object)$dataInicial).hashCode());
        Date $dataFinal = this.getDataFinal();
        result = result * 59 + ($dataFinal == null ? 43 : ((Object)$dataFinal).hashCode());
        String $nomeArquivo = this.getNomeArquivo();
        result = result * 59 + ($nomeArquivo == null ? 43 : $nomeArquivo.hashCode());
        List $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : ((Object)$situacao).hashCode());
        String $protocolo = this.getProtocolo();
        result = result * 59 + ($protocolo == null ? 43 : $protocolo.hashCode());
        String $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        Long $numeroSolicitacao = this.getNumeroSolicitacao();
        result = result * 59 + ($numeroSolicitacao == null ? 43 : ((Object)$numeroSolicitacao).hashCode());
        Long $exercicioSolicitacao = this.getExercicioSolicitacao();
        result = result * 59 + ($exercicioSolicitacao == null ? 43 : ((Object)$exercicioSolicitacao).hashCode());
        String $indeferido = this.getIndeferido();
        result = result * 59 + ($indeferido == null ? 43 : $indeferido.hashCode());
        String $motivoIndeferimento = this.getMotivoIndeferimento();
        result = result * 59 + ($motivoIndeferimento == null ? 43 : $motivoIndeferimento.hashCode());
        String $numeroExercicioSolicitacao = this.getNumeroExercicioSolicitacao();
        result = result * 59 + ($numeroExercicioSolicitacao == null ? 43 : $numeroExercicioSolicitacao.hashCode());
        String $situacaoSolicitacao = this.getSituacaoSolicitacao();
        result = result * 59 + ($situacaoSolicitacao == null ? 43 : $situacaoSolicitacao.hashCode());
        String $grauRisco = this.getGrauRisco();
        result = result * 59 + ($grauRisco == null ? 43 : $grauRisco.hashCode());
        result = result * 59 + (this.isMaisAntigas() ? 79 : 97);
        TipoInscricaoAlvaraEntity $tipoInscricao = this.getTipoInscricao();
        result = result * 59 + ($tipoInscricao == null ? 43 : $tipoInscricao.hashCode());
        NaturezaSolicitacaoAlvaraEntity $naturezaSolicitacao = this.getNaturezaSolicitacao();
        result = result * 59 + ($naturezaSolicitacao == null ? 43 : $naturezaSolicitacao.hashCode());
        Long $evento = this.getEvento();
        result = result * 59 + ($evento == null ? 43 : ((Object)$evento).hashCode());
        Boolean $alvaraEnviado = this.getAlvaraEnviado();
        result = result * 59 + ($alvaraEnviado == null ? 43 : ((Object)$alvaraEnviado).hashCode());
        Boolean $redeSim = this.getRedeSim();
        result = result * 59 + ($redeSim == null ? 43 : ((Object)$redeSim).hashCode());
        Boolean $laudosLiberados = this.getLaudosLiberados();
        result = result * 59 + ($laudosLiberados == null ? 43 : ((Object)$laudosLiberados).hashCode());
        Boolean $debitosEnviados = this.getDebitosEnviados();
        result = result * 59 + ($debitosEnviados == null ? 43 : ((Object)$debitosEnviados).hashCode());
        String $cnpjEmpresa = this.getCnpjEmpresa();
        result = result * 59 + ($cnpjEmpresa == null ? 43 : $cnpjEmpresa.hashCode());
        String $cpfSolicitante = this.getCpfSolicitante();
        result = result * 59 + ($cpfSolicitante == null ? 43 : $cpfSolicitante.hashCode());
        String $ativo = this.getAtivo();
        result = result * 59 + ($ativo == null ? 43 : $ativo.hashCode());
        String $inscricaoEnviada = this.getInscricaoEnviada();
        result = result * 59 + ($inscricaoEnviada == null ? 43 : $inscricaoEnviada.hashCode());
        return result;
    }

    public String toString() {
        return "FiltroConsultaRedeSim(dataInicial=" + this.getDataInicial() + ", dataFinal=" + this.getDataFinal() + ", nomeArquivo=" + this.getNomeArquivo() + ", situacao=" + this.getSituacao() + ", protocolo=" + this.getProtocolo() + ", tipo=" + this.getTipo() + ", numeroSolicitacao=" + this.getNumeroSolicitacao() + ", exercicioSolicitacao=" + this.getExercicioSolicitacao() + ", indeferido=" + this.getIndeferido() + ", motivoIndeferimento=" + this.getMotivoIndeferimento() + ", numeroExercicioSolicitacao=" + this.getNumeroExercicioSolicitacao() + ", situacaoSolicitacao=" + this.getSituacaoSolicitacao() + ", grauRisco=" + this.getGrauRisco() + ", maisAntigas=" + this.isMaisAntigas() + ", tipoInscricao=" + this.getTipoInscricao() + ", naturezaSolicitacao=" + this.getNaturezaSolicitacao() + ", evento=" + this.getEvento() + ", alvaraEnviado=" + this.getAlvaraEnviado() + ", redeSim=" + this.getRedeSim() + ", laudosLiberados=" + this.getLaudosLiberados() + ", debitosEnviados=" + this.getDebitosEnviados() + ", cnpjEmpresa=" + this.getCnpjEmpresa() + ", cpfSolicitante=" + this.getCpfSolicitante() + ", ativo=" + this.getAtivo() + ", inscricaoEnviada=" + this.getInscricaoEnviada() + ")";
    }
}

