/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain.vo;

import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.ReceitaVo;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class DebitoWebVo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<ReceitaVo> receitas;
    private int numeroParcelas;
    private int guia;
    private String observacao;
    private SolicitacaoAlvaraEntity solicitacaoAlvara;
    private Date vencimentoPrimeiraParcela;
    private String descricaoGuia;

    public List<ReceitaVo> getReceitas() {
        return this.receitas;
    }

    public void setReceitas(List<ReceitaVo> receitas) {
        this.receitas = receitas;
    }

    public int getNumeroParcelas() {
        return this.numeroParcelas;
    }

    public void setNumeroParcelas(int numeroParcelas) {
        this.numeroParcelas = numeroParcelas;
    }

    public int getGuia() {
        return this.guia;
    }

    public void setGuia(int guia) {
        this.guia = guia;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public SolicitacaoAlvaraEntity getSolicitacaoAlvara() {
        return this.solicitacaoAlvara;
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        this.solicitacaoAlvara = solicitacaoAlvara;
    }

    public Date getVencimentoPrimeiraParcela() {
        return this.vencimentoPrimeiraParcela;
    }

    public void setVencimentoPrimeiraParcela(Date vencimentoPrimeiraParcela) {
        this.vencimentoPrimeiraParcela = vencimentoPrimeiraParcela;
    }

    public String getDescricaoGuia() {
        return this.descricaoGuia;
    }

    public void setDescricaoGuia(String descricaoGuia) {
        this.descricaoGuia = descricaoGuia;
    }

    public BigDecimal valorTotal() {
        if (!EloListUtils.safeIsEmpty((List)this.receitas).booleanValue()) {
            return this.receitas.stream().map(ReceitaVo::getValor).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return BigDecimal.ZERO;
    }

    public String valorTotalString() {
        return EloStringUtils.formatValor((BigDecimal)this.valorTotal(), (int)2);
    }

    public String descricaoReceitas() {
        StringBuilder descricaoReceitas = new StringBuilder();
        for (ReceitaVo receitaVo : this.receitas) {
            descricaoReceitas.append(receitaVo.getReceita().getApelido()).append(", ");
        }
        return descricaoReceitas.toString().substring(0, descricaoReceitas.length() - 2);
    }
}

