/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain.vo;

import br.com.elotech.tributacao.domain.aise.AtividadeEntity;
import br.com.elotech.tributacao.domain.aise.CnaeEntity;
import java.io.Serializable;

public class AtividadeCnaeVo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Long INICIONUMERO = new Long(0L);
    public static final String CODIGO_CNAE_HOTEL = "5510801";
    public static final String CODIGO_CNAE_APARTAMENTO_HOTEL = "5510802";
    public static final String CODIGO_CNAE_MOTEL = "5510803";
    private AtividadeEntity atividade;
    private CnaeEntity cnae;
    private Long numeroQuarto;
    private Long numeroApartamento;
    private Long numeroSuite;

    public AtividadeCnaeVo(AtividadeEntity atividade, CnaeEntity cnae) {
        this.atividade = atividade;
        this.cnae = cnae;
        this.numeroApartamento = INICIONUMERO;
        this.numeroQuarto = INICIONUMERO;
        this.numeroSuite = INICIONUMERO;
    }

    public AtividadeEntity getAtividade() {
        return this.atividade;
    }

    public void setAtividade(AtividadeEntity atividade) {
        this.atividade = atividade;
    }

    public CnaeEntity getCnae() {
        return this.cnae;
    }

    public void setCnae(CnaeEntity cnae) {
        this.cnae = cnae;
    }

    public Long getNumeroQuarto() {
        return this.numeroQuarto;
    }

    public void setNumeroQuarto(Long numeroQuarto) {
        this.numeroQuarto = numeroQuarto;
    }

    public Long getNumeroApartamento() {
        return this.numeroApartamento;
    }

    public void setNumeroApartamento(Long numeroApartamento) {
        this.numeroApartamento = numeroApartamento;
    }

    public Long getNumeroSuite() {
        return this.numeroSuite;
    }

    public void setNumeroSuite(Long numeroSuite) {
        this.numeroSuite = numeroSuite;
    }

    public boolean existeUmCampoPreenchido() {
        return this.numeroQuarto > 0L || this.numeroApartamento > 0L || this.numeroSuite > 0L;
    }

    public boolean isAtividadeHotel() {
        return this.cnae.getCodigo().trim().equals(CODIGO_CNAE_HOTEL) ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isAtividadeMotel() {
        return this.cnae.getCodigo().trim().equals(CODIGO_CNAE_MOTEL) ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isAtividadeApartamento() {
        return this.cnae.getCodigo().trim().equals(CODIGO_CNAE_APARTAMENTO_HOTEL) ? Boolean.TRUE : Boolean.FALSE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.atividade == null ? 0 : this.atividade.hashCode());
        result = 31 * result + (this.cnae == null ? 0 : this.cnae.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AtividadeCnaeVo other = (AtividadeCnaeVo)obj;
        if (this.atividade == null ? other.atividade != null : !this.atividade.equals(other.atividade)) {
            return false;
        }
        return !(this.cnae == null ? other.cnae != null : !this.cnae.equals((Object)other.cnae));
    }
}

