/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain;

import br.com.elotech.domainLayer.ValidationEntityDef;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.util.string.EloStringUtils;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity(name="SolicitacaoDispensaAmbiental")
@Table(name="TRIBSOLDISPENSAAMBIENTAL")
public class SolicitacaoDispensaAmbientalEntity
implements ValidationEntityDef {
    private static final long serialVersionUID = 2398972342802160274L;
    @Id
    @GeneratedValue(generator="GEN_DISPENSAAMBIENTAL", strategy=GenerationType.SEQUENCE)
    @SequenceGenerator(name="GEN_DISPENSAAMBIENTAL", allocationSize=1, sequenceName="S40SOLDISPENSAAMBIENTAL")
    private Long id;
    private String solicitante;
    private Date dataSolicitacao;
    @ManyToOne
    @JoinColumn(name="solicitacaoAlvara", referencedColumnName="solicitacaoAlvara")
    private SolicitacaoAlvaraEntity solicitacaoAlvara;

    public void validar() throws ValidacaoException {
        ValidacaoException validacao = new ValidacaoException();
        if (EloStringUtils.isEmpty((String)this.solicitante)) {
            validacao.adicionarMensagem("N\u00e3o \u00e9 poss\u00edvel solicitar uma dispensa ambiental sem usu\u00e1rio logado.");
        }
        if (this.dataSolicitacao == null) {
            validacao.adicionarMensagem("N\u00e3o foi poss\u00edvel solicitar a dispensa ambiental, n\u00e3o encontramos a data de solicita\u00e7\u00e3o.");
        }
        if (this.solicitacaoAlvara == null) {
            validacao.adicionarMensagem("N\u00e3o encontramos a Solicita\u00e7\u00e3o de Alvar\u00e1 referente \u00e0 essa Dispensa Ambiental.");
        }
        validacao.lancarException();
    }

    public Long getId() {
        return this.id;
    }

    public String getSolicitante() {
        return this.solicitante;
    }

    public Date getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    public SolicitacaoAlvaraEntity getSolicitacaoAlvara() {
        return this.solicitacaoAlvara;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setSolicitante(String solicitante) {
        this.solicitante = solicitante;
    }

    public void setDataSolicitacao(Date dataSolicitacao) {
        this.dataSolicitacao = dataSolicitacao;
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        this.solicitacaoAlvara = solicitacaoAlvara;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SolicitacaoDispensaAmbientalEntity)) {
            return false;
        }
        SolicitacaoDispensaAmbientalEntity other = (SolicitacaoDispensaAmbientalEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$solicitante = this.getSolicitante();
        String other$solicitante = other.getSolicitante();
        if (this$solicitante == null ? other$solicitante != null : !this$solicitante.equals(other$solicitante)) {
            return false;
        }
        Date this$dataSolicitacao = this.getDataSolicitacao();
        Date other$dataSolicitacao = other.getDataSolicitacao();
        if (this$dataSolicitacao == null ? other$dataSolicitacao != null : !((Object)this$dataSolicitacao).equals(other$dataSolicitacao)) {
            return false;
        }
        SolicitacaoAlvaraEntity this$solicitacaoAlvara = this.getSolicitacaoAlvara();
        SolicitacaoAlvaraEntity other$solicitacaoAlvara = other.getSolicitacaoAlvara();
        return !(this$solicitacaoAlvara == null ? other$solicitacaoAlvara != null : !this$solicitacaoAlvara.equals(other$solicitacaoAlvara));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SolicitacaoDispensaAmbientalEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $solicitante = this.getSolicitante();
        result = result * 59 + ($solicitante == null ? 43 : $solicitante.hashCode());
        Date $dataSolicitacao = this.getDataSolicitacao();
        result = result * 59 + ($dataSolicitacao == null ? 43 : ((Object)$dataSolicitacao).hashCode());
        SolicitacaoAlvaraEntity $solicitacaoAlvara = this.getSolicitacaoAlvara();
        result = result * 59 + ($solicitacaoAlvara == null ? 43 : $solicitacaoAlvara.hashCode());
        return result;
    }

    public String toString() {
        return "SolicitacaoDispensaAmbientalEntity(id=" + this.getId() + ", solicitante=" + this.getSolicitante() + ", dataSolicitacao=" + this.getDataSolicitacao() + ", solicitacaoAlvara=" + this.getSolicitacaoAlvara() + ")";
    }
}

