/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain;

import br.com.elotech.domainLayer.EntityDef;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoContratoSocialPessoaEntity;
import br.com.elotech.tributacao.domain.aise.ContratoSocialEntity;
import br.com.elotech.tributacao.domain.aise.ContratoSocialPessoaEntity;
import br.com.elotech.tributacao.domain.aise.TipoCapitalSocialEntity;
import br.com.elotech.tributacao.domain.aise.TipoRegistroMercantilEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity(name="SolicitacaoContratoSocial")
@Table(name="tribsolicitacaocontrato")
public class SolicitacaoContratoSocialEntity
implements EntityDef {
    private static final long serialVersionUID = 1L;
    @Id
    private Long id;
    @OneToOne
    @JoinColumn(name="idsolicitacaoalvara")
    private SolicitacaoAlvaraEntity solicitacaoAlvara;
    @ManyToOne
    @JoinColumn(name="idtipocapitalsocial", referencedColumnName="tipoCapitalSocial")
    private TipoCapitalSocialEntity tipoCapitalSocial;
    @ManyToOne
    @JoinColumn(name="idtiporegistromercantil", referencedColumnName="tipoRegistroMercantil")
    private TipoRegistroMercantilEntity tipoRegistroMercantil;
    @Column(name="contratocartorioalteracao")
    private String contratoCartorioAlteracao;
    @Column(name="contratoregistroalteracao")
    private String contratoRegistroAlteracao;
    @Column(name="contratoaverbacaoalteracao")
    private String contratoAverbacaoAlteracao;
    @Temporal(value=TemporalType.DATE)
    @Column(name="contratodataalteracao")
    private Date contratoDataAlteracao;
    private BigDecimal capitalSocial;
    private BigDecimal valorCotas;
    @Column(name="USUARIO")
    private String usuario;
    private Long numeroAlteracao;
    private String numeroJuntaComercial;
    private Date dataRegistroJuntaComercial;
    private String observacaoDescricaoAlteracao;
    @OneToMany(mappedBy="contratoSocial", cascade={CascadeType.ALL})
    private List<SolicitacaoContratoSocialPessoaEntity> pessoas = new ArrayList();

    public SolicitacaoAlvaraEntity getSolicitacaoAlvara() {
        return this.solicitacaoAlvara;
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        this.solicitacaoAlvara = solicitacaoAlvara;
    }

    public List<SolicitacaoContratoSocialPessoaEntity> getPessoas() {
        return this.pessoas;
    }

    public void setPessoas(List<SolicitacaoContratoSocialPessoaEntity> pessoas) {
        this.pessoas = pessoas;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public TipoCapitalSocialEntity getTipoCapitalSocial() {
        return this.tipoCapitalSocial;
    }

    public void setTipoCapitalSocial(TipoCapitalSocialEntity tipoCapitalSocial) {
        this.tipoCapitalSocial = tipoCapitalSocial;
    }

    public TipoRegistroMercantilEntity getTipoRegistroMercantil() {
        return this.tipoRegistroMercantil;
    }

    public void setTipoRegistroMercantil(TipoRegistroMercantilEntity tipoRegistroMercantil) {
        this.tipoRegistroMercantil = tipoRegistroMercantil;
    }

    public String getContratoCartorioAlteracao() {
        return this.contratoCartorioAlteracao;
    }

    public void setContratoCartorioAlteracao(String contratoCartorioAlteracao) {
        this.contratoCartorioAlteracao = contratoCartorioAlteracao;
    }

    public String getContratoRegistroAlteracao() {
        return this.contratoRegistroAlteracao;
    }

    public void setContratoRegistroAlteracao(String contratoRegistroAlteracao) {
        this.contratoRegistroAlteracao = contratoRegistroAlteracao;
    }

    public String getContratoAverbacaoAlteracao() {
        return this.contratoAverbacaoAlteracao;
    }

    public void setContratoAverbacaoAlteracao(String contratoAverbacaoAlteracao) {
        this.contratoAverbacaoAlteracao = contratoAverbacaoAlteracao;
    }

    public Date getContratoDataAlteracao() {
        return this.contratoDataAlteracao;
    }

    public void setContratoDataAlteracao(Date contratoDataAlteracao) {
        this.contratoDataAlteracao = contratoDataAlteracao;
    }

    public BigDecimal getCapitalSocial() {
        return this.capitalSocial;
    }

    public void setCapitalSocial(BigDecimal capitalSocial) {
        this.capitalSocial = capitalSocial;
    }

    public BigDecimal getValorCotas() {
        return this.valorCotas;
    }

    public void setValorCotas(BigDecimal valorCotas) {
        this.valorCotas = valorCotas;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public Long getNumeroAlteracao() {
        return this.numeroAlteracao;
    }

    public void setNumeroAlteracao(Long numeroAlteracao) {
        this.numeroAlteracao = numeroAlteracao;
    }

    public String getNumeroJuntaComercial() {
        return this.numeroJuntaComercial;
    }

    public void setNumeroJuntaComercial(String numeroJuntaComercial) {
        this.numeroJuntaComercial = numeroJuntaComercial;
    }

    public Date getDataRegistroJuntaComercial() {
        return this.dataRegistroJuntaComercial;
    }

    public void setDataRegistroJuntaComercial(Date dataRegistroJuntaComercial) {
        this.dataRegistroJuntaComercial = dataRegistroJuntaComercial;
    }

    public String getObservacaoDescricaoAlteracao() {
        return this.observacaoDescricaoAlteracao;
    }

    public void setObservacaoDescricaoAlteracao(String observacaoDescricaoAlteracao) {
        this.observacaoDescricaoAlteracao = observacaoDescricaoAlteracao;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.capitalSocial == null ? 0 : this.capitalSocial.hashCode());
        result = 31 * result + (this.contratoAverbacaoAlteracao == null ? 0 : this.contratoAverbacaoAlteracao.hashCode());
        result = 31 * result + (this.contratoCartorioAlteracao == null ? 0 : this.contratoCartorioAlteracao.hashCode());
        result = 31 * result + (this.contratoDataAlteracao == null ? 0 : this.contratoDataAlteracao.hashCode());
        result = 31 * result + (this.contratoRegistroAlteracao == null ? 0 : this.contratoRegistroAlteracao.hashCode());
        result = 31 * result + (this.dataRegistroJuntaComercial == null ? 0 : this.dataRegistroJuntaComercial.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.numeroAlteracao == null ? 0 : this.numeroAlteracao.hashCode());
        result = 31 * result + (this.numeroJuntaComercial == null ? 0 : this.numeroJuntaComercial.hashCode());
        result = 31 * result + (this.observacaoDescricaoAlteracao == null ? 0 : this.observacaoDescricaoAlteracao.hashCode());
        result = 31 * result + (this.tipoCapitalSocial == null ? 0 : this.tipoCapitalSocial.hashCode());
        result = 31 * result + (this.tipoRegistroMercantil == null ? 0 : this.tipoRegistroMercantil.hashCode());
        result = 31 * result + (this.usuario == null ? 0 : this.usuario.hashCode());
        result = 31 * result + (this.valorCotas == null ? 0 : this.valorCotas.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SolicitacaoContratoSocialEntity other = (SolicitacaoContratoSocialEntity)obj;
        if (this.capitalSocial == null ? other.capitalSocial != null : !this.capitalSocial.equals(other.capitalSocial)) {
            return false;
        }
        if (this.contratoAverbacaoAlteracao == null ? other.contratoAverbacaoAlteracao != null : !this.contratoAverbacaoAlteracao.equals(other.contratoAverbacaoAlteracao)) {
            return false;
        }
        if (this.contratoCartorioAlteracao == null ? other.contratoCartorioAlteracao != null : !this.contratoCartorioAlteracao.equals(other.contratoCartorioAlteracao)) {
            return false;
        }
        if (this.contratoDataAlteracao == null ? other.contratoDataAlteracao != null : !this.contratoDataAlteracao.equals(other.contratoDataAlteracao)) {
            return false;
        }
        if (this.contratoRegistroAlteracao == null ? other.contratoRegistroAlteracao != null : !this.contratoRegistroAlteracao.equals(other.contratoRegistroAlteracao)) {
            return false;
        }
        if (this.dataRegistroJuntaComercial == null ? other.dataRegistroJuntaComercial != null : !this.dataRegistroJuntaComercial.equals(other.dataRegistroJuntaComercial)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.numeroAlteracao == null ? other.numeroAlteracao != null : !this.numeroAlteracao.equals(other.numeroAlteracao)) {
            return false;
        }
        if (this.numeroJuntaComercial == null ? other.numeroJuntaComercial != null : !this.numeroJuntaComercial.equals(other.numeroJuntaComercial)) {
            return false;
        }
        if (this.observacaoDescricaoAlteracao == null ? other.observacaoDescricaoAlteracao != null : !this.observacaoDescricaoAlteracao.equals(other.observacaoDescricaoAlteracao)) {
            return false;
        }
        if (this.tipoCapitalSocial == null ? other.tipoCapitalSocial != null : !this.tipoCapitalSocial.equals((Object)other.tipoCapitalSocial)) {
            return false;
        }
        if (this.tipoRegistroMercantil == null ? other.tipoRegistroMercantil != null : !this.tipoRegistroMercantil.equals((Object)other.tipoRegistroMercantil)) {
            return false;
        }
        if (this.usuario == null ? other.usuario != null : !this.usuario.equals(other.usuario)) {
            return false;
        }
        return !(this.valorCotas == null ? other.valorCotas != null : !this.valorCotas.equals(other.valorCotas));
    }

    public static SolicitacaoContratoSocialEntity fromContratoSocial(ContratoSocialEntity contratoSocial) {
        SolicitacaoContratoSocialEntity solicitacaoContratosocial = new SolicitacaoContratoSocialEntity();
        if (contratoSocial != null) {
            solicitacaoContratosocial.setTipoCapitalSocial(contratoSocial.getTipoCapitalSocial());
            solicitacaoContratosocial.setTipoRegistroMercantil(contratoSocial.getTipoRegistroMercantil());
            solicitacaoContratosocial.setContratoCartorioAlteracao(contratoSocial.getContratoCartorioAlteracao());
            solicitacaoContratosocial.setContratoRegistroAlteracao(contratoSocial.getContratoRegistroAlteracao());
            solicitacaoContratosocial.setContratoDataAlteracao(contratoSocial.getContratoDataAlteracao());
            solicitacaoContratosocial.setContratoAverbacaoAlteracao(contratoSocial.getContratoAverbacaoAlteracao());
            solicitacaoContratosocial.setCapitalSocial(contratoSocial.getCapitalSocial());
            solicitacaoContratosocial.setValorCotas(contratoSocial.getValorCotas());
            solicitacaoContratosocial.setUsuario(contratoSocial.getUsuario());
            solicitacaoContratosocial.setNumeroAlteracao(contratoSocial.getNumeroAlteracao());
            solicitacaoContratosocial.setNumeroJuntaComercial(contratoSocial.getNumeroJuntaComercial());
            solicitacaoContratosocial.setDataRegistroJuntaComercial(contratoSocial.getDataRegistroJuntaComercial());
            solicitacaoContratosocial.setObservacaoDescricaoAlteracao(contratoSocial.getObservacaoDescricaoAlteracao());
            for (ContratoSocialPessoaEntity contratoSocialPessoa : contratoSocial.getPessoas()) {
                SolicitacaoContratoSocialPessoaEntity solicitacaoContratoSocialPessoa = SolicitacaoContratoSocialPessoaEntity.fromContratoSocialPessoal((ContratoSocialPessoaEntity)contratoSocialPessoa);
                solicitacaoContratoSocialPessoa.setContratoSocial(solicitacaoContratosocial);
                solicitacaoContratosocial.getPessoas().add(solicitacaoContratoSocialPessoa);
            }
        }
        return solicitacaoContratosocial;
    }

    public ContratoSocialEntity toContratoSocial() {
        ContratoSocialEntity contratoSocial = new ContratoSocialEntity();
        contratoSocial.setTipoCapitalSocial(this.tipoCapitalSocial);
        contratoSocial.setTipoRegistroMercantil(this.tipoRegistroMercantil);
        contratoSocial.setContratoCartorioAlteracao(this.contratoCartorioAlteracao);
        contratoSocial.setContratoRegistroAlteracao(this.contratoRegistroAlteracao);
        contratoSocial.setContratoDataAlteracao(this.contratoDataAlteracao);
        contratoSocial.setContratoAverbacaoAlteracao(this.contratoAverbacaoAlteracao);
        contratoSocial.setCapitalSocial(this.capitalSocial);
        contratoSocial.setValorCotas(this.valorCotas);
        contratoSocial.setUsuario(this.usuario);
        contratoSocial.setNumeroAlteracao(this.numeroAlteracao);
        contratoSocial.setNumeroJuntaComercial(this.numeroJuntaComercial);
        contratoSocial.setDataRegistroJuntaComercial(this.dataRegistroJuntaComercial);
        contratoSocial.setObservacaoDescricaoAlteracao(this.observacaoDescricaoAlteracao);
        return contratoSocial;
    }
}

