/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain;

import br.com.elotech.domainLayer.EntityDef;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraNumConselhoEntity;
import br.com.elotech.portalarrecadacao.enumerator.GrauDeRiscoEnum;
import br.com.elotech.portalarrecadacao.exception.AtividadeNaoConfiguradaException;
import br.com.elotech.tributacao.domain.aise.AtividadeMeiEntity;
import br.com.elotech.tributacao.domain.aise.CnaeEntity;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeEntity;
import br.com.elotech.tributacao.domain.aise.RhCboEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity(name="SolicitacaoAlvaraAtividade")
@Table(name="tribsolicitacaoalvaraatividade")
public class SolicitacaoAlvaraAtividadeEntity
implements EntityDef {
    private static final long serialVersionUID = 1L;
    @Id
    private Long idSolicitacaoAtividade;
    @Transient
    private String descricaoAtividade;
    @Transient
    private String codigoAtividade;
    @ManyToOne
    @JoinColumn(name="atividadeMei", referencedColumnName="atividadeMei")
    private AtividadeMeiEntity atividadeMei;
    @ManyToOne
    @JoinColumn(name="cnae", referencedColumnName="cnae")
    private CnaeEntity cnae;
    @ManyToOne
    @JoinColumn(name="sequenciacbo", referencedColumnName="sequenciacbo")
    private RhCboEntity sequenciaCbo;
    @ManyToOne
    @JoinColumn(name="solicitacaoAlvara", referencedColumnName="solicitacaoAlvara")
    private SolicitacaoAlvaraEntity solicitacaoAlvara;
    @Column(name="situacao", length=1)
    private String situacao;
    @Column(name="principal", length=1)
    private String principal;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="solicitacaoAtividade")
    private List<SolicitacaoAlvaraNumConselhoEntity> numerosConselho;
    private String somenteEscritorio;
    private String somenteEscrConcomitanteRes;
    private String atividadeConcomitanteRes;
    private BigDecimal areaProcessamento;
    private String responsavelTec;
    private String observacao;
    private String exerceNoEndereco;

    public SolicitacaoAlvaraAtividadeEntity() {
    }

    public SolicitacaoAlvaraAtividadeEntity(Long idSolicitacaoAtividade, AtividadeMeiEntity atividadeMei, CnaeEntity cnae, RhCboEntity sequenciaCbo, String principal, Long teste) {
        this.idSolicitacaoAtividade = idSolicitacaoAtividade;
        this.atividadeMei = atividadeMei;
        this.cnae = cnae;
        this.sequenciaCbo = sequenciaCbo;
        this.principal = principal;
        this.solicitacaoAlvara.setSolicitacaoAlvara(teste);
    }

    public CnaeEntity obterCnae() {
        if (this.cnae != null) {
            return this.cnae;
        }
        if (this.atividadeMei != null) {
            return this.atividadeMei.getCnae();
        }
        return null;
    }

    public String getDescricaoAtividade() {
        if (this.cnae != null) {
            return this.cnae.getDescricao();
        }
        if (this.sequenciaCbo != null) {
            return this.sequenciaCbo.getDescricao();
        }
        if (this.atividadeMei != null) {
            return this.atividadeMei.getDescricao();
        }
        return this.descricaoAtividade;
    }

    public String getCodigoAtividade() {
        if (this.cnae != null) {
            return this.cnae.getCodigo();
        }
        if (this.sequenciaCbo != null) {
            return this.sequenciaCbo.getCbo().toString();
        }
        if (this.atividadeMei != null) {
            return this.atividadeMei.getCnae().getCodigo();
        }
        return this.codigoAtividade;
    }

    public String getGrauRisco() {
        String grauRisco = "";
        if (this.cnae != null) {
            grauRisco = this.cnae.getGrauRisco();
        } else if (this.sequenciaCbo != null) {
            grauRisco = this.sequenciaCbo.getGrauRisco();
        } else if (this.atividadeMei != null) {
            grauRisco = this.atividadeMei.getGrauRisco();
        }
        if (GrauDeRiscoEnum.isGrauRiscoAlto((String)grauRisco)) {
            return "Alto";
        }
        if (GrauDeRiscoEnum.isGrauRiscoBaixo((String)grauRisco)) {
            return "Baixo";
        }
        if (GrauDeRiscoEnum.isGrauRiscoLiberdadeEconomica((String)grauRisco)) {
            return "Liberdade Econ\u00f4mica";
        }
        return "";
    }

    public boolean obrigaDocumentoInscricaoCadastroMobiliario() {
        return SimNaoEnum.SIM.getShortText().equals(this.cnae.getObrigaDocumento());
    }

    public String getResponsavelTec() {
        return this.responsavelTec;
    }

    public void setResponsavelTec(String responsavelTec) {
        this.responsavelTec = responsavelTec;
    }

    public String getSomenteEscritorio() {
        return this.somenteEscritorio;
    }

    public void setSomenteEscritorio(String somenteEscritorio) {
        this.somenteEscritorio = somenteEscritorio;
    }

    public String getSomenteEscrConcomitanteRes() {
        return this.somenteEscrConcomitanteRes;
    }

    public void setSomenteEscrConcomitanteRes(String somenteEscrConcomitanteRes) {
        this.somenteEscrConcomitanteRes = somenteEscrConcomitanteRes;
    }

    public String getAtividadeConcomitanteRes() {
        return this.atividadeConcomitanteRes;
    }

    public void setAtividadeConcomitanteRes(String atividadeConcomitanteRes) {
        this.atividadeConcomitanteRes = atividadeConcomitanteRes;
    }

    public BigDecimal getAreaProcessamento() {
        return this.areaProcessamento;
    }

    public void setAreaProcessamento(BigDecimal areaProcessamento) {
        this.areaProcessamento = areaProcessamento;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public void setCodigoAtividade(String codigoAtividade) {
        this.codigoAtividade = codigoAtividade;
    }

    public void setDescricaoAtividade(String descricaoAtividade) {
        this.descricaoAtividade = descricaoAtividade;
    }

    public SolicitacaoAlvaraEntity getSolicitacaoAlvara() {
        return this.solicitacaoAlvara;
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        this.solicitacaoAlvara = solicitacaoAlvara;
    }

    public Long getIdSolicitacaoAtividade() {
        return this.idSolicitacaoAtividade;
    }

    public void setIdSolicitacaoAtividade(Long idSolicitacaoAtividade) {
        this.idSolicitacaoAtividade = idSolicitacaoAtividade;
    }

    public AtividadeMeiEntity getAtividadeMei() {
        return this.atividadeMei;
    }

    public void setAtividadeMei(AtividadeMeiEntity atividadeMei) {
        this.atividadeMei = atividadeMei;
    }

    public CnaeEntity getCnae() {
        return this.cnae;
    }

    public void setCnae(CnaeEntity cnae) {
        this.cnae = cnae;
    }

    public RhCboEntity getSequenciaCbo() {
        return this.sequenciaCbo;
    }

    public void setSequenciaCbo(RhCboEntity sequenciaCbo) {
        this.sequenciaCbo = sequenciaCbo;
    }

    public String getSituacao() {
        return this.situacao;
    }

    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    public List<SolicitacaoAlvaraNumConselhoEntity> getNumerosConselho() {
        return this.numerosConselho;
    }

    public void setNumerosConselho(List<SolicitacaoAlvaraNumConselhoEntity> numerosConselho) {
        this.numerosConselho = numerosConselho;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public boolean exigeResponsavel() {
        return SimNaoEnum.SIM.getShortText().equals(this.responsavelTec);
    }

    public ConfiguracaoAtividadeEntity getConfiguracaoAtividade() throws AtividadeNaoConfiguradaException {
        if (this.solicitacaoAlvara.isSolicitacaoJuridicaNormal() || this.solicitacaoAlvara.isSolicitacaoPrestadorServico()) {
            if (Objects.nonNull(this.cnae) && Objects.nonNull(this.cnae.getIdConfiguracaoAtividade())) {
                return this.cnae.getIdConfiguracaoAtividade();
            }
            throw new AtividadeNaoConfiguradaException(String.join((CharSequence)"-", "N\u00e3o existe configura\u00e7\u00e3o de atividade para este CNAE ", this.getCodigoAtividade()));
        }
        if (this.solicitacaoAlvara.isSolicitacaoMEI()) {
            if (Objects.nonNull(this.atividadeMei) && Objects.nonNull(this.atividadeMei.getIdConfiguracaoAtividade())) {
                return this.atividadeMei.getIdConfiguracaoAtividade();
            }
            throw new AtividadeNaoConfiguradaException(String.join((CharSequence)"-", "N\u00e3o existe configura\u00e7\u00e3o de atividade para este MEI ", this.getCodigoAtividade()));
        }
        if (Objects.nonNull(this.sequenciaCbo) && Objects.nonNull(this.sequenciaCbo.getIdConfiguracaoAtividade())) {
            return this.sequenciaCbo.getIdConfiguracaoAtividade();
        }
        throw new AtividadeNaoConfiguradaException(String.join((CharSequence)"-", "N\u00e3o existe configura\u00e7\u00e3o de atividade para este CBO ", this.getCodigoAtividade()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.atividadeMei == null ? 0 : this.atividadeMei.hashCode());
        result = 31 * result + (this.cnae == null ? 0 : this.cnae.hashCode());
        result = 31 * result + (this.codigoAtividade == null ? 0 : this.codigoAtividade.hashCode());
        result = 31 * result + (this.sequenciaCbo == null ? 0 : this.sequenciaCbo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SolicitacaoAlvaraAtividadeEntity other = (SolicitacaoAlvaraAtividadeEntity)obj;
        if (this.atividadeMei == null ? other.atividadeMei != null : !this.atividadeMei.equals((Object)other.atividadeMei)) {
            return false;
        }
        if (this.cnae == null ? other.cnae != null : !this.cnae.equals((Object)other.cnae)) {
            return false;
        }
        if (this.codigoAtividade == null ? other.codigoAtividade != null : !this.codigoAtividade.equals(other.codigoAtividade)) {
            return false;
        }
        return !(this.sequenciaCbo == null ? other.sequenciaCbo != null : !this.sequenciaCbo.equals((Object)other.sequenciaCbo));
    }

    public String getExerceNoEndereco() {
        return this.exerceNoEndereco;
    }

    public void setExerceNoEndereco(String exerceNoEndereco) {
        this.exerceNoEndereco = exerceNoEndereco;
    }
}

