/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain;

import br.com.elotech.domainLayer.EntityDef;
import br.com.elotech.portalarrecadacao.domain.ObservacaoRestricaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroRestricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import br.com.elotech.tributacao.domain.aise.PessoaEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;

@Entity(name="RestricaoAlvara")
@Table(name="tribrestricaoalvara", uniqueConstraints={@UniqueConstraint(columnNames={"exercicio", "entidade", "idRestricaoAlvara"})})
public class RestricaoAlvaraEntity
implements EntityDef {
    private static final long serialVersionUID = 1L;
    @Id
    private Long idRestricaoAlvara;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade"), @JoinColumn(name="exercicio", referencedColumnName="exercicio")})
    private EntidadeTributacaoEntity entidadeTributacao;
    private Long restricaoAlvara;
    @Temporal(value=TemporalType.DATE)
    private Date data;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="tipocadastromobiliario", referencedColumnName="tipocadastro"), @JoinColumn(name="cadastrogeralmobiliario", referencedColumnName="cadastrogeral")})
    private CadastroMobiliarioEntity cadastroMobiliario;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="tipocadastroimobiliario", referencedColumnName="tipocadastro"), @JoinColumn(name="cadastrogeralimobiliario", referencedColumnName="cadastrogeral")})
    private CadastroImobiliarioEntity cadastroImobiliario;
    @ManyToOne
    @JoinColumn(name="solicitacaoalvara", referencedColumnName="solicitacaoalvara")
    private SolicitacaoAlvaraEntity solicitacaoAlvara;
    @ManyToOne
    @JoinColumn(name="idcadastrorestricao", referencedColumnName="idrestricao")
    private CadastroRestricaoAlvaraEntity cadastroRestricaoAlvara;
    @ManyToOne
    @JoinColumn(name="pessoa", referencedColumnName="pessoa")
    private PessoaEntity pessoa;
    private String usuario;
    private String autorizado;
    @Temporal(value=TemporalType.DATE)
    private Date dataAutorizacao;
    private String descricao;
    private String campoVerificacao;
    @OneToMany(mappedBy="idRestricaoAlvara", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ObservacaoRestricaoAlvaraEntity> observacoes;

    public PessoaEntity getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(PessoaEntity pessoa) {
        this.pessoa = pessoa;
    }

    public String getCampoVerificacao() {
        return this.campoVerificacao;
    }

    public void setCampoVerificacao(String campoVerificacao) {
        this.campoVerificacao = campoVerificacao;
    }

    public CadastroRestricaoAlvaraEntity getCadastroRestricaoAlvara() {
        return this.cadastroRestricaoAlvara;
    }

    public void setCadastroRestricaoAlvara(CadastroRestricaoAlvaraEntity cadastroRestricaoAlvara) {
        this.cadastroRestricaoAlvara = cadastroRestricaoAlvara;
    }

    public Long getIdRestricaoAlvara() {
        return this.idRestricaoAlvara;
    }

    public void setIdRestricaoAlvara(Long idRestricaoAlvara) {
        this.idRestricaoAlvara = idRestricaoAlvara;
    }

    public EntidadeTributacaoEntity getEntidadeTributacao() {
        return this.entidadeTributacao;
    }

    public void setExercicio(EntidadeTributacaoEntity entidadeTributacao) {
        this.entidadeTributacao = entidadeTributacao;
    }

    public Long getRestricaoAlvara() {
        return this.restricaoAlvara;
    }

    public void setRestricaoAlvara(Long restricaoAlvara) {
        this.restricaoAlvara = restricaoAlvara;
    }

    public CadastroMobiliarioEntity getCadastroMobiliario() {
        return this.cadastroMobiliario;
    }

    public void setCadastroMobiliario(CadastroMobiliarioEntity cadastroMobiliario) {
        this.cadastroMobiliario = cadastroMobiliario;
    }

    public CadastroImobiliarioEntity getCadastroImobiliario() {
        return this.cadastroImobiliario;
    }

    public void setCadastroImobiliario(CadastroImobiliarioEntity cadastroImobiliario) {
        this.cadastroImobiliario = cadastroImobiliario;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Date getData() {
        return this.data;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public SolicitacaoAlvaraEntity getSolicitacaoAlvara() {
        return this.solicitacaoAlvara;
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        this.solicitacaoAlvara = solicitacaoAlvara;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public String getAutorizado() {
        return this.autorizado;
    }

    public void setAutorizado(String autorizado) {
        this.autorizado = autorizado;
    }

    public Date getDataAutorizacao() {
        return this.dataAutorizacao;
    }

    public void setDataAutorizacao(Date dataAutorizacao) {
        this.dataAutorizacao = dataAutorizacao;
    }

    public List<ObservacaoRestricaoAlvaraEntity> getObservacoes() {
        if (this.observacoes == null) {
            this.observacoes = new LinkedList();
        } else {
            Collections.sort(this.observacoes, new /* Unavailable Anonymous Inner Class!! */);
        }
        return this.observacoes;
    }

    public void setObservacoes(List<ObservacaoRestricaoAlvaraEntity> observacoes) {
        this.observacoes = observacoes;
    }

    public boolean isBloqueante() {
        return this.solicitacaoAlvara.isGrauRiscoBaixo() && SimNaoEnum.equalSim((String)this.cadastroRestricaoAlvara.getBloqueiaSolicitacaoRiscoBaixo()) != false || this.solicitacaoAlvara.isGrauRiscoAlto() && SimNaoEnum.equalSim((String)this.cadastroRestricaoAlvara.getBloqueiaSolicitacaoRiscoAlto()) != false;
    }

    public boolean isRestricaoAutorizada() {
        return SimNaoEnum.equalSim((String)this.autorizado);
    }
}

