/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain;

import br.com.elotech.domainLayer.EntityDef;
import br.com.elotech.portalarrecadacao.domain.HistoricoRenovacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.ObservacaoTipoLaudoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.type.StatusLaudoType;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.list.EloListUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;

@TypeDefs(value={@TypeDef(name="statusLaudoType", typeClass=StatusLaudoType.class)})
@Entity(name="LaudoAlvara")
@Table(name="TribLaudoAlvara")
public class LaudoAlvaraEntity
implements EntityDef {
    private static final long serialVersionUID = 7941874199721951790L;
    @Id
    private Long idLaudoAlvara;
    @ManyToOne
    @JoinColumn(name="idSolicitacaoAlvara", referencedColumnName="solicitacaoalvara")
    private SolicitacaoAlvaraEntity idSolicitacaoAlvara;
    @ManyToOne
    @JoinColumn(name="tipoLaudo", referencedColumnName="idTipoLaudo")
    private TipoLaudoEntity tipoLaudo;
    @ManyToOne
    @JoinColumn(name="usuario", referencedColumnName="usuario")
    private UsuarioEntity usuario;
    @ManyToOne
    @JoinColumn(name="laudoIndeferimento", referencedColumnName="idLaudoAlvara")
    private LaudoAlvaraEntity laudoIndeferimento;
    @Type(type="statusLaudoType")
    private StatusLaudoAlvara status;
    private String vistoriar;
    @Column(nullable=false)
    @Type(type="org.hibernate.type.BooleanType")
    private boolean vistoriadoFiscalizacao = Boolean.FALSE;
    @Temporal(value=TemporalType.DATE)
    private Date dataValidade;
    private String observacao;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="TRIBLAUDOALVARAOBSERVACAO", joinColumns={@JoinColumn(name="IDLAUDOALVARA", referencedColumnName="IDLAUDOALVARA")}, inverseJoinColumns={@JoinColumn(name="IDOBSERVACAOTIPOLAUDO", referencedColumnName="ID")})
    private List<ObservacaoTipoLaudoEntity> observacoesTipoLaudo;
    @OneToMany(mappedBy="laudoAlvara", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<LaudoAlvaraDocumentoEntity> documentos;
    @OneToMany
    @JoinColumn(name="laudoAlvara", referencedColumnName="idLaudoAlvara")
    private List<HistoricoRenovacaoAlvaraEntity> historicosRenovacao;
    @Transient
    private String gerouProcessoFiscalizacao;
    private String enviadoFiscalizacao;

    public LaudoAlvaraEntity() {
        this.setDocumentos(new ArrayList());
    }

    public List<LaudoAlvaraDocumentoEntity> getDocumentos() {
        return this.documentos;
    }

    public void setDocumentos(List<LaudoAlvaraDocumentoEntity> documentos) {
        this.documentos = documentos;
    }

    public List<ObservacaoTipoLaudoEntity> getObservacoesTipoLaudo() {
        return this.observacoesTipoLaudo;
    }

    public void setObservacoesTipoLaudo(List<ObservacaoTipoLaudoEntity> observacoesTipoLaudo) {
        this.observacoesTipoLaudo = observacoesTipoLaudo;
    }

    public UsuarioEntity getUsuario() {
        return this.usuario;
    }

    public void setUsuario(UsuarioEntity usuario) {
        this.usuario = usuario;
    }

    public String getVistoriar() {
        return this.vistoriar;
    }

    public void setVistoriar(String vistoriar) {
        this.vistoriar = vistoriar;
    }

    public Long getIdLaudoAlvara() {
        return this.idLaudoAlvara;
    }

    public void setIdLaudoAlvara(Long idLaudoAlvara) {
        this.idLaudoAlvara = idLaudoAlvara;
    }

    public SolicitacaoAlvaraEntity getIdSolicitacaoAlvara() {
        return this.idSolicitacaoAlvara;
    }

    public void setIdSolicitacaoAlvara(SolicitacaoAlvaraEntity idSolicitacaoAlvara) {
        this.idSolicitacaoAlvara = idSolicitacaoAlvara;
    }

    public TipoLaudoEntity getTipoLaudo() {
        return this.tipoLaudo;
    }

    public void setTipoLaudo(TipoLaudoEntity tipoLaudo) {
        this.tipoLaudo = tipoLaudo;
    }

    public StatusLaudoAlvara getStatus() {
        return this.status;
    }

    public void setStatus(StatusLaudoAlvara status) {
        this.status = status;
    }

    public Date getDataValidade() {
        return this.dataValidade;
    }

    public void setDataValidade(Date dataValidade) {
        this.dataValidade = dataValidade;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public String getGerouProcessoFiscalizacao() {
        return this.gerouProcessoFiscalizacao;
    }

    public void setGerouProcessoFiscalizacao(String gerouProcessoFiscalizacao) {
        this.gerouProcessoFiscalizacao = gerouProcessoFiscalizacao;
    }

    public LaudoAlvaraEntity getLaudoIndeferimento() {
        return this.laudoIndeferimento;
    }

    public void setLaudoIndeferimento(LaudoAlvaraEntity laudoIndeferimento) {
        this.laudoIndeferimento = laudoIndeferimento;
    }

    public List<HistoricoRenovacaoAlvaraEntity> getHistoricosRenovacao() {
        return this.historicosRenovacao;
    }

    public void setHistoricosRenovacao(List<HistoricoRenovacaoAlvaraEntity> historicosRenovacao) {
        this.historicosRenovacao = historicosRenovacao;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataValidade == null ? 0 : this.dataValidade.hashCode());
        result = 31 * result + (this.idSolicitacaoAlvara == null ? 0 : this.idSolicitacaoAlvara.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.tipoLaudo == null ? 0 : this.tipoLaudo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LaudoAlvaraEntity other = (LaudoAlvaraEntity)obj;
        if (this.dataValidade == null ? other.dataValidade != null : !this.dataValidade.equals(other.dataValidade)) {
            return false;
        }
        if (this.idSolicitacaoAlvara == null ? other.idSolicitacaoAlvara != null : !this.idSolicitacaoAlvara.equals(other.idSolicitacaoAlvara)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals((Object)other.status)) {
            return false;
        }
        return !(this.tipoLaudo == null ? other.tipoLaudo != null : !this.tipoLaudo.equals((Object)other.tipoLaudo));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LaudoAlvaraEntity [idLaudoAlvara=");
        builder.append(this.idLaudoAlvara);
        builder.append(", idSolicitacaoAlvara=");
        builder.append(this.idSolicitacaoAlvara);
        builder.append(", tipoLaudo=");
        builder.append(this.tipoLaudo);
        builder.append(", status=");
        builder.append(this.status);
        builder.append(", dataValidade=");
        builder.append(this.dataValidade);
        builder.append("]");
        return builder.toString();
    }

    public boolean isLaudoLiberadoProvisorio() {
        if (this.getStatus() == null) {
            return false;
        }
        return StatusLaudoAlvara.LIBERADO_PROVISORIO.getCodigo().equals(this.getStatus().getCodigo());
    }

    public boolean isLaudoLiberadoDefinitivo() {
        if (this.getStatus() == null) {
            return false;
        }
        return StatusLaudoAlvara.LIBERADO_DEFINITIVO.getCodigo().equals(this.getStatus().getCodigo());
    }

    public boolean isLaudoNaoLiberado() {
        if (Objects.isNull(this.getStatus())) {
            return false;
        }
        return StatusLaudoAlvara.NAO_LIBERADO.equals((Object)this.getStatus());
    }

    public boolean isLaudoLiberadoDefinitivoOuProvisorio() {
        return this.isLaudoLiberadoDefinitivo() || this.isLaudoLiberadoProvisorio();
    }

    public boolean isLaudoLiberadoDefinitivoOuLiberdadeEconomica() {
        return this.isLaudoLiberadoDefinitivo() || this.isLaudoLiberadoLiberdadeEconomica();
    }

    public boolean isLaudoEmAndamento() {
        if (this.getStatus() == null) {
            return false;
        }
        return StatusLaudoAlvara.EM_ANDAMENTO.getCodigo().equals(this.getStatus().getCodigo());
    }

    public String observacoesDeParecerPredefinidas() {
        StringBuilder builder = new StringBuilder();
        if (!EloListUtils.safeIsEmpty((List)this.observacoesTipoLaudo).booleanValue()) {
            for (ObservacaoTipoLaudoEntity obs : this.observacoesTipoLaudo) {
                if (!SimNaoEnum.NAO.getShortText().equals(obs.getExibirNoAlvara())) continue;
                builder.append(obs.getDescricao());
            }
        }
        return builder.toString();
    }

    public boolean isLaudoIndeferido() {
        return this.status == StatusLaudoAlvara.INDEFERIDO;
    }

    public String getEnviadoFiscalizacao() {
        return this.enviadoFiscalizacao;
    }

    public void setEnviadoFiscalizacao(String enviadoFiscalizacao) {
        this.enviadoFiscalizacao = enviadoFiscalizacao;
    }

    public Date getDataUltimoHistoricoRenovacao() {
        if (!EloListUtils.safeIsEmpty((List)this.historicosRenovacao).booleanValue() && StatusLaudoAlvara.RENOVAR.getCodigo().equals(this.getStatus().getCodigo())) {
            return Collections.max(this.historicosRenovacao, Comparator.comparing(HistoricoRenovacaoAlvaraEntity::getDataInclusao)).getDataInclusao();
        }
        return null;
    }

    public boolean isLaudoLiberadoLiberdadeEconomica() {
        return this.status == StatusLaudoAlvara.LIBERDADE_ECONOMICA;
    }

    public boolean possuiAnexoNoLaudo() {
        return EloListUtils.safeIsEmpty((List)this.documentos) == false;
    }

    public boolean isVistoriadoFiscalizacao() {
        return this.vistoriadoFiscalizacao;
    }

    public void setVistoriadoFiscalizacao(boolean vistoriadoFiscalizacao) {
        this.vistoriadoFiscalizacao = vistoriadoFiscalizacao;
    }
}

