/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.domain;

import br.com.elotech.domainLayer.EntityDef;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ObservacaoAndamentoLaudoEntity;
import br.com.elotech.portalarrecadacao.domain.ProcessoFiscalizacaoEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.type.StatusLaudoType;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;

@TypeDefs(value={@TypeDef(name="statusLaudoType", typeClass=StatusLaudoType.class)})
@Entity(name="AndamentoLaudoAlvara")
@Table(name="TribAndamentoLaudoAlvara")
public class AndamentoLaudoAlvaraEntity
implements EntityDef {
    private static final long serialVersionUID = 1L;
    @Id
    private Long idAndamentoLaudoAlvara;
    @ManyToOne
    @JoinColumn(name="idLaudoAlvara", referencedColumnName="idLaudoAlvara")
    private LaudoAlvaraEntity idLaudoAlvara;
    @Transient
    private String descricao;
    @Type(type="statusLaudoType")
    private StatusLaudoAlvara status;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataAndamento;
    @ManyToOne
    @JoinColumn(name="usuario", referencedColumnName="usuario")
    private UsuarioEntity usuario;
    @Temporal(value=TemporalType.DATE)
    private Date validadeProvisorio;
    private String nomeVistoriante;
    @OneToMany(mappedBy="idAndamentoLaudoAlvara", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ObservacaoAndamentoLaudoEntity> observacoes;
    @OneToOne(cascade={CascadeType.ALL}, mappedBy="andamentoLaudoAlvara")
    private ProcessoFiscalizacaoEntity processoFiscalizacao;

    public Date getValidadeProvisorio() {
        return this.validadeProvisorio;
    }

    public void setValidadeProvisorio(Date validadeProvisorio) {
        this.validadeProvisorio = validadeProvisorio;
    }

    public Long getIdAndamentoLaudoAlvara() {
        return this.idAndamentoLaudoAlvara;
    }

    public void setIdAndamentoLaudoAlvara(Long idAndamentoLaudoAlvara) {
        this.idAndamentoLaudoAlvara = idAndamentoLaudoAlvara;
    }

    public LaudoAlvaraEntity getIdLaudoAlvara() {
        return this.idLaudoAlvara;
    }

    public void setIdLaudoAlvara(LaudoAlvaraEntity idLaudoAlvara) {
        this.idLaudoAlvara = idLaudoAlvara;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public StatusLaudoAlvara getStatus() {
        return this.status;
    }

    public void setStatus(StatusLaudoAlvara status) {
        this.status = status;
    }

    public Date getDataAndamento() {
        return this.dataAndamento;
    }

    public void setDataAndamento(Date dataAndamento) {
        this.dataAndamento = dataAndamento;
    }

    public UsuarioEntity getUsuario() {
        return this.usuario;
    }

    public void setUsuario(UsuarioEntity usuario) {
        this.usuario = usuario;
    }

    public String getNomeVistoriante() {
        return this.nomeVistoriante;
    }

    public void setNomeVistoriante(String nomeVistoriante) {
        this.nomeVistoriante = nomeVistoriante;
    }

    public List<ObservacaoAndamentoLaudoEntity> getObservacoes() {
        if (this.observacoes == null) {
            this.observacoes = new LinkedList();
        } else {
            Collections.sort(this.observacoes, new /* Unavailable Anonymous Inner Class!! */);
        }
        return this.observacoes;
    }

    public void setObservacoes(List<ObservacaoAndamentoLaudoEntity> observacoes) {
        this.observacoes = observacoes;
    }

    public List<ObservacaoAndamentoLaudoEntity> observacoesNaoResolvidas() {
        LinkedList<ObservacaoAndamentoLaudoEntity> observacoesNaoResolvidas = new LinkedList<ObservacaoAndamentoLaudoEntity>();
        for (ObservacaoAndamentoLaudoEntity obs : this.getObservacoes()) {
            if (obs.getResolvido() != null && !obs.getResolvido().equals("N")) continue;
            observacoesNaoResolvidas.add(obs);
        }
        return observacoesNaoResolvidas;
    }

    public ProcessoFiscalizacaoEntity getProcessoFiscalizacao() {
        return this.processoFiscalizacao;
    }

    public void setProcessoFiscalizacao(ProcessoFiscalizacaoEntity processoFiscalizacao) {
        this.processoFiscalizacao = processoFiscalizacao;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataAndamento == null ? 0 : this.dataAndamento.hashCode());
        result = 31 * result + (this.descricao == null ? 0 : this.descricao.hashCode());
        result = 31 * result + (this.idAndamentoLaudoAlvara == null ? 0 : this.idAndamentoLaudoAlvara.hashCode());
        result = 31 * result + (this.idLaudoAlvara == null ? 0 : this.idLaudoAlvara.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AndamentoLaudoAlvaraEntity other = (AndamentoLaudoAlvaraEntity)obj;
        if (this.dataAndamento == null ? other.dataAndamento != null : !this.dataAndamento.equals(other.dataAndamento)) {
            return false;
        }
        if (this.descricao == null ? other.descricao != null : !this.descricao.equals(other.descricao)) {
            return false;
        }
        if (this.idAndamentoLaudoAlvara == null ? other.idAndamentoLaudoAlvara != null : !this.idAndamentoLaudoAlvara.equals(other.idAndamentoLaudoAlvara)) {
            return false;
        }
        if (this.idLaudoAlvara == null ? other.idLaudoAlvara != null : !this.idLaudoAlvara.equals((Object)other.idLaudoAlvara)) {
            return false;
        }
        return !(this.status == null ? other.status != null : !this.status.equals((Object)other.status));
    }
}

