/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.domain.TipoExigenciaEntity;
import br.com.elotech.portalarrecadacao.repository.RepositoryTipoExigencia;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.sql.Modulo;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryTipoExigencia")
public class DaoTipoExigenciaHibernate
extends DaoSequenciaHibernate<TipoExigenciaEntity, Long>
implements RepositoryTipoExigencia {
    private static final long serialVersionUID = 1L;

    public DaoTipoExigenciaHibernate() {
        super(TipoExigenciaEntity.class);
    }

    public List<TipoExigenciaEntity> consultarPorDescricao(String descricao) {
        DetachedCriteria criteria = DetachedCriteria.forClass(TipoExigenciaEntity.class);
        if (StringUtils.isNotBlank((String)descricao)) {
            criteria = criteria.add(Restrictions.ilike((String)"descricao", (String)descricao, (MatchMode)MatchMode.ANYWHERE));
        }
        return this.findByCriteria(criteria);
    }

    public List<TipoExigenciaEntity> carregarTiposExigenciaAtivos() {
        DetachedCriteria criteria = DetachedCriteria.forClass(TipoExigenciaEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"ativo", (Object)SimNaoEnum.SIM.getShortText()));
        return this.findByCriteria(criteria);
    }

    public Long getSequence() {
        return super.getSequence(Modulo.ALVARAONLINE, "tipoExigencia");
    }
}

