/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.domainLayer.EntityDef;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.portalarrecadacao.repository.RepositoryTipoDocumentoUsuarioAlvara;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.tributacao.domain.aise.TipoDocumentoUsuarioAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.util.sql.Modulo;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryTipoDocumentoUsuarioAlvara")
public class DaoTipoDocumentoUsuarioAlvaraHibernate
extends DaoSequenciaHibernate<TipoDocumentoUsuarioAlvaraEntity, Long>
implements RepositoryTipoDocumentoUsuarioAlvara {
    private static final long serialVersionUID = -8153096470873396444L;

    public DaoTipoDocumentoUsuarioAlvaraHibernate() {
        super(TipoDocumentoUsuarioAlvaraEntity.class, Modulo.ALVARAONLINE, "TIPODOCUMENTOUSUARIOALVARA");
    }

    public List<TipoDocumentoUsuarioAlvaraEntity> saveList(List<TipoDocumentoUsuarioAlvaraEntity> tipoDocUsuarioAlvara) throws ValidacaoException {
        for (TipoDocumentoUsuarioAlvaraEntity doc : tipoDocUsuarioAlvara) {
            this.saveWithValidation(doc);
        }
        return tipoDocUsuarioAlvara;
    }

    public TipoDocumentoUsuarioAlvaraEntity saveWithValidation(TipoDocumentoUsuarioAlvaraEntity tipoDocUsuarioAlvara) throws ValidacaoException {
        tipoDocUsuarioAlvara.validar();
        return (TipoDocumentoUsuarioAlvaraEntity)super.save((EntityDef)tipoDocUsuarioAlvara);
    }

    public List<TipoDocumentoUsuarioAlvaraEntity> carregaTiposDocumentosPorUsuario(UsuarioEntity usuario) {
        DetachedCriteria criteria = DetachedCriteria.forClass(TipoDocumentoUsuarioAlvaraEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"usuario.usuario", (Object)usuario.getUsuario()));
        return this.findByCriteria(criteria);
    }

    public List<TipoDocumentoUsuarioAlvaraEntity> carregaTiposDocumentosPorIdUsuario(String idUsuario) {
        DetachedCriteria criteria = DetachedCriteria.forClass(TipoDocumentoUsuarioAlvaraEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"usuario.usuario", (Object)idUsuario));
        return this.findByCriteria(criteria);
    }
}

