/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.domain.SolicitacaoEncaminhadaEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroSolicitacaoEncaminhada;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoEncaminhada;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.util.sql.Modulo;
import br.com.elotech.util.string.EloStringUtils;
import java.util.List;
import java.util.Objects;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositorySolicitacaoEncaminhada")
public class DaoSolicitacaoEncaminhadaHibernate
extends DaoSequenciaHibernate<SolicitacaoEncaminhadaEntity, Long>
implements RepositorySolicitacaoEncaminhada {
    private static final long serialVersionUID = 1L;

    public Long getSequence() {
        return super.getSequence(Modulo.ALVARAONLINE, "solicitacaoencaminhada");
    }

    public List<SolicitacaoEncaminhadaEntity> buscarSolicitacoes(FiltroSolicitacaoEncaminhada filtro) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SolicitacaoEncaminhadaEntity.class);
        if (Objects.nonNull(filtro)) {
            if (Objects.nonNull(filtro.getDataInicial())) {
                criteria.add((Criterion)Restrictions.ge((String)"dataSolicitacao", (Object)filtro.getDataInicial()));
            }
            if (Objects.nonNull(filtro.getDataFinal())) {
                criteria.add((Criterion)Restrictions.le((String)"dataSolicitacao", (Object)filtro.getDataFinal()));
            }
            if (!EloStringUtils.isEmpty((String)filtro.getProtocolo())) {
                criteria.add((Criterion)Restrictions.eq((String)"protocolo", (Object)filtro.getProtocolo().toUpperCase()));
            }
            if (Objects.nonNull(filtro.getEvento())) {
                criteria.createAlias("eventos", "e");
                criteria.add((Criterion)Restrictions.eq((String)"e.evento", (Object)filtro.getEvento().getEvento()));
            }
            if (Objects.nonNull(filtro.getEncaminhado())) {
                criteria.add((Criterion)Restrictions.eq((String)"encaminhado", (Object)filtro.getEncaminhado()));
            }
            if (!EloStringUtils.isEmpty((String)filtro.getTipoEmpresa())) {
                criteria.add((Criterion)Restrictions.eq((String)"tipoEmpresa", (Object)filtro.getTipoEmpresa()));
            }
            criteria.addOrder(Order.desc((String)"dataSolicitacao"));
        }
        return this.findByCriteria(criteria);
    }
}

