/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.domain.SolicitacaoDocRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoDocRedeSim;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.sql.Modulo;
import java.util.List;
import java.util.Objects;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositorySolicitacaoDocRedeSim")
public class DaoSolicitacaoDocRedeSimHibernate
extends DaoSequenciaHibernate<SolicitacaoDocRedeSimEntity, Long>
implements RepositorySolicitacaoDocRedeSim {
    private static final long serialVersionUID = 1L;

    public DaoSolicitacaoDocRedeSimHibernate() {
        super(SolicitacaoDocRedeSimEntity.class);
    }

    public Long getSequence() {
        return super.getSequence(Modulo.ALVARAONLINE, "solicitacaodocredesim");
    }

    public List<SolicitacaoDocRedeSimEntity> getSolicitacaoDocByProtocolo(String protocolo, String finalizado) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SolicitacaoDocRedeSimEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"protocolo", (Object)protocolo));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"finalizado", (Object)finalizado), (Criterion)Restrictions.isNull((String)"finalizado")));
        return this.findByCriteria(criteria);
    }

    public List<SolicitacaoDocRedeSimEntity> findSolicitacaoDocumentoByProtocolo(String protocolo, String finalizado) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SolicitacaoDocRedeSimEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"protocolo", (Object)protocolo));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"finalizado", (Object)finalizado), (Criterion)Restrictions.isNull((String)"finalizado")));
        return this.findByCriteria(criteria);
    }

    public List<SolicitacaoDocRedeSimEntity> findSolicitacaoDocumentoProcesadaAutomaticamenteByProtocoloAndModeloDocumento(String protocolo, Long modeloDocumento) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SolicitacaoDocRedeSimEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"protocolo", (Object)protocolo));
        criteria.add((Criterion)Restrictions.eq((String)"tipoModeloDocumento", (Object)modeloDocumento));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"processadoAutomatico", (Object)SimNaoEnum.getSimShortText()), (Criterion)Restrictions.isNull((String)"processadoAutomatico")));
        return this.findByCriteria(criteria);
    }

    public List<SolicitacaoDocRedeSimEntity> getSolicitacoesDocumento(SolicitacaoRedeSimEntity solicitacao) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SolicitacaoDocRedeSimEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"protocolo", (Object)solicitacao.getProtocolo()));
        return this.findByCriteria(criteria);
    }

    public List<SolicitacaoDocRedeSimEntity> findSolicitacaoDocumentoByProtocoloAndTipoDocumento(String protocolo, Long modeloDocumento) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SolicitacaoDocRedeSimEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"protocolo", (Object)protocolo));
        if (Objects.nonNull(modeloDocumento)) {
            criteria.add((Criterion)Restrictions.eq((String)"tipoModeloDocumento", (Object)modeloDocumento));
        } else {
            criteria.add(Restrictions.isNull((String)"tipoModeloDocumento"));
        }
        return this.findByCriteria(criteria);
    }

    public SolicitacaoDocRedeSimEntity getSolicitacaoDocumentoByProtocoloAndTipoDocumento(String protocolo, Long modeloDocumento) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SolicitacaoDocRedeSimEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"protocolo", (Object)protocolo));
        criteria.add((Criterion)Restrictions.eq((String)"tipoModeloDocumento", (Object)modeloDocumento));
        return (SolicitacaoDocRedeSimEntity)this.findByCriteriaUnique(criteria);
    }
}

