/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.domain.Page;
import br.com.elotech.portalarrecadacao.controller.dataModel.SolicitacaoAlvaraDataModel;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.domain.vo.SolicitacaoAlvaraVo;
import br.com.elotech.portalarrecadacao.domain.vod.DispensaAmbientalVO;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoDocumentoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoPesquisaDispensaAmbientalEnum;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.ContratoSocialEntity;
import br.com.elotech.tributacao.domain.aise.ContratoSocialPessoaEntity;
import br.com.elotech.tributacao.domain.aise.SituacaoMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.enumerator.TipoLaudoEnum;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.math.EloNumberUtils;
import br.com.elotech.util.sql.EloSqlUtils;
import br.com.elotech.util.sql.Modulo;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.base.Strings;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository(value="repositorySolicitacaoAlvara")
public class DaoSolicitacaoAlvaraHibernate
extends DaoSequenciaHibernate<SolicitacaoAlvaraEntity, Long>
implements RepositorySolicitacaoAlvara {
    private static final long serialVersionUID = 6779138285190521001L;
    private static final Long TIPO_CADASTRO_IMOBILIARIO = 1L;
    private static final String TODOS = "T";

    public DaoSolicitacaoAlvaraHibernate() {
        super(SolicitacaoAlvaraEntity.class);
    }

    public boolean existeAlvaraPorEndereco(CadastroImobiliarioEntity cadastroImobiliario) {
        String sql = "select s from SolicitacaoAlvara s where s.cadastroImobiliario.id.codigo = " + cadastroImobiliario.getId().getCodigo();
        return EloListUtils.safeIsEmpty((List)this.findByHql(sql)) == false;
    }

    public SolicitacaoAlvaraEntity buscaSolicitacaoPorCpfCnpjExercicioNumSolic(Long numeroSolicitacao, Long exercicio, String cpfCnpj) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SolicitacaoAlvaraEntity.class).add((Criterion)Restrictions.eq((String)"numeroSolicitacao", (Object)numeroSolicitacao)).add((Criterion)Restrictions.eq((String)"exercicio", (Object)exercicio));
        if (!EloStringUtils.isEmpty((String)cpfCnpj)) {
            criteria.add((Criterion)Restrictions.eq((String)"cpfCnpj", (Object)cpfCnpj));
        }
        return (SolicitacaoAlvaraEntity)this.findByCriteriaUnique(criteria);
    }

    public List<SolicitacaoAlvaraEntity> getSolicitacoesSemProcessoFiscalizacaoGerado() {
        StringBuilder hql = new StringBuilder();
        hql.append("select distinct new br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity( ");
        hql.append(" solicitacao.solicitacaoAlvara, ");
        hql.append(" solicitacao.numeroSolicitacao, ");
        hql.append(" solicitacao.exercicio, ");
        hql.append(" solicitacao.tipoDeInscricao, ");
        hql.append(" solicitacao.processoGerado ");
        hql.append(" ) ");
        hql.append(" from SolicitacaoAlvara solicitacao ");
        hql.append(" inner join solicitacao.laudos laudo ");
        hql.append(" where solicitacao.processoGerado is null or solicitacao.processoGerado = 'N' ");
        hql.append(" and laudo.tipoLaudo.codigo = :tipoLaudo");
        hql.append(" and laudo.status != :statusEmAndamento");
        hql.append(" and laudo.status != :statusNaoLiberado");
        Query query = EloSqlUtils.createQuery((String)hql.toString());
        query.setParameter("tipoLaudo", (Object)TipoLaudoEnum.INSCRICAO_CADASTRAL);
        query.setParameter("statusEmAndamento", (Object)StatusLaudoAlvara.EM_ANDAMENTO);
        query.setParameter("statusNaoLiberado", (Object)StatusLaudoAlvara.NAO_LIBERADO);
        return query.list();
    }

    public Long getSequence() {
        return super.getSequence(Modulo.ALVARAONLINE, "solicitacaoalvara");
    }

    public Long getNumeroSolicitacao(Long entidade, Long exercicio) {
        return super.getSequence(Modulo.ALVARAONLINE, "numerosolicitacao_" + entidade + "_" + exercicio);
    }

    public List<SolicitacaoAlvaraEntity> buscaSolicitacaoPorCpfCnpj(SolicitacaoAlvaraVo vo) {
        if (vo == null || this.filtroInvalido(vo)) {
            throw new IllegalArgumentException("Filtro inv\u00e1lido para pesquisar.");
        }
        StringBuilder str = new StringBuilder();
        if (vo.getNumeroSolicitacao() != null && !EloStringUtils.isEmpty((String)vo.getNumeroSolicitacao()) && EloNumberUtils.isBiggerThanZero((Number)vo.getExercicio()).booleanValue()) {
            this.criarCabecalhoConsultaHql(str);
            str.append(" s.numeroSolicitacao = ").append(Long.valueOf(vo.getNumeroSolicitacao()));
            str.append(" and s.exercicio = ").append(vo.getExercicio());
            this.adicionarFinalizado(str);
            this.adicionarOrdenacaoHql(str);
        } else if (!EloStringUtils.isEmpty((String)vo.getProtocoloRedeSim())) {
            this.criarCabecalhoConsultaHql(str);
            str.append(" s.protocoloRedeSim = '").append(vo.getProtocoloRedeSim()).append("'");
            this.adicionarFinalizado(str);
            this.adicionarOrdenacaoHql(str);
        } else if (!EloStringUtils.isEmpty((String)vo.getCpfCnpj())) {
            this.criarCabecalhoConsultaHql(str);
            str.append(" s.cadastroMobiliario.cadastroGeral.pessoa.cnpjCpf = '").append(vo.getCpfCnpj()).append("'");
            this.adicionarFinalizado(str);
            this.adicionarOrdenacaoHql(str);
        }
        if (str.toString().isEmpty()) {
            return null;
        }
        return this.findByHql(str.toString());
    }

    private void adicionarFinalizado(StringBuilder str) {
        str.append("and s.finalizado = 'S'");
    }

    private void criarCabecalhoConsultaHql(StringBuilder str) {
        str.append(" Select s From SolicitacaoAlvara s where ");
    }

    private void adicionarOrdenacaoHql(StringBuilder str) {
        str.append(" order by s.dataSolicitacao desc ");
    }

    private boolean filtroInvalido(SolicitacaoAlvaraVo vo) {
        return (EloStringUtils.isEmpty((String)vo.getNumeroSolicitacao()) || EloNumberUtils.isBiggerThanZero((Number)vo.getExercicio()) == false) && EloStringUtils.isEmpty((String)vo.getProtocoloRedeSim()) && EloStringUtils.isEmpty((String)vo.getCpfCnpj());
    }

    public List<SolicitacaoAlvaraEntity> buscaSolicitacoesParaValidar(Long numeroSolicitacao, Long exercicio, String cpfCnpj, Date dataInicial, Date dataFinal, boolean documentoNaoValidado) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SolicitacaoAlvaraEntity.class).setResultTransformer(DetachedCriteria.DISTINCT_ROOT_ENTITY).add((Criterion)Restrictions.eq((String)"finalizado", (Object)"S")).addOrder(Order.desc((String)"numeroSolicitacao"));
        if (EloNumberUtils.isBiggerThanZero((Number)numeroSolicitacao).booleanValue()) {
            criteria.add((Criterion)Restrictions.eq((String)"numeroSolicitacao", (Object)numeroSolicitacao));
        }
        if (EloNumberUtils.isBiggerThanZero((Number)exercicio).booleanValue()) {
            criteria.add((Criterion)Restrictions.eq((String)"exercicio", (Object)exercicio));
        }
        if (!EloStringUtils.isEmpty((String)cpfCnpj)) {
            criteria.add((Criterion)Restrictions.eq((String)"cpfCnpj", (Object)cpfCnpj));
        }
        if (dataInicial != null) {
            if (dataFinal != null) {
                criteria.add(Restrictions.between((String)"dataSolicitacao", (Object)dataInicial, (Object)dataFinal));
            } else {
                criteria.add((Criterion)Restrictions.gt((String)"dataSolicitacao", (Object)dataInicial));
            }
        } else if (dataFinal != null) {
            criteria.add((Criterion)Restrictions.lt((String)"dataSolicitacao", (Object)dataFinal));
        }
        if (documentoNaoValidado) {
            criteria.createCriteria("documentos").add((Criterion)Restrictions.eq((String)"situacao", (Object)"EM_ANALISE"));
        }
        return this.findByCriteriaAny(criteria);
    }

    public List<SolicitacaoAlvaraEntity> buscaSolicitacoesParecerDosLaudos(String solicitacao, String cpfCnpj, Date dataInicial, Date dataFinal, TipoLaudoEntity tipoLaudo, StatusLaudoAlvara situacaoLaudo) {
        StringBuilder query = new StringBuilder();
        query.append("Select distinct sol From SolicitacaoAlvara sol , LaudoAlvara laudo , TipoLaudo tipo");
        query.append(" where sol.solicitacaoAlvara = laudo.idSolicitacaoAlvara.solicitacaoAlvara ");
        query.append(" and laudo.tipoLaudo.idTipoLaudo = tipo.idTipoLaudo and sol.finalizado = 'S' ");
        if (tipoLaudo != null) {
            query.append(" and tipo.idTipoLaudo = " + tipoLaudo.getIdTipoLaudo());
        }
        if (situacaoLaudo != null) {
            if (StatusLaudoAlvara.EM_ANDAMENTO == situacaoLaudo) {
                query.append(" and (laudo.status = '" + StatusLaudoAlvara.EM_ANDAMENTO + "' or laudo.vistoriar = 'S') ");
            } else {
                query.append(" and  laudo.status = '" + situacaoLaudo.getCodigo() + "'");
            }
        }
        if (!EloStringUtils.isEmpty((String)solicitacao)) {
            try {
                String[] consulta = solicitacao.split("/");
                query.append(" and sol.numeroSolicitacao = " + consulta[0] + " and sol.exercicio = " + consulta[1]);
            }
            catch (Exception e) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"Verifique o n\u00famero informado. O n\u00famero deve estar no formato 'n\u00famero/ano'. Exemplo: 10/2015");
            }
        }
        if (!EloStringUtils.isEmpty((String)cpfCnpj)) {
            query.append(" and sol.cpfCnpj = '" + cpfCnpj + "'");
        }
        if (dataInicial != null) {
            if (dataFinal != null) {
                query.append(" and  sol.dataSolicitacao between '" + EloDateUtils.toAnsiDateString((Date)dataInicial) + "' and '" + EloDateUtils.toAnsiDateString((Date)dataFinal) + "'");
            } else {
                query.append(" and sol.dataSolicitacao >= '" + EloDateUtils.toAnsiDateString((Date)dataInicial) + "'");
            }
        } else if (dataFinal != null) {
            query.append(" and sol.dataSolicitacao <= '" + EloDateUtils.toAnsiDateString((Date)dataFinal) + "'");
        }
        query.append(" order by sol.dataSolicitacao desc");
        return this.findByHql(query.toString());
    }

    public Long getSequenceNumeroAlvara(String entidade, String exercicio, String grupo) {
        return super.getSequence(Modulo.TRIBUTOS, "DOCUMENTOGRUPO_" + entidade + "_" + exercicio + "_" + grupo);
    }

    public SolicitacaoAlvaraEntity buscaConsultaPreviaPorCpfCnpjExercicioNumSolic(Long solicitacao, Long exercicio, String cpfCnpj) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SolicitacaoAlvaraEntity.class).add((Criterion)Restrictions.eq((String)"numeroSolicitacao", (Object)solicitacao)).add((Criterion)Restrictions.eq((String)"exercicio", (Object)exercicio));
        if (!EloStringUtils.isEmpty((String)cpfCnpj)) {
            criteria.add((Criterion)Restrictions.eq((String)"cpfCnpjConsulta", (Object)cpfCnpj));
        }
        return (SolicitacaoAlvaraEntity)this.findByCriteriaUnique(criteria);
    }

    public Page<SolicitacaoAlvaraEntity> carregarListaSolicitacaoAlvaraPaginado(SolicitacaoAlvaraDataModel solicitacaoAlvara, Integer pagina, Integer tamanhoPagina) {
        String resultado;
        StringBuilder hqlSolicitacao = new StringBuilder();
        StringBuilder hqlCount = new StringBuilder();
        StringBuilder hqlCondicoes = new StringBuilder();
        hqlSolicitacao.append("select distinct solicitacao from SolicitacaoAlvara solicitacao ");
        hqlCount.append("select count(distinct solicitacao.solicitacaoAlvara) from SolicitacaoAlvara solicitacao ");
        if (solicitacaoAlvara.getTipoLaudoFiltro() != null || !EloListUtils.safeIsEmpty((List)solicitacaoAlvara.getTiposLaudoFiltro()).booleanValue() || solicitacaoAlvara.getSituacaoLaudoFiltro() != null || !EloListUtils.safeIsEmpty((List)solicitacaoAlvara.getSituacoesLaudoFiltro()).booleanValue() || solicitacaoAlvara.getLaudoDocumentosNaoValidadosFiltro() || solicitacaoAlvara.isSolicitacoesComAnexoNosLaudosFiltro()) {
            hqlCondicoes.append(" join solicitacao.laudos laudo ");
        }
        if (!EloListUtils.safeIsEmpty((List)solicitacaoAlvara.getSituacoesDocumento()).booleanValue() || solicitacaoAlvara.isSomenteComDocumentosValidados() || solicitacaoAlvara.isBuscaPendenciaRenovacao()) {
            hqlCondicoes.append(" left join solicitacao.documentos doc ");
        }
        if (solicitacaoAlvara.getNaturezaSolicitacaoFiltro() != null) {
            hqlCondicoes.append(" join solicitacao.naturezas nat ");
        }
        if (solicitacaoAlvara.getLaudoDocumentosNaoValidadosFiltro() || solicitacaoAlvara.isSolicitacoesComAnexoNosLaudosFiltro()) {
            hqlCondicoes.append(" join laudo.documentos docsLaudo");
        }
        hqlCondicoes.append(" where solicitacao.finalizado = 'S' ");
        if (EloNumberUtils.isBiggerThanZero((Number)solicitacaoAlvara.getNumeroSolicitacaoFiltro()).booleanValue()) {
            hqlCondicoes.append(" and solicitacao.numeroSolicitacao = ").append(solicitacaoAlvara.getNumeroSolicitacaoFiltro());
        }
        if (!EloStringUtils.isEmpty((String)solicitacaoAlvara.getCpfCnpjFiltro())) {
            hqlCondicoes.append(" and solicitacao.cpfCnpj = '").append(solicitacaoAlvara.getCpfCnpjFiltro()).append("' ");
        }
        if (solicitacaoAlvara.getDataInicialFiltro() != null) {
            hqlCondicoes.append(" and solicitacao.dataSolicitacao >= :dataInicial ");
        }
        if (solicitacaoAlvara.getDataFinalFiltro() != null) {
            hqlCondicoes.append(" and solicitacao.dataSolicitacao <= :dataFinal ");
        }
        if (solicitacaoAlvara.getTipoLaudoFiltro() != null) {
            hqlCondicoes.append(" and laudo.tipoLaudo.idTipoLaudo = ").append(solicitacaoAlvara.getTipoLaudoFiltro().getIdTipoLaudo());
        }
        if (!EloListUtils.safeIsEmpty((List)solicitacaoAlvara.getTiposLaudoFiltro()).booleanValue()) {
            resultado = solicitacaoAlvara.getTiposLaudoFiltro().stream().map(tipoLaudo -> tipoLaudo.getIdTipoLaudo().toString()).collect(Collectors.joining(", "));
            hqlCondicoes.append(" and laudo.tipoLaudo.idTipoLaudo in (").append(resultado).append(")");
        }
        if (solicitacaoAlvara.getSituacaoLaudoFiltro() != null) {
            hqlCondicoes.append(" and laudo.status = '").append(solicitacaoAlvara.getSituacaoLaudoFiltro().getCodigo()).append("' ");
        }
        if (!EloListUtils.safeIsEmpty((List)solicitacaoAlvara.getSituacoesLaudoFiltro()).booleanValue()) {
            resultado = solicitacaoAlvara.getSituacoesLaudoFiltro().stream().map(situacao -> "'" + situacao.getCodigo() + "'").collect(Collectors.joining(", "));
            hqlCondicoes.append(" and laudo.status in (").append(resultado).append(")");
        }
        if (EloNumberUtils.isBiggerThanZero((Number)solicitacaoAlvara.getExercicio()).booleanValue()) {
            hqlCondicoes.append(" and solicitacao.exercicio = " + solicitacaoAlvara.getExercicio());
        }
        if (!EloListUtils.safeIsEmpty((List)solicitacaoAlvara.getSituacoesDocumento()).booleanValue()) {
            resultado = solicitacaoAlvara.getSituacoesDocumento().stream().map(documento -> "'" + documento.name() + "'").collect(Collectors.joining(", "));
            hqlCondicoes.append(" and doc.situacao in (").append(resultado).append(")");
        }
        if (solicitacaoAlvara.isBuscaPendenciaRenovacao()) {
            hqlCondicoes.append(" and doc.renovacao = 'S'");
        }
        if (Objects.nonNull(solicitacaoAlvara.getProcessoFiscalizacao())) {
            if (SimNaoEnum.SIM.getShortText().equals(solicitacaoAlvara.getProcessoFiscalizacao())) {
                hqlCondicoes.append("and solicitacao.processoGerado = 'S'");
            } else if (SimNaoEnum.NAO.getShortText().equals(solicitacaoAlvara.getProcessoFiscalizacao())) {
                hqlCondicoes.append("and solicitacao.processoGerado = 'N'");
            }
        }
        if (solicitacaoAlvara.getTipoInscricaoFiltro() != null) {
            TipoInscricaoAlvaraEntity tipoInscricao = solicitacaoAlvara.getTipoInscricaoFiltro();
            if ("M".equals(tipoInscricao.getSigla()) || "MP".equals(tipoInscricao.getSigla())) {
                hqlCondicoes.append(" and (solicitacao.tipoDeInscricao.sigla = '").append("M").append("'");
                hqlCondicoes.append("       or solicitacao.tipoDeInscricao.sigla = '").append("MP").append("')");
            } else {
                hqlCondicoes.append(" and solicitacao.tipoDeInscricao.sigla = '").append(tipoInscricao.getSigla()).append("'");
            }
        }
        if (solicitacaoAlvara.getNaturezaSolicitacaoFiltro() != null) {
            hqlCondicoes.append(" and nat.naturezaSolicitacao = ").append(solicitacaoAlvara.getNaturezaSolicitacaoFiltro().getNaturezaSolicitacao());
        }
        if (!EloStringUtils.isEmpty((String)solicitacaoAlvara.getCadastroImobiliarioFiltro())) {
            hqlCondicoes.append(" and solicitacao.cadastroImobiliario.id.codigo = ").append(Long.valueOf(solicitacaoAlvara.getCadastroImobiliarioFiltro()));
            hqlCondicoes.append(" and solicitacao.cadastroImobiliario.id.tipo = ").append(TIPO_CADASTRO_IMOBILIARIO);
        }
        if (solicitacaoAlvara.isSomenteComDocumentosValidados()) {
            hqlCondicoes.append("and (not exists ( select documento from SolicitacaoAlvaraDocumento documento ").append("where documento.solicitacaoAlvara = solicitacao and (documento.situacao != '").append(SituacaoDocumentoAlvaraEnum.VALIDADO.name()).append("') or documento.situacao is null) ").append("or not exists (select documento from SolicitacaoAlvaraDocumento documento where documento.solicitacaoAlvara = solicitacao) ) ");
        }
        if (!EloStringUtils.isEmpty((String)solicitacaoAlvara.getProtocoloRedeSim())) {
            hqlCondicoes.append(" and protocoloRedeSim = '").append(solicitacaoAlvara.getProtocoloRedeSim()).append("'");
        }
        if (solicitacaoAlvara.getLaudoDocumentosNaoValidadosFiltro()) {
            hqlCondicoes.append(" and docsLaudo.docValidado = 'N'");
        }
        if (solicitacaoAlvara.isSolicitacoesComAnexoNosLaudosFiltro()) {
            hqlCondicoes.append(" and exists (select docsLaudo2.id from LaudoAlvaraDocumento docsLaudo2 ").append(" where docsLaudo2.laudoAlvara = laudo.idLaudoAlvara)");
        }
        if (!Strings.isNullOrEmpty((String)solicitacaoAlvara.getGrauRisco()) && !solicitacaoAlvara.getGrauRisco().equals(TODOS)) {
            hqlCondicoes.append(" and grauRisco = '").append(solicitacaoAlvara.getGrauRisco()).append("'");
        }
        Query queryCount = EloSqlUtils.createQuery((String)hqlCount.append((CharSequence)hqlCondicoes).toString());
        Query query = EloSqlUtils.createQuery((String)hqlSolicitacao.append((CharSequence)hqlCondicoes).toString());
        query.setFirstResult(pagina.intValue()).setMaxResults(tamanhoPagina.intValue());
        if (solicitacaoAlvara.getDataInicialFiltro() != null) {
            queryCount.setParameter("dataInicial", (Object)solicitacaoAlvara.getDataInicialFiltro());
            query.setParameter("dataInicial", (Object)solicitacaoAlvara.getDataInicialFiltro());
        }
        if (solicitacaoAlvara.getDataFinalFiltro() != null) {
            queryCount.setParameter("dataFinal", (Object)solicitacaoAlvara.getDataFinalFiltro());
            query.setParameter("dataFinal", (Object)solicitacaoAlvara.getDataFinalFiltro());
        }
        Long count = (Long)queryCount.uniqueResult();
        List solicitacoes = query.list();
        return new Page(solicitacoes, count.longValue());
    }

    public Long getSequenceNumeroAlvara() {
        return super.getSequence(Modulo.ALVARAONLINE, "numeroalvara");
    }

    public SolicitacaoAlvaraEntity inicializarDadosSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacao) {
        Hibernate.initialize((Object)solicitacao.getDebitos());
        Hibernate.initialize((Object)solicitacao.getLaudos());
        if (Objects.nonNull(solicitacao.getSolicitacaoAlvaraAtividades())) {
            Hibernate.initialize((Object)solicitacao.getSolicitacaoAlvaraAtividades());
            solicitacao.getSolicitacaoAlvaraAtividades().forEach(p -> Hibernate.initialize((Object)p.getNumerosConselho()));
        }
        if (!EloListUtils.safeIsEmpty((List)solicitacao.getLaudos()).booleanValue()) {
            for (LaudoAlvaraEntity laudoAlvara : solicitacao.getLaudos()) {
                Hibernate.initialize((Object)laudoAlvara.getDocumentos());
                Hibernate.initialize((Object)laudoAlvara.getObservacoesTipoLaudo());
                Hibernate.initialize((Object)laudoAlvara.getHistoricosRenovacao());
            }
        }
        Hibernate.initialize((Object)solicitacao.getNaturezas());
        Hibernate.initialize((Object)solicitacao.getDocumentos());
        Hibernate.initialize((Object)solicitacao.getSefazDocumentos());
        Hibernate.initialize((Object)solicitacao.getSolicitacaoAlvaraAtividades());
        if (!EloListUtils.safeIsEmpty((List)solicitacao.getSolicitacaoAlvaraAtividades()).booleanValue()) {
            for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
                Hibernate.initialize((Object)atividade.getNumerosConselho());
            }
        }
        if (Objects.nonNull(solicitacao.getCadastroMobiliario())) {
            SituacaoMobiliarioEntity situacaoAtual;
            Hibernate.initialize((Object)solicitacao.getCadastroMobiliario());
            Hibernate.initialize((Object)solicitacao.getCadastroMobiliario().getCadastroGeral().getIsencoes());
            Hibernate.initialize((Object)solicitacao.getCadastroMobiliario().getMobiliarioHorarioEspecial());
            if (!EloListUtils.safeIsEmpty((List)solicitacao.getCadastroMobiliario().getContratosSociais()).booleanValue()) {
                Hibernate.initialize((Object)solicitacao.getCadastroMobiliario().getContratosSociais());
                for (ContratoSocialEntity contratoSocial : solicitacao.getCadastroMobiliario().getContratosSociais()) {
                    Hibernate.initialize((Object)contratoSocial.getPessoas());
                    for (ContratoSocialPessoaEntity contratoPessoa : contratoSocial.getPessoas()) {
                        Hibernate.initialize((Object)contratoPessoa.getId().getPessoa().getEnderecos());
                        Hibernate.initialize((Object)contratoPessoa.getId().getPessoa().getContatos());
                    }
                }
            }
            Hibernate.initialize((Object)solicitacao.getCadastroMobiliario().getMobiliarioCnaes());
            Hibernate.initialize((Object)solicitacao.getCadastroMobiliario().getMobiliarioAtividadeMeis());
            Hibernate.initialize((Object)solicitacao.getCadastroMobiliario().getMobiliarioCbos());
            Hibernate.initialize((Object)solicitacao.getCadastroMobiliario().getMobiliarioSituacao());
            Hibernate.initialize((Object)solicitacao.getCadastroMobiliario().getMobiliarioServicos());
            if (Objects.nonNull(solicitacao.getCadastroMobiliario().getCadastroGeral()) && Objects.nonNull(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa())) {
                Hibernate.initialize((Object)solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getEnderecos());
            }
            solicitacao.getCadastroMobiliario().getMobiliarioSituacao().stream().forEach(s -> {
                if (Objects.nonNull(s.getSituacaoMobiliario())) {
                    Hibernate.initialize((Object)s.getSituacaoMobiliario().getSituacoesMobiliarioAlvara());
                }
            });
            Hibernate.initialize((Object)solicitacao.getCadastroMobiliario().getCadastroGeral().getIsencoes());
            if (solicitacao.getCadastroMobiliario().getCadastroImobiliario() != null) {
                Hibernate.initialize((Object)solicitacao.getCadastroMobiliario().getCadastroImobiliario());
                Hibernate.initialize((Object)solicitacao.getCadastroMobiliario().getCadastroImobiliario().getTestadas());
                Hibernate.initialize((Object)solicitacao.getCadastroMobiliario().getCadastroImobiliario().getTestadasGenericas());
            }
            if ((situacaoAtual = solicitacao.getCadastroMobiliario().getMobiliarioSituacaoAtual()) != null) {
                Hibernate.initialize((Object)situacaoAtual.getSituacoesMobiliarioAlvara());
            }
            if (solicitacao.getCadastroMobiliario().getCadastroGeral() != null && solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa() != null) {
                Hibernate.initialize((Object)solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getContatos());
            }
        }
        this.carregarContratoSocial(solicitacao);
        if (Objects.nonNull(solicitacao.getCadastroImobiliario())) {
            Hibernate.initialize((Object)solicitacao.getCadastroImobiliario().getSegmentos());
            Hibernate.initialize((Object)solicitacao.getCadastroImobiliario().getTestadas());
        }
        return solicitacao;
    }

    public void carregarContratoSocial(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        if (solicitacaoAlvara.getContratoSocial() != null) {
            Hibernate.initialize((Object)solicitacaoAlvara.getContratoSocial().getPessoas());
        }
    }

    public List<DispensaAmbientalVO> carregarSolicitacoesSemLaudoAmbiental(TipoPesquisaDispensaAmbientalEnum tipoPesquisa) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SolicitacaoAlvaraEntity.class, (String)"sa").createAlias("sa.naturezas", "naturezaJuridica").add(Subqueries.notExists((DetachedCriteria)this.subQueryTipoLaudo())).add((Criterion)Restrictions.or((Criterion)this.inicial(), (Criterion)this.alteracaoAtividadeEEndereco())).add((Criterion)Restrictions.eq((String)"sa.finalizado", (Object)SimNaoEnum.getSimShortText())).addOrder(Order.desc((String)"sa.exercicio")).addOrder(Order.desc((String)"sa.numeroSolicitacao"));
        if (TipoPesquisaDispensaAmbientalEnum.NAO_EMITIDA.equals((Object)tipoPesquisa)) {
            criteria.createAlias("sa.solicitacaoDispensaAmbiental", "dispensa", 1);
            criteria.add(Restrictions.isNull((String)"dispensa.id"));
        } else if (TipoPesquisaDispensaAmbientalEnum.EMITIDA.equals((Object)tipoPesquisa)) {
            criteria.createAlias("sa.solicitacaoDispensaAmbiental", "dispensa", 0);
        } else {
            criteria.createAlias("sa.solicitacaoDispensaAmbiental", "dispensa", 1);
        }
        criteria.setProjection((Projection)Projections.projectionList().add((Projection)Projections.groupProperty((String)"solicitacaoAlvara"), "solicitacaoAlvara").add((Projection)Projections.groupProperty((String)"sa.numeroSolicitacao"), "numeroSolicitacao").add((Projection)Projections.groupProperty((String)"sa.exercicio"), "exercicio").add((Projection)Projections.groupProperty((String)"sa.dataSolicitacao"), "dataSolicitacao").add((Projection)Projections.groupProperty((String)"dispensa.id"), "dispensa").add((Projection)Projections.groupProperty((String)"nomeRazaoSocial"), "nomeRazaoSocial").add((Projection)Projections.groupProperty((String)"cpfCnpj"), "cpfCnpj").add((Projection)Projections.groupProperty((String)"dispensa.dataSolicitacao"), "dataEmissaoDispensa").add((Projection)Projections.groupProperty((String)"dispensa.solicitante"), "solicitante")).setResultTransformer(Transformers.aliasToBean(DispensaAmbientalVO.class));
        return this.findByCriteriaAny(criteria);
    }

    private Criterion alteracaoAtividadeEEndereco() {
        return Restrictions.or((Criterion)Restrictions.eq((String)"naturezaJuridica.codigo", (Object)NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO.getValue()), (Criterion)Restrictions.eq((String)"naturezaJuridica.codigo", (Object)NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE.getValue()));
    }

    private Criterion inicial() {
        return Restrictions.eq((String)"naturezaJuridica.codigo", (Object)NaturezaSolicitacaoAlvaraEnum.INICIAL.getValue());
    }

    private DetachedCriteria subQueryTipoLaudo() {
        return DetachedCriteria.forClass(LaudoAlvaraEntity.class, (String)"laudoAlvara").createAlias("laudoAlvara.tipoLaudo", "tipoLaudo").add((Criterion)Restrictions.eq((String)"tipoLaudo.codigo", (Object)TipoLaudoEnum.AMBIENTAL)).add((Criterion)Restrictions.eqProperty((String)"laudoAlvara.idSolicitacaoAlvara", (String)"sa.solicitacaoAlvara")).setProjection((Projection)Projections.id());
    }
}

