/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.domain.SituacaoDocRedeSimEntity;
import br.com.elotech.portalarrecadacao.filter.FiltroSituacaoDocumentoPorSituacaoLaudo;
import br.com.elotech.portalarrecadacao.repository.RepositorySituacaoDocRedeSim;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.util.math.EloNumberUtils;
import br.com.elotech.util.sql.Modulo;
import br.com.elotech.util.string.EloStringUtils;
import java.util.List;
import java.util.Objects;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositorySituacaoDocRedeSim")
public class DaoSituacaoDocRedeSimHibernate
extends DaoSequenciaHibernate<SituacaoDocRedeSimEntity, Long>
implements RepositorySituacaoDocRedeSim {
    private static final long serialVersionUID = 1L;

    public DaoSituacaoDocRedeSimHibernate() {
        super(SituacaoDocRedeSimEntity.class, Modulo.ALVARAONLINE, "situacaoDocRedeSim");
    }

    public SituacaoDocRedeSimEntity getSituacaoByCodigo(Long codigo) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SituacaoDocRedeSimEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"situacaoDocRedeSim", (Object)codigo));
        return (SituacaoDocRedeSimEntity)this.findByCriteriaUnique(criteria);
    }

    public List<SituacaoDocRedeSimEntity> buscarSituacoesDocRedeSim(FiltroSituacaoDocumentoPorSituacaoLaudo filtro) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SituacaoDocRedeSimEntity.class);
        if (!EloStringUtils.isEmpty((String)filtro.getDescricao())) {
            criteria.add(Restrictions.ilike((String)"descricao", (String)filtro.getDescricao(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (EloNumberUtils.isBiggerThanZero((Number)filtro.getCodigoSituacao()).booleanValue()) {
            criteria.add((Criterion)Restrictions.eq((String)"situacaoDocRedeSim", (Object)filtro.getCodigoSituacao()));
        }
        if (!Objects.isNull(filtro.getSituacaoLaudo())) {
            criteria.add((Criterion)Restrictions.eq((String)"situacaoLaudo", (Object)filtro.getSituacaoLaudo().getCodigo()));
        }
        criteria.addOrder(Order.asc((String)"situacaoDocRedeSim"));
        return this.findByCriteria(criteria);
    }
}

