/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.dao.DaoParametroAlvara;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraNaturezaEntity;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.FiltroParametroException;
import br.com.elotech.portalarrecadacao.filter.FiltroParametro;
import br.com.elotech.portalarrecadacao.repository.RepositoryParametroAlvara;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.tributacao.domain.ParametroGeralEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeAiseEntity;
import br.com.elotech.util.sql.Modulo;
import br.com.elotech.util.string.EloStringUtils;
import java.util.List;
import java.util.Objects;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryParametroAlvara")
public class DaoParametroAlvaraHibernate
extends DaoSequenciaHibernate<ParametroAlvaraEntity, Long>
implements DaoParametroAlvara,
RepositoryParametroAlvara {
    private static final long serialVersionUID = -512544191174316711L;

    public DaoParametroAlvaraHibernate() {
        super(ParametroAlvaraEntity.class);
    }

    public ParametroAlvaraEntity getParametroAlvara(EntidadeAiseEntity entidade, ParametroAlvaraEnum paramEnum) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ParametroAlvaraEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"entidade.id", (Object)entidade.getId()));
        criteria.add((Criterion)Restrictions.eq((String)"parametro", (Object)paramEnum));
        return (ParametroAlvaraEntity)this.findByCriteriaUnique(criteria);
    }

    public List<ParametroAlvaraEntity> carregarParametrosPorFiltro(FiltroParametro filtro) throws FiltroParametroException {
        if (Objects.isNull(filtro)) {
            throw new FiltroParametroException();
        }
        DetachedCriteria criteria = DetachedCriteria.forClass(ParametroAlvaraEntity.class);
        if (Objects.nonNull(filtro.getEntidade())) {
            criteria.add((Criterion)Restrictions.eq((String)"entidade", (Object)filtro.getEntidade()));
        }
        if (!EloStringUtils.isEmpty((String)filtro.getParametro())) {
            criteria.add(Restrictions.sqlRestriction((String)String.format(" upper(this_.parametro) like '%%%s%%' ", filtro.getParametro().toUpperCase())));
        }
        if (!EloStringUtils.isEmpty((String)filtro.getDescricao())) {
            criteria.add(Restrictions.ilike((String)"descricao", (String)filtro.getDescricao(), (MatchMode)MatchMode.ANYWHERE));
        }
        criteria.addOrder(Order.asc((String)"parametro"));
        return this.findByCriteria(criteria);
    }

    public List<ParametroGeralEntity> carregarParametrosGeralPorFiltro(FiltroParametro filtro) throws FiltroParametroException {
        if (Objects.isNull(filtro)) {
            throw new FiltroParametroException();
        }
        DetachedCriteria criteria = DetachedCriteria.forClass(ParametroGeralEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"id.modulo", (Object)Modulo.ALVARAONLINE.getCodigo()));
        if (Objects.nonNull(filtro.getEntidade())) {
            criteria.add((Criterion)Restrictions.eq((String)"entidade", (Object)filtro.getEntidade()));
        }
        if (!EloStringUtils.isEmpty((String)filtro.getParametro())) {
            criteria.add(Restrictions.ilike((String)"id.parametro", (String)filtro.getParametro(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (!EloStringUtils.isEmpty((String)filtro.getDescricao())) {
            criteria.add(Restrictions.ilike((String)"descricao", (String)filtro.getDescricao(), (MatchMode)MatchMode.ANYWHERE));
        }
        criteria.addOrder(Order.asc((String)"id.parametro"));
        return this.findByCriteriaAny(criteria);
    }

    public List<ParametroAlvaraNaturezaEntity> carregarParametrosNaturezaPorFiltro(FiltroParametro filtro) throws FiltroParametroException {
        if (Objects.isNull(filtro)) {
            throw new FiltroParametroException();
        }
        DetachedCriteria criteria = DetachedCriteria.forClass(ParametroAlvaraNaturezaEntity.class);
        if (Objects.nonNull(filtro.getEntidade())) {
            criteria.add((Criterion)Restrictions.eq((String)"entidade", (Object)filtro.getEntidade()));
        }
        if (!EloStringUtils.isEmpty((String)filtro.getParametro())) {
            criteria.add(Restrictions.sqlRestriction((String)String.format(" upper(this_.parametro) like '%%%s%%' ", filtro.getParametro().toUpperCase())));
        }
        if (!EloStringUtils.isEmpty((String)filtro.getDescricao())) {
            criteria.add(Restrictions.ilike((String)"descricao", (String)filtro.getDescricao(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (filtro.getNaturezaSolicitacao() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"naturezaSolicitacao", (Object)filtro.getNaturezaSolicitacao()));
        }
        if (filtro.getTipoInscricao() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"tipoInscricao", (Object)filtro.getTipoInscricao()));
        }
        criteria.addOrder(Order.asc((String)"parametro"));
        criteria.addOrder(Order.asc((String)"tipoInscricao"));
        criteria.addOrder(Order.asc((String)"naturezaSolicitacao"));
        return this.findByCriteriaAny(criteria);
    }
}

