/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.dao.DaoObservacaoTipoLaudo;
import br.com.elotech.portalarrecadacao.domain.ObservacaoTipoLaudoEntity;
import br.com.elotech.portalarrecadacao.repository.RepositoryObservacaoTipoLaudo;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import br.com.elotech.util.sql.EloSqlUtils;
import br.com.elotech.util.sql.Modulo;
import br.com.elotech.util.string.EloStringUtils;
import java.util.List;
import java.util.Objects;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryObservacaoTipoLaudo")
public class DaoObservacaoTipoLaudoHibernate
extends DaoSequenciaHibernate<ObservacaoTipoLaudoEntity, Long>
implements DaoObservacaoTipoLaudo,
RepositoryObservacaoTipoLaudo {
    private static final long serialVersionUID = 5097832292294964347L;
    private static final String TODOS = "T";

    public DaoObservacaoTipoLaudoHibernate() {
        super(ObservacaoTipoLaudoEntity.class);
    }

    public List<ObservacaoTipoLaudoEntity> getObservacoesTipoLaudo(TipoLaudoEntity tipoLaudo, String exibirNoAlvara) {
        StringBuilder hql = new StringBuilder();
        hql.append("select o from ObservacaoTipoLaudo o ");
        hql.append(" where o.idTipoLaudo.idTipoLaudo = :tipoLaudo ");
        if (!EloStringUtils.isEmpty((String)exibirNoAlvara) && !TODOS.equals(exibirNoAlvara)) {
            hql.append(" and o.exibirNoAlvara = :exibirNoAlvara  ");
        }
        hql.append(" order by o.id asc");
        Query query = EloSqlUtils.createQuery((String)hql.toString());
        query.setParameter("tipoLaudo", (Object)tipoLaudo.getIdTipoLaudo());
        if (!EloStringUtils.isEmpty((String)exibirNoAlvara) && !TODOS.equals(exibirNoAlvara)) {
            query.setParameter("exibirNoAlvara", (Object)exibirNoAlvara);
        }
        return query.list();
    }

    public Long getSequence() {
        return super.getSequence(Modulo.ALVARAONLINE, "observacaoTipoLaudo");
    }

    public List<ObservacaoTipoLaudoEntity> getObservacoes(ObservacaoTipoLaudoEntity observacao) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ObservacaoTipoLaudoEntity.class);
        if (Objects.nonNull(observacao)) {
            if (!EloStringUtils.isEmpty((String)observacao.getTitulo())) {
                criteria.add(Restrictions.ilike((String)"titulo", (String)observacao.getTitulo(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (!EloStringUtils.isEmpty((String)observacao.getDescricao())) {
                criteria.add(Restrictions.ilike((String)"descricao", (String)observacao.getDescricao(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (!EloStringUtils.isEmpty((String)observacao.getExibirNoAlvara())) {
                criteria.add((Criterion)Restrictions.eq((String)"exibirNoAlvara", (Object)observacao.getExibirNoAlvara()));
            }
            if (Objects.nonNull(observacao.getIdTipoLaudo())) {
                criteria.add((Criterion)Restrictions.eq((String)"idTipoLaudo.idTipoLaudo", (Object)observacao.getIdTipoLaudo().getIdTipoLaudo()));
            }
            return this.findByCriteria(criteria);
        }
        return this.findAll();
    }
}

