/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.domainLayer.EntityDef;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoTipoInscricaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.filter.NaturezaSolicitacaoTipoInscricaoFilter;
import br.com.elotech.portalarrecadacao.repository.RepositoryNaturezaSolicitacaoTipoInscricaoAlvara;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.sql.Modulo;
import br.com.elotech.util.string.EloStringUtils;
import java.util.Collection;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryNaturezaSolicitacaoTipoInscricaoAlvara")
public class DaoNaturezaSolicitacaoTipoInscricaoAlvaraHibernate
extends DaoSequenciaHibernate<NaturezaSolicitacaoTipoInscricaoAlvaraEntity, Long>
implements RepositoryNaturezaSolicitacaoTipoInscricaoAlvara {
    private static final long serialVersionUID = 2421100164259616906L;

    public DaoNaturezaSolicitacaoTipoInscricaoAlvaraHibernate() {
        super(NaturezaSolicitacaoTipoInscricaoAlvaraEntity.class, Modulo.ALVARAONLINE, "NATUREZASOLTIPOINSCRICAO");
    }

    public List<NaturezaSolicitacaoTipoInscricaoAlvaraEntity> carregarNaturezasSolicitacaoTipoInscricaoByFilter(NaturezaSolicitacaoTipoInscricaoFilter filter) {
        DetachedCriteria criteria = DetachedCriteria.forClass(NaturezaSolicitacaoTipoInscricaoAlvaraEntity.class);
        criteria.createAlias("naturezaSolicitacao", "naturezaSolicitacao");
        criteria.createAlias("tipoInscricao", "tipoInscricao");
        this.adicionarFiltros(filter, criteria);
        criteria.addOrder(Order.asc((String)"tipoInscricao.idTipoInscricaoAlvara"));
        criteria.addOrder(Order.asc((String)"naturezaSolicitacao.codigo"));
        return this.findByCriteria(criteria);
    }

    private void adicionarFiltros(NaturezaSolicitacaoTipoInscricaoFilter filter, DetachedCriteria criteria) {
        if (filter == null) {
            return;
        }
        if (filter.getAtivo() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"ativo", (Object)true));
        }
        if (!EloStringUtils.isEmpty((String)filter.getSiglaNaturezaSolicitacao())) {
            criteria.add((Criterion)Restrictions.eq((String)"naturezaSolicitacao.codigo", (Object)filter.getSiglaNaturezaSolicitacao()));
        }
        if (filter.getTipoInscricao() != null && filter.getTipoInscricao().getIdTipoInscricaoAlvara() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"tipoInscricao.idTipoInscricaoAlvara", (Object)filter.getTipoInscricao().getIdTipoInscricaoAlvara()));
        }
        if (!EloListUtils.safeIsEmpty((List)filter.getSiglasTipoInscricao()).booleanValue()) {
            criteria.add(Restrictions.in((String)"tipoInscricao.sigla", (Collection)filter.getSiglasTipoInscricao()));
        }
    }

    public NaturezaSolicitacaoTipoInscricaoAlvaraEntity saveWithValidation(NaturezaSolicitacaoTipoInscricaoAlvaraEntity naturezaSolicitacaoTipoInscricao) throws ValidacaoException {
        naturezaSolicitacaoTipoInscricao.validar();
        return (NaturezaSolicitacaoTipoInscricaoAlvaraEntity)super.save((EntityDef)naturezaSolicitacaoTipoInscricao);
    }

    public List<NaturezaSolicitacaoTipoInscricaoAlvaraEntity> saveList(List<NaturezaSolicitacaoTipoInscricaoAlvaraEntity> naturezasSolicitacaoTipoInscricao) throws ValidacaoException {
        for (NaturezaSolicitacaoTipoInscricaoAlvaraEntity naturezaSolicitacaoTipoInscricao : naturezasSolicitacaoTipoInscricao) {
            NaturezaSolicitacaoTipoInscricaoAlvaraEntity naturezaSolicitacaoTipoInscricaoAlvaraEntity = this.saveWithValidation(naturezaSolicitacaoTipoInscricao);
        }
        return naturezasSolicitacaoTipoInscricao;
    }

    public List<TipoInscricaoAlvaraEntity> carregarTiposInscricaoAlvaraAtivos() {
        String hql = "select distinct ti    from NaturezaSolicitacaoTipoInscricaoAlvara nsti  join nsti.tipoInscricao ti  where nsti.ativo = ? ";
        return this.findAnyByHql(hql, new Object[]{Boolean.TRUE});
    }

    public List<NaturezaSolicitacaoAlvaraEntity> carregarNaturezasSolicitacaoAtivos() {
        String hql = "select distinct nsti.naturezaSolicitacao   from NaturezaSolicitacaoTipoInscricaoAlvara nsti  where nsti.ativo = ? ";
        return this.findAnyByHql(hql, new Object[]{Boolean.TRUE});
    }
}

