/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.repository.RepositoryNaturezaSolicitacaoAlvara;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryNaturezaSolicitacaoAlvara")
public class DaoNaturezaSolicitacaoAlvaraHibernate
extends DaoSequenciaHibernate<NaturezaSolicitacaoAlvaraEntity, Long>
implements RepositoryNaturezaSolicitacaoAlvara {
    private static final long serialVersionUID = -3667898345715859790L;
    private static final String CODIGO_NATUREZA_INICIAL = "IN";

    public DaoNaturezaSolicitacaoAlvaraHibernate() {
        super(NaturezaSolicitacaoAlvaraEntity.class);
    }

    public List<NaturezaSolicitacaoAlvaraEntity> carregaNaturezas() {
        DetachedCriteria criteria = DetachedCriteria.forClass(NaturezaSolicitacaoAlvaraEntity.class).add((Criterion)Restrictions.ne((String)"codigo", (Object)CODIGO_NATUREZA_INICIAL));
        return this.findByCriteria(criteria);
    }

    public NaturezaSolicitacaoAlvaraEntity carregaNaturezaInicial() {
        DetachedCriteria criteria = DetachedCriteria.forClass(NaturezaSolicitacaoAlvaraEntity.class).add((Criterion)Restrictions.eq((String)"codigo", (Object)CODIGO_NATUREZA_INICIAL));
        return (NaturezaSolicitacaoAlvaraEntity)this.findByCriteriaUnique(criteria);
    }

    public NaturezaSolicitacaoAlvaraEntity getNatureza(String codigo) {
        DetachedCriteria criteria = DetachedCriteria.forClass(NaturezaSolicitacaoAlvaraEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"codigo", (Object)codigo));
        return (NaturezaSolicitacaoAlvaraEntity)this.findByCriteriaUnique(criteria);
    }

    public List<NaturezaSolicitacaoAlvaraEntity> carregaTodasNaturezas() {
        DetachedCriteria criteria = DetachedCriteria.forClass(NaturezaSolicitacaoAlvaraEntity.class).addOrder(Order.asc((String)"descricao"));
        return this.findByCriteria(criteria);
    }

    public List<NaturezaSolicitacaoAlvaraEntity> carregarTodasExcetoInicial() {
        DetachedCriteria criteria = DetachedCriteria.forClass(NaturezaSolicitacaoAlvaraEntity.class).add((Criterion)Restrictions.ne((String)"codigo", (Object)CODIGO_NATUREZA_INICIAL));
        return this.findByCriteria(criteria);
    }
}

