/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryLaudoAlvara;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.TipoLaudoEnum;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.sql.Modulo;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryLaudoAlvara")
public class DaoLaudoAlvaraHibernate
extends DaoSequenciaHibernate<LaudoAlvaraEntity, Long>
implements RepositoryLaudoAlvara {
    private static final long serialVersionUID = 1L;

    public DaoLaudoAlvaraHibernate() {
        super(LaudoAlvaraEntity.class);
    }

    public List<LaudoAlvaraEntity> getListaLaudoAlvara(StatusLaudoAlvara situacao, String cnpjCpf, Date periodoInicial, Date periodoFinal, UsuarioEntity usuario) {
        StringBuilder sql = new StringBuilder();
        sql.append("Select laudo FROM LaudoAlvara laudo ");
        if (situacao != null) {
            if (situacao == StatusLaudoAlvara.NAO_CONCLUIDO) {
                sql.append(" WHERE (laudo.status = '" + StatusLaudoAlvara.EXIGENCIA.getCodigo() + "' or  laudo.status = '" + StatusLaudoAlvara.EM_ANDAMENTO.getCodigo() + "')  ");
            } else {
                sql.append("WHERE laudo.status = '" + situacao.getCodigo() + "' ");
            }
            if (periodoInicial != null && periodoFinal != null) {
                sql.append("and laudo.idSolicitacaoAlvara.dataSolicitacao  between '" + EloDateUtils.toAnsiDateString((Date)periodoInicial, (String)"yyyy-MM-dd") + "' and '" + EloDateUtils.toAnsiDateString((Date)periodoFinal, (String)"yyyy-MM-dd") + "'");
            } else if (periodoInicial != null && periodoFinal == null) {
                sql.append(" and laudo.idSolicitacaoAlvara.dataSolicitacao >= '" + EloDateUtils.toAnsiDateString((Date)periodoInicial, (String)"yyyy-MM-dd") + "'");
            }
            if (cnpjCpf != null && !cnpjCpf.equals("")) {
                sql.append(" and laudo.idSolicitacaoAlvara.cadastroMobiliario.cadastroGeral.pessoa.cnpjCpf = '" + cnpjCpf + "'");
            }
        } else {
            if (periodoInicial != null && periodoFinal != null) {
                sql.append(" WHERE laudo.idSolicitacaoAlvara.dataSolicitacao  between '" + EloDateUtils.toAnsiDateString((Date)periodoInicial, (String)"yyyy-MM-dd") + "' and '" + EloDateUtils.toAnsiDateString((Date)periodoFinal, (String)"yyyy-MM-dd") + "'");
            } else if (periodoInicial != null && periodoFinal == null) {
                if (!sql.toString().contains("WHERE")) {
                    sql.append("WHERE");
                } else {
                    sql.append("and");
                }
                sql.append(" laudo.idSolicitacaoAlvara.dataSolicitacao >= '" + EloDateUtils.toAnsiDateString((Date)periodoInicial, (String)"yyyy-MM-dd") + "'");
            }
            if (cnpjCpf != null && !cnpjCpf.equals("")) {
                if (!sql.toString().contains("WHERE")) {
                    sql.append("WHERE");
                } else {
                    sql.append("and");
                }
                sql.append(" laudo.idSolicitacaoAlvara.cadastroMobiliario.cadastroGeral.pessoa.cnpjCpf = '" + cnpjCpf + "'");
            }
        }
        sql.append(" order by laudo.idLaudoAlvara");
        return this.findAnyByHql(sql.toString());
    }

    public Long getSequence() {
        return super.getSequence(Modulo.ALVARAONLINE, "laudoalvara");
    }

    public List<LaudoAlvaraEntity> buscarLaudoPorSolicitacao(Long id) {
        DetachedCriteria criteria = DetachedCriteria.forClass(LaudoAlvaraEntity.class).add((Criterion)Restrictions.eq((String)"idSolicitacaoAlvara.solicitacaoAlvara", (Object)id));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return this.findByCriteriaAny(criteria);
    }

    public LaudoAlvaraEntity findById(Long idLaudo) {
        DetachedCriteria criteria = DetachedCriteria.forClass(LaudoAlvaraEntity.class).add((Criterion)Restrictions.eq((String)"idLaudoAlvara", (Object)idLaudo));
        return (LaudoAlvaraEntity)this.findByCriteriaUnique(criteria);
    }

    public boolean possuiLaudoAmbiental(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        DetachedCriteria criteria = DetachedCriteria.forClass(LaudoAlvaraEntity.class);
        criteria.createCriteria("tipoLaudo", "tipoLaudo");
        criteria.add((Criterion)Restrictions.eq((String)"idSolicitacaoAlvara", (Object)solicitacaoAlvara));
        criteria.add((Criterion)Restrictions.eq((String)"tipoLaudo.codigo", (Object)TipoLaudoEnum.AMBIENTAL));
        return EloListUtils.safeIsEmpty((List)this.findByCriteria(criteria)) == false;
    }
}

