/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.HistoricoRenovacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.filter.FiltroHistoricoRenovacao;
import br.com.elotech.portalarrecadacao.repository.RepositoryHistoricoRenovacaoAlvara;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.util.math.EloNumberUtils;
import br.com.elotech.util.sql.Modulo;
import br.com.elotech.util.string.EloStringUtils;
import java.util.List;
import org.apache.commons.lang.NullArgumentException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryHistoricoRenovacaoAlvara")
public class DaoHistoricoRenovacaoAlvaraHibernate
extends DaoSequenciaHibernate<HistoricoRenovacaoAlvaraEntity, Long>
implements RepositoryHistoricoRenovacaoAlvara {
    private static final long serialVersionUID = 1L;

    public DaoHistoricoRenovacaoAlvaraHibernate() {
        super(HistoricoRenovacaoAlvaraEntity.class);
    }

    public List<HistoricoRenovacaoAlvaraEntity> carregarHistoricoRenovacao(FiltroHistoricoRenovacao filtro) {
        if (filtro == null) {
            throw new NullArgumentException("Filtro de consulta de Hist\u00f3rico de Renova\u00e7\u00f5es est\u00e1 nulo.");
        }
        DetachedCriteria criteria = DetachedCriteria.forClass(HistoricoRenovacaoAlvaraEntity.class);
        criteria.createAlias("solicitacaoAlvara", "solicitacao");
        if (EloNumberUtils.isBiggerThanZero((Number)filtro.getCodigoCadastroImobiliario()).booleanValue()) {
            criteria.add((Criterion)Restrictions.eq((String)"solicitacao.cadastroImobiliario.id.codigo", (Object)filtro.getCodigoCadastroImobiliario()));
        }
        if (!EloStringUtils.isEmpty((String)filtro.getNumeroSolicitacaoExercicio())) {
            Long[] numeroSolicitacao = UtilsController.separarNumeroExercicioSolicitacao((String)filtro.getNumeroSolicitacaoExercicio());
            criteria.add((Criterion)Restrictions.eq((String)"solicitacao.numeroSolicitacao", (Object)numeroSolicitacao[0]));
            criteria.add((Criterion)Restrictions.eq((String)"solicitacao.exercicio", (Object)numeroSolicitacao[1]));
        }
        if (filtro.getDataInicialSolicitacao() != null) {
            criteria.add(Restrictions.between((String)"solicitacao.dataSolicitacao", (Object)filtro.getDataInicialSolicitacao(), (Object)filtro.getDataFinalSolicitacao()));
        }
        if (filtro.getDataInicialRenovacao() != null) {
            criteria.add(Restrictions.between((String)"dataInclusao", (Object)filtro.getDataInicialRenovacao(), (Object)filtro.getDataFinalRenovacao()));
        }
        criteria.addOrder(Order.asc((String)"dataInclusao"));
        return this.findByCriteria(criteria);
    }

    public Long getSequence() {
        return super.getSequence(Modulo.ALVARAONLINE, "HISTORICORENOVACAOALVARA");
    }
}

