/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.daoLayer.hibernate.DaoHibernate;
import br.com.elotech.portalarrecadacao.domain.EventoRedeSimEntity;
import br.com.elotech.portalarrecadacao.filter.FiltroEventoRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryEventoRedeSim;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryEventoRedeSim")
public class DaoEventoRedeSimHibernate
extends DaoHibernate<EventoRedeSimEntity, Long>
implements RepositoryEventoRedeSim {
    private static final long serialVersionUID = 1L;

    public DaoEventoRedeSimHibernate() {
        super(EventoRedeSimEntity.class);
    }

    public Boolean existeEvento(EventoRedeSimEntity evento) {
        DetachedCriteria criteria = DetachedCriteria.forClass(EventoRedeSimEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"evento", (Object)evento.getEvento()));
        return EloListUtils.safeIsEmpty((List)this.findByCriteria(criteria)) == false;
    }

    public List<EventoRedeSimEntity> buscarEventosRedeSim(FiltroEventoRedeSim filtro) {
        DetachedCriteria criteria = DetachedCriteria.forClass(EventoRedeSimEntity.class);
        if (filtro.getEvento() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"evento", (Object)filtro.getEvento()));
        }
        if (!EloStringUtils.isEmpty((String)filtro.getDescricao())) {
            criteria.add(Restrictions.ilike((String)"descricao", (String)filtro.getDescricao(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (!EloStringUtils.isEmpty((String)filtro.getSigla())) {
            criteria.add(Restrictions.ilike((String)"sigla", (Object)filtro.getSigla()));
        }
        criteria.addOrder(Order.asc((String)"evento"));
        return this.findByCriteria(criteria);
    }
}

