/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.domain.TipoDocumentoRedeSimLaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.exception.LaudoNaoEncontradoException;
import br.com.elotech.portalarrecadacao.filter.FiltroTipoDocumentoPorTipoLaudoRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryDocumentoRedeSimLaudoAlvara;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import br.com.elotech.util.sql.Modulo;
import br.com.elotech.util.string.EloStringUtils;
import java.util.List;
import java.util.Objects;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryDocumentoRedeSimLaudoAlvara")
public class DaoDocumentoRedeSimLaudoAlvaraHibernate
extends DaoSequenciaHibernate<TipoDocumentoRedeSimLaudoAlvaraEntity, Long>
implements RepositoryDocumentoRedeSimLaudoAlvara {
    private static final long serialVersionUID = 1L;

    public DaoDocumentoRedeSimLaudoAlvaraHibernate() {
        super(TipoDocumentoRedeSimLaudoAlvaraEntity.class, Modulo.ALVARAONLINE, "tipoDocumentoRedeSimLaudoAlvara");
    }

    public TipoLaudoEntity getTipoLaudo(Long tipoDocumentoRedeSim) throws LaudoNaoEncontradoException {
        DetachedCriteria criteria = DetachedCriteria.forClass(TipoDocumentoRedeSimLaudoAlvaraEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"tipoDocumentoRedeSim", (Object)tipoDocumentoRedeSim));
        TipoDocumentoRedeSimLaudoAlvaraEntity tipoDocumento = (TipoDocumentoRedeSimLaudoAlvaraEntity)this.findByCriteriaUniqueAny(criteria);
        if (Objects.nonNull(tipoDocumento) && Objects.nonNull(tipoDocumento.getTipoLaudo())) {
            return tipoDocumento.getTipoLaudo();
        }
        throw new LaudoNaoEncontradoException("N\u00e3o foi encontrado um tipo de laudo para o documento relacionado.");
    }

    public List<TipoDocumentoRedeSimLaudoAlvaraEntity> buscaDocumentosRedeSimLaudo(FiltroTipoDocumentoPorTipoLaudoRedeSim filtro) {
        DetachedCriteria criteria = DetachedCriteria.forClass(TipoDocumentoRedeSimLaudoAlvaraEntity.class);
        if (!EloStringUtils.isEmpty((String)filtro.getDescricao())) {
            criteria.add(Restrictions.ilike((String)"descricao", (String)filtro.getDescricao(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (!Objects.isNull(filtro.getTipoLaudo())) {
            criteria.add((Criterion)Restrictions.eq((String)"tipoLaudo", (Object)filtro.getTipoLaudo()));
        }
        if (filtro.getCodigo() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"tipoDocumentoRedeSim", (Object)filtro.getCodigo()));
        }
        criteria.addOrder(Order.asc((String)"id"));
        return this.findByCriteria(criteria);
    }
}

