/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.dao.DaoConfiguracaoAtividade;
import br.com.elotech.portalarrecadacao.domain.ExigenciaEntity;
import br.com.elotech.portalarrecadacao.domain.ProibicaoAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.ZoneamentoPermitidoEntity;
import br.com.elotech.portalarrecadacao.repository.RepositoryConfiguracaoAtividade;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioTestadaEntity;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeEntity;
import br.com.elotech.tributacao.domain.aise.EixoEntity;
import br.com.elotech.tributacao.enumerator.TipoAtividadeEnum;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.sql.EloSqlUtils;
import br.com.elotech.util.sql.Modulo;
import java.util.List;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryConfiguracaoAtividade")
public class DaoConfiguracaoAtividadeHibernate
extends DaoSequenciaHibernate<ConfiguracaoAtividadeEntity, Long>
implements RepositoryConfiguracaoAtividade,
DaoConfiguracaoAtividade {
    private static final long serialVersionUID = 1L;

    public DaoConfiguracaoAtividadeHibernate() {
        super(ConfiguracaoAtividadeEntity.class, Modulo.ALVARAONLINE, "CONFIGURACAOATIVIDADE");
    }

    public boolean isEixoPermitido(EixoEntity eixo, ConfiguracaoAtividadeEntity configuracaoAtividade) {
        if (configuracaoAtividade != null && configuracaoAtividade.getIdConfiguracaoAtividade() != null) {
            StringBuilder hql = new StringBuilder();
            hql.append(" select ep from EixoPermitido ep ");
            hql.append(" inner join ep.configuracaoAtividade config ");
            hql.append(" where ep.eixo = :eixo ");
            hql.append(" and config.idConfiguracaoAtividade = :idConfiguracaoAtividade ");
            Query query = EloSqlUtils.createQuery((String)hql.toString());
            query.setParameter("eixo", (Object)eixo);
            query.setParameter("idConfiguracaoAtividade", (Object)configuracaoAtividade.getIdConfiguracaoAtividade());
            return EloListUtils.safeIsEmpty((List)query.list()) == false;
        }
        return false;
    }

    public boolean isZoneamentoPermitido(CadastroImobiliarioTestadaEntity testadaPrincipal, ConfiguracaoAtividadeEntity configuracaoAtividade) {
        if (configuracaoAtividade != null && configuracaoAtividade.getIdConfiguracaoAtividade() != null) {
            StringBuilder hql = new StringBuilder();
            hql.append(" select zp from ZoneamentoPermitido zp ");
            hql.append(" inner join zp.configuracaoAtividade config ");
            hql.append(" where zp.zoneamento = :zoneamento ");
            hql.append(" and config.idConfiguracaoAtividade = :idConfiguracaoAtividade ");
            Query query = EloSqlUtils.createQuery((String)hql.toString());
            query.setParameter("zoneamento", (Object)testadaPrincipal.getZoneamento());
            query.setParameter("idConfiguracaoAtividade", (Object)configuracaoAtividade.getIdConfiguracaoAtividade());
            return EloListUtils.safeIsEmpty((List)query.list()) == false;
        }
        return false;
    }

    public ZoneamentoPermitidoEntity carregarZoneamentoPermitido(CadastroImobiliarioTestadaEntity testadaPrincipal, ConfiguracaoAtividadeEntity configuracaoAtividade) {
        if (configuracaoAtividade != null && configuracaoAtividade.getIdConfiguracaoAtividade() != null) {
            StringBuilder hql = new StringBuilder();
            hql.append(" select zp from ZoneamentoPermitido zp ");
            hql.append(" inner join zp.configuracaoAtividade config ");
            hql.append(" where zp.zoneamento = :zoneamento ");
            hql.append(" and config.idConfiguracaoAtividade = :idConfiguracaoAtividade ");
            Query query = EloSqlUtils.createQuery((String)hql.toString());
            query.setParameter("zoneamento", (Object)testadaPrincipal.getZoneamento());
            query.setParameter("idConfiguracaoAtividade", (Object)configuracaoAtividade.getIdConfiguracaoAtividade());
            return (ZoneamentoPermitidoEntity)query.uniqueResult();
        }
        return null;
    }

    public ConfiguracaoAtividadeEntity carregarDocumentos(ConfiguracaoAtividadeEntity conf) {
        Hibernate.initialize((Object)conf.getDocumentosAtividade());
        return conf;
    }

    public List<ExigenciaEntity> recuperarExigencias(ConfiguracaoAtividadeEntity configuracaoAtividade) {
        StringBuilder hql = new StringBuilder();
        hql.append(" select ex from Exigencia ex ");
        hql.append(" inner join ex.configuracaoAtividade config ");
        hql.append(" where config.id.idConfiguracaoAtividade = :idConfiguracaoAtividade ");
        Query query = EloSqlUtils.createQuery((String)hql.toString());
        query.setParameter("idConfiguracaoAtividade", (Object)configuracaoAtividade.getIdConfiguracaoAtividade());
        return query.list();
    }

    public List<ProibicaoAtividadeEntity> recuperarProibicoes(ConfiguracaoAtividadeEntity configuracaoAtividade) {
        StringBuilder hql = new StringBuilder();
        hql.append(" select pa from ProibicaoAtividade pa ");
        hql.append(" join pa.id atividadePK ");
        hql.append(" inner join atividadePK.configuracaoAtividade config ");
        hql.append(" where config.idConfiguracaoAtividade = :idConfiguracaoAtividade ");
        Query query = EloSqlUtils.createQuery((String)hql.toString());
        query.setParameter("idConfiguracaoAtividade", (Object)configuracaoAtividade.getIdConfiguracaoAtividade());
        return query.list();
    }

    public ConfiguracaoAtividadeEntity getConfiguracaoAtividadeByidAtividade(Long idAtividade, TipoAtividadeEnum tipoAtividade) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ConfiguracaoAtividadeEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"idAtividade", (Object)idAtividade));
        criteria.add((Criterion)Restrictions.eq((String)"tipo", (Object)tipoAtividade));
        return (ConfiguracaoAtividadeEntity)this.findByCriteriaUnique(criteria);
    }
}

