/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.daoLayer.hibernate.DaoHibernate;
import br.com.elotech.portalarrecadacao.domain.CnaePrestadorServicoEntity;
import br.com.elotech.portalarrecadacao.repository.RepositoryCnaePrestadorServico;
import br.com.elotech.tributacao.domain.aise.CnaeEntity;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryCnaePrestadorServico")
public class DaoCnaePrestadorServicoHibernate
extends DaoHibernate<CnaePrestadorServicoEntity, Long>
implements RepositoryCnaePrestadorServico {
    private static final long serialVersionUID = 1L;

    public DaoCnaePrestadorServicoHibernate() {
        super(CnaePrestadorServicoEntity.class);
    }

    public Boolean verificaCnaePrestadorServico(Atividade atividade) {
        DetachedCriteria criteria = DetachedCriteria.forClass(CnaePrestadorServicoEntity.class).createCriteria("cnae", "c").add((Criterion)Restrictions.eq((String)"c.codigo", (Object)atividade.getCodigo()));
        List cnaes = this.findByCriteria(criteria);
        if (!EloListUtils.safeIsEmpty((List)cnaes).booleanValue()) {
            return true;
        }
        return false;
    }

    public Boolean verificaCnaePrestadorServico(List<String> codigosCnae) {
        DetachedCriteria criteria = DetachedCriteria.forClass(CnaePrestadorServicoEntity.class).createCriteria("cnae", "c").add(Restrictions.in((String)"c.codigo", codigosCnae));
        List cnaesPrestador = this.findByCriteria(criteria);
        if (!EloListUtils.safeIsEmpty((List)cnaesPrestador).booleanValue()) {
            return cnaesPrestador.size() == codigosCnae.size();
        }
        return false;
    }

    public List<TipoLaudoEntity> carregaLaudosPorCnae(CnaeEntity cnae) {
        DetachedCriteria criteria = DetachedCriteria.forClass(CnaePrestadorServicoEntity.class);
        criteria.createCriteria("cnae", "c");
        criteria.add((Criterion)Restrictions.eq((String)"c.codigo", (Object)cnae.getCodigo()));
        CnaePrestadorServicoEntity cnaePrestador = (CnaePrestadorServicoEntity)this.findByCriteriaUnique(criteria);
        return cnaePrestador.getTiposLaudo();
    }
}

