/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.filter.FiltroCadastroRestricao;
import br.com.elotech.portalarrecadacao.repository.RepositoryCadastroRestricaoAlvara;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.tributacao.domain.aise.CadastroRestricaoAlvaraEntity;
import br.com.elotech.util.string.EloStringUtils;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryCadastroRestricaoAlvara")
public class DaoCadastroRestricaoAlvaraHibernate
extends DaoSequenciaHibernate<CadastroRestricaoAlvaraEntity, Long>
implements RepositoryCadastroRestricaoAlvara {
    private static final long serialVersionUID = 1L;

    public DaoCadastroRestricaoAlvaraHibernate() {
        super(CadastroRestricaoAlvaraEntity.class);
    }

    public CadastroRestricaoAlvaraEntity carregaCadastroRestricaoAlvara(Long codigo) {
        DetachedCriteria criteria = DetachedCriteria.forClass(CadastroRestricaoAlvaraEntity.class).add((Criterion)Restrictions.eq((String)"idRestricao", (Object)codigo)).add((Criterion)Restrictions.eq((String)"ativo", (Object)"S"));
        return (CadastroRestricaoAlvaraEntity)this.findByCriteriaUnique(criteria);
    }

    public List<CadastroRestricaoAlvaraEntity> carregarListaCadastroRestricoes(FiltroCadastroRestricao filtro) {
        DetachedCriteria criteria = DetachedCriteria.forClass(CadastroRestricaoAlvaraEntity.class).addOrder(Order.asc((String)"descricao"));
        if (!EloStringUtils.isEmpty((String)filtro.getDescricao())) {
            criteria.add(Restrictions.ilike((String)"descricao", (String)filtro.getDescricao(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (!EloStringUtils.isEmpty((String)filtro.getAtivo())) {
            criteria.add((Criterion)Restrictions.eq((String)"ativo", (Object)filtro.getAtivo()));
        }
        return this.findByCriteria(criteria);
    }
}

