/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.dao.impl;

import br.com.elotech.portalarrecadacao.domain.AndamentoAlvaraProvisorioEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.filter.FiltroAlvaraProvisorioRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryAndamentoAlvaraProvisorio;
import br.com.elotech.tributacao.dao.DaoSequenciaHibernate;
import br.com.elotech.util.sql.Modulo;
import br.com.elotech.util.string.EloStringUtils;
import java.util.List;
import java.util.Objects;
import org.hibernate.Hibernate;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryAndamentoAlvaraProvisorio")
public class DaoAndamentoAlvaraProvisorioHibernate
extends DaoSequenciaHibernate<AndamentoAlvaraProvisorioEntity, Long>
implements RepositoryAndamentoAlvaraProvisorio {
    private static final long serialVersionUID = 1L;

    public DaoAndamentoAlvaraProvisorioHibernate() {
        super(AndamentoAlvaraProvisorioEntity.class, Modulo.ALVARAONLINE, "andamentoAlvaraProvisorio");
    }

    public List<AndamentoAlvaraProvisorioEntity> pesquisarAlvarasProvisorio(FiltroAlvaraProvisorioRedeSim filtro) {
        StringBuilder hql = new StringBuilder();
        if (filtro.isDebitoPago()) {
            hql.append("select andamento ");
            hql.append(" from AndamentoAlvaraProvisorio andamento, Debito deb");
            hql.append(" join andamento.solicitacaoRedeSim rs");
            hql.append(" join rs.solicitacoesAlvara sol");
            hql.append(" join sol.debitos solDeb");
            hql.append(" where solDeb.solicitacaoAlvara.solicitacaoAlvara = sol.solicitacaoAlvara");
            hql.append(" and deb.idDebito = solDeb.idDebito");
            hql.append(" and ((rs.alvaraEnviado = null or rs.alvaraEnviado = 'FUNCIONAMENTO_PROVISORIO') and rs.tipo = 'S') ");
            hql.append(" and andamento.dataAndamento =");
            hql.append(" (select max (andamento2.dataAndamento)");
            hql.append(" from AndamentoAlvaraProvisorio andamento2");
            hql.append(" where andamento2.solicitacaoRedeSim = andamento.solicitacaoRedeSim)");
            hql.append(" and not exists (");
            hql.append(" select 1");
            hql.append(" from DebitoParcela dp");
            hql.append(" join dp.situacaoDebito sp");
            hql.append(" where sp.tipoSituacaoParcela.tipoSituacaoParcela <> 2");
            hql.append(" and deb.id.cadastroGeral.id.tipo = dp.id.debito.id.cadastroGeral.id.tipo");
            hql.append(" and deb.id.cadastroGeral.id.codigo = dp.id.debito.id.cadastroGeral.id.codigo");
            hql.append(" and deb.id.guiaRecolhimento.id.entidadeTributacao.id.exercicioTributacao.exercicio = dp.id.debito.id.guiaRecolhimento.id.entidadeTributacao.id.exercicioTributacao.exercicio");
            hql.append(" and deb.id.guiaRecolhimento.id.guiaRecolhimento = dp.id.debito.id.guiaRecolhimento.id.guiaRecolhimento");
            hql.append(" and deb.id.subdivida = dp.id.debito.id.subdivida");
            hql.append(")");
        } else {
            hql.append("select andamento");
            hql.append(" from AndamentoAlvaraProvisorio andamento ");
            hql.append(" where andamento.dataAndamento =");
            hql.append(" (select max (b.dataAndamento)");
            hql.append(" from AndamentoAlvaraProvisorio b");
            hql.append(" where b.solicitacaoRedeSim = andamento.solicitacaoRedeSim)");
        }
        if (!EloStringUtils.isEmpty((String)filtro.getGerouDebito())) {
            hql.append(" and gerouDebito = '").append(filtro.getGerouDebito()).append("'");
        }
        if (!EloStringUtils.isEmpty((String)filtro.getGerouAlvara())) {
            hql.append(" and gerouAlvara = '").append(filtro.getGerouAlvara()).append("'");
        }
        if (!EloStringUtils.isEmpty((String)filtro.getEnviouAlvara())) {
            hql.append(" and enviouAlvara = '").append(filtro.getEnviouAlvara()).append("'");
        }
        hql.append(" order by andamento.dataAndamento desc");
        return this.findByHql(hql.toString());
    }

    public List<AndamentoAlvaraProvisorioEntity> buscarTramitesAlvara(SolicitacaoRedeSimEntity solicitacaoRedeSim) {
        DetachedCriteria criteria = DetachedCriteria.forClass(AndamentoAlvaraProvisorioEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"solicitacaoRedeSim", (Object)solicitacaoRedeSim));
        criteria.addOrder(Order.desc((String)"dataAndamento"));
        List tramites = this.findByCriteria(criteria);
        for (AndamentoAlvaraProvisorioEntity tramite : tramites) {
            Hibernate.initialize((Object)tramite.getSolicitacaoRedeSim());
            if (!Objects.nonNull(tramite.getSolicitacaoRedeSim())) continue;
            Hibernate.initialize((Object)tramite.getSolicitacaoRedeSim().getHistoricosExigencias());
        }
        return tramites;
    }

    public AndamentoAlvaraProvisorioEntity carregarUltimoAndamentoAlvaraProvisorio(SolicitacaoRedeSimEntity solicitacaoRedeSim) {
        StringBuilder hql = new StringBuilder();
        hql.append("select ap1 from AndamentoAlvaraProvisorio ap1 where ap1.solicitacaoRedeSim.id = ? ");
        hql.append("and ap1.dataAndamento = ");
        hql.append("(select max(ap2.dataAndamento) from AndamentoAlvaraProvisorio ap2 where ap2.solicitacaoRedeSim.id = ap1.solicitacaoRedeSim.id) ");
        Object[] args = new Object[]{solicitacaoRedeSim.getId()};
        return (AndamentoAlvaraProvisorioEntity)this.findUniqueByHql(hql.toString(), args);
    }
}

