/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.converter;

import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.util.exceptions.FormatError;
import br.com.elotech.util.string.EloStringUtils;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;

@FacesConverter(value="cpfCnpjConverter")
public class CpfCnpjConverter
extends EloLogger
implements Converter {
    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        return value;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        String str = (String)value;
        try {
            if (str.length() == 11) {
                str = EloStringUtils.formatCpf((String)EloStringUtils.safeTrim((String)str));
            } else if (str.length() == 14) {
                str = EloStringUtils.formatCnpj((String)EloStringUtils.safeTrim((String)str));
            }
        }
        catch (FormatError e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return str;
    }
}

