/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller.dataModel;

import br.com.elotech.domain.Page;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.dataModel.AbstractLazyDataModel;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoDocumentoAlvaraEnum;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.validator.CpfCnpjValidador;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.math.EloNumberUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.primefaces.model.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolicitacaoAlvaraDataModel
extends AbstractLazyDataModel<SolicitacaoAlvaraEntity> {
    private static final long serialVersionUID = 1L;
    private static final long ZERAR_LISTA = 0L;
    private static final Logger logger = LoggerFactory.getLogger(SolicitacaoAlvaraDataModel.class);
    private Long numeroSolicitacaoFiltro;
    private String cpfCnpjFiltro;
    private Date dataInicialFiltro;
    private Date dataFinalFiltro;
    private TipoLaudoEntity tipoLaudoFiltro;
    private List<TipoLaudoEntity> tiposLaudoFiltro;
    private StatusLaudoAlvara situacaoLaudoFiltro;
    private List<StatusLaudoAlvara> situacoesLaudoFiltro;
    private Long exercicio;
    private boolean documentoNaoValidado;
    private boolean somenteComDocumentosValidados;
    private boolean buscaPendenciaRenovacao;
    private TipoInscricaoAlvaraEntity tipoInscricaoFiltro;
    private NaturezaSolicitacaoAlvaraEntity naturezaSolicitacaoFiltro;
    private String cadastroImobiliarioFiltro;
    private String processoFiscalizacao;
    private List<SituacaoDocumentoAlvaraEnum> situacoesDocumento;
    private String protocoloRedeSim;
    private boolean laudoDocumentosNaoValidadosFiltro;
    private boolean solicitacoesComAnexoNosLaudosFiltro;
    private String grauRisco;

    public Page<SolicitacaoAlvaraEntity> executaPesquisa(int pagina, int tamanhoPagina, String campoOrdenacao, SortOrder ordenacao) {
        if (this.isConsultaValida().booleanValue()) {
            try {
                FacadeSolicitacaoAlvara facade = (FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class);
                Page resultado = facade.carregaListaSolicitacaoAlvaraPaginado(this, pagina, tamanhoPagina);
                if (this.isSomenteComDocumentosValidados()) {
                    ArrayList solicitacaoComDocumentosNaoValidados = Lists.newArrayList();
                    for (SolicitacaoAlvaraEntity solicitacao : resultado.getData()) {
                        if (solicitacao.isTodosDocumentosValidos()) continue;
                        solicitacaoComDocumentosNaoValidados.add(solicitacao);
                    }
                    resultado.getData().removeAll(solicitacaoComDocumentosNaoValidados);
                    if (EloListUtils.safeIsEmpty((List)resultado.getData()).booleanValue() && EloNumberUtils.isBiggerThanZero((Number)resultado.getTotal()).booleanValue()) {
                        resultado.setTotal(0L);
                    } else {
                        resultado.setTotal(resultado.getTotal() - (long)solicitacaoComDocumentosNaoValidados.size());
                    }
                }
                return resultado;
            }
            catch (BaseException be) {
                logger.error(be.getMessage(), (Throwable)be);
            }
        }
        return new Page(new ArrayList(), 0L);
    }

    private Boolean isConsultaValida() {
        if (!EloStringUtils.isEmpty((String)this.cpfCnpjFiltro)) {
            if (!new CpfCnpjValidador().validarCpfCnpj(this.cpfCnpjFiltro)) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (EloNumberUtils.isBiggerThanZero((Number)this.numeroSolicitacaoFiltro).booleanValue()) {
            return Boolean.TRUE;
        }
        if (this.dataInicialFiltro != null) {
            return Boolean.TRUE;
        }
        if (this.dataFinalFiltro != null) {
            return Boolean.TRUE;
        }
        if (this.tipoLaudoFiltro != null) {
            return Boolean.TRUE;
        }
        if (this.situacaoLaudoFiltro != null || !EloListUtils.safeIsEmpty((List)this.situacoesLaudoFiltro).booleanValue()) {
            return Boolean.TRUE;
        }
        if (EloNumberUtils.isBiggerThanZero((Number)this.exercicio).booleanValue()) {
            return Boolean.TRUE;
        }
        if (this.tipoInscricaoFiltro != null || !EloListUtils.safeIsEmpty((List)this.tiposLaudoFiltro).booleanValue()) {
            return Boolean.TRUE;
        }
        if (this.naturezaSolicitacaoFiltro != null) {
            return Boolean.TRUE;
        }
        if (!EloStringUtils.isEmpty((String)this.cadastroImobiliarioFiltro)) {
            return Boolean.TRUE;
        }
        if (!EloStringUtils.isEmpty((String)this.protocoloRedeSim)) {
            return Boolean.TRUE;
        }
        if (this.isSolicitacoesComAnexoNosLaudosFiltro()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean isDocumentoNaoValidado() {
        return this.documentoNaoValidado;
    }

    public boolean isSomenteComDocumentosValidados() {
        return this.somenteComDocumentosValidados;
    }

    public boolean isBuscaPendenciaRenovacao() {
        return this.buscaPendenciaRenovacao;
    }

    public void setProcessoFiscalizacao(String processoFiscalizacao) {
        this.processoFiscalizacao = processoFiscalizacao;
    }

    public boolean getLaudoDocumentosNaoValidadosFiltro() {
        return this.laudoDocumentosNaoValidadosFiltro;
    }

    public void setLaudoDocumentosNaoValidadosFiltro(boolean laudoDocumentosNaoValidadosFiltro) {
        this.laudoDocumentosNaoValidadosFiltro = laudoDocumentosNaoValidadosFiltro;
    }

    public boolean isSolicitacoesComAnexoNosLaudosFiltro() {
        return this.solicitacoesComAnexoNosLaudosFiltro;
    }

    public Long getNumeroSolicitacaoFiltro() {
        return this.numeroSolicitacaoFiltro;
    }

    public String getCpfCnpjFiltro() {
        return this.cpfCnpjFiltro;
    }

    public Date getDataInicialFiltro() {
        return this.dataInicialFiltro;
    }

    public Date getDataFinalFiltro() {
        return this.dataFinalFiltro;
    }

    public TipoLaudoEntity getTipoLaudoFiltro() {
        return this.tipoLaudoFiltro;
    }

    public List<TipoLaudoEntity> getTiposLaudoFiltro() {
        return this.tiposLaudoFiltro;
    }

    public StatusLaudoAlvara getSituacaoLaudoFiltro() {
        return this.situacaoLaudoFiltro;
    }

    public List<StatusLaudoAlvara> getSituacoesLaudoFiltro() {
        return this.situacoesLaudoFiltro;
    }

    public Long getExercicio() {
        return this.exercicio;
    }

    public TipoInscricaoAlvaraEntity getTipoInscricaoFiltro() {
        return this.tipoInscricaoFiltro;
    }

    public NaturezaSolicitacaoAlvaraEntity getNaturezaSolicitacaoFiltro() {
        return this.naturezaSolicitacaoFiltro;
    }

    public String getCadastroImobiliarioFiltro() {
        return this.cadastroImobiliarioFiltro;
    }

    public String getProcessoFiscalizacao() {
        return this.processoFiscalizacao;
    }

    public List<SituacaoDocumentoAlvaraEnum> getSituacoesDocumento() {
        return this.situacoesDocumento;
    }

    public String getProtocoloRedeSim() {
        return this.protocoloRedeSim;
    }

    public String getGrauRisco() {
        return this.grauRisco;
    }

    public void setNumeroSolicitacaoFiltro(Long numeroSolicitacaoFiltro) {
        this.numeroSolicitacaoFiltro = numeroSolicitacaoFiltro;
    }

    public void setCpfCnpjFiltro(String cpfCnpjFiltro) {
        this.cpfCnpjFiltro = cpfCnpjFiltro;
    }

    public void setDataInicialFiltro(Date dataInicialFiltro) {
        this.dataInicialFiltro = dataInicialFiltro;
    }

    public void setDataFinalFiltro(Date dataFinalFiltro) {
        this.dataFinalFiltro = dataFinalFiltro;
    }

    public void setTipoLaudoFiltro(TipoLaudoEntity tipoLaudoFiltro) {
        this.tipoLaudoFiltro = tipoLaudoFiltro;
    }

    public void setTiposLaudoFiltro(List<TipoLaudoEntity> tiposLaudoFiltro) {
        this.tiposLaudoFiltro = tiposLaudoFiltro;
    }

    public void setSituacaoLaudoFiltro(StatusLaudoAlvara situacaoLaudoFiltro) {
        this.situacaoLaudoFiltro = situacaoLaudoFiltro;
    }

    public void setSituacoesLaudoFiltro(List<StatusLaudoAlvara> situacoesLaudoFiltro) {
        this.situacoesLaudoFiltro = situacoesLaudoFiltro;
    }

    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    public void setDocumentoNaoValidado(boolean documentoNaoValidado) {
        this.documentoNaoValidado = documentoNaoValidado;
    }

    public void setSomenteComDocumentosValidados(boolean somenteComDocumentosValidados) {
        this.somenteComDocumentosValidados = somenteComDocumentosValidados;
    }

    public void setBuscaPendenciaRenovacao(boolean buscaPendenciaRenovacao) {
        this.buscaPendenciaRenovacao = buscaPendenciaRenovacao;
    }

    public void setTipoInscricaoFiltro(TipoInscricaoAlvaraEntity tipoInscricaoFiltro) {
        this.tipoInscricaoFiltro = tipoInscricaoFiltro;
    }

    public void setNaturezaSolicitacaoFiltro(NaturezaSolicitacaoAlvaraEntity naturezaSolicitacaoFiltro) {
        this.naturezaSolicitacaoFiltro = naturezaSolicitacaoFiltro;
    }

    public void setCadastroImobiliarioFiltro(String cadastroImobiliarioFiltro) {
        this.cadastroImobiliarioFiltro = cadastroImobiliarioFiltro;
    }

    public void setSituacoesDocumento(List<SituacaoDocumentoAlvaraEnum> situacoesDocumento) {
        this.situacoesDocumento = situacoesDocumento;
    }

    public void setProtocoloRedeSim(String protocoloRedeSim) {
        this.protocoloRedeSim = protocoloRedeSim;
    }

    public void setSolicitacoesComAnexoNosLaudosFiltro(boolean solicitacoesComAnexoNosLaudosFiltro) {
        this.solicitacoesComAnexoNosLaudosFiltro = solicitacoesComAnexoNosLaudosFiltro;
    }

    public void setGrauRisco(String grauRisco) {
        this.grauRisco = grauRisco;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SolicitacaoAlvaraDataModel)) {
            return false;
        }
        SolicitacaoAlvaraDataModel other = (SolicitacaoAlvaraDataModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$numeroSolicitacaoFiltro = this.getNumeroSolicitacaoFiltro();
        Long other$numeroSolicitacaoFiltro = other.getNumeroSolicitacaoFiltro();
        if (this$numeroSolicitacaoFiltro == null ? other$numeroSolicitacaoFiltro != null : !((Object)this$numeroSolicitacaoFiltro).equals(other$numeroSolicitacaoFiltro)) {
            return false;
        }
        String this$cpfCnpjFiltro = this.getCpfCnpjFiltro();
        String other$cpfCnpjFiltro = other.getCpfCnpjFiltro();
        if (this$cpfCnpjFiltro == null ? other$cpfCnpjFiltro != null : !this$cpfCnpjFiltro.equals(other$cpfCnpjFiltro)) {
            return false;
        }
        Date this$dataInicialFiltro = this.getDataInicialFiltro();
        Date other$dataInicialFiltro = other.getDataInicialFiltro();
        if (this$dataInicialFiltro == null ? other$dataInicialFiltro != null : !((Object)this$dataInicialFiltro).equals(other$dataInicialFiltro)) {
            return false;
        }
        Date this$dataFinalFiltro = this.getDataFinalFiltro();
        Date other$dataFinalFiltro = other.getDataFinalFiltro();
        if (this$dataFinalFiltro == null ? other$dataFinalFiltro != null : !((Object)this$dataFinalFiltro).equals(other$dataFinalFiltro)) {
            return false;
        }
        TipoLaudoEntity this$tipoLaudoFiltro = this.getTipoLaudoFiltro();
        TipoLaudoEntity other$tipoLaudoFiltro = other.getTipoLaudoFiltro();
        if (this$tipoLaudoFiltro == null ? other$tipoLaudoFiltro != null : !this$tipoLaudoFiltro.equals(other$tipoLaudoFiltro)) {
            return false;
        }
        List this$tiposLaudoFiltro = this.getTiposLaudoFiltro();
        List other$tiposLaudoFiltro = other.getTiposLaudoFiltro();
        if (this$tiposLaudoFiltro == null ? other$tiposLaudoFiltro != null : !((Object)this$tiposLaudoFiltro).equals(other$tiposLaudoFiltro)) {
            return false;
        }
        StatusLaudoAlvara this$situacaoLaudoFiltro = this.getSituacaoLaudoFiltro();
        StatusLaudoAlvara other$situacaoLaudoFiltro = other.getSituacaoLaudoFiltro();
        if (this$situacaoLaudoFiltro == null ? other$situacaoLaudoFiltro != null : !this$situacaoLaudoFiltro.equals(other$situacaoLaudoFiltro)) {
            return false;
        }
        List this$situacoesLaudoFiltro = this.getSituacoesLaudoFiltro();
        List other$situacoesLaudoFiltro = other.getSituacoesLaudoFiltro();
        if (this$situacoesLaudoFiltro == null ? other$situacoesLaudoFiltro != null : !((Object)this$situacoesLaudoFiltro).equals(other$situacoesLaudoFiltro)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        if (this.isDocumentoNaoValidado() != other.isDocumentoNaoValidado()) {
            return false;
        }
        if (this.isSomenteComDocumentosValidados() != other.isSomenteComDocumentosValidados()) {
            return false;
        }
        if (this.isBuscaPendenciaRenovacao() != other.isBuscaPendenciaRenovacao()) {
            return false;
        }
        TipoInscricaoAlvaraEntity this$tipoInscricaoFiltro = this.getTipoInscricaoFiltro();
        TipoInscricaoAlvaraEntity other$tipoInscricaoFiltro = other.getTipoInscricaoFiltro();
        if (this$tipoInscricaoFiltro == null ? other$tipoInscricaoFiltro != null : !this$tipoInscricaoFiltro.equals(other$tipoInscricaoFiltro)) {
            return false;
        }
        NaturezaSolicitacaoAlvaraEntity this$naturezaSolicitacaoFiltro = this.getNaturezaSolicitacaoFiltro();
        NaturezaSolicitacaoAlvaraEntity other$naturezaSolicitacaoFiltro = other.getNaturezaSolicitacaoFiltro();
        if (this$naturezaSolicitacaoFiltro == null ? other$naturezaSolicitacaoFiltro != null : !this$naturezaSolicitacaoFiltro.equals(other$naturezaSolicitacaoFiltro)) {
            return false;
        }
        String this$cadastroImobiliarioFiltro = this.getCadastroImobiliarioFiltro();
        String other$cadastroImobiliarioFiltro = other.getCadastroImobiliarioFiltro();
        if (this$cadastroImobiliarioFiltro == null ? other$cadastroImobiliarioFiltro != null : !this$cadastroImobiliarioFiltro.equals(other$cadastroImobiliarioFiltro)) {
            return false;
        }
        String this$processoFiscalizacao = this.getProcessoFiscalizacao();
        String other$processoFiscalizacao = other.getProcessoFiscalizacao();
        if (this$processoFiscalizacao == null ? other$processoFiscalizacao != null : !this$processoFiscalizacao.equals(other$processoFiscalizacao)) {
            return false;
        }
        List this$situacoesDocumento = this.getSituacoesDocumento();
        List other$situacoesDocumento = other.getSituacoesDocumento();
        if (this$situacoesDocumento == null ? other$situacoesDocumento != null : !((Object)this$situacoesDocumento).equals(other$situacoesDocumento)) {
            return false;
        }
        String this$protocoloRedeSim = this.getProtocoloRedeSim();
        String other$protocoloRedeSim = other.getProtocoloRedeSim();
        if (this$protocoloRedeSim == null ? other$protocoloRedeSim != null : !this$protocoloRedeSim.equals(other$protocoloRedeSim)) {
            return false;
        }
        if (this.getLaudoDocumentosNaoValidadosFiltro() != other.getLaudoDocumentosNaoValidadosFiltro()) {
            return false;
        }
        if (this.isSolicitacoesComAnexoNosLaudosFiltro() != other.isSolicitacoesComAnexoNosLaudosFiltro()) {
            return false;
        }
        String this$grauRisco = this.getGrauRisco();
        String other$grauRisco = other.getGrauRisco();
        return !(this$grauRisco == null ? other$grauRisco != null : !this$grauRisco.equals(other$grauRisco));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SolicitacaoAlvaraDataModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $numeroSolicitacaoFiltro = this.getNumeroSolicitacaoFiltro();
        result = result * 59 + ($numeroSolicitacaoFiltro == null ? 43 : ((Object)$numeroSolicitacaoFiltro).hashCode());
        String $cpfCnpjFiltro = this.getCpfCnpjFiltro();
        result = result * 59 + ($cpfCnpjFiltro == null ? 43 : $cpfCnpjFiltro.hashCode());
        Date $dataInicialFiltro = this.getDataInicialFiltro();
        result = result * 59 + ($dataInicialFiltro == null ? 43 : ((Object)$dataInicialFiltro).hashCode());
        Date $dataFinalFiltro = this.getDataFinalFiltro();
        result = result * 59 + ($dataFinalFiltro == null ? 43 : ((Object)$dataFinalFiltro).hashCode());
        TipoLaudoEntity $tipoLaudoFiltro = this.getTipoLaudoFiltro();
        result = result * 59 + ($tipoLaudoFiltro == null ? 43 : $tipoLaudoFiltro.hashCode());
        List $tiposLaudoFiltro = this.getTiposLaudoFiltro();
        result = result * 59 + ($tiposLaudoFiltro == null ? 43 : ((Object)$tiposLaudoFiltro).hashCode());
        StatusLaudoAlvara $situacaoLaudoFiltro = this.getSituacaoLaudoFiltro();
        result = result * 59 + ($situacaoLaudoFiltro == null ? 43 : $situacaoLaudoFiltro.hashCode());
        List $situacoesLaudoFiltro = this.getSituacoesLaudoFiltro();
        result = result * 59 + ($situacoesLaudoFiltro == null ? 43 : ((Object)$situacoesLaudoFiltro).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        result = result * 59 + (this.isDocumentoNaoValidado() ? 79 : 97);
        result = result * 59 + (this.isSomenteComDocumentosValidados() ? 79 : 97);
        result = result * 59 + (this.isBuscaPendenciaRenovacao() ? 79 : 97);
        TipoInscricaoAlvaraEntity $tipoInscricaoFiltro = this.getTipoInscricaoFiltro();
        result = result * 59 + ($tipoInscricaoFiltro == null ? 43 : $tipoInscricaoFiltro.hashCode());
        NaturezaSolicitacaoAlvaraEntity $naturezaSolicitacaoFiltro = this.getNaturezaSolicitacaoFiltro();
        result = result * 59 + ($naturezaSolicitacaoFiltro == null ? 43 : $naturezaSolicitacaoFiltro.hashCode());
        String $cadastroImobiliarioFiltro = this.getCadastroImobiliarioFiltro();
        result = result * 59 + ($cadastroImobiliarioFiltro == null ? 43 : $cadastroImobiliarioFiltro.hashCode());
        String $processoFiscalizacao = this.getProcessoFiscalizacao();
        result = result * 59 + ($processoFiscalizacao == null ? 43 : $processoFiscalizacao.hashCode());
        List $situacoesDocumento = this.getSituacoesDocumento();
        result = result * 59 + ($situacoesDocumento == null ? 43 : ((Object)$situacoesDocumento).hashCode());
        String $protocoloRedeSim = this.getProtocoloRedeSim();
        result = result * 59 + ($protocoloRedeSim == null ? 43 : $protocoloRedeSim.hashCode());
        result = result * 59 + (this.getLaudoDocumentosNaoValidadosFiltro() ? 79 : 97);
        result = result * 59 + (this.isSolicitacoesComAnexoNosLaudosFiltro() ? 79 : 97);
        String $grauRisco = this.getGrauRisco();
        result = result * 59 + ($grauRisco == null ? 43 : $grauRisco.hashCode());
        return result;
    }

    public String toString() {
        return "SolicitacaoAlvaraDataModel(numeroSolicitacaoFiltro=" + this.getNumeroSolicitacaoFiltro() + ", cpfCnpjFiltro=" + this.getCpfCnpjFiltro() + ", dataInicialFiltro=" + this.getDataInicialFiltro() + ", dataFinalFiltro=" + this.getDataFinalFiltro() + ", tipoLaudoFiltro=" + this.getTipoLaudoFiltro() + ", tiposLaudoFiltro=" + this.getTiposLaudoFiltro() + ", situacaoLaudoFiltro=" + this.getSituacaoLaudoFiltro() + ", situacoesLaudoFiltro=" + this.getSituacoesLaudoFiltro() + ", exercicio=" + this.getExercicio() + ", documentoNaoValidado=" + this.isDocumentoNaoValidado() + ", somenteComDocumentosValidados=" + this.isSomenteComDocumentosValidados() + ", buscaPendenciaRenovacao=" + this.isBuscaPendenciaRenovacao() + ", tipoInscricaoFiltro=" + this.getTipoInscricaoFiltro() + ", naturezaSolicitacaoFiltro=" + this.getNaturezaSolicitacaoFiltro() + ", cadastroImobiliarioFiltro=" + this.getCadastroImobiliarioFiltro() + ", processoFiscalizacao=" + this.getProcessoFiscalizacao() + ", situacoesDocumento=" + this.getSituacoesDocumento() + ", protocoloRedeSim=" + this.getProtocoloRedeSim() + ", laudoDocumentosNaoValidadosFiltro=" + this.getLaudoDocumentosNaoValidadosFiltro() + ", solicitacoesComAnexoNosLaudosFiltro=" + this.isSolicitacoesComAnexoNosLaudosFiltro() + ", grauRisco=" + this.getGrauRisco() + ")";
    }
}

