/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.controller.RequerimentoSolicitacaoAlvaraController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.controller.dataModel.SolicitacaoAlvaraDataModel;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SefazDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraNumConselhoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraValidadeSefazEntity;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoDocumentoAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.facade.FacadeDocumento;
import br.com.elotech.portalarrecadacao.facade.FacadeLaudoAlvara;
import br.com.elotech.portalarrecadacao.facade.FacadeProcessoFiscalizacao;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.facade.FacadeValidacaoDocumentos;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.ContratoSocialPessoaEntity;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.facade.FacadeLoginAise;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.tributacao.security.AuthenticationProviderAise;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.enumerator.UsuarioMasterTecnicoEnum;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.primefaces.context.RequestContext;
import org.primefaces.event.FileUploadEvent;
import org.primefaces.model.DefaultStreamedContent;
import org.primefaces.model.StreamedContent;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

@Scope(value="flow")
@EloController(value="validacaoDocumentosController")
public class ValidacaoDocumentosController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SolicitacaoAlvaraDataModel solicitacaoAlvaraDataModel;
    private String solicitacao;
    private String cpfCnpj;
    private Long numeroSolicitacao;
    private Long exercicio;
    private List<SolicitacaoAlvaraEntity> solicitacoes;
    private SolicitacaoAlvaraEntity solicitacaoSelecionada;
    private StreamedContent file;
    private Date dataInicial;
    private Date dataFinal;
    private String descricaoDataHoraAtual;
    private Integer maxLengthObs = 0;
    private Boolean provisorioSefaz = false;
    private Date dataValidadeProvisorioSefaz;
    private static final Integer TAMANHOCAMPOOBS = 3500;
    private boolean buscaDocumentosNaoValidados;
    private boolean buscaPendenciaRenovacaoNaoValidados;
    private String nomeAtividade;
    private List<Atividade> listaAtividade;
    private List<SolicitacaoAlvaraNumConselhoEntity> listaSolicitacaoNumConselho;
    private List<ContratoSocialPessoaEntity> listaSocios;
    private List<TipoInscricaoAlvaraEntity> listaTipoInscricaoAlvara;
    private TipoInscricaoAlvaraEntity tipoInscricaoAlvaraSelecionado;
    private List<NaturezaSolicitacaoAlvaraEntity> listaNaturezaJuridica;
    private NaturezaSolicitacaoAlvaraEntity naturezaJuridicaSelecionado;
    private SefazDocumentoEntity documentoSefaz;
    private SolicitacaoAlvaraDocumentoEntity solicitacaoAlvaraDocumento;
    private List<SituacaoDocumentoAlvaraEnum> situacoesDocumento = Arrays.asList(SituacaoDocumentoAlvaraEnum.values());
    private List<SituacaoDocumentoAlvaraEnum> situacoesSelecionadas = new ArrayList();
    @Resource
    private RequerimentoSolicitacaoAlvaraController requerimentoSolicitacaoAlvaraController;
    @Resource
    private AuthenticationProviderAise authenticationProviderAise;
    private boolean solicitacaoComLaudosCancelados;
    private boolean bloqueiaTramite;

    public SolicitacaoAlvaraDataModel getSolicitacaoAlvaraDataModel() {
        return this.solicitacaoAlvaraDataModel;
    }

    public void setSolicitacaoAlvaraDataModel(SolicitacaoAlvaraDataModel solicitacaoAlvaraDataModel) {
        this.solicitacaoAlvaraDataModel = solicitacaoAlvaraDataModel;
    }

    public List<Atividade> getListaAtividade() {
        return this.listaAtividade;
    }

    public void setListaAtividade(List<Atividade> listaAtividade) {
        this.listaAtividade = listaAtividade;
    }

    public Integer getMaxLengthObs() {
        return this.maxLengthObs;
    }

    public void setMaxLengthObs(Integer maxLengthObs) {
        this.maxLengthObs = maxLengthObs;
    }

    public String getNomeAtividade() {
        return this.nomeAtividade;
    }

    public void setNomeAtividade(String nomeAtividade) {
        this.nomeAtividade = nomeAtividade;
    }

    public boolean isBuscaDocumentosNaoValidados() {
        return this.buscaDocumentosNaoValidados;
    }

    public void setBuscaDocumentosNaoValidados(boolean buscaDocumentosNaoValidados) {
        this.buscaDocumentosNaoValidados = buscaDocumentosNaoValidados;
    }

    public boolean isBuscaPendenciaRenovacaoNaoValidados() {
        return this.buscaPendenciaRenovacaoNaoValidados;
    }

    public void setBuscaPendenciaRenovacaoNaoValidados(boolean buscaPendenciaRenovacaoNaoValidados) {
        this.buscaPendenciaRenovacaoNaoValidados = buscaPendenciaRenovacaoNaoValidados;
    }

    public String getSolicitacao() {
        return this.solicitacao;
    }

    public void setSolicitacao(String solicitacao) {
        this.solicitacao = solicitacao;
    }

    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    public Long getNumeroSolicitacao() {
        return this.numeroSolicitacao;
    }

    public void setNumeroSolicitacao(Long numeroSolicitacao) {
        this.numeroSolicitacao = numeroSolicitacao;
    }

    public Long getExercicio() {
        return this.exercicio;
    }

    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    public List<SolicitacaoAlvaraEntity> getSolicitacoes() {
        return this.solicitacoes;
    }

    public void setSolicitacoes(List<SolicitacaoAlvaraEntity> solicitacoes) {
        this.solicitacoes = solicitacoes;
    }

    public SolicitacaoAlvaraEntity getSolicitacaoSelecionada() {
        return this.solicitacaoSelecionada;
    }

    public void setSolicitacaoSelecionada(SolicitacaoAlvaraEntity solicitacaoSelecionada) {
        this.solicitacaoSelecionada = solicitacaoSelecionada;
    }

    public StreamedContent getFile() {
        return this.file;
    }

    public void setFile(StreamedContent file) {
        this.file = file;
    }

    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    public String getDescricaoDataHoraAtual() {
        this.descricaoDataHoraAtual = EloDateUtils.toAnsiDateString((Date)new Date(), (String)"dd/MM/yyyy - HH:mm");
        return this.descricaoDataHoraAtual;
    }

    public void setDescricaoDataHoraAtual(String descricaoDataHoraAtual) {
        this.descricaoDataHoraAtual = descricaoDataHoraAtual;
    }

    public Boolean getProvisorioSefaz() {
        return this.provisorioSefaz;
    }

    public void setProvisorioSefaz(Boolean provisorioSefaz) {
        this.provisorioSefaz = provisorioSefaz;
    }

    public Date getDataValidadeProvisorioSefaz() {
        return this.dataValidadeProvisorioSefaz;
    }

    public void setDataValidadeProvisorioSefaz(Date dataValidadeProvisorioSefaz) {
        this.dataValidadeProvisorioSefaz = dataValidadeProvisorioSefaz;
    }

    public List<SolicitacaoAlvaraNumConselhoEntity> getListaSolicitacaoNumConselho() {
        return this.listaSolicitacaoNumConselho;
    }

    public void setListaSolicitacaoNumConselho(List<SolicitacaoAlvaraNumConselhoEntity> listaSolicitacaoNumConselho) {
        this.listaSolicitacaoNumConselho = listaSolicitacaoNumConselho;
    }

    public List<ContratoSocialPessoaEntity> getListaSocios() {
        return this.listaSocios;
    }

    public void setListaSocios(List<ContratoSocialPessoaEntity> listaSocios) {
        this.listaSocios = listaSocios;
    }

    public List<TipoInscricaoAlvaraEntity> getListaTipoInscricaoAlvara() {
        return this.listaTipoInscricaoAlvara;
    }

    public TipoInscricaoAlvaraEntity getTipoInscricaoAlvaraSelecionado() {
        return this.tipoInscricaoAlvaraSelecionado;
    }

    public void setTipoInscricaoAlvaraSelecionado(TipoInscricaoAlvaraEntity tipoInscricaoAlvaraSelecionado) {
        this.tipoInscricaoAlvaraSelecionado = tipoInscricaoAlvaraSelecionado;
    }

    public List<NaturezaSolicitacaoAlvaraEntity> getListaNaturezaJuridica() {
        return this.listaNaturezaJuridica;
    }

    public NaturezaSolicitacaoAlvaraEntity getNaturezaJuridicaSelecionado() {
        return this.naturezaJuridicaSelecionado;
    }

    public void setNaturezaJuridicaSelecionado(NaturezaSolicitacaoAlvaraEntity naturezaJuridicaSelecionado) {
        this.naturezaJuridicaSelecionado = naturezaJuridicaSelecionado;
    }

    public SefazDocumentoEntity getDocumentoSefaz() {
        return this.documentoSefaz;
    }

    public void setDocumentoSefaz(SefazDocumentoEntity documentoSefaz) {
        this.documentoSefaz = documentoSefaz;
    }

    public SolicitacaoAlvaraDocumentoEntity getSolicitacaoAlvaraDocumento() {
        return this.solicitacaoAlvaraDocumento;
    }

    public void setSolicitacaoAlvaraDocumento(SolicitacaoAlvaraDocumentoEntity solicitacaoAlvaraDocumento) {
        this.solicitacaoAlvaraDocumento = solicitacaoAlvaraDocumento;
    }

    public List<SituacaoDocumentoAlvaraEnum> getSituacoesSelecionadas() {
        return this.situacoesSelecionadas;
    }

    public void setSituacoesSelecionadas(List<SituacaoDocumentoAlvaraEnum> situacoesSelecionadas) {
        this.situacoesSelecionadas = situacoesSelecionadas;
    }

    public List<SituacaoDocumentoAlvaraEnum> getSituacoesDocumento() {
        return this.situacoesDocumento;
    }

    public void setSituacoesDocumento(List<SituacaoDocumentoAlvaraEnum> situacoesDocumento) {
        this.situacoesDocumento = situacoesDocumento;
    }

    public boolean isSolicitacaoComLaudosCancelados() {
        return this.solicitacaoComLaudosCancelados;
    }

    public void setSolicitacaoComLaudosCancelados(boolean solicitacaoComLaudosCancelados) {
        this.solicitacaoComLaudosCancelados = solicitacaoComLaudosCancelados;
    }

    public boolean isBloqueiaTramite() {
        return this.bloqueiaTramite;
    }

    public void setBloqueiaTramite(boolean bloqueiaTramite) {
        this.bloqueiaTramite = bloqueiaTramite;
    }

    public void pesquisar() throws BaseException {
        this.solicitacaoSelecionada = null;
        this.numeroSolicitacao = null;
        this.exercicio = null;
        if (!EloStringUtils.isEmpty((String)this.solicitacao)) {
            Long[] consulta = UtilsController.separarNumeroExercicioSolicitacao((String)this.solicitacao);
            if (consulta == null) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"Verifique o n\u00famero informado. O n\u00famero deve estar no formato 'n\u00famero/ano'. Exemplo: 10/2015");
                throw new SolicitacaoAlvaraException("Verifique o n\u00famero informado. O n\u00famero deve estar no formato 'n\u00famero/ano'. Exemplo: 10/2015");
            }
            this.numeroSolicitacao = consulta[0];
            this.exercicio = consulta[1];
        } else if (this.isNecessarioMaisCampos()) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Preencha mais campos para realizar a consulta!");
            return;
        }
        if (this.solicitacaoAlvaraDataModel == null) {
            this.solicitacaoAlvaraDataModel = new SolicitacaoAlvaraDataModel();
        }
        this.solicitacaoAlvaraDataModel.setNumeroSolicitacaoFiltro(this.numeroSolicitacao != null ? this.numeroSolicitacao : null);
        this.solicitacaoAlvaraDataModel.setExercicio(this.exercicio);
        this.solicitacaoAlvaraDataModel.setCpfCnpjFiltro(this.cpfCnpj);
        this.solicitacaoAlvaraDataModel.setDataInicialFiltro(this.dataInicial);
        this.solicitacaoAlvaraDataModel.setDataFinalFiltro(this.dataFinal);
        this.solicitacaoAlvaraDataModel.setSituacoesDocumento(this.situacoesSelecionadas);
        this.solicitacaoAlvaraDataModel.setBuscaPendenciaRenovacao(this.buscaPendenciaRenovacaoNaoValidados);
        this.solicitacaoAlvaraDataModel.setTipoInscricaoFiltro(this.tipoInscricaoAlvaraSelecionado);
        this.solicitacaoAlvaraDataModel.setNaturezaSolicitacaoFiltro(this.naturezaJuridicaSelecionado);
    }

    private boolean isNecessarioMaisCampos() {
        return EloStringUtils.isEmpty((String)this.solicitacao) && this.dataInicial == null && this.dataFinal == null && EloStringUtils.isEmpty((String)this.cpfCnpj);
    }

    public void limpar() {
        this.solicitacao = "";
        this.cpfCnpj = "";
        this.dataInicial = null;
        this.dataFinal = null;
        this.solicitacoes = null;
        this.tipoInscricaoAlvaraSelecionado = null;
        this.naturezaJuridicaSelecionado = null;
        this.solicitacaoAlvaraDataModel = null;
        this.solicitacaoSelecionada = null;
    }

    public void onRowSelect() throws BaseException {
        if (this.solicitacaoSelecionada != null) {
            if (UtilsController.isBloqueiaTramiteDepoisAlvaraEmitido((SolicitacaoAlvaraEntity)this.solicitacaoSelecionada)) {
                ShowMessage.addInfoMessage((String)"validacao", (String)"Solicita\u00e7\u00e3o Bloqueada, j\u00e1 foi emitido um alvar\u00e1 para esta solicita\u00e7\u00e3o ");
            }
            this.solicitacaoComLaudosCancelados = ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).isExisteLaudoComSituacaoCancelado(this.solicitacaoSelecionada);
            if (this.solicitacaoComLaudosCancelados) {
                ShowMessage.addWarnMessage((String)"validacao", (String)"Solicita\u00e7\u00e3o com os laudos cancelados.");
            }
            this.dataValidadeProvisorioSefaz = this.solicitacaoSelecionada.getDataValidadeSefaz();
        } else {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Solicita\u00e7\u00e3o n\u00e3o encontrada");
        }
    }

    public StreamedContent downloadFile(SolicitacaoAlvaraDocumentoEntity documento) {
        ByteArrayInputStream stream = new ByteArrayInputStream(documento.getDocumento());
        this.file = new DefaultStreamedContent((InputStream)stream);
        return this.file;
    }

    public void validar(SolicitacaoAlvaraDocumentoEntity documento) {
        if (documento.isDocumentoValidado()) {
            ShowMessage.addInfoMessage((String)"validacao", (String)"Documento j\u00e1 validado!");
            return;
        }
        if (!documento.isDocumentoValidado()) {
            documento.setSituacao(SituacaoDocumentoAlvaraEnum.VALIDADO);
            documento.setDataValidacao(new Date());
            documento.setUsuario((UsuarioEntity)SecurityContextHolder.getContext().getAuthentication().getPrincipal());
            try {
                ((FacadeValidacaoDocumentos)SpringContext.getBean(FacadeValidacaoDocumentos.class)).salvarDocumento(documento);
                ((FacadeValidacaoDocumentos)SpringContext.getBean(FacadeValidacaoDocumentos.class)).notificarValidacaoDocumento(documento);
            }
            catch (BaseException e) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"N\u00e3o foi poss\u00edvel validar o documento");
            }
            try {
                ((FacadeProcessoFiscalizacao)SpringContext.getBean(FacadeProcessoFiscalizacao.class)).abrirProcessoAutomatico(this.solicitacaoSelecionada);
            }
            catch (BaseException e) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"N\u00e3o foi poss\u00edvel abrir o processo de fiscaliza\u00e7\u00e3o");
            }
        }
    }

    public void verDetalhes(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        this.requerimentoSolicitacaoAlvaraController.verDetalhes(solicitacao, true);
    }

    public void gravarProvisorioSefaz() {
        try {
            if (this.solicitacaoSelecionada != null && this.validarDataValidadeSefaz()) {
                this.solicitacaoSelecionada.setDataValidadeSefaz(this.dataValidadeProvisorioSefaz);
                SolicitacaoAlvaraValidadeSefazEntity solicitacaoAlvaraValidadeSefaz = new SolicitacaoAlvaraValidadeSefazEntity();
                solicitacaoAlvaraValidadeSefaz.setDataInclusao(new Date());
                solicitacaoAlvaraValidadeSefaz.setDataValidade(this.dataValidadeProvisorioSefaz);
                solicitacaoAlvaraValidadeSefaz.setSolicitacaoAlvara(this.solicitacaoSelecionada);
                solicitacaoAlvaraValidadeSefaz.setUsuario((UsuarioEntity)SecurityContextHolder.getContext().getAuthentication().getPrincipal());
                ((FacadeValidacaoDocumentos)SpringContext.getBean(FacadeValidacaoDocumentos.class)).salvarValidadeSefaz(solicitacaoAlvaraValidadeSefaz);
                ShowMessage.addInfoMessage((String)"validacao", (String)"Dados gravados com sucesso.");
            }
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)("N\u00e3o foi poss\u00edvel salvar a Solicita\u00e7\u00e3o" + e.getMessage()));
        }
    }

    protected boolean validarDataValidadeSefaz() {
        if (this.dataValidadeProvisorioSefaz != null && (EloDateUtils.isSameDay((Date)new Date(), (Date)this.dataValidadeProvisorioSefaz) || EloDateUtils.isBeforeDay((Date)this.dataValidadeProvisorioSefaz, (Date)new Date()))) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"A data da validade deve ser maior que a data atual!");
            this.dataValidadeProvisorioSefaz = this.solicitacaoSelecionada.getDataValidadeSefaz();
            return false;
        }
        return true;
    }

    public void iniciar() {
        ((EntidadeController)SpringContext.getBean(EntidadeController.class)).isNavMenu();
        this.buscaDocumentosNaoValidados = true;
        this.buscaPendenciaRenovacaoNaoValidados = false;
        this.limpar();
        this.solicitacoes = new ArrayList();
        this.dataValidadeProvisorioSefaz = null;
        this.solicitacaoSelecionada = null;
        this.solicitacaoAlvaraDataModel = new SolicitacaoAlvaraDataModel();
        try {
            this.listaTipoInscricaoAlvara = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregarMenusTipoInscricao();
            this.listaNaturezaJuridica = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregaNaturezas(true);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void salvarObservacao() throws BaseException {
        if (this.solicitacaoSelecionada.getObsValidacaoDoc().length() > TAMANHOCAMPOOBS) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Tamanho do Texto Passou do Limite!");
            return;
        }
        ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).atualizaSolicitacaoAlvara(this.solicitacaoSelecionada);
        this.solicitacaoSelecionada = null;
    }

    public void abrirObservacoes() {
        if (this.solicitacaoSelecionada == null) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Selecione uma Solicita\u00e7\u00e3o!");
            return;
        }
        this.maxLengthObs = this.solicitacaoSelecionada.getObservacoes() == null ? TAMANHOCAMPOOBS : Integer.valueOf(TAMANHOCAMPOOBS - this.solicitacaoSelecionada.getObsValidacaoDoc().length());
    }

    public String retornaNomeCmcResponsavel(Long cadastroGeral) throws BaseException {
        if (cadastroGeral != null && cadastroGeral != 0L) {
            return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregaCadastroMobiliarioByCadastroGeral(cadastroGeral).getCadastroGeral().getPessoa().getNome();
        }
        return "";
    }

    public String retornaCnpjCmcResponsavel(Long cadastroGeral) throws BaseException {
        if (cadastroGeral != null && cadastroGeral != 0L) {
            return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregaCadastroMobiliarioByCadastroGeral(cadastroGeral).getCadastroGeral().getPessoa().getCnpjCpf();
        }
        return "";
    }

    public String formataData(Date data) {
        String dataFormatada = data != null ? EloDateUtils.toAnsiDateString((Date)data, (String)"dd/MM/yyyy") : "";
        return dataFormatada;
    }

    public void visualizarDocumentosSefaz() {
        try {
            if (this.solicitacaoSelecionada != null) {
                this.solicitacaoSelecionada.setSefazDocumentos(((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregaDocumentosSefaz(this.solicitacaoSelecionada));
            }
            this.inicializarDocumentoSefaz();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void inicializarDocumentoSefaz() {
        this.documentoSefaz = new SefazDocumentoEntity();
        this.documentoSefaz.setSolicitacaoAlvara(this.solicitacaoSelecionada);
    }

    public void handleFileUpload(FileUploadEvent event) {
        if (event.getFile() != null && event.getFile().getContents() != null) {
            this.documentoSefaz.setDocumento(event.getFile().getContents());
            this.documentoSefaz.setDataInclusao(EloDateUtils.getNowShort());
            this.documentoSefaz.setNomeArquivo(EloStringUtils.limit((String)event.getFile().getFileName(), (int)70));
        }
    }

    public void adicionarDocumentoSefaz() {
        try {
            ((FacadeDocumento)SpringContext.getBean(FacadeDocumento.class)).adicionarDocumentoSefaz(this.documentoSefaz);
            this.inicializarDocumentoSefaz();
            this.solicitacaoSelecionada.setSefazDocumentos(((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregaDocumentosSefaz(this.solicitacaoSelecionada));
            this.solicitacaoSelecionada.setDocumentos(((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregaDocumentosEnviadosSolicitacao(this.solicitacaoSelecionada));
        }
        catch (ValidacaoException ve) {
            ShowMessage.addErrorMessages((String)"validacaoDocumentos", (List)ve.getMensagens());
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacaoDocumentos", (String)("Erro ao adiconar o documento sefaz: " + e.getMessage()));
        }
    }

    public StreamedContent downloadFileDocumentoSefaz(SefazDocumentoEntity documento) {
        ByteArrayInputStream stream = new ByteArrayInputStream(documento.getDocumento());
        return new DefaultStreamedContent((InputStream)stream);
    }

    public void removerDocumentoSefaz(SefazDocumentoEntity documento) {
        try {
            ((FacadeDocumento)SpringContext.getBean(FacadeDocumento.class)).removerDocumentoSefaz(documento);
            this.solicitacaoSelecionada.setSefazDocumentos(((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregaDocumentosSefaz(this.solicitacaoSelecionada));
            this.solicitacaoSelecionada.setDocumentos(((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregaDocumentosEnviadosSolicitacao(this.solicitacaoSelecionada));
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacaoDocumentos", (String)("Erro ao remover o documento sefaz: " + e.getMessage()));
        }
    }

    public void opcaoDocumentoNaoValidado() {
        if (this.buscaPendenciaRenovacaoNaoValidados) {
            this.buscaDocumentosNaoValidados = true;
        }
    }

    public void confirmarInvalidacao(SolicitacaoAlvaraDocumentoEntity documento) {
        this.solicitacaoAlvaraDocumento = documento;
        if (documento.isDocumentoNaoValidado()) {
            ShowMessage.addInfoMessage((String)"validacao", (String)"Documento j\u00e1 foi marcado como inv\u00e1lido!");
            return;
        }
        RequestContext.getCurrentInstance().execute("PF('confirmarInvalidacaoDocumento').show()");
    }

    public void invalidar() {
        if (Strings.isNullOrEmpty((String)this.solicitacaoAlvaraDocumento.getMotivoInvalidacao())) {
            ShowMessage.addErrorMessage((String)"msgInvalidarDocumento", (String)"Informe o motivo!");
            return;
        }
        this.solicitacaoAlvaraDocumento.setSituacao(SituacaoDocumentoAlvaraEnum.NAO_VALIDADO);
        this.solicitacaoAlvaraDocumento.setDataValidacao(new Date());
        this.solicitacaoAlvaraDocumento.setUsuario((UsuarioEntity)SecurityContextHolder.getContext().getAuthentication().getPrincipal());
        try {
            ((FacadeValidacaoDocumentos)SpringContext.getBean(FacadeValidacaoDocumentos.class)).salvarDocumento(this.solicitacaoAlvaraDocumento);
            ((FacadeValidacaoDocumentos)SpringContext.getBean(FacadeValidacaoDocumentos.class)).notificarValidacaoDocumento(this.solicitacaoAlvaraDocumento);
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"N\u00e3o foi poss\u00edvel invalidar o documento");
        }
    }

    public boolean usuarioTemPermissaoParaValidar(SolicitacaoAlvaraDocumentoEntity documento) throws BaseException {
        UserDetails usuarioLogado = this.authenticationProviderAise.getUsuarioLogado();
        if (UsuarioMasterTecnicoEnum.isUsuarioTecnicoOuMaster((String)usuarioLogado.getUsername())) {
            return true;
        }
        if (usuarioLogado instanceof UsuarioEntity) {
            UsuarioEntity usuarioAiseLogado = (UsuarioEntity)usuarioLogado;
            usuarioAiseLogado = this.carregarUsuarioComListasPreenchidas(usuarioAiseLogado);
            return usuarioAiseLogado.temPermissaoParaValidarDocumento(documento.getTipoDocumento());
        }
        return false;
    }

    private UsuarioEntity carregarUsuarioComListasPreenchidas(UsuarioEntity usuarioAiseLogado) throws BaseException {
        return ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).verificarLogin(usuarioAiseLogado.getPessoa().getCnpjCpf());
    }
}

