/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.controller.SolicitacaoAlvaraController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.DocumentoAtividadeTipoInscricaoVo;
import br.com.elotech.portalarrecadacao.enumerator.GrauDeRiscoEnum;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoDocumentoAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeDocumento;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.TipoDocumentoEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.enumerator.TipoConfiguracaoAtividadeDocEnum;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.math.EloNumberUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.primefaces.context.RequestContext;
import org.primefaces.event.FileUploadEvent;
import org.primefaces.model.UploadedFile;
import org.springframework.context.annotation.Scope;

@EloController(value="uploadController")
@Scope(value="flow")
public class UploadDocumentosController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private UploadedFile documento;
    private SolicitacaoAlvaraDocumentoEntity selectedDocumento;
    private List<SolicitacaoAlvaraDocumentoEntity> documentos;
    private List<SolicitacaoAlvaraDocumentoEntity> documentosParaEnviar = new ArrayList();
    private TipoDocumentoEntity selectedTipoDocumento;
    private List<DocumentoAtividadeTipoInscricaoVo> documentosAtividadeTipoInscricao;
    private boolean flagTermoConcessao = false;
    private static final long TIPODOCUMENTOTERMOCONCESSAO = 24L;
    private List<String> anexos;
    SolicitacaoAlvaraDocumentoEntity documentoAlvara;
    private boolean renderRemoveDialog;
    @Resource
    private SolicitacaoAlvaraController solicitacaoAlvaraController;
    @Resource
    private EntidadeController entidadeController;

    public UploadedFile getDocumento() {
        return this.documento;
    }

    public void setDocumento(UploadedFile documento) {
        this.documento = documento;
    }

    public List<SolicitacaoAlvaraDocumentoEntity> getDocumentos() {
        if (this.documentos == null) {
            this.documentos = new ArrayList();
        }
        return this.documentos;
    }

    public void setDocumentos(List<SolicitacaoAlvaraDocumentoEntity> documentos) {
        this.documentos = documentos;
    }

    public void setSolicitacaoAlvaraController(SolicitacaoAlvaraController solicitacaoAlvaraController) {
        this.solicitacaoAlvaraController = solicitacaoAlvaraController;
    }

    public void setEntidadeController(EntidadeController entidadeController) {
        this.entidadeController = entidadeController;
    }

    public SolicitacaoAlvaraDocumentoEntity getSelectedDocumento() {
        return this.selectedDocumento;
    }

    public void setSelectedDocumento(SolicitacaoAlvaraDocumentoEntity selectedDocumento) {
        this.selectedDocumento = selectedDocumento;
    }

    public TipoDocumentoEntity getSelectedTipoDocumento() {
        return this.selectedTipoDocumento;
    }

    public void setSelectedTipoDocumento(TipoDocumentoEntity selectedTipoDocumento) {
        this.selectedTipoDocumento = selectedTipoDocumento;
    }

    public List<DocumentoAtividadeTipoInscricaoVo> getDocumentosAtividadeTipoInscricao() {
        return this.documentosAtividadeTipoInscricao;
    }

    public void setDocumentosAtividadeTipoInscricao(List<DocumentoAtividadeTipoInscricaoVo> documentosAtividadeTipoInscricao) {
        this.documentosAtividadeTipoInscricao = documentosAtividadeTipoInscricao;
    }

    public List<String> getAnexos() {
        return this.anexos;
    }

    public void setAnexos(List<String> anexos) {
        this.anexos = anexos;
    }

    public boolean isRenderRemoveDialog() {
        return this.renderRemoveDialog;
    }

    public void setRenderRemoveDialog(boolean renderRemoveDialog) {
        this.renderRemoveDialog = renderRemoveDialog;
    }

    public void iniciar() throws BaseException {
        if (EloListUtils.safeIsEmpty((List)this.documentos).booleanValue()) {
            this.documentos = new ArrayList();
        }
        if (this.solicitacaoAlvaraController.getSolicitacaoAlvara().isSolicitacaoJuridicaNormal()) {
            this.processarDadosPessoaJuridicaNormal();
        }
        try {
            this.documentosAtividadeTipoInscricao = this.carregarDocumentos();
        }
        catch (BaseException be) {
            ShowMessage.addErrorMessage((String)"validacao", (String)("N\u00e3o foi poss\u00edvel carregar os tipos de documento. " + be.getMessage()));
        }
    }

    protected List<DocumentoAtividadeTipoInscricaoVo> carregarDocumentos() throws BaseException {
        return ((FacadeDocumento)SpringContext.getBean(FacadeDocumento.class)).carregarDocumentoPorAtividadeOuTipoInscricao(this.solicitacaoAlvaraController.getSolicitacaoAlvara(), TipoConfiguracaoAtividadeDocEnum.SOLICITACAO);
    }

    private void processarDadosPessoaJuridicaNormal() {
        if (this.solicitacaoAlvaraController.getSolicitacaoAlvara().isNaturezaInicial() || this.solicitacaoAlvaraController.getSolicitacaoAlvara().isNaturezaMudancaEndereco()) {
            try {
                this.flagTermoConcessao = ((FacadeDocumento)SpringContext.getBean(FacadeDocumento.class)).verificaPatrimonioPublicoByImobiliario(this.solicitacaoAlvaraController.getSolicitacaoAlvara().getCadastroImobiliario());
            }
            catch (BaseException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void handleFileUpload(FileUploadEvent event) {
        if (event.getFile() != null && event.getFile().getContents() != null) {
            for (SolicitacaoAlvaraDocumentoEntity docEnviados : this.documentos) {
                if (!docEnviados.getTipoDocumento().getTipoDocumento().equals(this.selectedTipoDocumento.getTipoDocumento())) continue;
                ShowMessage.addErrorMessage((String)"validacao", (String)"J\u00e1 existe um anexo para este tipo de documento. N\u00e3o \u00e9 poss\u00edvel adicionar outro.");
                return;
            }
            this.documentoAlvara = new SolicitacaoAlvaraDocumentoEntity();
            this.documentoAlvara.setSituacao(SituacaoDocumentoAlvaraEnum.EM_ANALISE);
            this.documentoAlvara.setSolicitacaoAlvara(this.solicitacaoAlvaraController.getSolicitacaoAlvara());
            this.documentoAlvara.setDocumento(event.getFile().getContents());
            this.documentoAlvara.setTipoDocumento(this.selectedTipoDocumento);
            this.documentoAlvara.setDataInclusao(new Date());
            this.documentoAlvara.setNomeArquivo(event.getFile().getFileName());
            this.anexos.add(event.getFile().getFileName());
            if (this.selectedTipoDocumento.getTipoDocumento().equals(24L)) {
                this.flagTermoConcessao = false;
            }
            this.documentosParaEnviar.add(this.documentoAlvara);
        }
    }

    public void removeDocumento(TipoDocumentoEntity tipoDocumento) {
        ArrayList<SolicitacaoAlvaraDocumentoEntity> docs = new ArrayList<SolicitacaoAlvaraDocumentoEntity>();
        for (SolicitacaoAlvaraDocumentoEntity documento : this.documentos) {
            if (!documento.getTipoDocumento().equals((Object)tipoDocumento)) continue;
            docs.add(documento);
        }
        this.documentos.removeAll(docs);
    }

    public void removeAnexo(String anexo) {
        if (this.anexos.contains(anexo)) {
            this.anexos.remove(anexo);
        }
        ArrayList<SolicitacaoAlvaraDocumentoEntity> docsParaRemover = new ArrayList<SolicitacaoAlvaraDocumentoEntity>();
        for (SolicitacaoAlvaraDocumentoEntity documento : this.documentosParaEnviar) {
            if (!documento.getNomeArquivo().equals(anexo)) continue;
            docsParaRemover.add(documento);
        }
        if (!EloListUtils.safeIsEmpty(docsParaRemover).booleanValue()) {
            this.documentosParaEnviar.removeAll(docsParaRemover);
        }
    }

    public Boolean enviouDocumentos(TipoDocumentoEntity tipoDocumento) {
        if (!EloListUtils.safeIsEmpty((List)this.documentos).booleanValue()) {
            for (SolicitacaoAlvaraDocumentoEntity documento : this.documentos) {
                if (!documento.getTipoDocumento().equals((Object)tipoDocumento)) continue;
                return true;
            }
        }
        return false;
    }

    public String avancar() throws BaseException {
        if (!EloListUtils.safeIsEmpty((List)this.documentos).booleanValue()) {
            if (this.isDocumentoObrigatorio()) {
                return null;
            }
            if (this.flagTermoConcessao) {
                boolean termo = false;
                if (!EloListUtils.safeIsEmpty((List)this.documentos).booleanValue()) {
                    ParametroAlvaraEntity parametroTermoDeUso = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.TIPO_DOCUMENTO_TERMO_DE_USO);
                    Long tipoDocumentoTermoDeUso = Long.valueOf(parametroTermoDeUso.getValor());
                    for (SolicitacaoAlvaraDocumentoEntity documento : this.documentos) {
                        if (!documento.getTipoDocumento().getTipoDocumento().equals(tipoDocumentoTermoDeUso)) continue;
                        termo = true;
                    }
                }
                if (!termo) {
                    ShowMessage.addErrorMessage((String)"validacao", (String)"O Im\u00f3vel \u00e9 um Patrim\u00f4nio P\u00fablico Municipal \u00e9 Obrigat\u00f3rio anexar o Termo de concess\u00e3o de uso!");
                    return null;
                }
            }
            if (this.obrigaDocumentoInscricaoCadastroMobiliario()) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"Essa solicita\u00e7\u00e3o possui cnae de liberdade econ\u00f4mica, ser\u00e1 necess\u00e1rio anexar o documento de Inscri\u00e7\u00e3o de Cadastro Mobili\u00e1rio!");
                return null;
            }
            this.solicitacaoAlvaraController.getSolicitacaoAlvara().setDocumentos(this.getDocumentos());
            return "toAdicionaNumeroConselho";
        }
        ShowMessage.addErrorMessage((String)"validacao", (String)"Adicione um Documento");
        return null;
    }

    private boolean isDocumentoObrigatorio() {
        for (DocumentoAtividadeTipoInscricaoVo documento : this.documentosAtividadeTipoInscricao) {
            if (!documento.getObrigatorio().equals(SimNaoEnum.SIM.getShortText()) || this.existeDocumentoNaLista(documento.getTipoDocumento().getTipoDocumento())) continue;
            ShowMessage.addErrorMessage((String)"validacao", (String)String.format("O Documento %s \u00e9 Obrigat\u00f3rio para este tipo de Inscri\u00e7\u00e3o.", documento.getTipoDocumento().getDescricao()));
            return true;
        }
        return false;
    }

    private boolean existeDocumentoNaLista(Long idTipoDoc) {
        for (SolicitacaoAlvaraDocumentoEntity doc : this.getDocumentos()) {
            if (!doc.getTipoDocumento().getTipoDocumento().equals(idTipoDoc)) continue;
            return true;
        }
        return false;
    }

    public void enviar() {
        if (this.anexos.size() <= 0) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Adicione um Documento");
            return;
        }
        for (SolicitacaoAlvaraDocumentoEntity doc : this.documentosParaEnviar) {
            if (this.selectedTipoDocumento == null) continue;
            doc.setTipoDocumento(this.selectedTipoDocumento);
        }
        this.getDocumentos().addAll(this.documentosParaEnviar);
        this.documentosParaEnviar.clear();
        RequestContext.getCurrentInstance().execute("docsDialog.hide()");
    }

    public void openDialog(TipoDocumentoEntity tipoDocumento) {
        this.selectedTipoDocumento = tipoDocumento;
        if (this.anexos == null) {
            this.anexos = new ArrayList();
        }
        if (!this.anexos.isEmpty()) {
            this.anexos.clear();
        }
        for (SolicitacaoAlvaraDocumentoEntity doc : this.documentos) {
            if (!doc.getTipoDocumento().getTipoDocumento().equals(tipoDocumento.getTipoDocumento())) continue;
            this.anexos.add(doc.getNomeArquivo());
        }
        this.renderRemoveDialog = this.anexos.isEmpty();
    }

    public boolean validaSolicitacao() throws BaseException {
        SolicitacaoAlvaraEntity solicitacao = this.solicitacaoAlvaraController.getSolicitacaoAlvara();
        if (UtilsController.isBloqueiaSolicitacaoLiberdadeEconomicaSemIntegracao((SolicitacaoAlvaraEntity)solicitacao)) {
            ShowMessage.addInfoMessage((String)"validacao", (String)"ATEN\u00c7\u00c3O! - Com o advento da Lei n\u00ba 13.874/2019, denominada de Lei da Liberdade Econ\u00f4mica, as empresas com atividades somente com CNAE's elencados nas RESOLU\u00c7\u00d5ES CGSIM N\u00bas. 57 e 59/2020 est\u00e3o dispensadas de Licen\u00e7a para Localiza\u00e7\u00e3o. Favor verificar se todos os CNAES inseridos na consulta pr\u00e9via est\u00e3o nas resolu\u00e7\u00f5es supracitadas. Caso sim, dever\u00e1 fazer apenas a inscri\u00e7\u00e3o municipal via pra\u00e7a de atendimento. Caso n\u00e3o, solicitar alvar\u00e1 atrav\u00e9s do sistema antigo. D\u00favidas: 3221-1321.");
            return false;
        }
        if (solicitacao.isSolicitacaoJuridicaNormal() || solicitacao.isSolicitacaoCBO() && UtilsController.validarAreaUtilizadaCBO()) {
            return this.validaSolicitacaoAreaUtilizada(solicitacao);
        }
        return true;
    }

    private Boolean validaSolicitacaoAreaUtilizada(SolicitacaoAlvaraEntity solicitacao) {
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA}) && !solicitacao.isPossuiPontoReferencia() && !EloNumberUtils.isBiggerThanZero((Number)solicitacao.getAreaConstruida()).booleanValue()) {
            this.entidadeController.setNavMenu(true);
            ShowMessage.addErrorMessage((String)"validacao", (String)"Na Consulta Pr\u00e9via n\u00e3o consta a \u00e1rea utilizada, fa\u00e7a uma nova Consulta Pr\u00e9via informando os valores.");
            return false;
        }
        return true;
    }

    public void limparDocumentoAnexado() {
        if (!EloListUtils.safeIsEmpty((List)this.documentosParaEnviar).booleanValue()) {
            this.documentosParaEnviar.remove(this.documentoAlvara);
        }
    }

    private boolean obrigaDocumentoInscricaoCadastroMobiliario() throws BaseException {
        Long tipoDocumentoInscricaoCadastroMobiliario = Long.valueOf(UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.TIPO_DOCUMENTO_INSCRICAO_CADASTRO_MOBILIARIO).getValor());
        return this.solicitacaoAlvaraController.getSolicitacaoAlvara().isNaturezaInicial() && GrauDeRiscoEnum.isGrauRiscoLiberdadeEconomica((String)this.solicitacaoAlvaraController.getSolicitacaoAlvara().getGrauRisco()) && this.solicitacaoAlvaraController.getSolicitacaoAlvara().getSolicitacaoAlvaraAtividades().stream().anyMatch(SolicitacaoAlvaraAtividadeEntity::obrigaDocumentoInscricaoCadastroMobiliario) && this.documentos.stream().noneMatch(documento -> documento.getTipoDocumento().getTipoDocumento().equals(tipoDocumentoInscricaoCadastroMobiliario));
    }
}

