/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.TipoExigenciaEntity;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeTipoExigencia;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import java.io.Serializable;
import java.util.List;
import org.springframework.context.annotation.Scope;

@Scope(value="flow")
@EloController(value="tipoExigenciaController")
public class TipoExigenciaController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 492536779862884787L;
    private List<TipoExigenciaEntity> tiposExigencia;
    private TipoExigenciaEntity tipoExigencia;

    public void iniciar() throws BaseException {
        this.carregarTiposExigencia();
    }

    private void carregarTiposExigencia() throws BaseException {
        this.tiposExigencia = this.getFacadeTipoExigencia().carregarTodosTipoExigencia();
    }

    private FacadeTipoExigencia getFacadeTipoExigencia() {
        return (FacadeTipoExigencia)SpringContext.getBean(FacadeTipoExigencia.class);
    }

    public void salvarTipoExigencia() throws BaseException {
        this.getFacadeTipoExigencia().salvarTipoExigencia(this.tipoExigencia);
        this.carregarTiposExigencia();
    }

    public void removerTipoExigencia(TipoExigenciaEntity tipoExigencia) {
        try {
            this.getFacadeTipoExigencia().removerTipoExigencia(tipoExigencia);
            this.carregarTiposExigencia();
            ShowMessage.addInfoMessage((String)"msgTipoExigencia", (String)"Tipo de Exig\u00eancia exclu\u00eddo com sucesso.");
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"msgTipoExigencia", (String)String.format("Ocorreu uma falha ao deletar o tipo de exig\u00eancia: %s", e.getCause()));
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void editarTipoExigencia(TipoExigenciaEntity tipoExigencia) {
        this.tipoExigencia = tipoExigencia;
    }

    public List<TipoExigenciaEntity> getTiposExigencia() {
        return this.tiposExigencia;
    }

    public void setTiposExigencia(List<TipoExigenciaEntity> tiposExigencia) {
        this.tiposExigencia = tiposExigencia;
    }

    public TipoExigenciaEntity getTipoExigencia() {
        return this.tipoExigencia;
    }

    public void setTipoExigencia(TipoExigenciaEntity tipoExigencia) {
        this.tipoExigencia = tipoExigencia;
    }

    public void novoTipoExigencia() {
        this.tipoExigencia = new TipoExigenciaEntity();
        this.tipoExigencia.setAtivo(SimNaoEnum.SIM.getShortText());
    }

    public SimNaoEnum[] simNaoEnum() {
        return SimNaoEnum.values();
    }
}

