/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.common.CommonController;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeDocumento;
import br.com.elotech.portalarrecadacao.facade.FacadeUsuario;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.TipoDocumentoEntity;
import br.com.elotech.tributacao.domain.aise.TipoDocumentoUsuarioAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.util.filter.EloFilter;
import br.com.elotech.util.filter.HashMapEloFilter;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.sql.Modulo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.context.annotation.Scope;

@Scope(value="flow")
@EloController
public class TipoDocumentoPorUsuarioController
extends CommonController {
    private static final long serialVersionUID = 26089764928776767L;
    public static final String ROLE_VALIDACAODOCUMENTO = "ROLE_VALIDACAODOCUMENTO";
    private UsuarioEntity usuarioSelecionado;
    private List<TipoDocumentoEntity> tiposDocumento = new ArrayList();
    private List<TipoDocumentoEntity> tiposDocumentoSelecionados = new ArrayList();
    private List<UsuarioEntity> usuarios;
    private String nomeConsulta;
    private String cpfConsulta;

    public String getNomeConsulta() {
        return this.nomeConsulta;
    }

    public void setNomeConsulta(String nomeConsulta) {
        this.nomeConsulta = nomeConsulta;
    }

    public String getCpfConsulta() {
        return this.cpfConsulta;
    }

    public void setCpfConsulta(String cpfConsulta) {
        this.cpfConsulta = cpfConsulta;
    }

    public List<UsuarioEntity> getUsuarios() {
        return this.usuarios;
    }

    public void setUsuarios(List<UsuarioEntity> usuarios) {
        this.usuarios = usuarios;
    }

    public List<TipoDocumentoEntity> getTiposDocumento() {
        return this.tiposDocumento;
    }

    public void setTiposDocumento(List<TipoDocumentoEntity> tiposDocumento) {
        this.tiposDocumento = tiposDocumento;
    }

    public List<TipoDocumentoEntity> getTiposDocumentoSelecionados() {
        return this.tiposDocumentoSelecionados;
    }

    public void setTiposDocumentoSelecionados(List<TipoDocumentoEntity> tiposDocumentoSelecionados) {
        this.tiposDocumentoSelecionados = tiposDocumentoSelecionados;
    }

    public UsuarioEntity getUsuarioSelecionado() {
        return this.usuarioSelecionado;
    }

    public void setUsuarioSelecionado(UsuarioEntity usuarioSelecionado) {
        this.usuarioSelecionado = usuarioSelecionado;
    }

    public void iniciarComException() {
        try {
            this.carregarUsuariosAlvara();
            this.carregarTiposDocumento();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)e.getMessage());
        }
    }

    private void carregarUsuariosAlvara() throws BaseException {
        ArrayList<EloFilter> filtros = new ArrayList<EloFilter>();
        filtros.add(EloFilter.newFrom((String)"modulo", (Object)Modulo.ALVARAONLINE.getCodigo()));
        filtros.add(EloFilter.newFrom((String)"seletor", (Object)ROLE_VALIDACAODOCUMENTO));
        HashMapEloFilter filter = new HashMapEloFilter(filtros);
        this.usuarios = this.carregarUsuarios(filter);
    }

    private void carregarTiposDocumento() throws BaseException {
        this.tiposDocumento = ((FacadeDocumento)SpringContext.getBean(FacadeDocumento.class)).buscarTiposDocumento();
    }

    public void carregaTipoDocumentoUsuario(String idUsuario) {
        try {
            this.usuarioSelecionado = ((FacadeUsuario)SpringContext.getBean(FacadeUsuario.class)).carregaUsuarioPorId(idUsuario);
            this.adicionarTiposDocumentoJaVinculados();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)String.format("N\u00e3o foi poss\u00edvel carregar os documentos: %s", e.getMessage()));
        }
    }

    private void adicionarTiposDocumentoJaVinculados() {
        if (this.usuarioSelecionado == null) {
            ShowMessage.addInfoMessage((String)"msg", (String)"Nenhum usu\u00e1rio selecionado.");
            return;
        }
        this.tiposDocumentoSelecionados.clear();
        this.usuarioSelecionado.getTiposDocumento().forEach(tipoDocumento -> this.tiposDocumentoSelecionados.add(tipoDocumento.getTipoDocumento()));
    }

    public void salvar() {
        try {
            this.usuarioSelecionado.getTiposDocumento().clear();
            this.usuarioSelecionado.getTiposDocumento().addAll(this.adicionarTiposDocumentoParaUsuario());
            ((FacadeUsuario)SpringContext.getBean(FacadeUsuario.class)).salvarTipoDocUsuarioAlvara(this.usuarioSelecionado);
            ShowMessage.addInfoMessage((String)"msg", (String)String.format("Tipos de Documento vinculados ao usu\u00e1rio %s com sucesso", this.usuarioSelecionado.getUsuario()));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)e.getMessage());
        }
    }

    private Collection<? extends TipoDocumentoUsuarioAlvaraEntity> adicionarTiposDocumentoParaUsuario() {
        ArrayList tiposSelecionados = new ArrayList();
        if (!EloListUtils.safeIsEmpty((List)this.tiposDocumentoSelecionados).booleanValue()) {
            this.tiposDocumentoSelecionados.forEach(tipoSelecionado -> {
                TipoDocumentoUsuarioAlvaraEntity tipoDocumentoUsuario = new TipoDocumentoUsuarioAlvaraEntity();
                tipoDocumentoUsuario.setUsuario(this.usuarioSelecionado);
                tipoDocumentoUsuario.setTipoDocumento(tipoSelecionado);
                tiposSelecionados.add(tipoDocumentoUsuario);
            });
        }
        return tiposSelecionados;
    }

    public boolean contemTipoAdicionadoParaUsuario(TipoDocumentoEntity tipoDocumento) {
        if (this.usuarioSelecionado == null || EloListUtils.safeIsEmpty((List)this.usuarioSelecionado.getTiposDocumento()).booleanValue()) {
            return false;
        }
        return this.usuarioSelecionado.getTiposDocumento().contains(tipoDocumento);
    }

    public void pesquisar() {
        try {
            ArrayList<EloFilter> filtros = new ArrayList<EloFilter>();
            filtros.add(EloFilter.newFrom((String)"modulo", (Object)Modulo.ALVARAONLINE.getCodigo()));
            filtros.add(EloFilter.newFrom((String)"cpf", (Object)this.cpfConsulta.replace(".", "").replace("-", "")));
            filtros.add(EloFilter.newFrom((String)"nome", (Object)this.nomeConsulta));
            filtros.add(EloFilter.newFrom((String)"seletor", (Object)ROLE_VALIDACAODOCUMENTO));
            HashMapEloFilter filter = new HashMapEloFilter(filtros);
            this.usuarios = this.carregarUsuarios(filter);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)e.getMessage());
        }
    }

    private List<UsuarioEntity> carregarUsuarios(HashMapEloFilter filter) throws BaseException {
        return ((FacadeUsuario)SpringContext.getBean(FacadeUsuario.class)).carregarUsuarioPorSeletor(filter);
    }

    public void limpar() {
        try {
            this.cpfConsulta = null;
            this.nomeConsulta = null;
            this.carregarUsuariosAlvara();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)e.getMessage());
        }
    }
}

