/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.SituacaoDocRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.filter.FiltroSituacaoDocumentoPorSituacaoLaudo;
import br.com.elotech.spring.SpringContext;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.springframework.context.annotation.Scope;

@EloController(value="situacaoDocumentoPorSituacaoLaudoRedeSimController")
@Scope(value="flow")
public class SituacaoDocumentoPorSituacaoLaudoRedeSimController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<SituacaoDocRedeSimEntity> situacoesDoc;
    private List<StatusLaudoAlvara> situacoesLaudo;
    private FiltroSituacaoDocumentoPorSituacaoLaudo filtro;

    public List<SituacaoDocRedeSimEntity> getSituacoesDoc() {
        return this.situacoesDoc;
    }

    public void setSituacoesDoc(List<SituacaoDocRedeSimEntity> situacoesDoc) {
        this.situacoesDoc = situacoesDoc;
    }

    public List<StatusLaudoAlvara> getSituacoesLaudo() {
        return this.situacoesLaudo;
    }

    public void setSituacoesLaudo(List<StatusLaudoAlvara> situacoesLaudo) {
        this.situacoesLaudo = situacoesLaudo;
    }

    public FiltroSituacaoDocumentoPorSituacaoLaudo getFiltro() {
        return this.filtro;
    }

    public void setFiltro(FiltroSituacaoDocumentoPorSituacaoLaudo filtro) {
        this.filtro = filtro;
    }

    public void iniciar() {
        try {
            this.filtro = new FiltroSituacaoDocumentoPorSituacaoLaudo();
            this.filtro.setDescricao("");
            this.situacoesLaudo = Arrays.asList(StatusLaudoAlvara.values());
            this.buscarSituacoesDoc();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)e.getMessage());
        }
    }

    public void buscarSituacoesDoc() throws BaseException {
        this.situacoesDoc = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).buscarSituacoesDoc(this.filtro);
    }

    public void salvarSituacaoDoc(SituacaoDocRedeSimEntity situacaoDoc) {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSituacaoDoc(situacaoDoc);
            ShowMessage.addInfoMessage((String)"growl", (String)"Registro alterado com sucesso!");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"growl", (String)e.getMessage());
        }
    }
}

