/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.portalarrecadacao.controller.AlteracaoAtividadesController;
import br.com.elotech.portalarrecadacao.controller.ConsultaCpfCnpjController;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.controller.SolicitacaoAlvaraController;
import br.com.elotech.portalarrecadacao.domain.Cnae;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.interfaces.Atividade;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.springframework.context.annotation.Scope;

@EloController(value="restricoesPerimetroController")
@Scope(value="flow")
public class RestricoesPerimetroController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Atividade> atividades;
    private Cnae selectedAtividade;
    private Boolean possuiRestricoes;
    @Resource
    private ConsultaCpfCnpjController consultaCpfCnpjController;
    @Resource
    private SolicitacaoAlvaraController solicitacaoAlvaraController;
    @Resource
    private AlteracaoAtividadesController alteracaoAtividadeController;

    public Boolean getPossuiRestricoes() {
        return this.possuiRestricoes;
    }

    public void setAlteracaoAtividadeController(AlteracaoAtividadesController alteracaoAtividadeController) {
        this.alteracaoAtividadeController = alteracaoAtividadeController;
    }

    public void setPossuiRestricoes(Boolean possuiRestricoes) {
        this.possuiRestricoes = possuiRestricoes;
    }

    public Cnae getSelectedAtividade() {
        return this.selectedAtividade;
    }

    public void setSelectedAtividade(Cnae selectedAtividade) {
        this.selectedAtividade = selectedAtividade;
    }

    public void setAtividades(List<Atividade> atividades) {
        this.atividades = atividades;
    }

    public List<Atividade> getAtividades() {
        return this.atividades;
    }

    public boolean addAtividades() {
        this.atividades = new ArrayList();
        if (this.alteracaoAtividadeController.getAtividadesComRestricoes() != null) {
            this.atividades.addAll(this.alteracaoAtividadeController.getAtividadesComRestricoes());
        }
        this.possuiRestricoes = !this.atividades.isEmpty() ? Boolean.valueOf(true) : Boolean.valueOf(false);
        return this.possuiRestricoes;
    }

    public void remover() {
        if (this.atividades != null) {
            this.atividades.remove(this.selectedAtividade);
        }
        this.selectedAtividade = null;
    }

    public String voltar() {
        ((EntidadeController)SpringContext.getBean(EntidadeController.class)).setImagemRestricaoPerimetro(null);
        ((AlteracaoAtividadesController)SpringContext.getBean(AlteracaoAtividadesController.class)).setImagemWS(null);
        if (this.consultaCpfCnpjController.isCheckBoxNaturezaInicial() || this.consultaCpfCnpjController.isNaturezaAlteracaoAtividade()) {
            return "toAlteracaoAtividades";
        }
        if (this.consultaCpfCnpjController.isNaturezaMudancaEnd()) {
            return "toConsultaCadastroImobiliario";
        }
        return "toConsultaCpfCnpj";
    }

    public String avancar() {
        ((EntidadeController)SpringContext.getBean(EntidadeController.class)).setImagemRestricaoPerimetro(null);
        ((AlteracaoAtividadesController)SpringContext.getBean(AlteracaoAtividadesController.class)).setImagemWS(null);
        if (this.atividades.size() > 0) {
            FacesContext.getCurrentInstance().addMessage("msg", new FacesMessage(FacesMessage.SEVERITY_WARN, "Aten\u00e7\u00e3o!", "A atividade em quest\u00e3o n\u00e3o atende a Lei Complementar n\u00ba 888/2011, portanto a atividade n\u00e3o \u00e9 permitida."));
            return "";
        }
        boolean naturezaInicial = false;
        boolean naturezaAlteracaoAtividade = false;
        for (NaturezaSolicitacaoAlvaraEntity natureza : this.solicitacaoAlvaraController.getSolicitacaoAlvara().getNaturezas()) {
            if ("IN".equals(natureza.getCodigo())) {
                naturezaInicial = true;
                continue;
            }
            if (!"AA".equals(natureza.getCodigo())) continue;
            naturezaAlteracaoAtividade = true;
        }
        if (naturezaInicial || naturezaAlteracaoAtividade) {
            Integer size = this.solicitacaoAlvaraController.getSolicitacaoAlvara().getSolicitacaoAlvaraAtividades().size();
            if (this.solicitacaoAlvaraController.getSolicitacaoAlvara().getSolicitacaoAlvaraAtividades() == null || size.equals(new Integer(0))) {
                FacesContext.getCurrentInstance().addMessage("msg", new FacesMessage(FacesMessage.SEVERITY_ERROR, "Aten\u00e7\u00e3o!", "Foram exclu\u00eddas todas as atividades da solicita\u00e7\u00e3o, clique no bot\u00e3o Voltar para adicionar pelo menos uma atividade."));
                return "";
            }
        }
        return "toFinalizaConsulta";
    }

    public void removerAtividade(Atividade atividade) {
        ArrayList listaAtividade = new ArrayList();
        listaAtividade.addAll(this.solicitacaoAlvaraController.getSolicitacaoAlvara().getSolicitacaoAlvaraAtividades());
        for (Atividade item : this.atividades) {
            if (listaAtividade == null) continue;
            for (int i = 0; i < listaAtividade.size(); ++i) {
                if (!item.getCodigo().equals(((SolicitacaoAlvaraAtividadeEntity)listaAtividade.get(i)).getCodigoAtividade())) continue;
                listaAtividade.remove(i);
            }
        }
        this.atividades.remove(atividade);
        this.solicitacaoAlvaraController.getSolicitacaoAlvara().setSolicitacaoAlvaraAtividades(new ArrayList());
        this.solicitacaoAlvaraController.getSolicitacaoAlvara().getSolicitacaoAlvaraAtividades().addAll(listaAtividade);
        if (this.atividades.isEmpty()) {
            ((EntidadeController)SpringContext.getBean(EntidadeController.class)).setImagemRestricaoPerimetro(null);
            ((AlteracaoAtividadesController)SpringContext.getBean(AlteracaoAtividadesController.class)).setImagemWS(null);
        }
    }
}

