/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.RestricaoCadastroController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.HistoricoExigenciaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.RestricaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraNumConselhoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoContratoSocialPessoaEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeCadastroImobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeParecerDoLaudo;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.facade.FacadeRestricaoCadastro;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoAlvaraRedeSimDTO;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.AtividadeMeiEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CnaeEntity;
import br.com.elotech.tributacao.domain.aise.ContatoPessoaEntity;
import br.com.elotech.tributacao.domain.aise.EnderecoCadastroGeralEntity;
import br.com.elotech.tributacao.domain.aise.RhCboEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.exceptions.FormatError;
import br.com.elotech.util.string.EloStringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloController(value="requerimentoSolicitacaoAlvaraController")
@Scope(value="flow")
public class RequerimentoSolicitacaoAlvaraController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ContatoPessoaEntity contatoPessoa;
    private EnderecoCadastroGeralEntity enderecoImobiliarioPrincipal;
    private List<Atividade> listaAtividade;
    private List<SolicitacaoAlvaraNumConselhoEntity> listaSolicitacaoNumConselho;
    private StringBuilder informacoesAdicionais;
    private String nomeAtividade;
    private List<SolicitacaoContratoSocialPessoaEntity> listaSocios;
    private CadastroMobiliarioEntity cmcResponsavel;
    private SolicitacaoAlvaraEntity solicitacaoSelecionado;
    private String descRestricaoAlvara;
    private SolicitacaoAlvaraRedeSimDTO arquivoEmpresa;
    private List<HistoricoExigenciaRedeSimEntity> exigenciasSolicitacaoSelecionada;
    @Resource
    private RestricaoCadastroController restricaoCadastroController;
    private String emailCadastroMobiliario;

    public String getEmailCadastroMobiliario() {
        return this.emailCadastroMobiliario;
    }

    public void setEmailCadastroMobiliario(String emailCadastroMobiliario) {
        this.emailCadastroMobiliario = emailCadastroMobiliario;
    }

    public RestricaoCadastroController getRestricaoCadastroController() {
        return this.restricaoCadastroController;
    }

    public String getDescRestricaoAlvara() {
        return this.descRestricaoAlvara;
    }

    public void setDescRestricaoAlvara(String descRestricaoAlvara) {
        this.descRestricaoAlvara = descRestricaoAlvara;
    }

    public void setRestricaoCadastroController(RestricaoCadastroController restricaoCadastroController) {
        this.restricaoCadastroController = restricaoCadastroController;
    }

    public SolicitacaoAlvaraEntity getSolicitacaoSelecionado() {
        return this.solicitacaoSelecionado;
    }

    public void setSolicitacaoSelecionado(SolicitacaoAlvaraEntity solicitacaoSelecionado) {
        this.solicitacaoSelecionado = solicitacaoSelecionado;
    }

    public ContatoPessoaEntity getContatoPessoa() {
        return this.contatoPessoa;
    }

    public void setContatoPessoa(ContatoPessoaEntity contatoPessoa) {
        this.contatoPessoa = contatoPessoa;
    }

    public EnderecoCadastroGeralEntity getEnderecoImobiliarioPrincipal() {
        return this.enderecoImobiliarioPrincipal;
    }

    public void setEnderecoImobiliarioPrincipal(EnderecoCadastroGeralEntity enderecoImobiliarioPrincipal) {
        this.enderecoImobiliarioPrincipal = enderecoImobiliarioPrincipal;
    }

    public List<Atividade> getListaAtividade() {
        return this.listaAtividade;
    }

    public void setListaAtividade(List<Atividade> listaAtividade) {
        this.listaAtividade = listaAtividade;
    }

    public List<SolicitacaoAlvaraNumConselhoEntity> getListaSolicitacaoNumConselho() {
        return this.listaSolicitacaoNumConselho;
    }

    public void setListaSolicitacaoNumConselho(List<SolicitacaoAlvaraNumConselhoEntity> listaSolicitacaoNumConselho) {
        this.listaSolicitacaoNumConselho = listaSolicitacaoNumConselho;
    }

    public StringBuilder getInformacoesAdicionais() {
        return this.informacoesAdicionais;
    }

    public void setInformacoesAdicionais(StringBuilder informacoesAdicionais) {
        this.informacoesAdicionais = informacoesAdicionais;
    }

    public String getNomeAtividade() {
        return this.nomeAtividade;
    }

    public void setNomeAtividade(String nomeAtividade) {
        this.nomeAtividade = nomeAtividade;
    }

    public List<SolicitacaoContratoSocialPessoaEntity> getListaSocios() {
        return this.listaSocios;
    }

    public void setListaSocios(List<SolicitacaoContratoSocialPessoaEntity> listaSocios) {
        this.listaSocios = listaSocios;
    }

    public CadastroMobiliarioEntity getCmcResponsavel() {
        return this.cmcResponsavel;
    }

    public void setCmcResponsavel(CadastroMobiliarioEntity cmcResponsavel) {
        this.cmcResponsavel = cmcResponsavel;
    }

    public SolicitacaoAlvaraRedeSimDTO getArquivoEmpresa() {
        return this.arquivoEmpresa;
    }

    public void setArquivoEmpresa(SolicitacaoAlvaraRedeSimDTO arquivoEmpresa) {
        this.arquivoEmpresa = arquivoEmpresa;
    }

    public List<HistoricoExigenciaRedeSimEntity> getExigenciasSolicitacaoSelecionada() {
        return this.exigenciasSolicitacaoSelecionada;
    }

    public void setExigenciasSolicitacaoSelecionada(List<HistoricoExigenciaRedeSimEntity> exigenciasSolicitacaoSelecionada) {
        this.exigenciasSolicitacaoSelecionada = exigenciasSolicitacaoSelecionada;
    }

    public void verDetalhes(SolicitacaoAlvaraEntity solicitacao, boolean exibeSocios) throws BaseException {
        this.solicitacaoSelecionado = solicitacao;
        this.listaAtividade = new ArrayList();
        this.listaSolicitacaoNumConselho = new ArrayList();
        this.informacoesAdicionais = new StringBuilder();
        this.exigenciasSolicitacaoSelecionada = this.getHistoricoExigenciasSolicitacaoSelecionada(solicitacao);
        for (SolicitacaoAlvaraAtividadeEntity atividade : this.solicitacaoSelecionado.getSolicitacaoAlvaraAtividades()) {
            if (atividade.getCnae() != null) {
                this.nomeAtividade = "CNAE";
                CnaeEntity cnae = new CnaeEntity();
                cnae.setCodigo(atividade.getCnae().getCodigo());
                cnae.setDescricao(atividade.getCnae().getDescricao());
                cnae.setRisco(atividade.getCnae().getGrauRisco());
                cnae.setPrincipal(atividade.getPrincipal());
                this.listaAtividade.add(cnae);
                if ("S".equals(atividade.getSomenteEscritorio())) {
                    this.informacoesAdicionais.append(atividade.getCnae().getDescricao()).append(" - Somente Escrit\u00f3rio; <br/> ");
                }
                if ("S".equals(atividade.getSomenteEscrConcomitanteRes())) {
                    this.informacoesAdicionais.append(atividade.getCnae().getDescricao()).append(" - Somente Escrit\u00f3rio Concomitante a Resid\u00eancia; <br/> ");
                }
                if ("S".equals(atividade.getAtividadeConcomitanteRes())) {
                    this.informacoesAdicionais.append(atividade.getCnae().getDescricao()).append(" - Atividade Concomitante a Resid\u00eancia; <br/> ");
                }
            } else if (atividade.getAtividadeMei() != null) {
                this.nomeAtividade = "Atividade MEI";
                AtividadeMeiEntity mei = new AtividadeMeiEntity();
                mei.setCnae(new CnaeEntity());
                mei.setCodigo(atividade.getAtividadeMei().getCnae().getCodigo());
                mei.setDescricao(atividade.getAtividadeMei().getDescricao());
                mei.setRisco(atividade.getAtividadeMei().getGrauRisco());
                mei.setPrincipal(atividade.getPrincipal());
                this.listaAtividade.add(mei);
            } else if (atividade.getSequenciaCbo() != null) {
                this.nomeAtividade = "CBO";
                RhCboEntity cbo = new RhCboEntity();
                cbo.setCodigo(atividade.getSequenciaCbo().getCodigo());
                cbo.setDescricao(atividade.getSequenciaCbo().getDescricao());
                cbo.setRisco(atividade.getSequenciaCbo().getRisco());
                cbo.setPrincipal(atividade.getPrincipal());
                this.listaAtividade.add(cbo);
            }
            if (atividade.getNumerosConselho() == null) continue;
            this.listaSolicitacaoNumConselho.addAll(atividade.getNumerosConselho());
        }
        if (this.solicitacaoSelecionado.getContratoSocial() != null && exibeSocios) {
            this.listaSocios = new ArrayList();
            try {
                this.listaSocios = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregaListaParticipantesContratoSocial(this.solicitacaoSelecionado);
            }
            catch (BaseException e) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"Ocorreu uma Falha em carregar a lista de participantes do contrato social");
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                return;
            }
        }
        if (this.solicitacaoSelecionado.isSolicitacaoJuridicaNormal()) {
            this.adicionaInformacoesSolicitacaoJuridicaNormal();
        }
        try {
            if (this.solicitacaoSelecionado.getCadastroMobiliario() != null) {
                this.cmcResponsavel = this.carregarCmcResponsavel(this.solicitacaoSelecionado.getCadastroMobiliario().getCmcresponsavel());
            }
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Ocorreu uma Falha em carregar o Cmc Respons\u00e1vel");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        try {
            this.enderecoImobiliarioPrincipal = this.buscaEnderecoPrincipal(this.solicitacaoSelecionado);
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Ocorreu uma falha em carregar o imobili\u00e1rio principal.");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        try {
            if (this.cmcResponsavel != null) {
                this.contatoPessoa = ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).carregarUltimoContatoPessoa(this.cmcResponsavel.getCadastroGeral().getPessoa());
            }
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Ocorreu uma falha em carregar o imobili\u00e1rio principal.");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        try {
            StringBuilder restricaoAlvara = new StringBuilder();
            List listaRestricaoAlvara = ((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).carregaRestricaoPorSolicitacao(this.solicitacaoSelecionado);
            if (listaRestricaoAlvara != null && !listaRestricaoAlvara.isEmpty()) {
                for (RestricaoAlvaraEntity restricaoAlvaraItem : listaRestricaoAlvara) {
                    restricaoAlvara.append(restricaoAlvaraItem.getDescricao()).append("<br />");
                }
            }
            this.descRestricaoAlvara = restricaoAlvara.toString();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private List<HistoricoExigenciaRedeSimEntity> getHistoricoExigenciasSolicitacaoSelecionada(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        SolicitacaoRedeSimEntity solicitacaoRedeSimEntity = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getSolicitacaoRedeSimBySolicitacaoAlvara(solicitacaoAlvara);
        if (Objects.isNull(solicitacaoRedeSimEntity)) {
            return new ArrayList<HistoricoExigenciaRedeSimEntity>();
        }
        return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getHistoricoPorSolicitacaoId(solicitacaoRedeSimEntity.getId());
    }

    public String getTextFromSituacao(String sigla) {
        for (SituacaoConsultaPreviaRedeSimEnum situacao : SituacaoConsultaPreviaRedeSimEnum.values()) {
            if (!situacao.getSigla().equals(sigla)) continue;
            return situacao.getTexto();
        }
        return sigla;
    }

    public Boolean isIntegracaoSimplificadaRedeSim() throws BaseException {
        return SimNaoEnum.equalSim((String)UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.INTEGRADO_REDESIM).getValor());
    }

    private void adicionaInformacoesSolicitacaoJuridicaNormal() {
        BigDecimal areaProcessamento;
        if (SimNaoEnum.SIM.getShortText().equals(this.solicitacaoSelecionado.getRivGasAcima1560k())) {
            this.informacoesAdicionais.append("Comercializa\u00e7\u00e3o de G\u00e1s(GLP) Acima de 1560Kg; <br/> ");
        }
        if (SimNaoEnum.SIM.getShortText().equals(this.solicitacaoSelecionado.getRivNaveAcima500m())) {
            this.informacoesAdicionais.append("Igreja / Templo(Local de realiza\u00e7\u00e3o dos cultos com \u00e1rea superior a 500m\u00b2; <br/> ");
        }
        if ((areaProcessamento = this.solicitacaoSelecionado.getAreaProcessamento()) != null) {
            this.informacoesAdicionais.append("\u00c1rea de Processamento/Armazenamento:").append(areaProcessamento.toString()).append("m\u00b2 <br/>");
        }
    }

    private EnderecoCadastroGeralEntity buscaEnderecoPrincipal(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (solicitacao.getCadastroImobiliario() != null) {
            return ((FacadeCadastroImobiliario)SpringContext.getBean(FacadeCadastroImobiliario.class)).getBuscaEnderecoImobiliarioPrincipal(solicitacao.getCadastroImobiliario().getCadastroGeral().getId().getCodigo());
        }
        if (solicitacao.getCadastroMobiliario() != null) {
            return ((FacadeCadastroImobiliario)SpringContext.getBean(FacadeCadastroImobiliario.class)).getBuscaEnderecoImobiliarioPrincipal(solicitacao.getCadastroMobiliario().getCadastroGeral().getId().getCodigo());
        }
        return null;
    }

    public CadastroMobiliarioEntity carregarCmcResponsavel(Long cadastroGeral) throws BaseException {
        if (cadastroGeral != null && cadastroGeral != 0L) {
            return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregaCadastroMobiliarioByCadastroGeral(cadastroGeral);
        }
        return null;
    }

    public String formatCpfCnpj(String cpfCnpj) {
        try {
            return EloStringUtils.formatCpfCnpjReport((String)cpfCnpj);
        }
        catch (FormatError e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String formatFone(String fone) {
        try {
            return EloStringUtils.formatFone((String)fone);
        }
        catch (FormatError e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String formataData(Date data) {
        String dataFormatada = data != null ? EloDateUtils.toAnsiDateString((Date)data, (String)"dd/MM/yyyy") : "";
        return dataFormatada;
    }
}

