/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.controller.ReciboConsultaPreviaController;
import br.com.elotech.portalarrecadacao.controller.RequerimentoSolicitacaoAlvaraController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroRelatorioSolicitacoesVo;
import br.com.elotech.portalarrecadacao.domain.vo.SolicitacaoAlvaraVo;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeAlteracaoAtividades;
import br.com.elotech.portalarrecadacao.facade.FacadeCadastroMobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeRelatorios;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.impl.SrvValidaCpfImpl;
import br.com.elotech.report.DataSet;
import br.com.elotech.report.Parameter;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.LogradouroEntity;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.exceptions.FormatError;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.primefaces.model.DefaultStreamedContent;
import org.primefaces.model.StreamedContent;
import org.springframework.context.annotation.Scope;

@EloController(value="relatorioSolicitacoesController")
@Scope(value="flow")
public class RelatorioSolicitacoesController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 7809900820490092087L;
    private List<TipoInscricaoAlvaraEntity> listaTipoInscricao;
    private List<SolicitacaoAlvaraEntity> listaSolicitacoes;
    private FiltroRelatorioSolicitacoesVo filtro;
    @Resource
    private RequerimentoSolicitacaoAlvaraController requerimentoSolicitacaoAlvaraController;
    @Resource
    private EntidadeController entidadeController;
    @Resource
    private ReciboConsultaPreviaController reciboConsultaPreviaController;
    private byte[] relatorio;
    private StringBuilder filtrosUsados;

    public List<TipoInscricaoAlvaraEntity> getListaTipoInscricao() {
        return this.listaTipoInscricao;
    }

    public FiltroRelatorioSolicitacoesVo getFiltro() {
        return this.filtro;
    }

    public void setFiltro(FiltroRelatorioSolicitacoesVo filtro) {
        this.filtro = filtro;
    }

    public List<SolicitacaoAlvaraEntity> getListaSolicitacoes() {
        return this.listaSolicitacoes;
    }

    public void iniciar() throws BaseException {
        this.filtro = new FiltroRelatorioSolicitacoesVo();
        this.filtro.setConsultaPrevia(true);
        this.listaTipoInscricao = this.getTipoInscricaoAlvara();
        if (!EloListUtils.safeIsEmpty((List)this.listaTipoInscricao).booleanValue()) {
            this.filtro.setTipoInscricao((TipoInscricaoAlvaraEntity)this.listaTipoInscricao.get(0));
        }
    }

    public List<TipoInscricaoAlvaraEntity> getTipoInscricaoAlvara() throws BaseException {
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregarMenusTipoInscricao();
    }

    public void filtrar() throws BaseException {
        if (this.validaCampos()) {
            this.listaSolicitacoes = this.carregarSolicitacoes(this.filtro);
            if (EloListUtils.safeIsEmpty((List)this.listaSolicitacoes).booleanValue()) {
                ShowMessage.addInfoMessage((String)"validacao", (String)"Nenhum registro encontrado!");
            }
        }
    }

    private List<SolicitacaoAlvaraEntity> carregarSolicitacoes(FiltroRelatorioSolicitacoesVo filtro) throws BaseException {
        this.iniciarListaSolicitacoes();
        return ((FacadeRelatorios)SpringContext.getBean(FacadeRelatorios.class)).carregarListaSolicitacoes(filtro);
    }

    public String formatCpfCnpj(String cpfCnpj) throws FormatError {
        if (EloStringUtils.isEmpty((String)cpfCnpj)) {
            return cpfCnpj;
        }
        return EloStringUtils.formatCpfCnpj((String)cpfCnpj);
    }

    public List<LogradouroEntity> completeLogradouro(String query) {
        List enderecos = null;
        try {
            Long codigoCidade = ((EntidadeController)SpringContext.getBean(EntidadeController.class)).getEntidade().getLogradouro().getId().getCidade().getId();
            enderecos = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregaListaLogradouroPorCidade(codigoCidade, query);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return enderecos;
    }

    public List<Atividade> completeAtividade(String query) {
        ArrayList<Atividade> atividades = new ArrayList<Atividade>();
        if (this.filtro.getTipoInscricao() != null) {
            try {
                if (this.filtro.getTipoInscricao().getSigla().equals("C")) {
                    List cbos = ((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).carregaListaAtividadesCboPorDescricao(query);
                    atividades.addAll(cbos);
                } else if (this.filtro.getTipoInscricao().getSigla().equals("M") || this.filtro.getTipoInscricao().getSigla().equals("MP")) {
                    List listaMei = ((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).carregarListaMeiPorDescricao(query, "N");
                    atividades.addAll(listaMei);
                } else if (this.filtro.getTipoInscricao().getSigla().equals("N") || this.filtro.getTipoInscricao().getSigla().equals("P")) {
                    List cnaes = ((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).carregarListaCnaePorDescricao(query);
                    atividades.addAll(cnaes);
                }
            }
            catch (BaseException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return atividades;
    }

    public void limpar() {
        this.filtro.setNumeroSolicitacao("");
        this.filtro.setCpfCnpjResponsavel("");
        this.filtro.setCpfCnpjMobiliario("");
        this.filtro.setCadastroImobiliario("");
        this.filtro.setPeriodoInicial(null);
        this.filtro.setPeriodoFinal(null);
        this.filtro.setCodigoAtividade("");
        this.filtro.setAtividadeSelecionada(null);
        this.filtro.setCodigoEndereco("");
        this.filtro.setEndereco(null);
        this.filtro.setZona("");
        this.filtro.setQuadra("");
        this.filtro.setLote("");
        this.iniciarListaSolicitacoes();
    }

    public void iniciarListaSolicitacoes() {
        if (this.listaSolicitacoes == null) {
            this.listaSolicitacoes = new ArrayList();
        } else {
            this.listaSolicitacoes.clear();
        }
    }

    public boolean validaCampos() {
        int quantidadeDias;
        if (!this.temFiltroPreenchido()) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Informe ao menos um filtro, para minimizar o tempo da consulta.");
            return false;
        }
        boolean valido = true;
        if (!this.validarNumeroSolicitacao()) {
            valido = false;
        }
        if (!this.validarCpfCnpj(this.filtro.getCpfCnpjResponsavel())) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"CPF/CNPJ do Respons\u00e1vel \u00e9 inv\u00e1lido.");
            valido = false;
        }
        if (!this.validarCpfCnpj(this.filtro.getCpfCnpjMobiliario())) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"CPF/CNPJ do Mobili\u00e1rio \u00e9 inv\u00e1lido.");
            valido = false;
        }
        if (this.filtro.getPeriodoInicial() == null && this.filtro.getPeriodoFinal() != null) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Informe a data inicial.");
            valido = false;
        }
        if (this.filtro.getPeriodoInicial() != null && this.filtro.getPeriodoFinal() != null && (quantidadeDias = EloDateUtils.daysBetween((Date)this.filtro.getPeriodoInicial(), (Date)this.filtro.getPeriodoFinal())) < 0) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"A data final n\u00e3o pode ser anterior \u00e0 data inicial.");
            valido = false;
        }
        return valido;
    }

    private boolean temFiltroPreenchido() {
        String juncao;
        boolean temFiltro = false;
        this.filtrosUsados = new StringBuilder("Filtros: ");
        String tipoAtividade = this.recuperarTipoAtividade();
        this.filtrosUsados.append(this.filtro.isConsultaPrevia() ? "Consulta Pr\u00e9via para" : "Solicita\u00e7\u00e3o para").append(" ");
        this.filtrosUsados.append("Tipo de Inscri\u00e7\u00e3o = ").append(this.filtro.getTipoInscricao().getDescricao()).append(" ");
        if (!EloStringUtils.isEmpty((String)this.filtro.getNumeroSolicitacao())) {
            temFiltro = true;
            this.filtrosUsados.append("N\u00b0 da Solicita\u00e7\u00e3o = ").append(this.filtro.getNumeroSolicitacao()).append(" ");
        }
        if (!EloStringUtils.isEmpty((String)this.filtro.getCpfCnpjResponsavel())) {
            temFiltro = true;
            this.filtrosUsados.append("CPF/CNPJ do Respons\u00e1vel = ").append(this.filtro.getCpfCnpjResponsavel()).append(" ");
        }
        if (!EloStringUtils.isEmpty((String)this.filtro.getCpfCnpjMobiliario())) {
            temFiltro = true;
            this.filtrosUsados.append("CPF/CNPJ do Mobili\u00e1rio = ").append(this.filtro.getCpfCnpjMobiliario()).append(" ");
        }
        if (!EloStringUtils.isEmpty((String)this.filtro.getCadastroImobiliario())) {
            temFiltro = true;
            this.filtrosUsados.append("Cadastro Imobili\u00e1rio = ").append(this.filtro.getCadastroImobiliario()).append(" ");
        }
        if (this.filtro.getPeriodoInicial() != null) {
            temFiltro = true;
            this.filtrosUsados.append("Per\u00edodo Inicial = ").append(EloDateUtils.toAnsiDateString((Date)this.filtro.getPeriodoInicial(), (String)"dd/MM/yyyy")).append(" ");
        }
        if (this.filtro.getPeriodoFinal() != null) {
            temFiltro = true;
            this.filtrosUsados.append("Per\u00edodo Final = ").append(EloDateUtils.toAnsiDateString((Date)this.filtro.getPeriodoFinal(), (String)"dd/MM/yyyy")).append(" ");
        }
        if (!EloStringUtils.isEmpty((String)this.filtro.getCodigoAtividade()) || this.filtro.getAtividadeSelecionada() != null) {
            temFiltro = true;
            juncao = "";
            this.filtrosUsados.append(tipoAtividade + " = ");
            if (!EloStringUtils.isEmpty((String)this.filtro.getCodigoAtividade())) {
                this.filtrosUsados.append(this.filtro.getCodigoAtividade());
                juncao = " - ";
            }
            if (this.filtro.getAtividadeSelecionada() != null) {
                this.filtrosUsados.append(juncao).append(this.filtro.getAtividadeSelecionada().getDescricao());
            }
            this.filtrosUsados.append(" ");
        }
        if (!EloStringUtils.isEmpty((String)this.filtro.getCodigoEndereco()) || this.filtro.getEndereco() != null) {
            temFiltro = true;
            juncao = "";
            this.filtrosUsados.append("Endere\u00e7o = ");
            if (!EloStringUtils.isEmpty((String)this.filtro.getCodigoEndereco())) {
                this.filtrosUsados.append(this.filtro.getCodigoEndereco());
                juncao = " - ";
            }
            if (this.filtro.getEndereco() != null) {
                this.filtrosUsados.append(juncao).append(this.filtro.getEndereco().getTipoDescricao());
            }
            this.filtrosUsados.append(" ");
        }
        if (!EloStringUtils.isEmpty((String)this.filtro.getZona())) {
            temFiltro = true;
            this.filtrosUsados.append("Zona = ").append(this.filtro.getZona()).append(" ");
        }
        if (!EloStringUtils.isEmpty((String)this.filtro.getQuadra())) {
            temFiltro = true;
            this.filtrosUsados.append("Quadra = ").append(this.filtro.getQuadra()).append(" ");
        }
        if (!EloStringUtils.isEmpty((String)this.filtro.getLote())) {
            temFiltro = true;
            this.filtrosUsados.append("Lote = ").append(this.filtro.getLote()).append(" ");
        }
        if (!EloStringUtils.isEmpty((String)this.filtro.getProtocoloRedeSim())) {
            temFiltro = true;
            this.filtrosUsados.append("Protocolo RedeSim = ").append(this.filtro.getProtocoloRedeSim()).append(" ");
        }
        return temFiltro;
    }

    private boolean validarCpfCnpj(String cpfCnpj) {
        return EloStringUtils.isEmpty((String)cpfCnpj) || !(cpfCnpj.length() > 11 ? !SrvValidaCpfImpl.isValidCNPJ((String)cpfCnpj) : !SrvValidaCpfImpl.isValidCPF((String)cpfCnpj));
    }

    private boolean validarNumeroSolicitacao() {
        block3: {
            try {
                if (EloStringUtils.isEmpty((String)this.filtro.getNumeroSolicitacao())) break block3;
                String[] consulta = this.filtro.getNumeroSolicitacao().split("/");
                if (consulta.length == 2) {
                    Long.valueOf(consulta[0]);
                    Long.valueOf(consulta[1]);
                    break block3;
                }
                throw new Exception();
            }
            catch (Exception e) {
                ShowMessage.addWarnMessage((String)"validacao", (String)("Verifique o n\u00famero da " + (this.filtro.isConsultaPrevia() ? "Consulta Pr\u00e9via." : "Solicita\u00e7\u00e3o.") + " O n\u00famero deve estar no formato 'n\u00famero/ano'. Exemplo: 10/2015"));
                return false;
            }
        }
        return true;
    }

    public String recuperarTipoAtividade() {
        if (this.filtro.getTipoInscricao().getSigla().equals("N") || this.filtro.getTipoInscricao().getSigla().equals("P")) {
            return "CNAE";
        }
        if (this.filtro.getTipoInscricao().getSigla().equals("C")) {
            return "CBO";
        }
        if (this.filtro.getTipoInscricao().getSigla().equals("M") || this.filtro.getTipoInscricao().getSigla().equals("MP")) {
            return "MEI";
        }
        return "";
    }

    public void verDetalhes(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        this.requerimentoSolicitacaoAlvaraController.verDetalhes(solicitacao, true);
    }

    public void verDetalhesConsultaPrevia(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        this.reciboConsultaPreviaController.getSolicitacaoAlvaraController().setSolicitacaoAlvara(solicitacao);
        this.reciboConsultaPreviaController.getTramites(solicitacao);
        try {
            this.reciboConsultaPreviaController.gerarRecibo();
            this.reciboConsultaPreviaController.montarRestricaoConsultaPrevia(solicitacao);
            this.reciboConsultaPreviaController.montarObservacaoGeral();
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Falha ao gerar o recibo da consulta pr\u00e9via");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void imprimirRelatorio() throws Exception {
        try {
            DataSet dataSet = new DataSet(SolicitacaoAlvaraVo.class);
            HashMap<String, Parameter> params = new HashMap<String, Parameter>();
            String relatorioJasper = "RelatorioSolicitacoesAlvara.jasper";
            ByteArrayInputStream inputStreamBrasao = new ByteArrayInputStream(this.entidadeController.getEntidade().getBrasao());
            params.put("brasao", new Parameter((Object)inputStreamBrasao));
            params.put("entidade", new Parameter((Object)this.entidadeController.getEntidade().getNome()));
            params.put("filtros", new Parameter((Object)this.filtrosUsados.toString()));
            params.put("nome_secretaria", new Parameter((Object)UtilsController.getNomeSecretaria()));
            this.montarDataSetSolicitacaoAlvara(dataSet);
            this.relatorio = ((FacadeRelatorios)SpringContext.getBean(FacadeRelatorios.class)).imprimeRelatorio(relatorioJasper, dataSet, null, params);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Falha ao imprimir o relat\u00f3rio.");
        }
    }

    private void montarDataSetSolicitacaoAlvara(DataSet dataSet) throws BaseException {
        for (SolicitacaoAlvaraEntity solicitacao : this.listaSolicitacoes) {
            SolicitacaoAlvaraVo vo = new SolicitacaoAlvaraVo();
            vo.setNumeroSolicitacao(solicitacao.getNumeroSolicitacao() + "/" + solicitacao.getExercicio());
            vo.setExercicio(solicitacao.getExercicio());
            vo.setCpfCnpj(solicitacao.getCpfCnpj() != null ? this.formatCpfCnpj(solicitacao.getCpfCnpj()) : "");
            vo.setCpfCnpjResponsavel(this.formatCpfCnpj(solicitacao.getCpfCnpjConsulta()));
            if (solicitacao.getCadastroMobiliario() != null) {
                vo.setCadastroMobiliario(solicitacao.getCadastroMobiliario().getId().getCodigo().toString());
            } else {
                vo.setCadastroMobiliario("");
            }
            vo.setCadastroImobiliario(solicitacao.getCadastroImobiliario().getId().getCodigo().toString());
            vo.setNomeRazaoSocial(solicitacao.getNomeRazaoSocial());
            if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE})) {
                vo.setDescricaoAtividade(solicitacao.getCadastroMobiliario() != null ? solicitacao.getCadastroMobiliario().getAtividadePrincipal() : "");
            } else {
                vo.setDescricaoAtividade(solicitacao.getDescricaoAtividades());
            }
            vo.setEndereco(solicitacao.montarEnderecoCorretoDaSolicitacao());
            vo.setComplemento(solicitacao.montarComplementoMobiliarioEImobiliario());
            vo.setBairro(solicitacao.getCadastroImobiliario().getCadastroGeral().getBairro().getDescricao());
            vo.setCidade(solicitacao.getCadastroImobiliario().getCadastroGeral().getLogradouro().getId().getCidade().getDescricao() + " - " + solicitacao.getCadastroImobiliario().getCadastroGeral().getLogradouro().getId().getCidade().getUnidadeFederacao().getId().getUnidadeFederacao());
            vo.setNaturezas(this.getNaturezas(solicitacao));
            vo.setZona(solicitacao.getCadastroImobiliario().getSetorDescr());
            vo.setQuadra(solicitacao.getCadastroImobiliario().getQuadraDescr());
            vo.setLote(solicitacao.getCadastroImobiliario().getLoteDescr());
            vo.setAtividades(this.getAtividades(solicitacao));
            dataSet.add((Object)vo);
        }
    }

    private String getAtividades(SolicitacaoAlvaraEntity solicitacao) {
        StringBuilder sb = new StringBuilder();
        if (!EloListUtils.safeIsEmpty((List)solicitacao.getSolicitacaoAlvaraAtividades()).booleanValue()) {
            for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
                sb.append(" - ");
                if (atividade.getSequenciaCbo() != null) {
                    sb.append(atividade.getSequenciaCbo().getDescricao());
                } else if (atividade.getAtividadeMei() != null) {
                    sb.append(atividade.getAtividadeMei().getDescricao());
                } else {
                    sb.append(atividade.getCnae().getDescricao());
                }
                sb.append("S".equals(atividade.getPrincipal()) ? " - Principal" : "");
                sb.append(";\n");
            }
            sb = sb.delete(sb.toString().length() - 1, sb.toString().length());
        }
        return sb.toString();
    }

    private String getNaturezas(SolicitacaoAlvaraEntity solicitacao) {
        StringBuilder sb = new StringBuilder();
        if (!EloListUtils.safeIsEmpty((List)solicitacao.getNaturezas()).booleanValue()) {
            for (NaturezaSolicitacaoAlvaraEntity natureza : solicitacao.getNaturezas()) {
                sb.append(natureza.getDescricao());
                sb.append("; ");
            }
            sb = sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    public StreamedContent downloadRelatorio() {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.relatorio);
        String nomeRelatorio = this.filtro.isConsultaPrevia() ? "RELATORIO_CONSULTA_PREVIA_" + EloDateUtils.toAnsiDateString((Date)new Date()) : "RELATORIO_SOLICITACAO_" + EloDateUtils.toAnsiDateString((Date)new Date());
        return new DefaultStreamedContent((InputStream)stream, "application/pdf", nomeRelatorio + ".pdf");
    }

    public void alterouConsultaPreviaSolicitacao() {
        this.filtro.setConcluidas(null);
        this.filtro.setDocumentosEmitidos(null);
    }

    public void alterouConcluidas() {
        this.filtro.setDocumentosEmitidos(null);
    }
}

