/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoDispensaAmbientalEntity;
import br.com.elotech.portalarrecadacao.domain.vod.DispensaAmbientalVO;
import br.com.elotech.portalarrecadacao.enumerator.TipoPesquisaDispensaAmbientalEnum;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeRelatorios;
import br.com.elotech.spring.SpringContext;
import java.io.Serializable;
import java.util.List;
import org.springframework.context.annotation.Scope;

@Scope(value="flow")
@EloController(value="relatorioDispensa")
public class RelatorioSolicitacaoDispensaLicencaAmbientalController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = -1629646498896517779L;
    private List<SolicitacaoDispensaAmbientalEntity> solicitacoesDispensa;
    private List<DispensaAmbientalVO> solicitacoesQuePodemSolicitarDispensa;
    private TipoPesquisaDispensaAmbientalEnum tipoPesquisa;

    public List<SolicitacaoDispensaAmbientalEntity> getSolicitacoesDispensa() {
        return this.solicitacoesDispensa;
    }

    public void setSolicitacoesDispensa(List<SolicitacaoDispensaAmbientalEntity> solicitacoesDispensa) {
        this.solicitacoesDispensa = solicitacoesDispensa;
    }

    public List<DispensaAmbientalVO> getSolicitacoesQuePodemSolicitarDispensa() {
        return this.solicitacoesQuePodemSolicitarDispensa;
    }

    public void setSolicitacoesQuePodemSolicitarDispensa(List<DispensaAmbientalVO> solicitacoesQuePodemSolicitarDispensa) {
        this.solicitacoesQuePodemSolicitarDispensa = solicitacoesQuePodemSolicitarDispensa;
    }

    public TipoPesquisaDispensaAmbientalEnum getTipoPesquisa() {
        return this.tipoPesquisa;
    }

    public void setTipoPesquisa(TipoPesquisaDispensaAmbientalEnum tipoPesquisa) {
        this.tipoPesquisa = tipoPesquisa;
    }

    public void iniciar() {
        try {
            this.tipoPesquisa = TipoPesquisaDispensaAmbientalEnum.TODAS;
            this.carregarSolicitacoesDispensa();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)"Desculpe. Ocorreu um erro inesperado ao tentar carregar as informa\u00e7\u00f5es.");
        }
    }

    public void carregarSolicitacoesDispensa() throws BaseException {
        this.solicitacoesQuePodemSolicitarDispensa = ((FacadeRelatorios)SpringContext.getBean(FacadeRelatorios.class)).carregarSolicitacoesQuePodemSolicitarDispensaAmbiental(this.tipoPesquisa);
    }

    public TipoPesquisaDispensaAmbientalEnum[] getTiposPesquisa() {
        return TipoPesquisaDispensaAmbientalEnum.values();
    }
}

