/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroRelatorioLaudoVo;
import br.com.elotech.portalarrecadacao.domain.vo.LaudoAlvaraVo;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeParecerDoLaudo;
import br.com.elotech.portalarrecadacao.facade.FacadeRelatorios;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.report.DataSet;
import br.com.elotech.report.Parameter;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import br.com.elotech.tributacao.enumerator.TipoLaudoEnum;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.primefaces.model.DefaultStreamedContent;
import org.primefaces.model.StreamedContent;
import org.springframework.context.annotation.Scope;

@EloController(value="relatorioLaudosVencidosController")
@Scope(value="flow")
public class RelatorioLaudosVencidosController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 5092036628926259093L;
    @Resource
    private EntidadeController entidadeController;
    private List<LaudoAlvaraEntity> listaLaudos;
    private FiltroRelatorioLaudoVo filtro;
    private byte[] relatorio;
    private StringBuilder filtrosUsados;
    private List<TipoInscricaoAlvaraEntity> tiposInscricao;
    private List<TipoLaudoEntity> tiposLaudo;

    public List<LaudoAlvaraEntity> getListaLaudos() {
        return this.listaLaudos;
    }

    public FiltroRelatorioLaudoVo getFiltro() {
        return this.filtro;
    }

    public void setFiltro(FiltroRelatorioLaudoVo filtro) {
        this.filtro = filtro;
    }

    public List<TipoInscricaoAlvaraEntity> getTiposInscricao() {
        return this.tiposInscricao;
    }

    public void setTiposInscricao(List<TipoInscricaoAlvaraEntity> tiposInscricao) {
        this.tiposInscricao = tiposInscricao;
    }

    public List<TipoLaudoEntity> getTiposLaudo() {
        return this.tiposLaudo;
    }

    public void setTiposLaudo(List<TipoLaudoEntity> tiposLaudo) {
        this.tiposLaudo = tiposLaudo;
    }

    public void iniciar() throws BaseException {
        this.filtro = new FiltroRelatorioLaudoVo();
        this.filtro.setValidadeFinal(new Date());
        this.carregarTiposInscricao();
        this.carregarTiposLaudo();
    }

    private void carregarTiposLaudo() throws BaseException {
        this.tiposLaudo = ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).getListaTipoLaudo();
    }

    private void carregarTiposInscricao() throws BaseException {
        this.tiposInscricao = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregarMenusTipoInscricao();
    }

    public void filtrar() {
        try {
            this.iniciarListaLaudos();
            this.listaLaudos = this.carregarListaLaudos(this.filtro);
            if (EloListUtils.safeIsEmpty((List)this.listaLaudos).booleanValue()) {
                ShowMessage.addInfoMessage((String)"validacao", (String)"Nenhum registro encontrado!");
            }
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)String.format("Ocorreu uma Falha ao Filtrar os Laudos! %s", e.getMessage()));
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private List<LaudoAlvaraEntity> carregarListaLaudos(FiltroRelatorioLaudoVo filtro) throws BaseException {
        return ((FacadeRelatorios)SpringContext.getBean(FacadeRelatorios.class)).carregarLaudosVencidos(filtro);
    }

    public void limpar() {
        this.filtro.limpar();
        this.iniciarListaLaudos();
    }

    public void iniciarListaLaudos() {
        if (this.listaLaudos == null) {
            this.listaLaudos = new ArrayList();
        } else {
            this.listaLaudos.clear();
        }
    }

    public List<TipoLaudoEnum> listaTipoLaudo() {
        return Arrays.asList(TipoLaudoEnum.values());
    }

    public void imprimirRelatorio() throws Exception {
        try {
            this.montarFiltrosUsados();
            DataSet dataSet = new DataSet(LaudoAlvaraVo.class);
            HashMap<String, Parameter> params = new HashMap<String, Parameter>();
            String relatorioJasper = "RelatorioLaudos.jasper";
            ByteArrayInputStream inputStreamBrasao = new ByteArrayInputStream(this.entidadeController.getEntidade().getBrasao());
            params.put("brasao", new Parameter((Object)inputStreamBrasao));
            params.put("entidade", new Parameter((Object)this.entidadeController.getEntidade().getNome()));
            params.put("filtros", new Parameter((Object)this.filtrosUsados.toString()));
            params.put("nome_secretaria", new Parameter((Object)UtilsController.getNomeSecretaria()));
            this.montarDataSetLaudo(dataSet);
            this.relatorio = ((FacadeRelatorios)SpringContext.getBean(FacadeRelatorios.class)).imprimeRelatorio(relatorioJasper, dataSet, null, params);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Falha ao imprimir o relat\u00f3rio.");
        }
    }

    private void montarDataSetLaudo(DataSet dataSet) {
        for (LaudoAlvaraEntity laudo : this.listaLaudos) {
            LaudoAlvaraVo vo = new LaudoAlvaraVo();
            vo.setNumeroSolicitacao(laudo.getIdSolicitacaoAlvara().getNumeroSolicitacao() + "/" + laudo.getIdSolicitacaoAlvara().getExercicio());
            vo.setDataValidade(laudo.getDataValidade());
            vo.setSituacaoLaudo(laudo.getStatus().descricaoCapitalize());
            vo.setTipoLaudo(laudo.getTipoLaudo().getDescricao());
            vo.setVistoriar("S".equals(laudo.getVistoriar()) ? "Sim" : "N\u00e3o");
            dataSet.add((Object)vo);
        }
    }

    public StreamedContent downloadRelatorio() {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.relatorio);
        String nomeRelatorio = "RELATORIO_LAUDO_" + EloDateUtils.toAnsiDateString((Date)new Date(), (String)"dd-MM-yyyy");
        return new DefaultStreamedContent((InputStream)stream, "application/pdf", nomeRelatorio + ".pdf");
    }

    private void montarFiltrosUsados() {
        this.filtrosUsados = new StringBuilder("Filtros: ");
        if (this.filtro.getSituacaoLaudo() != null) {
            this.filtrosUsados.append("Situa\u00e7\u00e3o do Laudo = ").append(this.filtro.getSituacaoLaudo().descricaoCapitalize()).append(" ");
        }
        if (this.filtro.getTipoLaudo() != null) {
            this.filtrosUsados.append("Tipo do Laudo = ").append(this.filtro.getTipoLaudo().getNome()).append(" ");
        }
        if (!EloStringUtils.isEmpty((String)this.filtro.getNumeroSolicitacao())) {
            this.filtrosUsados.append("N\u00b0 da Solicita\u00e7\u00e3o = ").append(this.filtro.getNumeroSolicitacao()).append(" ");
        }
        if (this.filtro.getPeriodoInicial() != null) {
            this.filtrosUsados.append("Per\u00edodo Inicial = ").append(EloDateUtils.toAnsiDateString((Date)this.filtro.getPeriodoInicial(), (String)"dd/MM/yyyy")).append(" ");
        }
        if (this.filtro.getPeriodoFinal() != null) {
            this.filtrosUsados.append("Per\u00edodo Final = ").append(EloDateUtils.toAnsiDateString((Date)this.filtro.getPeriodoFinal(), (String)"dd/MM/yyyy")).append(" ");
        }
        if (this.filtro.getValidadeInicial() != null) {
            this.filtrosUsados.append("Per\u00edodo Inicial = ").append(EloDateUtils.toAnsiDateString((Date)this.filtro.getValidadeInicial(), (String)"dd/MM/yyyy")).append(" ");
        }
        if (this.filtro.getValidadeFinal() != null) {
            this.filtrosUsados.append("Per\u00edodo Final = ").append(EloDateUtils.toAnsiDateString((Date)this.filtro.getValidadeFinal(), (String)"dd/MM/yyyy")).append(" ");
        }
    }
}

