/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.AndamentoLaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroRelatorioLaudoVo;
import br.com.elotech.portalarrecadacao.domain.vo.LaudoAlvaraVo;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeParecerDoLaudo;
import br.com.elotech.portalarrecadacao.facade.FacadeRelatorios;
import br.com.elotech.report.DataSet;
import br.com.elotech.report.Parameter;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.enumerator.TipoLaudoEnum;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.primefaces.model.DefaultStreamedContent;
import org.primefaces.model.StreamedContent;
import org.springframework.context.annotation.Scope;

@EloController(value="relatorioLaudoController")
@Scope(value="flow")
public class RelatorioLaudoController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 7809900820490092087L;
    @Resource
    private EntidadeController entidadeController;
    private List<LaudoAlvaraEntity> listaLaudos;
    private List<AndamentoLaudoAlvaraEntity> andamentos = new ArrayList();
    private FiltroRelatorioLaudoVo filtro;
    private byte[] relatorio;
    private StringBuilder filtrosUsados;
    private final int DIAS_MAXIMO_PERIODO = 60;
    private LaudoAlvaraEntity laudoSelecionado;

    public List<LaudoAlvaraEntity> getListaLaudos() {
        return this.listaLaudos;
    }

    public FiltroRelatorioLaudoVo getFiltro() {
        return this.filtro;
    }

    public void setFiltro(FiltroRelatorioLaudoVo filtro) {
        this.filtro = filtro;
    }

    public void iniciar() throws BaseException {
        this.filtro = new FiltroRelatorioLaudoVo();
    }

    public List<AndamentoLaudoAlvaraEntity> getAndamentos() {
        return this.andamentos;
    }

    public LaudoAlvaraEntity getLaudoSelecionado() {
        return this.laudoSelecionado;
    }

    public void filtrar() throws BaseException {
        this.iniciarListaLaudos();
        if (this.validarCampos()) {
            this.listaLaudos = this.carregarListaLaudos(this.filtro);
            if (EloListUtils.safeIsEmpty((List)this.listaLaudos).booleanValue()) {
                ShowMessage.addInfoMessage((String)"validacao", (String)"Nenhum registro encontrado!");
            }
        }
    }

    private List<LaudoAlvaraEntity> carregarListaLaudos(FiltroRelatorioLaudoVo filtro) throws BaseException {
        return ((FacadeRelatorios)SpringContext.getBean(FacadeRelatorios.class)).carregarListaLaudos(filtro);
    }

    public void limpar() {
        this.filtro.setNumeroSolicitacao("");
        this.filtro.setSituacaoLaudo(null);
        this.filtro.setTipoLaudo(null);
        this.filtro.setPeriodoInicial(null);
        this.filtro.setPeriodoFinal(null);
        this.filtro.setValidadeInicial(null);
        this.filtro.setValidadeFinal(null);
        this.iniciarListaLaudos();
    }

    public void iniciarListaLaudos() {
        if (this.listaLaudos == null) {
            this.listaLaudos = new ArrayList();
        } else {
            this.listaLaudos.clear();
        }
    }

    public List<StatusLaudoAlvara> listaSituacoesLaudo() {
        return Arrays.asList(StatusLaudoAlvara.values());
    }

    public List<TipoLaudoEnum> listaTipoLaudo() {
        return Arrays.asList(TipoLaudoEnum.values());
    }

    public boolean validarCampos() {
        boolean valido = true;
        if (!UtilsController.isNumeroSolicitacaoValido((String)this.filtro.getNumeroSolicitacao()).booleanValue()) {
            valido = false;
        }
        if (EloStringUtils.isEmpty((String)this.filtro.getNumeroSolicitacao()) && !this.isPeriodoInformado() && !this.isValidadeInformada() && EloStringUtils.isEmpty((String)this.filtro.getProtocoloRedeSim())) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"\u00c9 necess\u00e1rio informar uma data para consultar.");
            valido = false;
        } else {
            if (this.isPeriodoInformado()) {
                valido = this.isPeriodoEntreDatasValido(this.filtro.getPeriodoInicial(), this.filtro.getPeriodoFinal());
            }
            if (valido && this.isValidadeInformada()) {
                valido = this.isPeriodoEntreDatasValido(this.filtro.getValidadeInicial(), this.filtro.getValidadeFinal());
            }
        }
        return valido;
    }

    public boolean isPeriodoEntreDatasValido(Date dataInicial, Date dataFinal) {
        int quantidadeDias = EloDateUtils.daysBetween((Date)dataInicial, (Date)dataFinal);
        if (quantidadeDias > 60) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Per\u00edodo m\u00e1ximo de 60 dias.");
            return false;
        }
        if (quantidadeDias < 0) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"A data final n\u00e3o pode ser anterior \u00e0 data inicial.");
            return false;
        }
        return true;
    }

    private boolean isValidadeInformada() {
        return this.filtro.getValidadeInicial() != null && this.filtro.getValidadeFinal() != null;
    }

    private boolean isPeriodoInformado() {
        return this.filtro.getPeriodoInicial() != null && this.filtro.getPeriodoFinal() != null;
    }

    public void imprimirRelatorio() throws Exception {
        try {
            this.montarFiltrosUsados();
            DataSet dataSet = new DataSet(LaudoAlvaraVo.class);
            HashMap<String, Parameter> params = new HashMap<String, Parameter>();
            String relatorioJasper = "RelatorioLaudos.jasper";
            ByteArrayInputStream inputStreamBrasao = new ByteArrayInputStream(this.entidadeController.getEntidade().getBrasao());
            params.put("brasao", new Parameter((Object)inputStreamBrasao));
            params.put("entidade", new Parameter((Object)this.entidadeController.getEntidade().getNome()));
            params.put("filtros", new Parameter((Object)this.filtrosUsados.toString()));
            params.put("nome_secretaria", new Parameter((Object)UtilsController.getNomeSecretaria()));
            this.montarDataSetLaudo(dataSet);
            this.relatorio = ((FacadeRelatorios)SpringContext.getBean(FacadeRelatorios.class)).imprimeRelatorio(relatorioJasper, dataSet, null, params);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Falha ao imprimir o relat\u00f3rio.");
        }
    }

    private void montarDataSetLaudo(DataSet dataSet) {
        for (LaudoAlvaraEntity laudo : this.listaLaudos) {
            LaudoAlvaraVo vo = new LaudoAlvaraVo();
            vo.setNumeroSolicitacao(laudo.getIdSolicitacaoAlvara().getNumeroSolicitacao() + "/" + laudo.getIdSolicitacaoAlvara().getExercicio());
            vo.setDataValidade(laudo.getDataValidade());
            vo.setSituacaoLaudo(laudo.getStatus().descricaoCapitalize());
            vo.setTipoLaudo(laudo.getTipoLaudo().getDescricao());
            vo.setVistoriar("S".equals(laudo.getVistoriar()) ? "Sim" : "N\u00e3o");
            vo.setVistoriadoFiscalizacao(laudo.isVistoriadoFiscalizacao() ? "Sim" : "N\u00e3o");
            dataSet.add((Object)vo);
        }
    }

    public StreamedContent downloadRelatorio() {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.relatorio);
        String nomeRelatorio = "RELATORIO_LAUDO_" + EloDateUtils.toAnsiDateString((Date)new Date(), (String)"dd-MM-yyyy");
        return new DefaultStreamedContent((InputStream)stream, "application/pdf", nomeRelatorio + ".pdf");
    }

    private void montarFiltrosUsados() {
        this.filtrosUsados = new StringBuilder("Filtros: ");
        if (this.filtro.getSituacaoLaudo() != null) {
            this.filtrosUsados.append("Situa\u00e7\u00e3o do Laudo = ").append(this.filtro.getSituacaoLaudo().descricaoCapitalize()).append(" ");
        }
        if (this.filtro.getTipoLaudo() != null) {
            this.filtrosUsados.append("Tipo do Laudo = ").append(this.filtro.getTipoLaudo().getNome()).append(" ");
        }
        if (!EloStringUtils.isEmpty((String)this.filtro.getNumeroSolicitacao())) {
            this.filtrosUsados.append("N\u00b0 da Solicita\u00e7\u00e3o = ").append(this.filtro.getNumeroSolicitacao()).append(" ");
        }
        if (this.filtro.getPeriodoInicial() != null) {
            this.filtrosUsados.append("Per\u00edodo Inicial = ").append(EloDateUtils.toAnsiDateString((Date)this.filtro.getPeriodoInicial(), (String)"dd/MM/yyyy")).append(" ");
        }
        if (this.filtro.getPeriodoFinal() != null) {
            this.filtrosUsados.append("Per\u00edodo Final = ").append(EloDateUtils.toAnsiDateString((Date)this.filtro.getPeriodoFinal(), (String)"dd/MM/yyyy")).append(" ");
        }
        if (this.filtro.getValidadeInicial() != null) {
            this.filtrosUsados.append("Per\u00edodo Inicial = ").append(EloDateUtils.toAnsiDateString((Date)this.filtro.getValidadeInicial(), (String)"dd/MM/yyyy")).append(" ");
        }
        if (this.filtro.getValidadeFinal() != null) {
            this.filtrosUsados.append("Per\u00edodo Final = ").append(EloDateUtils.toAnsiDateString((Date)this.filtro.getValidadeFinal(), (String)"dd/MM/yyyy")).append(" ");
        }
    }

    public int getDiasMaximoPeriodo() {
        return 60;
    }

    public void carregarAndamento(LaudoAlvaraEntity laudo) throws BaseException {
        this.laudoSelecionado = laudo;
        this.andamentos.clear();
        this.andamentos = ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).getCarregaListaAndamentoLaudoAlvara(laudo.getIdLaudoAlvara());
    }
}

