/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.caelum.stella.validation.CPFValidator;
import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.vo.EmailVo;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.AcessoWebEntity;
import br.com.elotech.tributacao.facade.FacadeLoginAise;
import br.com.elotech.util.string.EloHashUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import javax.faces.context.FacesContext;
import org.springframework.context.annotation.Scope;

@EloController(value="recuperarSenhaController")
@Scope(value="flow")
public class RecuperarSenhaController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = -5374045224755385867L;
    public static final Integer CODIGO_5_DIGITOS = 5;
    private static final String ALFA_NUMERICO = "123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private AcessoWebEntity usuario;
    private String codigoParaAlterarSenha;

    public AcessoWebEntity getUsuario() {
        return this.usuario;
    }

    public void setUsuario(AcessoWebEntity usuario) {
        this.usuario = usuario;
    }

    public String getCodigoParaAlterarSenha() {
        return this.codigoParaAlterarSenha;
    }

    public void setCodigoParaAlterarSenha(String codigoParaAlterarSenha) {
        this.codigoParaAlterarSenha = codigoParaAlterarSenha;
    }

    public void iniciar() throws BaseException {
        this.usuario = new AcessoWebEntity();
        this.codigoParaAlterarSenha = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("codigo");
        this.usuario.setCpf((String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("cpf"));
    }

    protected AcessoWebEntity recuperarUsuario(String cpf) {
        try {
            AcessoWebEntity usuarioAcessoWeb = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).verificarLoginAcessoWeb(cpf);
            if (usuarioAcessoWeb == null || usuarioAcessoWeb.getId() == null) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"Usu\u00e1rio n\u00e3o encontrado.");
                return null;
            }
            return usuarioAcessoWeb;
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)"Erro ao validar CPF existente");
            return null;
        }
    }

    public void solicitarCodigoAlteracaoSenha() throws BaseException {
        AcessoWebEntity usuario;
        if (this.validarCPF() && (usuario = this.recuperarUsuario(this.usuario.getCpf())) != null) {
            String codigoGerado = this.gerarCodigoAlteracaoSenha();
            usuario.setCodigoAlteracaoSenha(EloHashUtils.hashMD5((String)codigoGerado));
            this.salvarUsuario(usuario);
            this.enviarEmailComCodigoAlteracaoSenha(usuario, codigoGerado);
            ShowMessage.addInfoMessage((String)"validacao", (String)"Foi enviado um e-mail com o C\u00f3digo de Altera\u00e7\u00e3o.");
        }
    }

    protected boolean validarCPF() {
        if (EloStringUtils.isEmpty((String)this.usuario.getCpf())) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Informe o CPF.");
            return false;
        }
        if (new CPFValidator(false).invalidMessagesFor(this.usuario.getCpf()).size() != 0) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"CPF Inv\u00e1lido.");
            return false;
        }
        return true;
    }

    protected void enviarEmailComCodigoAlteracaoSenha(AcessoWebEntity usuario, String codigoGerado) {
        try {
            EmailVo email = new EmailVo();
            email.setDestinatario(usuario.getEmail());
            email.setAssunto("C\u00f3digo de Altera\u00e7\u00e3o - Alvar\u00e1 Online");
            email.setMensagem(EloStringUtils.replaceTemplates((String)this.getMensagemEmail(usuario, codigoGerado), (Map)EloStringUtils.HTML_ACENTOS_TEMPLATE));
            ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).enviarEmail(email);
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Erro ao enviar e-mail com o c\u00f3digo de altera\u00e7\u00e3o");
        }
    }

    protected String getMensagemEmail(AcessoWebEntity usuario, String codigoGerado) {
        String url = PortalUtils.getUrlApplicacao() + "/app/recuperarSenha?codigo=" + codigoGerado + "&cpf=" + usuario.getCpf();
        StringBuilder mensagem = new StringBuilder();
        mensagem.append("<div style='font-family: Arial, times, Serif;'>");
        mensagem.append("<b>Prezado(a) Sr.(a):</b>");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append("Para cadastrar um nova senha, acesse ");
        mensagem.append("<a href='" + url + "'>Recuperar Senha</a>");
        mensagem.append("<br>");
        mensagem.append(String.format("<p>Utilize seu CPF e o c\u00f3digo <b>%s</b> para cadastrar a nova senha.", codigoGerado));
        mensagem.append("</p>");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append("Atenciosamente,");
        mensagem.append("<br>");
        mensagem.append("<p><b>Alvar\u00e1 Online</b></p>");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append("<h5>Obs.: Esta \u00e9 uma mensagem autom\u00e1tica, por favor n\u00e3o responda este e-mail.</h5>");
        mensagem.append("</div>");
        return mensagem.toString();
    }

    protected void salvarUsuario(AcessoWebEntity usuario) throws BaseException {
        ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).incluirUsuario(usuario);
    }

    protected String gerarCodigoAlteracaoSenha() {
        Random random = new Random(new Date().getTime());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < CODIGO_5_DIGITOS; ++i) {
            int n = random.nextInt(ALFA_NUMERICO.length());
            sb.append(ALFA_NUMERICO.charAt(n));
        }
        return sb.toString();
    }

    public void salvarNovaSenha() throws BaseException {
        AcessoWebEntity usuario;
        if (this.validarCPF() && this.validarCamposNovaSenha() && (usuario = this.recuperarUsuario(this.usuario.getCpf())) != null && usuario.getId() != null) {
            if (usuario.getCodigoAlteracaoSenha() != null && usuario.getCodigoAlteracaoSenha().equals(EloHashUtils.hashMD5((String)this.codigoParaAlterarSenha))) {
                usuario.setSenha(EloHashUtils.hashMD5((String)EloStringUtils.build((Object[])new Object[]{this.usuario.getCpf(), ":", this.usuario.getSenha()})).toUpperCase());
                usuario.setCodigoAlteracaoSenha(null);
                this.salvarUsuario(usuario);
                this.codigoParaAlterarSenha = "";
                this.usuario = new AcessoWebEntity();
                ShowMessage.addInfoMessage((String)"validacao", (String)"Sua nova senha foi criada.");
            } else {
                ShowMessage.addErrorMessage((String)"validacao", (String)"O c\u00f3digo de altera\u00e7\u00e3o n\u00e3o \u00e9 v\u00e1lido.");
            }
        }
    }

    protected boolean validarCamposNovaSenha() {
        if (EloStringUtils.isEmpty((String)this.codigoParaAlterarSenha)) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"O campo C\u00f3digo de Altera\u00e7\u00e3o \u00e9 obrigat\u00f3rio.");
            return false;
        }
        boolean valido = true;
        if (EloStringUtils.isEmpty((String)this.usuario.getSenha())) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"O campo Senha \u00e9 obrigat\u00f3rio.");
        } else if (this.usuario.getSenha().length() < 6 || this.usuario.getSenha().length() > 15) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"A senha deve possuir de 6 a 15 caracteres.");
        } else if (EloStringUtils.isEmpty((String)this.usuario.getConfirmacaoSenha())) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"O campo Confirmar Senha \u00e9 obrigat\u00f3rio.");
        } else if (!this.usuario.getSenha().equals(this.usuario.getConfirmacaoSenha())) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"As senhas informadas n\u00e3o conferem.");
        }
        return valido;
    }
}

