/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.AdicionaNumeroConselhoController;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.controller.RequerimentoSolicitacaoAlvaraController;
import br.com.elotech.portalarrecadacao.controller.SolicitacaoAlvaraController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.controller.dataModel.SolicitacaoAlvaraDataModel;
import br.com.elotech.portalarrecadacao.domain.AndamentoAlvaraProvisorioEntity;
import br.com.elotech.portalarrecadacao.domain.AndamentoLaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ExigenciaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ObservacaoAndamentoLaudoEntity;
import br.com.elotech.portalarrecadacao.domain.ObservacaoTipoLaudoEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraNumConselhoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.domain.helper.ImprimirTaxasAlvara;
import br.com.elotech.portalarrecadacao.domain.vo.AnexoSolicitacaoRedeSimVo;
import br.com.elotech.portalarrecadacao.enumerator.GrauDeRiscoEnum;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.SistemaFiscalizacaoEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoRespostaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.facade.FacadeAlteracaoAtividades;
import br.com.elotech.portalarrecadacao.facade.FacadeLaudoAlvara;
import br.com.elotech.portalarrecadacao.facade.FacadeParecerDoLaudo;
import br.com.elotech.portalarrecadacao.facade.FacadeProcessoFiscalizacao;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.facade.FacadeStatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.integration.dto.dadosEmpresa.Atividade;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoAlvaraRedeSimDTO;
import br.com.elotech.portalarrecadacao.utils.faces.FacesUtil;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.ContatoPessoaEntity;
import br.com.elotech.tributacao.domain.aise.ContratoSocialPessoaEntity;
import br.com.elotech.tributacao.domain.aise.EnderecoCadastroGeralEntity;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.enumerator.TipoLaudoEnum;
import br.com.elotech.tributacao.security.AuthenticationProviderAise;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.exceptions.FormatError;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.faces.model.SelectItem;
import javax.security.sasl.AuthenticationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.util.string.Strings;
import org.primefaces.context.RequestContext;
import org.primefaces.event.FileUploadEvent;
import org.primefaces.model.DefaultStreamedContent;
import org.primefaces.model.StreamedContent;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.context.SecurityContextHolder;

@Scope(value="flow")
@EloController
public class ParecerDosLaudosController
extends EloLogger
implements Serializable {
    private static final String VALIDACAO_DETALHES = "validacaoDetalhes";
    private static final String VALIDACAO_PROVISORIO = "validacaoProvisorio";
    private static final int PERIODO_CONSULTA = 90;
    private static final String TODOS = "T";
    private static final long serialVersionUID = 1L;
    private SolicitacaoAlvaraDataModel solicitacaoDataModel;
    private AndamentoLaudoAlvaraEntity andamento = new AndamentoLaudoAlvaraEntity();
    private List<AndamentoLaudoAlvaraEntity> listaAndamentoLaudo = new ArrayList();
    private LaudoAlvaraEntity laudoSelecionado;
    private List<StatusLaudoAlvara> situacoesSelecionadas;
    private String grauRisco = "T";
    private Date periodoInicial;
    private Date periodoFinal;
    private String cnpjCpf;
    private Boolean isProvisorio;
    private Date dataValidade;
    private String descricaoDataHoraAtual;
    private String numeroSolicitacao;
    private String cadastroImobiliarioFiltro;
    private List<TipoLaudoEntity> tiposLaudoSelecionados;
    private boolean laudoDocumentosNaoValidadosFiltro;
    private List<SolicitacaoAlvaraEntity> listaSolicitacao;
    private SolicitacaoAlvaraEntity solicitacaoSelecionado;
    private List<TipoLaudoEntity> listaTipoLaudo;
    private String descricaoAtividades;
    private String responsavelTec;
    private List<Atividade> listaAtividade;
    private String nomeAtividade;
    private List<ContratoSocialPessoaEntity> listaSocios;
    private CadastroMobiliarioEntity cmcResponsavel;
    private StringBuilder informacoesAdicionais;
    private EnderecoCadastroGeralEntity enderecoImobiliarioPrincipal;
    private boolean solicitacoesComAnexoNosLaudosFiltro;
    private ContatoPessoaEntity contatoPessoa;
    private List<TipoInscricaoAlvaraEntity> listaTipoInscricaoAlvara;
    private TipoInscricaoAlvaraEntity tipoInscricaoAlvaraSelecionado;
    private List<NaturezaSolicitacaoAlvaraEntity> listaNaturezaJuridica;
    private NaturezaSolicitacaoAlvaraEntity naturezaJuridicaSelecionado;
    private List<ObservacaoTipoLaudoEntity> listaObservacoesPredefinidas;
    private List<ObservacaoTipoLaudoEntity> listaObservacoesPredefinidasSelecionadas;
    private LaudoAlvaraDocumentoEntity laudoAlvaraDocumento;
    private List<LaudoAlvaraDocumentoEntity> documentosParaEnviar = new ArrayList();
    private List<LaudoAlvaraDocumentoEntity> documentosDoLaudo = new ArrayList();
    private ObservacaoAndamentoLaudoEntity observacaoAndamentoLaudo;
    private AndamentoLaudoAlvaraEntity andamentoSelecionado = new AndamentoLaudoAlvaraEntity();
    private List<AnexoSolicitacaoRedeSimVo> anexosSolicitacaoSelecionada;
    private boolean flagLaudoPostura = false;
    private boolean flagLaudoVigilanciaSanitaria = false;
    private boolean flagLaudoAmbiental = false;
    private ExigenciaRedeSimEntity exigenciaRedeSim;
    private List<ExigenciaRedeSimEntity> listaExigenciaRedeSim;
    private boolean renderizarBotaoAbrirProcesso;
    private String possuiProcessoFiscalizacao = "T";
    private boolean somenteComDocumentosValidados = true;
    private String assuntoOsmSelecionado = null;
    private String abrirSegundoProcesso;
    private boolean renderReativarLaudos;
    private boolean renderCancelarTodosLaudos;
    private String protocoloRedeSim;
    @Resource
    private AdicionaNumeroConselhoController adicionaNumeroConselhoController;
    @Resource
    private AuthenticationProviderAise authenticationProviderAise;
    @Resource
    private EntidadeController entidadeController;
    @Resource
    private RequerimentoSolicitacaoAlvaraController requerimentoSolicitacaoAlvaraController;
    @Resource
    private SolicitacaoAlvaraController solicitacaoAlvaraController;
    private String motivoCancelamento;

    public String getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    public void setMotivoCancelamento(String motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    public List<LaudoAlvaraDocumentoEntity> getDocumentosDoLaudo() {
        return this.documentosDoLaudo;
    }

    public List<LaudoAlvaraDocumentoEntity> getDocumentosParaEnviar() {
        return this.documentosParaEnviar;
    }

    public List<ObservacaoTipoLaudoEntity> getListaObservacoesPredefinidasSelecionadas() {
        return this.listaObservacoesPredefinidasSelecionadas;
    }

    public void setListaObservacoesPredefinidasSelecionadas(List<ObservacaoTipoLaudoEntity> listaObservacoesPredefinidasSelecionadas) {
        this.listaObservacoesPredefinidasSelecionadas = listaObservacoesPredefinidasSelecionadas;
    }

    public List<ObservacaoTipoLaudoEntity> getListaObservacoesPredefinidas() {
        return this.listaObservacoesPredefinidas;
    }

    public void setListaObservacoesPredefinidas(List<ObservacaoTipoLaudoEntity> listaObservacoesPredefinidas) {
        this.listaObservacoesPredefinidas = listaObservacoesPredefinidas;
    }

    public SolicitacaoAlvaraDataModel getSolicitacaoDataModel() {
        return this.solicitacaoDataModel;
    }

    public void setSolicitacaoDataModel(SolicitacaoAlvaraDataModel solicitacaoDataModel) {
        this.solicitacaoDataModel = solicitacaoDataModel;
    }

    public CadastroMobiliarioEntity getCmcResponsavel() {
        return this.cmcResponsavel;
    }

    public void setCmcResponsavel(CadastroMobiliarioEntity cmcResponsavel) {
        this.cmcResponsavel = cmcResponsavel;
    }

    public EnderecoCadastroGeralEntity getEnderecoImobiliarioPrincipal() {
        return this.enderecoImobiliarioPrincipal;
    }

    public void setEnderecoImobiliarioPrincipal(EnderecoCadastroGeralEntity enderecoImobiliarioPrincipal) {
        this.enderecoImobiliarioPrincipal = enderecoImobiliarioPrincipal;
    }

    public ContatoPessoaEntity getContatoPessoa() {
        return this.contatoPessoa;
    }

    public void setContatoPessoa(ContatoPessoaEntity contatoPessoa) {
        this.contatoPessoa = contatoPessoa;
    }

    public AndamentoLaudoAlvaraEntity getAndamentoSelecionado() {
        return this.andamentoSelecionado;
    }

    public List<SolicitacaoAlvaraEntity> getListaSolicitacao() {
        return this.listaSolicitacao;
    }

    public void setListaSolicitacao(List<SolicitacaoAlvaraEntity> listaSolicitacao) {
        this.listaSolicitacao = listaSolicitacao;
    }

    public String getNomeAtividade() {
        return this.nomeAtividade;
    }

    public void setNomeAtividade(String nomeAtividade) {
        this.nomeAtividade = nomeAtividade;
    }

    public List<ContratoSocialPessoaEntity> getListaSocios() {
        return this.listaSocios;
    }

    public void setListaSocios(List<ContratoSocialPessoaEntity> listaSocios) {
        this.listaSocios = listaSocios;
    }

    public List<Atividade> getListaAtividade() {
        return this.listaAtividade;
    }

    public void setListaAtividade(List<Atividade> listaAtividade) {
        this.listaAtividade = listaAtividade;
    }

    public String getDescricaoAtividades() {
        return this.descricaoAtividades;
    }

    public void setDescricaoAtividades(String descricaoAtividades) {
        this.descricaoAtividades = descricaoAtividades;
    }

    public SolicitacaoAlvaraEntity getSolicitacaoSelecionado() {
        return this.solicitacaoSelecionado;
    }

    public void setSolicitacaoSelecionado(SolicitacaoAlvaraEntity solicitacaoSelecionado) {
        this.solicitacaoSelecionado = solicitacaoSelecionado;
    }

    public String getResponsavelTec() {
        return this.responsavelTec;
    }

    public void setResponsavelTec(String responsavelTec) {
        this.responsavelTec = responsavelTec;
    }

    public String getNumeroSolicitacao() {
        return this.numeroSolicitacao;
    }

    public void setNumeroSolicitacao(String numeroSolicitacao) {
        this.numeroSolicitacao = numeroSolicitacao;
    }

    public String getCadastroImobiliarioFiltro() {
        return this.cadastroImobiliarioFiltro;
    }

    public void setCadastroImobiliarioFiltro(String cadastroImobiliarioFiltro) {
        this.cadastroImobiliarioFiltro = cadastroImobiliarioFiltro;
    }

    public List<TipoLaudoEntity> getListaTipoLaudo() {
        return this.listaTipoLaudo;
    }

    public void setListaTipoLaudo(List<TipoLaudoEntity> listaTipoLaudo) {
        this.listaTipoLaudo = listaTipoLaudo;
    }

    public List<TipoLaudoEntity> getTiposLaudoSelecionados() {
        return this.tiposLaudoSelecionados;
    }

    public void setTiposLaudoSelecionados(List<TipoLaudoEntity> tiposLaudoSelecionados) {
        this.tiposLaudoSelecionados = tiposLaudoSelecionados;
    }

    public SolicitacaoAlvaraController getSolicitacaoAlvaraController() {
        return this.solicitacaoAlvaraController;
    }

    public void setSolicitacaoAlvaraController(SolicitacaoAlvaraController solicitacaoAlvaraController) {
        this.solicitacaoAlvaraController = solicitacaoAlvaraController;
    }

    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    public Date getPeriodoInicial() {
        return this.periodoInicial;
    }

    public void setPeriodoInicial(Date periodoInicial) {
        this.periodoInicial = periodoInicial;
    }

    public boolean isFlagLaudoPostura() {
        return this.flagLaudoPostura;
    }

    public boolean isFlagLaudoVigilanciaSanitaria() {
        return this.flagLaudoVigilanciaSanitaria;
    }

    public boolean isFlagLaudoAmbiental() {
        return this.flagLaudoAmbiental;
    }

    public Date getPeriodoFinal() {
        return this.periodoFinal;
    }

    public void setPeriodoFinal(Date periodoFinal) {
        this.periodoFinal = periodoFinal;
    }

    public List<StatusLaudoAlvara> getSituacoesSelecionadas() {
        return this.situacoesSelecionadas;
    }

    public void setSituacoesSelecionadas(List<StatusLaudoAlvara> situacoesSelecionadas) {
        this.situacoesSelecionadas = situacoesSelecionadas;
    }

    public LaudoAlvaraEntity getLaudoSelecionado() {
        return this.laudoSelecionado;
    }

    public void setLaudoSelecionado(LaudoAlvaraEntity laudoSelecionado) {
        this.laudoSelecionado = laudoSelecionado;
    }

    public AndamentoLaudoAlvaraEntity getAndamento() {
        return this.andamento;
    }

    public void setAndamento(AndamentoLaudoAlvaraEntity andamento) {
        this.andamento = andamento;
    }

    public String getAbrirSegundoProcesso() {
        return this.abrirSegundoProcesso;
    }

    public void setAbrirSegundoProcesso(String abrirSegundoProcesso) {
        this.abrirSegundoProcesso = abrirSegundoProcesso;
    }

    public String getProtocoloRedeSim() {
        return this.protocoloRedeSim;
    }

    public void setProtocoloRedeSim(String protocoloRedeSim) {
        this.protocoloRedeSim = protocoloRedeSim;
    }

    public boolean isDocumentosNaoValidadosFiltro() {
        return this.laudoDocumentosNaoValidadosFiltro;
    }

    public void setDocumentosNaoValidadosFiltro(boolean laudoDocumentosNaoValidadosFiltro) {
        this.laudoDocumentosNaoValidadosFiltro = laudoDocumentosNaoValidadosFiltro;
    }

    public List<AndamentoLaudoAlvaraEntity> getListaAndamentoLaudo() {
        Collections.sort(this.listaAndamentoLaudo, new /* Unavailable Anonymous Inner Class!! */);
        return this.listaAndamentoLaudo;
    }

    public void setListaAndamentoLaudo(List<AndamentoLaudoAlvaraEntity> listaAndamentoLaudo) {
        this.listaAndamentoLaudo = listaAndamentoLaudo;
    }

    public Boolean getIsProvisorio() {
        return this.isProvisorio;
    }

    public void setIsProvisorio(Boolean isProvisorio) {
        this.isProvisorio = isProvisorio;
    }

    public Date getDataValidade() {
        return this.dataValidade;
    }

    public void setDataValidade(Date dataValidade) {
        this.dataValidade = dataValidade;
    }

    public String getDescricaoDataHoraAtual() {
        this.descricaoDataHoraAtual = EloDateUtils.toAnsiDateString((Date)new Date(), (String)"dd/MM/yyyy - HH:mm");
        return this.descricaoDataHoraAtual;
    }

    public void setDescricaoDataHoraAtual(String descricaoDataHoraAtual) {
        this.descricaoDataHoraAtual = descricaoDataHoraAtual;
    }

    public StringBuilder getInformacoesAdicionais() {
        return this.informacoesAdicionais;
    }

    public void setInformacoesAdicionais(StringBuilder informacoesAdicionais) {
        this.informacoesAdicionais = informacoesAdicionais;
    }

    public boolean permiteEdicaoArea() {
        return this.solicitacaoSelecionado.isNaturezaInicial() || this.solicitacaoSelecionado.isNaturezaMudancaEndereco() || this.solicitacaoSelecionado.isNaturezaMudancaArea();
    }

    public List<TipoInscricaoAlvaraEntity> getListaTipoInscricaoAlvara() {
        return this.listaTipoInscricaoAlvara;
    }

    public TipoInscricaoAlvaraEntity getTipoInscricaoAlvaraSelecionado() {
        return this.tipoInscricaoAlvaraSelecionado;
    }

    public void setTipoInscricaoAlvaraSelecionado(TipoInscricaoAlvaraEntity tipoInscricaoAlvaraSelecionado) {
        this.tipoInscricaoAlvaraSelecionado = tipoInscricaoAlvaraSelecionado;
    }

    public List<NaturezaSolicitacaoAlvaraEntity> getListaNaturezaJuridica() {
        return this.listaNaturezaJuridica;
    }

    public NaturezaSolicitacaoAlvaraEntity getNaturezaJuridicaSelecionado() {
        return this.naturezaJuridicaSelecionado;
    }

    public void setNaturezaJuridicaSelecionado(NaturezaSolicitacaoAlvaraEntity naturezaJuridicaSelecionado) {
        this.naturezaJuridicaSelecionado = naturezaJuridicaSelecionado;
    }

    public ObservacaoAndamentoLaudoEntity getObservacaoAndamentoLaudo() {
        return this.observacaoAndamentoLaudo;
    }

    public void setObservacaoAndamentoLaudo(ObservacaoAndamentoLaudoEntity observacaoAndamentoLaudo) {
        this.observacaoAndamentoLaudo = observacaoAndamentoLaudo;
    }

    public AdicionaNumeroConselhoController getAdicionaNumeroConselhoController() {
        return this.adicionaNumeroConselhoController;
    }

    public ExigenciaRedeSimEntity getExigenciaRedeSim() {
        return this.exigenciaRedeSim;
    }

    public void setExigenciaRedeSim(ExigenciaRedeSimEntity exigenciaRedeSim) {
        this.exigenciaRedeSim = exigenciaRedeSim;
    }

    public List<ExigenciaRedeSimEntity> getListaExigenciaRedeSim() {
        return this.listaExigenciaRedeSim;
    }

    public void setListaExigenciaRedeSim(List<ExigenciaRedeSimEntity> listaExigenciaRedeSim) {
        this.listaExigenciaRedeSim = listaExigenciaRedeSim;
    }

    public boolean isRenderizarBotaoAbrirProcesso() {
        return this.renderizarBotaoAbrirProcesso;
    }

    public boolean isSomenteComDocumentosValidados() {
        return this.somenteComDocumentosValidados;
    }

    public void setSomenteComDocumentosValidados(boolean somenteComDocumentosValidados) {
        this.somenteComDocumentosValidados = somenteComDocumentosValidados;
    }

    public String getPossuiProcessoFiscalizacao() {
        return this.possuiProcessoFiscalizacao;
    }

    public void setPossuiProcessoFiscalizacao(String possuiProcessoFiscalizacao) {
        this.possuiProcessoFiscalizacao = possuiProcessoFiscalizacao;
    }

    public String getAssuntoOsmSelecionado() {
        return this.assuntoOsmSelecionado;
    }

    public void setAssuntoOsmSelecionado(String assuntoOsmSelecionado) {
        this.assuntoOsmSelecionado = assuntoOsmSelecionado;
    }

    public boolean isRenderReativarLaudos() {
        return this.renderReativarLaudos;
    }

    public void setRenderReativarLaudos(boolean renderReativarLaudos) {
        this.renderReativarLaudos = renderReativarLaudos;
    }

    public boolean isRenderCancelarTodosLaudos() {
        return this.renderCancelarTodosLaudos;
    }

    public void setRenderCancelarTodosLaudos(boolean renderCancelarTodosLaudos) {
        this.renderCancelarTodosLaudos = renderCancelarTodosLaudos;
    }

    public List<AnexoSolicitacaoRedeSimVo> getAnexosSolicitacaoSelecionada() {
        return this.anexosSolicitacaoSelecionada;
    }

    public void setAnexosSolicitacaoSelecionada(List<AnexoSolicitacaoRedeSimVo> anexosSolicitacaoSelecionada) {
        this.anexosSolicitacaoSelecionada = anexosSolicitacaoSelecionada;
    }

    public boolean isSolicitacoesComAnexoNosLaudosFiltro() {
        return this.solicitacoesComAnexoNosLaudosFiltro;
    }

    public void setSolicitacoesComAnexoNosLaudosFiltro(boolean solicitacoesComAnexoNosLaudosFiltro) {
        this.solicitacoesComAnexoNosLaudosFiltro = solicitacoesComAnexoNosLaudosFiltro;
    }

    public void cancelarLaudosPelaTelaDeAndamento() {
        try {
            if (this.isUltimoAndamentoIgualAoSelecionado()) {
                ShowMessage.addErrorMessage((String)VALIDACAO_PROVISORIO, (String)"Esta \u00e9 a \u00faltima situa\u00e7\u00e3o adicionada. Utilize o bot\u00e3o Adicionar Observa\u00e7\u00e3o na Lista dos Pareceres.");
            } else {
                boolean documentoCancelado = ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).verificaExisteDocumentoOuDocCancelado(this.solicitacaoSelecionado.getCadastroMobiliario().getId(), this.solicitacaoSelecionado.getNumeroAlvara());
                if (documentoCancelado) {
                    ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).addAndamentoCanceladoEmTodosLaudos(this.solicitacaoSelecionado, this.andamento.getDescricao());
                    this.listaAndamentoLaudo = this.carregaListaAndamentoAlvaras(this.laudoSelecionado.getIdLaudoAlvara());
                    this.andamento = new AndamentoLaudoAlvaraEntity();
                } else {
                    ShowMessage.addErrorMessage((String)VALIDACAO_PROVISORIO, (String)"O laudo n\u00e3o pode ser cancelado, j\u00e1 existe um documento de alvar\u00e1 emitido para esta solicita\u00e7\u00e3o.");
                }
            }
        }
        catch (BaseException e) {
            ShowMessage.addInfoMessage((String)VALIDACAO_PROVISORIO, (String)e.getMessage());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void indeferirLaudo() {
        try {
            LaudoAlvaraEntity laudoIndeferimento = this.laudoSelecionado;
            for (LaudoAlvaraEntity laudo : this.solicitacaoSelecionado.getLaudos()) {
                laudo.setStatus(StatusLaudoAlvara.INDEFERIDO);
                laudo.setLaudoIndeferimento(laudoIndeferimento);
                this.laudoSelecionado = laudo;
                this.andamento = new AndamentoLaudoAlvaraEntity();
                this.andamento.setStatus(StatusLaudoAlvara.INDEFERIDO);
                this.salvarAndamentoLaudo();
            }
            String utilizaIntegracaoRedeSim = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.INTEGRADO_REDESIM).getValor();
            if (SimNaoEnum.SIM.getShortText().equals(utilizaIntegracaoRedeSim)) {
                SolicitacaoRedeSimEntity solicitacaoRedeSim = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getConsultaRedeSim(this.solicitacaoSelecionado.getProtocoloRedeSim(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.INDEFERIDO, Optional.of("Indeferimento por laudo"));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
        FacesUtil.execute((String)"dialogConfirmaIndeferimentoLaudoWidgetVar.hide();");
        FacesUtil.execute((String)"dialogSuccessIndeferimentoLaudoWidgetVar.show();");
    }

    public void verificarAdicionarAndamento() {
        if (StatusLaudoAlvara.CANCELADO.getCodigo().equals(this.andamento.getStatus().getCodigo())) {
            if (EloStringUtils.isEmpty((String)this.andamento.getDescricao())) {
                ShowMessage.addInfoMessage((String)VALIDACAO_PROVISORIO, (String)"Descreva o motivo do Cancelamento. ");
            } else {
                RequestContext.getCurrentInstance().execute("confirmCancelamentoLaudos.show()");
            }
        } else if (StatusLaudoAlvara.ENCAMINHADO_PARA_VISTORIA.getCodigo().equals(this.andamento.getStatus().getCodigo()) && this.verificaAberturaDoSegundoProcesso()) {
            RequestContext.getCurrentInstance().execute("dialogCriaNovoProcesso.show();");
        } else if (StatusLaudoAlvara.INDEFERIDO.getCodigo().equals(this.andamento.getStatus().getCodigo())) {
            FacesUtil.execute((String)"dialogConfirmaIndeferimentoLaudoWidgetVar.show();");
        } else {
            try {
                this.existeSolicitacaoComLaudoCancelado();
                this.adicionarAndamento();
                this.andamento = new AndamentoLaudoAlvaraEntity();
                this.dataValidade = null;
            }
            catch (BaseException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                ShowMessage.addErrorMessage((String)VALIDACAO_PROVISORIO, (String)e.getMessage());
            }
        }
    }

    private void adicionarAndamento() throws BaseException {
        if (SimNaoEnum.equalNao((String)this.abrirSegundoProcesso).booleanValue()) {
            this.laudoSelecionado.setDataValidade(this.dataValidade);
            if (StatusLaudoAlvara.LIBERADO_PROVISORIO == this.andamento.getStatus()) {
                if (this.dataValidade == null) {
                    ShowMessage.addInfoMessage((String)VALIDACAO_PROVISORIO, (String)"Aten\u00e7\u00e3o, Informe a Data de Validade para o Laudo Provis\u00f3rio");
                    return;
                }
                if (this.dataValidade.compareTo(new Date()) < 0) {
                    this.isProvisorio = false;
                    ShowMessage.addErrorMessage((String)VALIDACAO_PROVISORIO, (String)" N\u00e3o \u00e9 poss\u00edvel adicionar uma data menor que a data atual.");
                    return;
                }
                this.laudoSelecionado.setDataValidade(this.dataValidade);
                this.andamento.setValidadeProvisorio(this.dataValidade);
            } else if (StatusLaudoAlvara.LIBERADO_DEFINITIVO == this.andamento.getStatus()) {
                this.dataValidade = null;
                this.laudoSelecionado.setDataValidade(this.dataValidade);
            }
            if (this.isLaudoSituacaoAndamentoProvisorio() && !SimNaoEnum.getSimShortText().equals(this.solicitacaoSelecionado.getRenovacao())) {
                ShowMessage.addErrorMessage((String)VALIDACAO_PROVISORIO, (String)"N\u00e3o foi poss\u00edvel realizar a opera\u00e7\u00e3o, pois n\u00e3o foi realizada uma renova\u00e7\u00e3o para esta solicita\u00e7\u00e3o at\u00e9 o momento.");
                return;
            }
            if (this.isUltimoAndamentoIgualAoSelecionado()) {
                throw new SolicitacaoAlvaraException("Esta \u00e9 a \u00faltima situa\u00e7\u00e3o adicionada. Utilize o bot\u00e3o Adicionar Observa\u00e7\u00e3o na Lista dos Pareceres.");
            }
            if (this.isExibeMotivoIndeferimentoSolicitacao() && StatusLaudoAlvara.NAO_LIBERADO.equals((Object)this.andamento.getStatus()) && EloStringUtils.isEmpty((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.MOTIVO_INDEFERIMENTO_LAUDO_ENVIO_REDESIM))) {
                ShowMessage.addErrorMessage((String)VALIDACAO_PROVISORIO, (String)"N\u00e3o foi poss\u00edvel realizar a opera\u00e7\u00e3o, pois n\u00e3o foi parametrizado o motivo do indeferimento do laudo para enviar \u00e0 Rede Sim.");
                return;
            }
            this.laudoSelecionado.setVistoriar("N");
            this.laudoSelecionado.setStatus(this.andamento.getStatus());
            this.laudoSelecionado.setVistoriadoFiscalizacao(StatusLaudoAlvara.LOCAL_FECHADO.equals((Object)this.andamento.getStatus()));
            this.adicionarObservacaoAndamento(this.andamento);
            this.salvarAndamentoLaudo();
            this.listaAndamentoLaudo.add(this.andamento);
            if (this.solicitacaoSelecionado.possuiTodosLaudosLiberado() && this.solicitacaoSelecionado.isRedeSim()) {
                this.alterarSituacaoSolicitacaoRedeSimLaudoDefinitivos();
                if (this.isEnviaAlvaraParaRedeSimAutomatico()) {
                    SolicitacaoRedeSimEntity solicitacaoRedeSim = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getSolicitacaoRedeSimBySolicitacaoAlvara(this.solicitacaoSelecionado);
                    if (((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).anexosRedeSimValidados(solicitacaoRedeSim)) {
                        try {
                            if (!this.solicitacaoSelecionado.isNaturezaInicial() && SimNaoEnum.equalNao((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS)).booleanValue()) {
                                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).efetivarAlteracaoSolicitacao(this.solicitacaoSelecionado);
                            }
                            if (!this.solicitacaoSelecionado.isSolicitacaoMEI() && (this.solicitacaoSelecionado.isGrauRiscoAlto() || this.solicitacaoSelecionado.isGrauRiscoBaixo())) {
                                this.gerarDebitoEEnviar(solicitacaoRedeSim);
                                this.gerarAlvara(solicitacaoRedeSim);
                                this.enviarAlvara(solicitacaoRedeSim);
                                ShowMessage.addInfoMessage((String)VALIDACAO_PROVISORIO, (String)"O alvar\u00e1 foi gerado e enviado para a Rede Sim");
                            }
                        }
                        catch (Exception e) {
                            this.logger.error((Object)String.format("Falha no protocolo %s na rotina de adicionar o Parecer dos Laudos", this.solicitacaoSelecionado.getProtocoloRedeSim()), (Throwable)e);
                        }
                    }
                }
            }
        }
        if (this.isExibeMotivoIndeferimentoSolicitacao() && (StatusLaudoAlvara.NAO_LIBERADO.equals((Object)this.andamento.getStatus()) && EloListUtils.safeIsEmpty((List)this.solicitacaoSelecionado.getLaudos()).booleanValue() || this.solicitacaoSelecionado.possuiAlgumLaudoNaoLiberado())) {
            FacadeRedeSim facadeRedeSim = (FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class);
            SolicitacaoRedeSimEntity solicitacaoRedeSim = facadeRedeSim.getSolicitacaoRedeSimBySolicitacaoAlvara(this.solicitacaoSelecionado);
            facadeRedeSim.enviarIndeferimentoRedeSim(solicitacaoRedeSim, this.buildMotivoIndeferimentoRedeSimLaudos());
            ShowMessage.addInfoMessage((String)VALIDACAO_PROVISORIO, (String)"Foi realizado o indeferimento da solicita\u00e7\u00e3o na Rede Sim");
        }
    }

    private String buildMotivoIndeferimentoRedeSimLaudos() throws BaseException {
        String tiposLaudosNaoLiberados = StringUtils.join((Iterable)this.solicitacaoSelecionado.getLaudos().stream().filter(l -> l.isLaudoNaoLiberado() && Objects.nonNull(l.getTipoLaudo()) && Objects.nonNull(l.getTipoLaudo().getCodigo())).map(l -> l.getTipoLaudo().getCodigo().getNome()).collect(Collectors.toList()), (String)", ");
        String motivoIndeferimentoLaudoEnvioRedeSim = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.MOTIVO_INDEFERIMENTO_LAUDO_ENVIO_REDESIM);
        String motivoIndeferimento = EloStringUtils.isEmpty((String)tiposLaudosNaoLiberados) ? motivoIndeferimentoLaudoEnvioRedeSim : String.format("Tipos de laudos n\u00e3o liberados: %s: %s", tiposLaudosNaoLiberados, motivoIndeferimentoLaudoEnvioRedeSim);
        return StringUtils.substring((String)motivoIndeferimento, (int)0, (int)2000);
    }

    private boolean isExibeMotivoIndeferimentoSolicitacao() throws BaseException {
        return SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.HABILITA_ENVIO_INDEFERIMENTO_REDESIM_SOLICITACAO_LAUDOS)) != false && !this.solicitacaoSelecionado.isSolicitacaoMEI() && this.solicitacaoSelecionado.isRedeSim();
    }

    private void gerarDebitoEEnviar(SolicitacaoRedeSimEntity solicitacaoRedeSim) throws BaseException {
        if (this.solicitacaoSelecionado.isSolicitacaoJuridicaNormal() || this.solicitacaoSelecionado.isSolicitacaoPrestadorServico()) {
            try {
                ImprimirTaxasAlvara numeroCarneBloqueto = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).imprimirTaxas(this.solicitacaoSelecionado);
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).enviarDocumento(solicitacaoRedeSim, SituacaoRespostaRedeSimEnum.EM_ANALISE, Boolean.TRUE.booleanValue(), numeroCarneBloqueto);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.SOLICITACAO_INCONSISTENTE, Optional.of("Ocorreu uma falha na rotina de d\u00e9bito no parecer dos laudos - " + e.getMessage()));
                throw new SolicitacaoAlvaraException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void enviarAlvara(SolicitacaoRedeSimEntity solicitacaoRedeSim) throws BaseException {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).enviarDocumento(solicitacaoRedeSim, SituacaoRespostaRedeSimEnum.EMITIDO, Boolean.FALSE.booleanValue());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoRedeSim(solicitacaoRedeSim);
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.SOLICITACAO_INCONSISTENTE, Optional.of("Ocorreu uma falha na rotina de enviar alvar\u00e1 no parecer dos laudos"));
            throw new SolicitacaoAlvaraException(e.getMessage(), (Throwable)e);
        }
    }

    private void gerarAlvara(SolicitacaoRedeSimEntity solicitacaoRedeSim) throws BaseException {
        try {
            if (UtilsController.existeHistoricoAlvaraProvisorioEnviado((SolicitacaoRedeSimEntity)solicitacaoRedeSim) || UtilsController.jaFoiGeradoAlvaraProvisorio((SolicitacaoRedeSimEntity)solicitacaoRedeSim)) {
                solicitacaoRedeSim.getSolicitacaoAlvara().setRenovacao(SimNaoEnum.getSimShortText());
            }
            solicitacaoRedeSim.getSolicitacaoAlvara().setDataValidadeProvisorio(null);
            Boolean gerarAlvaraDefinitivo = EloListUtils.safeIsEmpty((List)this.solicitacaoSelecionado.getLaudos()) != false || this.solicitacaoSelecionado.possuiTodosLaudosLiberadoDefinitivo();
            if (Boolean.TRUE.equals(gerarAlvaraDefinitivo)) {
                solicitacaoRedeSim.setAlvaraEnviado(TipoAlvaraEnum.DEFINITIVO);
            } else {
                solicitacaoRedeSim.setAlvaraEnviado(TipoAlvaraEnum.FUNCIONAMENTO_PROVISORIO);
            }
            solicitacaoRedeSim.setSolicitacaoAlvara(((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).montarObsAlvaraRedeSim(solicitacaoRedeSim));
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).gerarAlvaraRedeSim(solicitacaoRedeSim.getSolicitacaoAlvara());
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarObsAlvaraGerado(solicitacaoRedeSim.getSolicitacaoAlvara());
            if (Boolean.TRUE.equals(gerarAlvaraDefinitivo)) {
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.ALVARA_EMITIDO, Optional.of("Alvar\u00e1 Emitido"));
            } else {
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.ALVARA_FUNCIONAMENTO_PROVISORIO, Optional.of("Alvar\u00e1 Provis\u00f3rio"));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.SOLICITACAO_INCONSISTENTE, Optional.of("Ocorreu uma falha na rotina de gera\u00e7\u00e3o de alvar\u00e1 no parecer dos laudos - " + e.getMessage()));
            throw new SolicitacaoAlvaraException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean isEnviaAlvaraParaRedeSimAutomatico() throws BaseException {
        return SimNaoEnum.equalSim((String)UtilsController.getParametro((ParametroAlvaraEnum)ParametroAlvaraEnum.HABILITA_PROCESSO_AUTOMATICO_SOLICITACAO_REDESIM).getValor());
    }

    private void alterarSituacaoSolicitacaoRedeSimLaudoDefinitivos() throws BaseException {
        if (this.solicitacaoSelecionado.possuiTodosLaudosLiberadoDefinitivo()) {
            SolicitacaoRedeSimEntity solicitacaoRedeSim = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getConsultaRedeSim(this.solicitacaoSelecionado.getProtocoloRedeSim(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.LAUDOS_LIBERADOS, Optional.empty());
        }
    }

    private AndamentoAlvaraProvisorioEntity adicionarAndamentoLaudosProvisorio() throws BaseException {
        if (this.solicitacaoSelecionado.contemLaudosProvisorios()) {
            return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarAndamentoAlvaraProvisorio(this.solicitacaoSelecionado.getSolicitacaoAlvara());
        }
        return null;
    }

    private boolean isUltimoAndamentoIgualAoSelecionado() throws SolicitacaoAlvaraException {
        AndamentoLaudoAlvaraEntity ultimoAndamento;
        if (!(EloListUtils.safeIsEmpty((List)this.listaAndamentoLaudo).booleanValue() || (ultimoAndamento = (AndamentoLaudoAlvaraEntity)this.listaAndamentoLaudo.get(0)).getStatus() != this.andamento.getStatus() || ultimoAndamento.getValidadeProvisorio() != this.andamento.getValidadeProvisorio() && ultimoAndamento.getValidadeProvisorio().compareTo(this.andamento.getValidadeProvisorio()) != 0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void adicionarObservacaoAndamento(AndamentoLaudoAlvaraEntity andamento) {
        try {
            UsuarioEntity usuarioLogado = (UsuarioEntity)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            if (!EloStringUtils.isEmpty((String)andamento.getDescricao())) {
                this.observacaoAndamentoLaudo = new ObservacaoAndamentoLaudoEntity();
                this.observacaoAndamentoLaudo.setDescricao(andamento.getDescricao());
                this.observacaoAndamentoLaudo.setIdAndamentoLaudoAlvara(andamento);
                this.observacaoAndamentoLaudo.setUsuario(usuarioLogado);
                this.observacaoAndamentoLaudo.setDataObservacao(new Date());
                this.observacaoAndamentoLaudo.setResolvido(SimNaoEnum.NAO.getShortText());
                andamento.getObservacoes().add(this.observacaoAndamentoLaudo);
                ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).salvarAndamentoLaudo(andamento);
                this.andamentoSelecionado.setDescricao("");
            }
            this.adicionaObservacoesPredefinidas(andamento, usuarioLogado);
            this.observacaoAndamentoLaudo = null;
            this.listaObservacoesPredefinidasSelecionadas = new ArrayList();
        }
        catch (Exception e) {
            ShowMessage.addErrorMessage((String)"msgObservacaoAndamento", (String)"Erro ao adicionar a descri\u00e7\u00e3o");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void adicionaObservacoesPredefinidas(AndamentoLaudoAlvaraEntity andamento, UsuarioEntity usuarioLogado) throws BaseException {
        if (!EloListUtils.safeIsEmpty((List)this.listaObservacoesPredefinidasSelecionadas).booleanValue()) {
            for (ObservacaoTipoLaudoEntity obsTipoLaudo : this.listaObservacoesPredefinidasSelecionadas) {
                ObservacaoAndamentoLaudoEntity observacaoAndamentoLaudo = new ObservacaoAndamentoLaudoEntity();
                observacaoAndamentoLaudo.setUsuario(usuarioLogado);
                observacaoAndamentoLaudo.setDataObservacao(new Date());
                observacaoAndamentoLaudo.setResolvido(SimNaoEnum.NAO.getShortText());
                observacaoAndamentoLaudo.setDescricao(obsTipoLaudo.getDescricao());
                observacaoAndamentoLaudo.setIdAndamentoLaudoAlvara(andamento);
                andamento.getObservacoes().add(observacaoAndamentoLaudo);
            }
            ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).salvarAndamentoLaudo(andamento);
        }
    }

    private boolean isLaudoSituacaoAndamentoProvisorio() {
        for (AndamentoLaudoAlvaraEntity andamentoLaudo : this.listaAndamentoLaudo) {
            if (!andamentoLaudo.getStatus().equals((Object)StatusLaudoAlvara.LIBERADO_PROVISORIO)) continue;
            return true;
        }
        return false;
    }

    public void salvarAndamentoLaudo() throws SolicitacaoAlvaraException {
        if (this.laudoSelecionado != null) {
            try {
                this.andamento.setIdLaudoAlvara(this.laudoSelecionado);
                if (this.andamento.getDataAndamento() == null) {
                    this.andamento.setDataAndamento(new Date());
                }
                UsuarioEntity usuarioLogado = (UsuarioEntity)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                this.andamento.setUsuario(usuarioLogado);
                for (LaudoAlvaraEntity laudo : this.solicitacaoSelecionado.getLaudos()) {
                    if (!laudo.getIdLaudoAlvara().equals(this.laudoSelecionado.getIdLaudoAlvara()) || laudo.getStatus().equals((Object)this.laudoSelecionado.getStatus())) continue;
                    laudo.setStatus(this.laudoSelecionado.getStatus());
                }
                this.salvarLaudo(this.andamento);
                if (this.laudoSelecionado.getTipoLaudo().getCodigo() == TipoLaudoEnum.INSCRICAO_CADASTRAL) {
                    this.abrirProcessoAutomatico();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new SolicitacaoAlvaraException("Falha ao salvar o andamento. " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void salvarLaudo(AndamentoLaudoAlvaraEntity andamento) throws BaseException {
        ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).addAndamentoLaudo(this.laudoSelecionado, andamento, this.solicitacaoSelecionado);
    }

    public void onRowSelectTabSolicitacao() {
        try {
            if (this.isIntegradoComFiscalizacao()) {
                block2: for (LaudoAlvaraEntity laudo : this.solicitacaoSelecionado.getLaudos()) {
                    List listaAndamento = this.carregaListaAndamentoAlvaras(laudo.getIdLaudoAlvara());
                    for (AndamentoLaudoAlvaraEntity andamento : listaAndamento) {
                        laudo.setGerouProcessoFiscalizacao(null);
                        if (!Objects.nonNull(andamento.getProcessoFiscalizacao())) continue;
                        laudo.setGerouProcessoFiscalizacao(SimNaoEnum.SIM.getShortText());
                        continue block2;
                    }
                }
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean isIntegradoComFiscalizacao() throws BaseException {
        ParametroAlvaraEntity paramIntegraFiscalizacao = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.INTEGRACAO_FISCALIZACAO_SISTEMA);
        if (Objects.nonNull(paramIntegraFiscalizacao.getValor()) && (paramIntegraFiscalizacao.getValor().equals(SistemaFiscalizacaoEnum.ELOTECH.name()) || paramIntegraFiscalizacao.getValor().equals(SistemaFiscalizacaoEnum.OSM.name()))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void iniciar() {
        this.solicitacaoDataModel = new SolicitacaoAlvaraDataModel();
        this.assuntoOsmSelecionado = null;
        try {
            this.listaTipoInscricaoAlvara = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregarMenusTipoInscricao();
            this.listaNaturezaJuridica = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregaNaturezas(true);
            this.listaTipoLaudo = ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).getListaTipoLaudo();
            this.listaExigenciaRedeSim = new ArrayList();
            this.listaExigenciaRedeSim.addAll(((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).buscaLaudosExigidosRedeSim());
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public List<LaudoAlvaraEntity> carregaListaLaudosAlvaras(StatusLaudoAlvara situacao, Date periodoI, Date periodoF, String cnpjCpf, UsuarioEntity usuario) throws BaseException {
        return ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).getCarregaListaLaudoAlvara(situacao, periodoI, periodoF, cnpjCpf, usuario);
    }

    public List<AndamentoLaudoAlvaraEntity> carregaListaAndamentoAlvaras(Long codigoLaudo) throws BaseException {
        return ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).getCarregaListaAndamentoLaudoAlvara(codigoLaudo);
    }

    public void pesquisar() throws BaseException {
        Long numeroSolicitacaoSeparado = null;
        Long numeroExercicioSeparado = null;
        this.solicitacaoSelecionado = null;
        if (!EloStringUtils.isEmpty((String)this.numeroSolicitacao)) {
            Long[] consulta = UtilsController.separarNumeroExercicioSolicitacao((String)this.numeroSolicitacao);
            if (consulta == null) {
                return;
            }
            numeroSolicitacaoSeparado = consulta[0];
            numeroExercicioSeparado = consulta[1];
        }
        if (!this.validarData()) {
            return;
        }
        if (this.solicitacaoDataModel == null) {
            this.solicitacaoDataModel = new SolicitacaoAlvaraDataModel();
        }
        this.solicitacaoDataModel.setNumeroSolicitacaoFiltro(numeroSolicitacaoSeparado);
        this.solicitacaoDataModel.setExercicio(numeroExercicioSeparado);
        this.solicitacaoDataModel.setCpfCnpjFiltro(this.cnpjCpf);
        this.solicitacaoDataModel.setDataInicialFiltro(this.periodoInicial);
        this.solicitacaoDataModel.setDataFinalFiltro(this.periodoFinal);
        this.solicitacaoDataModel.setSituacoesLaudoFiltro(this.situacoesSelecionadas);
        this.solicitacaoDataModel.setTiposLaudoFiltro(this.tiposLaudoSelecionados);
        this.solicitacaoDataModel.setTipoInscricaoFiltro(this.tipoInscricaoAlvaraSelecionado);
        this.solicitacaoDataModel.setNaturezaSolicitacaoFiltro(this.naturezaJuridicaSelecionado);
        this.solicitacaoDataModel.setCadastroImobiliarioFiltro(this.cadastroImobiliarioFiltro);
        this.solicitacaoDataModel.setProcessoFiscalizacao(this.possuiProcessoFiscalizacao);
        this.solicitacaoDataModel.setSomenteComDocumentosValidados(this.somenteComDocumentosValidados);
        this.solicitacaoDataModel.setSolicitacoesComAnexoNosLaudosFiltro(this.solicitacoesComAnexoNosLaudosFiltro);
        if (!EloStringUtils.isEmpty((String)this.protocoloRedeSim)) {
            this.solicitacaoDataModel.setProtocoloRedeSim(this.protocoloRedeSim.toUpperCase());
        }
        this.solicitacaoDataModel.setLaudoDocumentosNaoValidadosFiltro(this.laudoDocumentosNaoValidadosFiltro);
        this.solicitacaoDataModel.setGrauRisco(this.grauRisco);
    }

    private boolean validarData() {
        int dias;
        if (this.periodoInicial == null && this.periodoFinal != null) {
            ShowMessage.addWarnMessage((String)"validacao", (String)"Insira um per\u00edodo inicial para pesquisa.");
            return false;
        }
        if (this.periodoInicial != null && this.periodoFinal == null) {
            this.periodoFinal = new Date();
        }
        if ((dias = EloDateUtils.daysBetween((Date)this.periodoInicial, (Date)this.periodoFinal)) > 90) {
            ShowMessage.addInfoMessage((String)"validacao", (String)"Por favor, informe um per\u00edodo mais curto para efetuar a pesquisa.");
            return false;
        }
        if (dias < 0) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"A data final n\u00e3o pode ser menor que a data inicial.");
            return false;
        }
        return true;
    }

    public String formataCpfCnpj(String str) throws FormatError {
        if (!EloStringUtils.isEmpty((String)str)) {
            return EloStringUtils.formatCpfCnpj((String)str);
        }
        return "";
    }

    public String formataData(Date data) {
        String dataFormatada = data != null ? EloDateUtils.toAnsiDateString((Date)data, (String)"dd/MM/yyyy") : "";
        return dataFormatada;
    }

    public String formatGrauRisco(String grauDeRisco) {
        return GrauDeRiscoEnum.getTextoFromSigla((String)grauDeRisco);
    }

    public void verificaLaudoProvisorio() {
        this.isProvisorio = StatusLaudoAlvara.LIBERADO_PROVISORIO == this.andamento.getStatus();
    }

    public boolean renderBotaoAlteracao() {
        try {
            return ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).getRenderLaudoBotaoAlteracao(this.laudoSelecionado);
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)("Par\u00e2metro " + ParametroAlvaraEnum.TIPO_LAUDO_HABILITA_ALTERACAO + " configurado incorretamente."));
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)("Ocorreu um erro ao verificar o par\u00e2metro " + ParametroAlvaraEnum.TIPO_LAUDO_HABILITA_ALTERACAO + ": " + e.getCause()));
        }
        return false;
    }

    public void visualizarParecer(LaudoAlvaraEntity laudo) throws BaseException {
        this.andamento = new AndamentoLaudoAlvaraEntity();
        this.verificaLaudoProvisorio();
        this.abrirSegundoProcesso = SimNaoEnum.NAO.getShortText();
        this.flagLaudoPostura = false;
        this.flagLaudoAmbiental = false;
        this.flagLaudoVigilanciaSanitaria = false;
        this.dataValidade = null;
        if (laudo != null) {
            this.listaAndamentoLaudo = new ArrayList();
            this.setDocumentosDoLaudoSelecionado(laudo);
            this.observacaoAndamentoLaudo = new ObservacaoAndamentoLaudoEntity();
            boolean acessaAndamento = this.validarUsuario();
            if (acessaAndamento) {
                this.listaAndamentoLaudo = this.carregaListaAndamentoAlvaras(laudo.getIdLaudoAlvara());
            }
            if (TipoLaudoEnum.POSTURA.getCodigo().equals(this.laudoSelecionado.getTipoLaudo().getIdTipoLaudo())) {
                this.flagLaudoPostura = true;
                this.flagLaudoAmbiental = false;
                this.flagLaudoVigilanciaSanitaria = false;
                if (Objects.isNull(this.solicitacaoSelecionado.getAreaConstruida())) {
                    this.solicitacaoSelecionado.setAreaConstruida(BigDecimal.ZERO);
                }
                if (Objects.isNull(this.solicitacaoSelecionado.getAreaPatio())) {
                    this.solicitacaoSelecionado.setAreaPatio(BigDecimal.ZERO);
                }
                if (this.solicitacaoSelecionado.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA})) {
                    this.solicitacaoSelecionado.getCadastroMobiliario().setAreaUtilizada(this.solicitacaoSelecionado.getAreaConstruida().add(this.solicitacaoSelecionado.getAreaPatio()));
                    this.solicitacaoSelecionado.getCadastroMobiliario().setAreaPatio(this.solicitacaoSelecionado.getAreaPatio());
                    this.solicitacaoSelecionado.getCadastroMobiliario().setAreaConstruida(this.solicitacaoSelecionado.getAreaConstruida());
                }
            } else if (this.laudoSelecionado.getTipoLaudo().getIdTipoLaudo().equals(TipoLaudoEnum.VIGILANCIA_SANITARIA.getCodigo())) {
                this.flagLaudoPostura = false;
                this.flagLaudoAmbiental = false;
                this.flagLaudoVigilanciaSanitaria = true;
                this.carregarAtividadesPossuemNumeroConselho();
            } else if (this.laudoSelecionado.getTipoLaudo().getIdTipoLaudo().equals(TipoLaudoEnum.AMBIENTAL.getCodigo())) {
                this.flagLaudoPostura = false;
                this.flagLaudoAmbiental = true;
                this.flagLaudoVigilanciaSanitaria = false;
                this.carregarAtividadesPossuemNumeroConselho();
            }
            this.carregarObservacoesPredefinidas(SimNaoEnum.SIM.getShortText());
            RequestContext.getCurrentInstance().addCallbackParam("acessaAndamento", (Object)acessaAndamento);
        }
    }

    public void setDocumentosDoLaudoSelecionado(LaudoAlvaraEntity laudo) {
        this.laudoSelecionado = laudo;
        this.documentosDoLaudo.clear();
        this.documentosDoLaudo.addAll(this.laudoSelecionado.getDocumentos());
    }

    protected void carregarObservacoesPredefinidas(String exibirNoAlvara) throws BaseException {
        this.listaObservacoesPredefinidas = Lists.newArrayList();
        this.listaObservacoesPredefinidas = ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).listaObservacoesTipoLaudo(this.laudoSelecionado.getTipoLaudo(), exibirNoAlvara);
    }

    private void carregarAtividadesPossuemNumeroConselho() throws BaseException {
        this.adicionaNumeroConselhoController.getSolicitacaoAlvaraController().setSolicitacaoAlvara(this.solicitacaoSelecionado);
        this.adicionaNumeroConselhoController.iniciar();
        this.adicionaNumeroConselhoController.carregarAtividadesPossuemNumeroConselho();
    }

    public void limparCampos() {
        this.situacoesSelecionadas = new ArrayList();
        this.tiposLaudoSelecionados = new ArrayList();
        this.periodoInicial = null;
        this.periodoFinal = null;
        this.numeroSolicitacao = "";
        this.cnpjCpf = "";
        this.listaSolicitacao = null;
        this.tipoInscricaoAlvaraSelecionado = null;
        this.naturezaJuridicaSelecionado = null;
        this.solicitacaoDataModel = null;
        this.laudoSelecionado = null;
        this.protocoloRedeSim = "";
        this.laudoDocumentosNaoValidadosFiltro = false;
        this.grauRisco = TODOS;
    }

    public void verDetalhes(SolicitacaoAlvaraEntity solicitacao) {
        try {
            this.solicitacaoSelecionado = solicitacao;
            this.verificaBotaoAbrirProcesso();
            this.requerimentoSolicitacaoAlvaraController.verDetalhes(solicitacao, true);
            this.renderReativarLaudos = this.contemTodosLaudosCancelados();
            if (solicitacao.isRedeSim()) {
                SolicitacaoRedeSimEntity solicitacaoRedeSim = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getSolicitacaoRedeSimBySolicitacaoAlvara(solicitacao);
                SolicitacaoAlvaraRedeSimDTO arquivoEmpresa = PortalUtils.normalizeJson((String)solicitacaoRedeSim.getArquivoDadosEmpresa());
                this.requerimentoSolicitacaoAlvaraController.setArquivoEmpresa(arquivoEmpresa);
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            this.renderReativarLaudos = false;
            this.renderCancelarTodosLaudos = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"Ocorreu um erro ao verificar se os laudos est\u00e3o cancelados.");
        }
    }

    public void abrirDialogVisualizarDocumentos(SolicitacaoAlvaraEntity solicitacao) {
        this.solicitacaoSelecionado = solicitacao;
    }

    public void salvarAlteracoesPostura() throws BaseException {
        this.logger.info((Object)String.format("Salvando altera\u00e7\u00f5es do Laudo de Postura: %d", this.laudoSelecionado.getIdLaudoAlvara()));
        try {
            if (Objects.isNull(this.solicitacaoSelecionado.getAreaConstruida())) {
                this.solicitacaoSelecionado.setAreaConstruida(BigDecimal.ZERO);
            }
            if (Objects.isNull(this.solicitacaoSelecionado.getAreaPatio())) {
                this.solicitacaoSelecionado.setAreaPatio(BigDecimal.ZERO);
            }
            this.solicitacaoSelecionado.setAreaUtilizada(this.solicitacaoSelecionado.getAreaConstruida().add(this.solicitacaoSelecionado.getAreaPatio()));
            if (this.permiteEdicaoArea() || SimNaoEnum.equalSim((String)this.solicitacaoSelecionado.getEfetivado()).booleanValue()) {
                this.solicitacaoSelecionado.getCadastroMobiliario().setAreaUtilizada(this.solicitacaoSelecionado.getAreaUtilizada());
                this.solicitacaoSelecionado.getCadastroMobiliario().setAreaBombeiro(this.solicitacaoSelecionado.getAreaUtilizada());
                this.solicitacaoSelecionado.getCadastroMobiliario().setAreaPatio(this.solicitacaoSelecionado.getAreaPatio());
                this.solicitacaoSelecionado.getCadastroMobiliario().setAreaConstruida(this.solicitacaoSelecionado.getAreaConstruida());
                ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarCadastroMobiliario(this.solicitacaoSelecionado.getCadastroMobiliario());
            }
            this.solicitacaoSelecionado.setGerarAlvara(SimNaoEnum.getSimShortText());
            ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).atualizaSolicitacaoAlvara(this.solicitacaoSelecionado);
            if (this.permiteEdicaoArea() || SimNaoEnum.equalSim((String)this.solicitacaoSelecionado.getEfetivado()).booleanValue()) {
                ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarCadastroGeral(this.solicitacaoSelecionado);
            }
            FacesUtil.execute((String)"dialogAlteracoesPostura.hide();dialogDocumentoLaudoWidgetVar.hide();");
        }
        catch (Exception e) {
            String mensagemDeErro = String.format("Erro ao salvar as altera\u00e7\u00f5es do Laudo de Postura: %d - %s", this.laudoSelecionado.getIdLaudoAlvara(), e.getMessage());
            this.logger.error((Object)mensagemDeErro, (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgAlteracoesPostura", (String)mensagemDeErro);
        }
    }

    public void carregaDescricaoAndamento(AndamentoLaudoAlvaraEntity andamento) throws BaseException {
        this.andamentoSelecionado = andamento;
        this.carregarObservacoesPredefinidas(SimNaoEnum.NAO.getShortText());
    }

    public List<StatusLaudoAlvara> getStatusFiltro() throws BaseException {
        List statusPermitidos = ((FacadeStatusLaudoAlvara)SpringContext.getBean(FacadeStatusLaudoAlvara.class)).getStatusLaudoAlvaraPermitidos(this.entidadeController.getEntidade());
        if (EloListUtils.safeIsEmpty((List)statusPermitidos).booleanValue()) {
            return new ArrayList<StatusLaudoAlvara>();
        }
        return statusPermitidos;
    }

    public List<SelectItem> opcaoSimNao() {
        ArrayList<SelectItem> lista = new ArrayList<SelectItem>();
        lista.add(new SelectItem(null, ""));
        for (SimNaoEnum sn : SimNaoEnum.values()) {
            lista.add(new SelectItem((Object)sn.getShortText(), sn.getLongText()));
        }
        return lista;
    }

    public void visualizarObservacao() throws BaseException {
        this.listaObservacoesPredefinidas = ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).listaObservacoesTipoLaudo(this.laudoSelecionado.getTipoLaudo(), SimNaoEnum.SIM.getShortText());
        RequestContext context = RequestContext.getCurrentInstance();
        context.addCallbackParam("acessaAndamento", (Object)this.validarUsuario());
    }

    private boolean validarUsuario() {
        UsuarioEntity usuario = (UsuarioEntity)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        boolean acessaAndamento = false;
        for (TipoLaudoEntity tipoLaudo : usuario.getTipoLaudos()) {
            if (!this.laudoSelecionado.getTipoLaudo().equals((Object)tipoLaudo)) continue;
            acessaAndamento = true;
        }
        if (!acessaAndamento) {
            ShowMessage.addInfoMessage((String)"validacao", (String)"Usu\u00e1rio conectado n\u00e3o tem permiss\u00e3o para alterar o laudo selecionado!");
        }
        return acessaAndamento;
    }

    public void salvarObservacao() {
        if (this.laudoSelecionado != null) {
            try {
                ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).salvarLaudoAlvara(this.laudoSelecionado);
                ShowMessage.addInfoMessage((String)VALIDACAO_PROVISORIO, (String)("As observa\u00e7\u00f5es para o laudo " + this.laudoSelecionado.getTipoLaudo().getDescricao() + " foram salvas com sucesso!"));
            }
            catch (BaseException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void handleFileUpload(FileUploadEvent event) {
        try {
            if (event.getFile() != null && event.getFile().getContents() != null) {
                this.laudoAlvaraDocumento = new LaudoAlvaraDocumentoEntity();
                this.laudoAlvaraDocumento.setLaudoAlvara(this.laudoSelecionado);
                this.laudoAlvaraDocumento.setDocumento(event.getFile().getContents());
                this.laudoAlvaraDocumento.setDataInclusao(EloDateUtils.getNowShort());
                this.laudoAlvaraDocumento.setNomeArquivo(EloStringUtils.limit((String)event.getFile().getFileName(), (int)70));
                this.laudoAlvaraDocumento.setExercicio(UtilsController.getExercicio());
                this.documentosParaEnviar.add(this.laudoAlvaraDocumento);
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void salvarDocumentos() {
        try {
            if (EloListUtils.safeIsEmpty((List)this.laudoSelecionado.getDocumentos()).booleanValue()) {
                this.laudoSelecionado.setDocumentos(new ArrayList());
            }
            if (!this.removerDocumentos() && EloListUtils.safeIsEmpty((List)this.documentosParaEnviar).booleanValue()) {
                ShowMessage.addInfoMessage((String)"validacaoDocumentos", (String)"N\u00e3o houve altera\u00e7\u00f5es nos documentos para salvar.");
                FacesUtil.execute((String)"dialogFailDocumentoSalvoWidgetVar.show()");
                return;
            }
            this.laudoSelecionado.getDocumentos().addAll(this.documentosParaEnviar);
            for (LaudoAlvaraDocumentoEntity doc : this.laudoSelecionado.getDocumentos()) {
                if (doc.getDocValidado() != null) continue;
                doc.setDocValidado("N");
            }
            ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).salvarLaudoAlvara(this.laudoSelecionado);
            this.reiniciarListasUpload();
            ShowMessage.addInfoMessage((String)"validacaoDocumentos", (String)"Os documentos foram salvos com sucesso.");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        FacesUtil.execute((String)"dialogSuccessDocumentoSalvoWidgetVar.show()");
    }

    public StreamedContent downloadFile(LaudoAlvaraDocumentoEntity documento) {
        ByteArrayInputStream stream = new ByteArrayInputStream(documento.getDocumento());
        return new DefaultStreamedContent((InputStream)stream);
    }

    public void reiniciarListasUpload() {
        this.documentosParaEnviar.clear();
        this.documentosDoLaudo.clear();
        this.documentosDoLaudo.addAll(this.laudoSelecionado.getDocumentos());
    }

    public void removerDocumentosParaEnviar(LaudoAlvaraDocumentoEntity documento) {
        this.documentosParaEnviar.remove(documento);
    }

    public void removerDocumentosLaudo(LaudoAlvaraDocumentoEntity documento) {
        this.documentosDoLaudo.remove(documento);
    }

    public boolean removerDocumentos() {
        boolean documentoRemovido = false;
        if (!EloListUtils.safeIsEmpty((List)this.documentosDoLaudo).booleanValue() || EloListUtils.safeIsEmpty((List)this.documentosDoLaudo).booleanValue() && !EloListUtils.safeIsEmpty((List)this.laudoSelecionado.getDocumentos()).booleanValue()) {
            ArrayList<LaudoAlvaraDocumentoEntity> docsRemover = new ArrayList<LaudoAlvaraDocumentoEntity>();
            for (LaudoAlvaraDocumentoEntity doc : this.laudoSelecionado.getDocumentos()) {
                if (this.documentosDoLaudo.contains(doc)) continue;
                docsRemover.add(doc);
                documentoRemovido = true;
            }
            this.laudoSelecionado.getDocumentos().removeAll(docsRemover);
        } else {
            this.laudoSelecionado.getDocumentos().clear();
        }
        return documentoRemovido;
    }

    public void marcarObservacaoResolvida(ObservacaoAndamentoLaudoEntity obs) {
        try {
            if ("S".equals(obs.getResolvido())) {
                obs.setResolvido("N");
            } else {
                obs.setResolvido("S");
            }
            ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).salvarAndamentoLaudo(this.andamentoSelecionado);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgObservacaoAndamento", (String)"Erro ao marcar a observa\u00e7\u00e3o como resolvido");
        }
    }

    public void adicionarNumConselho() {
        try {
            this.adicionaNumeroConselhoController.adicionarNumConselho();
            this.salvarAlteracoesResponsavelTecnico();
            this.atualizarListaAtividadeNumeroConselho();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgDlgNumConselho", (String)e.getMessage());
        }
    }

    private void atualizarListaAtividadeNumeroConselho() {
        this.adicionaNumeroConselhoController.setarAtividadeSelecionada(this.adicionaNumeroConselhoController.getAtividadeSelecionada());
    }

    public void removerNumConselho(SolicitacaoAlvaraNumConselhoEntity numeroConselho) {
        try {
            this.adicionaNumeroConselhoController.removerNumConselho(numeroConselho);
            this.removerSolicitacaoAlvaraNumeroConselho(numeroConselho);
            this.atualizarListaAtividadeNumeroConselho();
            ShowMessage.addInfoMessage((String)"msgDlgNumConselho", (String)"N\u00famero do conselho exclu\u00eddo.");
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            this.adicionaNumeroConselhoController.setSolicitacaoAlvaraNumConselhoSelecionado(numeroConselho);
            this.adicionaNumeroConselhoController.adicionarNumConselho();
            ShowMessage.addErrorMessage((String)"msgDlgNumConselho", (String)e.getMessage());
        }
    }

    private void removerSolicitacaoAlvaraNumeroConselho(SolicitacaoAlvaraNumConselhoEntity numeroConselho) throws BaseException {
        ((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).removerAtividadeNumeroConselho(numeroConselho);
    }

    public void salvarAlteracoesResponsavelTecnico() throws Exception {
        try {
            ((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).salvarAtividadesSolicitacao(this.adicionaNumeroConselhoController.getAtividadeSelecionada());
            ShowMessage.addInfoMessage((String)"msgDlgNumConselho", (String)"N\u00famero do conselho adicionado.");
        }
        catch (Exception e) {
            String mensagemDeErro = String.format("N\u00e3o foi poss\u00edvel alterar o respons\u00e1vel t\u00e9cnico - %s", e.getMessage());
            this.logger.error((Object)mensagemDeErro, (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgAlteracoesPostura", (String)mensagemDeErro);
        }
    }

    public SolicitacaoAlvaraDataModel getSolicitacaoAlvaraDataModel() {
        return this.solicitacaoDataModel;
    }

    private void abrirProcessoAutomatico() {
        try {
            ((FacadeProcessoFiscalizacao)SpringContext.getBean(FacadeProcessoFiscalizacao.class)).abrirProcessoAutomatico(this.solicitacaoSelecionado);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)VALIDACAO_PROVISORIO, (String)("N\u00e3o foi poss\u00edvel abrir o processo de fiscaliza\u00e7\u00e3o " + e.getMessage()));
        }
    }

    public void abrirSegundoProcesso() {
        try {
            if (Strings.isEmpty((CharSequence)this.assuntoOsmSelecionado) && SimNaoEnum.SIM.getShortText().equals(this.abrirSegundoProcesso)) {
                ShowMessage.addWarnErrorMessage((String)VALIDACAO_PROVISORIO, (String)"Selecione um Assunto para abrir o processo.");
            } else {
                if (SimNaoEnum.NAO.getShortText().equals(this.abrirSegundoProcesso)) {
                    this.adicionarAndamento();
                } else {
                    this.abrirProcessos();
                }
                ShowMessage.addInfoMessage((String)VALIDACAO_PROVISORIO, (String)"Processo criado com Sucesso!");
                this.andamento = new AndamentoLaudoAlvaraEntity();
                this.dataValidade = null;
                this.assuntoOsmSelecionado = null;
            }
        }
        catch (Exception e) {
            this.abrirSegundoProcesso = SimNaoEnum.NAO.getShortText();
            this.assuntoOsmSelecionado = null;
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void abrirProcessos() throws SolicitacaoAlvaraException, AuthenticationException {
        try {
            Optional<Object> idAssunto = Optional.empty();
            if (Strings.isEmpty((CharSequence)this.assuntoOsmSelecionado) || this.assuntoOsmSelecionado.equals("alvaraLocalizacao")) {
                idAssunto = Optional.of(this.getCodigoAssuntoAlvaraLocalizacao());
            } else if (this.assuntoOsmSelecionado.equals("acessibilidade")) {
                idAssunto = Optional.of(this.getCodigoAssuntoAcessibilidade());
            }
            List processos = ((FacadeProcessoFiscalizacao)SpringContext.getBean(FacadeProcessoFiscalizacao.class)).abrirProcesso(this.solicitacaoSelecionado, idAssunto);
            if (!processos.isEmpty()) {
                this.renderizarBotaoAbrirProcesso = false;
                String mensagemProcesso = processos.size() == 1 ? "O processo foi aberto" : "Os Processos foram abertos";
                ShowMessage.addInfoMessage((String)VALIDACAO_DETALHES, (String)String.format("%s com sucesso.", mensagemProcesso));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)VALIDACAO_DETALHES, (String)e.getMessage());
            ShowMessage.addErrorMessage((String)VALIDACAO_PROVISORIO, (String)e.getMessage());
            throw new SolicitacaoAlvaraException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean verificaAberturaDoSegundoProcesso() {
        try {
            ParametroAlvaraEntity sistemaFiscalizacao = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.INTEGRACAO_FISCALIZACAO_SISTEMA);
            if (Objects.nonNull(sistemaFiscalizacao.getValor()) && Objects.nonNull(this.solicitacaoSelecionado) && SimNaoEnum.SIM.getShortText().equalsIgnoreCase(this.solicitacaoSelecionado.getProcessoGerado()) && this.laudoSelecionado.getTipoLaudo().getIdTipoLaudo().equals(TipoLaudoEnum.POSTURA.getCodigo()) && !this.isUltimoAndamentoLiberadoProvisorio()) {
                return Boolean.TRUE;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)VALIDACAO_DETALHES, (String)e.getMessage());
        }
        return Boolean.FALSE;
    }

    private boolean isUltimoAndamentoLiberadoProvisorio() {
        AndamentoLaudoAlvaraEntity andamentoLaudo = (AndamentoLaudoAlvaraEntity)this.listaAndamentoLaudo.stream().sorted((a1, a2) -> a1.getDataAndamento().compareTo(a2.getDataAndamento())).reduce((primeiro, segundo) -> segundo).get();
        return andamentoLaudo != null && StatusLaudoAlvara.LIBERADO_PROVISORIO.equals((Object)andamentoLaudo.getStatus());
    }

    public void verificaBotaoAbrirProcesso() {
        try {
            ParametroAlvaraEntity sistemaFiscalizacao = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.INTEGRACAO_FISCALIZACAO_SISTEMA);
            ParametroAlvaraEntity habilitaAberturaAutomatica = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.HABILITA_ABERTURA_PROCESSO_AUTOMATICA);
            this.renderizarBotaoAbrirProcesso = !SimNaoEnum.SIM.getShortText().equalsIgnoreCase(habilitaAberturaAutomatica.getValor()) && Objects.nonNull(sistemaFiscalizacao.getValor()) && Objects.nonNull(this.solicitacaoSelecionado) && !SimNaoEnum.SIM.getShortText().equalsIgnoreCase(this.solicitacaoSelecionado.getProcessoGerado());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)VALIDACAO_DETALHES, (String)e.getMessage());
        }
    }

    private Integer getCodigoAssuntoAlvaraLocalizacao() throws BaseException {
        return Integer.parseInt(UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.CODIGO_ASSUNTO_ALVARALOCALIZACAO_OSM));
    }

    private Integer getCodigoAssuntoAcessibilidade() throws BaseException {
        return Integer.parseInt(UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.CODIGO_ASSUNTO_ACESSIBILIDADE_OSM));
    }

    public void cancelarTodosLaudos() {
        try {
            ((FacadeProcessoFiscalizacao)SpringContext.getBean(FacadeProcessoFiscalizacao.class)).cancelarProcessoFiscalizacao(this.solicitacaoSelecionado, this.motivoCancelamento);
            ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).addAndamentoCanceladoEmTodosLaudos(this.solicitacaoSelecionado, this.motivoCancelamento);
            RequestContext.getCurrentInstance().execute("dlgCancelarLaudos.hide()");
            this.motivoCancelamento = null;
            this.renderReativarLaudos = this.contemTodosLaudosCancelados();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgDlgCancelarLaudos", (String)Strings.join((String)e.getMessage(), (String[])new String[]{e.getCause().toString()}));
        }
    }

    private void existeSolicitacaoComLaudoCancelado() throws BaseException {
        boolean laudoCancelado = ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).isExisteLaudoComSituacaoCancelado(this.solicitacaoSelecionado);
        if (laudoCancelado) {
            throw new SolicitacaoAlvaraException("Solicita\u00e7\u00e3o com laudos cancelados, n\u00e3o \u00e9 permitido inclus\u00e3o de novo tipo de laudo.");
        }
    }

    public boolean exibirLinhaConsultaRedeSimEFiscalizacao() throws BaseException {
        return this.entidadeController.getMenu().isMenuAtivo(ParametroAlvaraEnum.INTEGRADO_REDESIM.name()) || this.isIntegradoComFiscalizacao();
    }

    public void validarDocumento(LaudoAlvaraDocumentoEntity documento) {
        if (!documento.isDocValidado().booleanValue()) {
            documento.setDocValidado(SimNaoEnum.SIM.getShortText());
            UsuarioEntity user = (UsuarioEntity)this.authenticationProviderAise.getUsuarioLogado();
            documento.setUsuarioValidacao(user.getUsuario());
            try {
                ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).salvarLaudoAlvara(this.laudoSelecionado);
                this.reiniciarListasUpload();
                ShowMessage.addInfoMessage((String)"validacaoDocumentos", (String)"Os documentos foram salvos com sucesso.");
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                ShowMessage.addErrorMessage((String)"validacaoUpload", (String)Strings.join((String)e.getMessage(), (String[])new String[]{e.getCause().toString()}));
            }
        }
    }

    public void reativarLaudos() {
        try {
            ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).reativarLaudosCancelados(this.solicitacaoSelecionado);
            RequestContext.getCurrentInstance().execute("dlgVerificarReativacaoLaudos.hide()");
            this.renderReativarLaudos = this.contemTodosLaudosCancelados();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgReativarLaudos", (String)Strings.join((String)e.getMessage(), (String[])new String[]{e.getCause().toString()}));
        }
    }

    private boolean contemTodosLaudosCancelados() throws BaseException {
        return ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).verificarTodosLaudosCancelados(this.solicitacaoSelecionado);
    }

    public void montarAnexosSolicitacaoVo(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        SolicitacaoRedeSimEntity solicitacaoRedeSim = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getSolicitacaoRedeSimBySolicitacaoAlvara(solicitacao);
        if (Objects.nonNull(solicitacaoRedeSim)) {
            try {
                this.anexosSolicitacaoSelecionada = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).montarAnexosSolicitacaoVo(solicitacaoRedeSim);
            }
            catch (BaseException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
            }
        } else {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Erro: Solicita\u00e7\u00e3o Rede Sim n\u00e3o encontrada para esta solicita\u00e7\u00e3o.");
        }
    }

    public String getGrauRisco() {
        return this.grauRisco;
    }

    public boolean isLaudoDocumentosNaoValidadosFiltro() {
        return this.laudoDocumentosNaoValidadosFiltro;
    }

    public LaudoAlvaraDocumentoEntity getLaudoAlvaraDocumento() {
        return this.laudoAlvaraDocumento;
    }

    public AuthenticationProviderAise getAuthenticationProviderAise() {
        return this.authenticationProviderAise;
    }

    public EntidadeController getEntidadeController() {
        return this.entidadeController;
    }

    public RequerimentoSolicitacaoAlvaraController getRequerimentoSolicitacaoAlvaraController() {
        return this.requerimentoSolicitacaoAlvaraController;
    }

    public void setGrauRisco(String grauRisco) {
        this.grauRisco = grauRisco;
    }

    public void setLaudoDocumentosNaoValidadosFiltro(boolean laudoDocumentosNaoValidadosFiltro) {
        this.laudoDocumentosNaoValidadosFiltro = laudoDocumentosNaoValidadosFiltro;
    }

    public void setListaTipoInscricaoAlvara(List<TipoInscricaoAlvaraEntity> listaTipoInscricaoAlvara) {
        this.listaTipoInscricaoAlvara = listaTipoInscricaoAlvara;
    }

    public void setListaNaturezaJuridica(List<NaturezaSolicitacaoAlvaraEntity> listaNaturezaJuridica) {
        this.listaNaturezaJuridica = listaNaturezaJuridica;
    }

    public void setLaudoAlvaraDocumento(LaudoAlvaraDocumentoEntity laudoAlvaraDocumento) {
        this.laudoAlvaraDocumento = laudoAlvaraDocumento;
    }

    public void setDocumentosParaEnviar(List<LaudoAlvaraDocumentoEntity> documentosParaEnviar) {
        this.documentosParaEnviar = documentosParaEnviar;
    }

    public void setDocumentosDoLaudo(List<LaudoAlvaraDocumentoEntity> documentosDoLaudo) {
        this.documentosDoLaudo = documentosDoLaudo;
    }

    public void setAndamentoSelecionado(AndamentoLaudoAlvaraEntity andamentoSelecionado) {
        this.andamentoSelecionado = andamentoSelecionado;
    }

    public void setFlagLaudoPostura(boolean flagLaudoPostura) {
        this.flagLaudoPostura = flagLaudoPostura;
    }

    public void setFlagLaudoVigilanciaSanitaria(boolean flagLaudoVigilanciaSanitaria) {
        this.flagLaudoVigilanciaSanitaria = flagLaudoVigilanciaSanitaria;
    }

    public void setFlagLaudoAmbiental(boolean flagLaudoAmbiental) {
        this.flagLaudoAmbiental = flagLaudoAmbiental;
    }

    public void setRenderizarBotaoAbrirProcesso(boolean renderizarBotaoAbrirProcesso) {
        this.renderizarBotaoAbrirProcesso = renderizarBotaoAbrirProcesso;
    }

    public void setAdicionaNumeroConselhoController(AdicionaNumeroConselhoController adicionaNumeroConselhoController) {
        this.adicionaNumeroConselhoController = adicionaNumeroConselhoController;
    }

    public void setAuthenticationProviderAise(AuthenticationProviderAise authenticationProviderAise) {
        this.authenticationProviderAise = authenticationProviderAise;
    }

    public void setEntidadeController(EntidadeController entidadeController) {
        this.entidadeController = entidadeController;
    }

    public void setRequerimentoSolicitacaoAlvaraController(RequerimentoSolicitacaoAlvaraController requerimentoSolicitacaoAlvaraController) {
        this.requerimentoSolicitacaoAlvaraController = requerimentoSolicitacaoAlvaraController;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParecerDosLaudosController)) {
            return false;
        }
        ParecerDosLaudosController other = (ParecerDosLaudosController)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        SolicitacaoAlvaraDataModel this$solicitacaoDataModel = this.getSolicitacaoDataModel();
        SolicitacaoAlvaraDataModel other$solicitacaoDataModel = other.getSolicitacaoDataModel();
        if (this$solicitacaoDataModel == null ? other$solicitacaoDataModel != null : !this$solicitacaoDataModel.equals(other$solicitacaoDataModel)) {
            return false;
        }
        AndamentoLaudoAlvaraEntity this$andamento = this.getAndamento();
        AndamentoLaudoAlvaraEntity other$andamento = other.getAndamento();
        if (this$andamento == null ? other$andamento != null : !this$andamento.equals(other$andamento)) {
            return false;
        }
        List this$listaAndamentoLaudo = this.getListaAndamentoLaudo();
        List other$listaAndamentoLaudo = other.getListaAndamentoLaudo();
        if (this$listaAndamentoLaudo == null ? other$listaAndamentoLaudo != null : !((Object)this$listaAndamentoLaudo).equals(other$listaAndamentoLaudo)) {
            return false;
        }
        LaudoAlvaraEntity this$laudoSelecionado = this.getLaudoSelecionado();
        LaudoAlvaraEntity other$laudoSelecionado = other.getLaudoSelecionado();
        if (this$laudoSelecionado == null ? other$laudoSelecionado != null : !this$laudoSelecionado.equals(other$laudoSelecionado)) {
            return false;
        }
        List this$situacoesSelecionadas = this.getSituacoesSelecionadas();
        List other$situacoesSelecionadas = other.getSituacoesSelecionadas();
        if (this$situacoesSelecionadas == null ? other$situacoesSelecionadas != null : !((Object)this$situacoesSelecionadas).equals(other$situacoesSelecionadas)) {
            return false;
        }
        String this$grauRisco = this.getGrauRisco();
        String other$grauRisco = other.getGrauRisco();
        if (this$grauRisco == null ? other$grauRisco != null : !this$grauRisco.equals(other$grauRisco)) {
            return false;
        }
        Date this$periodoInicial = this.getPeriodoInicial();
        Date other$periodoInicial = other.getPeriodoInicial();
        if (this$periodoInicial == null ? other$periodoInicial != null : !((Object)this$periodoInicial).equals(other$periodoInicial)) {
            return false;
        }
        Date this$periodoFinal = this.getPeriodoFinal();
        Date other$periodoFinal = other.getPeriodoFinal();
        if (this$periodoFinal == null ? other$periodoFinal != null : !((Object)this$periodoFinal).equals(other$periodoFinal)) {
            return false;
        }
        String this$cnpjCpf = this.getCnpjCpf();
        String other$cnpjCpf = other.getCnpjCpf();
        if (this$cnpjCpf == null ? other$cnpjCpf != null : !this$cnpjCpf.equals(other$cnpjCpf)) {
            return false;
        }
        Boolean this$isProvisorio = this.getIsProvisorio();
        Boolean other$isProvisorio = other.getIsProvisorio();
        if (this$isProvisorio == null ? other$isProvisorio != null : !((Object)this$isProvisorio).equals(other$isProvisorio)) {
            return false;
        }
        Date this$dataValidade = this.getDataValidade();
        Date other$dataValidade = other.getDataValidade();
        if (this$dataValidade == null ? other$dataValidade != null : !((Object)this$dataValidade).equals(other$dataValidade)) {
            return false;
        }
        String this$descricaoDataHoraAtual = this.getDescricaoDataHoraAtual();
        String other$descricaoDataHoraAtual = other.getDescricaoDataHoraAtual();
        if (this$descricaoDataHoraAtual == null ? other$descricaoDataHoraAtual != null : !this$descricaoDataHoraAtual.equals(other$descricaoDataHoraAtual)) {
            return false;
        }
        String this$numeroSolicitacao = this.getNumeroSolicitacao();
        String other$numeroSolicitacao = other.getNumeroSolicitacao();
        if (this$numeroSolicitacao == null ? other$numeroSolicitacao != null : !this$numeroSolicitacao.equals(other$numeroSolicitacao)) {
            return false;
        }
        String this$cadastroImobiliarioFiltro = this.getCadastroImobiliarioFiltro();
        String other$cadastroImobiliarioFiltro = other.getCadastroImobiliarioFiltro();
        if (this$cadastroImobiliarioFiltro == null ? other$cadastroImobiliarioFiltro != null : !this$cadastroImobiliarioFiltro.equals(other$cadastroImobiliarioFiltro)) {
            return false;
        }
        List this$tiposLaudoSelecionados = this.getTiposLaudoSelecionados();
        List other$tiposLaudoSelecionados = other.getTiposLaudoSelecionados();
        if (this$tiposLaudoSelecionados == null ? other$tiposLaudoSelecionados != null : !((Object)this$tiposLaudoSelecionados).equals(other$tiposLaudoSelecionados)) {
            return false;
        }
        if (this.isLaudoDocumentosNaoValidadosFiltro() != other.isLaudoDocumentosNaoValidadosFiltro()) {
            return false;
        }
        List this$listaSolicitacao = this.getListaSolicitacao();
        List other$listaSolicitacao = other.getListaSolicitacao();
        if (this$listaSolicitacao == null ? other$listaSolicitacao != null : !((Object)this$listaSolicitacao).equals(other$listaSolicitacao)) {
            return false;
        }
        SolicitacaoAlvaraEntity this$solicitacaoSelecionado = this.getSolicitacaoSelecionado();
        SolicitacaoAlvaraEntity other$solicitacaoSelecionado = other.getSolicitacaoSelecionado();
        if (this$solicitacaoSelecionado == null ? other$solicitacaoSelecionado != null : !this$solicitacaoSelecionado.equals(other$solicitacaoSelecionado)) {
            return false;
        }
        List this$listaTipoLaudo = this.getListaTipoLaudo();
        List other$listaTipoLaudo = other.getListaTipoLaudo();
        if (this$listaTipoLaudo == null ? other$listaTipoLaudo != null : !((Object)this$listaTipoLaudo).equals(other$listaTipoLaudo)) {
            return false;
        }
        String this$descricaoAtividades = this.getDescricaoAtividades();
        String other$descricaoAtividades = other.getDescricaoAtividades();
        if (this$descricaoAtividades == null ? other$descricaoAtividades != null : !this$descricaoAtividades.equals(other$descricaoAtividades)) {
            return false;
        }
        String this$responsavelTec = this.getResponsavelTec();
        String other$responsavelTec = other.getResponsavelTec();
        if (this$responsavelTec == null ? other$responsavelTec != null : !this$responsavelTec.equals(other$responsavelTec)) {
            return false;
        }
        List this$listaAtividade = this.getListaAtividade();
        List other$listaAtividade = other.getListaAtividade();
        if (this$listaAtividade == null ? other$listaAtividade != null : !((Object)this$listaAtividade).equals(other$listaAtividade)) {
            return false;
        }
        String this$nomeAtividade = this.getNomeAtividade();
        String other$nomeAtividade = other.getNomeAtividade();
        if (this$nomeAtividade == null ? other$nomeAtividade != null : !this$nomeAtividade.equals(other$nomeAtividade)) {
            return false;
        }
        List this$listaSocios = this.getListaSocios();
        List other$listaSocios = other.getListaSocios();
        if (this$listaSocios == null ? other$listaSocios != null : !((Object)this$listaSocios).equals(other$listaSocios)) {
            return false;
        }
        CadastroMobiliarioEntity this$cmcResponsavel = this.getCmcResponsavel();
        CadastroMobiliarioEntity other$cmcResponsavel = other.getCmcResponsavel();
        if (this$cmcResponsavel == null ? other$cmcResponsavel != null : !this$cmcResponsavel.equals(other$cmcResponsavel)) {
            return false;
        }
        StringBuilder this$informacoesAdicionais = this.getInformacoesAdicionais();
        StringBuilder other$informacoesAdicionais = other.getInformacoesAdicionais();
        if (this$informacoesAdicionais == null ? other$informacoesAdicionais != null : !this$informacoesAdicionais.equals(other$informacoesAdicionais)) {
            return false;
        }
        EnderecoCadastroGeralEntity this$enderecoImobiliarioPrincipal = this.getEnderecoImobiliarioPrincipal();
        EnderecoCadastroGeralEntity other$enderecoImobiliarioPrincipal = other.getEnderecoImobiliarioPrincipal();
        if (this$enderecoImobiliarioPrincipal == null ? other$enderecoImobiliarioPrincipal != null : !this$enderecoImobiliarioPrincipal.equals(other$enderecoImobiliarioPrincipal)) {
            return false;
        }
        if (this.isSolicitacoesComAnexoNosLaudosFiltro() != other.isSolicitacoesComAnexoNosLaudosFiltro()) {
            return false;
        }
        ContatoPessoaEntity this$contatoPessoa = this.getContatoPessoa();
        ContatoPessoaEntity other$contatoPessoa = other.getContatoPessoa();
        if (this$contatoPessoa == null ? other$contatoPessoa != null : !this$contatoPessoa.equals(other$contatoPessoa)) {
            return false;
        }
        List this$listaTipoInscricaoAlvara = this.getListaTipoInscricaoAlvara();
        List other$listaTipoInscricaoAlvara = other.getListaTipoInscricaoAlvara();
        if (this$listaTipoInscricaoAlvara == null ? other$listaTipoInscricaoAlvara != null : !((Object)this$listaTipoInscricaoAlvara).equals(other$listaTipoInscricaoAlvara)) {
            return false;
        }
        TipoInscricaoAlvaraEntity this$tipoInscricaoAlvaraSelecionado = this.getTipoInscricaoAlvaraSelecionado();
        TipoInscricaoAlvaraEntity other$tipoInscricaoAlvaraSelecionado = other.getTipoInscricaoAlvaraSelecionado();
        if (this$tipoInscricaoAlvaraSelecionado == null ? other$tipoInscricaoAlvaraSelecionado != null : !this$tipoInscricaoAlvaraSelecionado.equals(other$tipoInscricaoAlvaraSelecionado)) {
            return false;
        }
        List this$listaNaturezaJuridica = this.getListaNaturezaJuridica();
        List other$listaNaturezaJuridica = other.getListaNaturezaJuridica();
        if (this$listaNaturezaJuridica == null ? other$listaNaturezaJuridica != null : !((Object)this$listaNaturezaJuridica).equals(other$listaNaturezaJuridica)) {
            return false;
        }
        NaturezaSolicitacaoAlvaraEntity this$naturezaJuridicaSelecionado = this.getNaturezaJuridicaSelecionado();
        NaturezaSolicitacaoAlvaraEntity other$naturezaJuridicaSelecionado = other.getNaturezaJuridicaSelecionado();
        if (this$naturezaJuridicaSelecionado == null ? other$naturezaJuridicaSelecionado != null : !this$naturezaJuridicaSelecionado.equals(other$naturezaJuridicaSelecionado)) {
            return false;
        }
        List this$listaObservacoesPredefinidas = this.getListaObservacoesPredefinidas();
        List other$listaObservacoesPredefinidas = other.getListaObservacoesPredefinidas();
        if (this$listaObservacoesPredefinidas == null ? other$listaObservacoesPredefinidas != null : !((Object)this$listaObservacoesPredefinidas).equals(other$listaObservacoesPredefinidas)) {
            return false;
        }
        List this$listaObservacoesPredefinidasSelecionadas = this.getListaObservacoesPredefinidasSelecionadas();
        List other$listaObservacoesPredefinidasSelecionadas = other.getListaObservacoesPredefinidasSelecionadas();
        if (this$listaObservacoesPredefinidasSelecionadas == null ? other$listaObservacoesPredefinidasSelecionadas != null : !((Object)this$listaObservacoesPredefinidasSelecionadas).equals(other$listaObservacoesPredefinidasSelecionadas)) {
            return false;
        }
        LaudoAlvaraDocumentoEntity this$laudoAlvaraDocumento = this.getLaudoAlvaraDocumento();
        LaudoAlvaraDocumentoEntity other$laudoAlvaraDocumento = other.getLaudoAlvaraDocumento();
        if (this$laudoAlvaraDocumento == null ? other$laudoAlvaraDocumento != null : !this$laudoAlvaraDocumento.equals(other$laudoAlvaraDocumento)) {
            return false;
        }
        List this$documentosParaEnviar = this.getDocumentosParaEnviar();
        List other$documentosParaEnviar = other.getDocumentosParaEnviar();
        if (this$documentosParaEnviar == null ? other$documentosParaEnviar != null : !((Object)this$documentosParaEnviar).equals(other$documentosParaEnviar)) {
            return false;
        }
        List this$documentosDoLaudo = this.getDocumentosDoLaudo();
        List other$documentosDoLaudo = other.getDocumentosDoLaudo();
        if (this$documentosDoLaudo == null ? other$documentosDoLaudo != null : !((Object)this$documentosDoLaudo).equals(other$documentosDoLaudo)) {
            return false;
        }
        ObservacaoAndamentoLaudoEntity this$observacaoAndamentoLaudo = this.getObservacaoAndamentoLaudo();
        ObservacaoAndamentoLaudoEntity other$observacaoAndamentoLaudo = other.getObservacaoAndamentoLaudo();
        if (this$observacaoAndamentoLaudo == null ? other$observacaoAndamentoLaudo != null : !this$observacaoAndamentoLaudo.equals(other$observacaoAndamentoLaudo)) {
            return false;
        }
        AndamentoLaudoAlvaraEntity this$andamentoSelecionado = this.getAndamentoSelecionado();
        AndamentoLaudoAlvaraEntity other$andamentoSelecionado = other.getAndamentoSelecionado();
        if (this$andamentoSelecionado == null ? other$andamentoSelecionado != null : !this$andamentoSelecionado.equals(other$andamentoSelecionado)) {
            return false;
        }
        List this$anexosSolicitacaoSelecionada = this.getAnexosSolicitacaoSelecionada();
        List other$anexosSolicitacaoSelecionada = other.getAnexosSolicitacaoSelecionada();
        if (this$anexosSolicitacaoSelecionada == null ? other$anexosSolicitacaoSelecionada != null : !((Object)this$anexosSolicitacaoSelecionada).equals(other$anexosSolicitacaoSelecionada)) {
            return false;
        }
        if (this.isFlagLaudoPostura() != other.isFlagLaudoPostura()) {
            return false;
        }
        if (this.isFlagLaudoVigilanciaSanitaria() != other.isFlagLaudoVigilanciaSanitaria()) {
            return false;
        }
        if (this.isFlagLaudoAmbiental() != other.isFlagLaudoAmbiental()) {
            return false;
        }
        ExigenciaRedeSimEntity this$exigenciaRedeSim = this.getExigenciaRedeSim();
        ExigenciaRedeSimEntity other$exigenciaRedeSim = other.getExigenciaRedeSim();
        if (this$exigenciaRedeSim == null ? other$exigenciaRedeSim != null : !this$exigenciaRedeSim.equals(other$exigenciaRedeSim)) {
            return false;
        }
        List this$listaExigenciaRedeSim = this.getListaExigenciaRedeSim();
        List other$listaExigenciaRedeSim = other.getListaExigenciaRedeSim();
        if (this$listaExigenciaRedeSim == null ? other$listaExigenciaRedeSim != null : !((Object)this$listaExigenciaRedeSim).equals(other$listaExigenciaRedeSim)) {
            return false;
        }
        if (this.isRenderizarBotaoAbrirProcesso() != other.isRenderizarBotaoAbrirProcesso()) {
            return false;
        }
        String this$possuiProcessoFiscalizacao = this.getPossuiProcessoFiscalizacao();
        String other$possuiProcessoFiscalizacao = other.getPossuiProcessoFiscalizacao();
        if (this$possuiProcessoFiscalizacao == null ? other$possuiProcessoFiscalizacao != null : !this$possuiProcessoFiscalizacao.equals(other$possuiProcessoFiscalizacao)) {
            return false;
        }
        if (this.isSomenteComDocumentosValidados() != other.isSomenteComDocumentosValidados()) {
            return false;
        }
        String this$assuntoOsmSelecionado = this.getAssuntoOsmSelecionado();
        String other$assuntoOsmSelecionado = other.getAssuntoOsmSelecionado();
        if (this$assuntoOsmSelecionado == null ? other$assuntoOsmSelecionado != null : !this$assuntoOsmSelecionado.equals(other$assuntoOsmSelecionado)) {
            return false;
        }
        String this$abrirSegundoProcesso = this.getAbrirSegundoProcesso();
        String other$abrirSegundoProcesso = other.getAbrirSegundoProcesso();
        if (this$abrirSegundoProcesso == null ? other$abrirSegundoProcesso != null : !this$abrirSegundoProcesso.equals(other$abrirSegundoProcesso)) {
            return false;
        }
        if (this.isRenderReativarLaudos() != other.isRenderReativarLaudos()) {
            return false;
        }
        if (this.isRenderCancelarTodosLaudos() != other.isRenderCancelarTodosLaudos()) {
            return false;
        }
        String this$protocoloRedeSim = this.getProtocoloRedeSim();
        String other$protocoloRedeSim = other.getProtocoloRedeSim();
        if (this$protocoloRedeSim == null ? other$protocoloRedeSim != null : !this$protocoloRedeSim.equals(other$protocoloRedeSim)) {
            return false;
        }
        AdicionaNumeroConselhoController this$adicionaNumeroConselhoController = this.getAdicionaNumeroConselhoController();
        AdicionaNumeroConselhoController other$adicionaNumeroConselhoController = other.getAdicionaNumeroConselhoController();
        if (this$adicionaNumeroConselhoController == null ? other$adicionaNumeroConselhoController != null : !this$adicionaNumeroConselhoController.equals(other$adicionaNumeroConselhoController)) {
            return false;
        }
        AuthenticationProviderAise this$authenticationProviderAise = this.getAuthenticationProviderAise();
        AuthenticationProviderAise other$authenticationProviderAise = other.getAuthenticationProviderAise();
        if (this$authenticationProviderAise == null ? other$authenticationProviderAise != null : !this$authenticationProviderAise.equals(other$authenticationProviderAise)) {
            return false;
        }
        EntidadeController this$entidadeController = this.getEntidadeController();
        EntidadeController other$entidadeController = other.getEntidadeController();
        if (this$entidadeController == null ? other$entidadeController != null : !this$entidadeController.equals(other$entidadeController)) {
            return false;
        }
        RequerimentoSolicitacaoAlvaraController this$requerimentoSolicitacaoAlvaraController = this.getRequerimentoSolicitacaoAlvaraController();
        RequerimentoSolicitacaoAlvaraController other$requerimentoSolicitacaoAlvaraController = other.getRequerimentoSolicitacaoAlvaraController();
        if (this$requerimentoSolicitacaoAlvaraController == null ? other$requerimentoSolicitacaoAlvaraController != null : !this$requerimentoSolicitacaoAlvaraController.equals(other$requerimentoSolicitacaoAlvaraController)) {
            return false;
        }
        SolicitacaoAlvaraController this$solicitacaoAlvaraController = this.getSolicitacaoAlvaraController();
        SolicitacaoAlvaraController other$solicitacaoAlvaraController = other.getSolicitacaoAlvaraController();
        if (this$solicitacaoAlvaraController == null ? other$solicitacaoAlvaraController != null : !this$solicitacaoAlvaraController.equals(other$solicitacaoAlvaraController)) {
            return false;
        }
        String this$motivoCancelamento = this.getMotivoCancelamento();
        String other$motivoCancelamento = other.getMotivoCancelamento();
        return !(this$motivoCancelamento == null ? other$motivoCancelamento != null : !this$motivoCancelamento.equals(other$motivoCancelamento));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParecerDosLaudosController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SolicitacaoAlvaraDataModel $solicitacaoDataModel = this.getSolicitacaoDataModel();
        result = result * 59 + ($solicitacaoDataModel == null ? 43 : $solicitacaoDataModel.hashCode());
        AndamentoLaudoAlvaraEntity $andamento = this.getAndamento();
        result = result * 59 + ($andamento == null ? 43 : $andamento.hashCode());
        List $listaAndamentoLaudo = this.getListaAndamentoLaudo();
        result = result * 59 + ($listaAndamentoLaudo == null ? 43 : ((Object)$listaAndamentoLaudo).hashCode());
        LaudoAlvaraEntity $laudoSelecionado = this.getLaudoSelecionado();
        result = result * 59 + ($laudoSelecionado == null ? 43 : $laudoSelecionado.hashCode());
        List $situacoesSelecionadas = this.getSituacoesSelecionadas();
        result = result * 59 + ($situacoesSelecionadas == null ? 43 : ((Object)$situacoesSelecionadas).hashCode());
        String $grauRisco = this.getGrauRisco();
        result = result * 59 + ($grauRisco == null ? 43 : $grauRisco.hashCode());
        Date $periodoInicial = this.getPeriodoInicial();
        result = result * 59 + ($periodoInicial == null ? 43 : ((Object)$periodoInicial).hashCode());
        Date $periodoFinal = this.getPeriodoFinal();
        result = result * 59 + ($periodoFinal == null ? 43 : ((Object)$periodoFinal).hashCode());
        String $cnpjCpf = this.getCnpjCpf();
        result = result * 59 + ($cnpjCpf == null ? 43 : $cnpjCpf.hashCode());
        Boolean $isProvisorio = this.getIsProvisorio();
        result = result * 59 + ($isProvisorio == null ? 43 : ((Object)$isProvisorio).hashCode());
        Date $dataValidade = this.getDataValidade();
        result = result * 59 + ($dataValidade == null ? 43 : ((Object)$dataValidade).hashCode());
        String $descricaoDataHoraAtual = this.getDescricaoDataHoraAtual();
        result = result * 59 + ($descricaoDataHoraAtual == null ? 43 : $descricaoDataHoraAtual.hashCode());
        String $numeroSolicitacao = this.getNumeroSolicitacao();
        result = result * 59 + ($numeroSolicitacao == null ? 43 : $numeroSolicitacao.hashCode());
        String $cadastroImobiliarioFiltro = this.getCadastroImobiliarioFiltro();
        result = result * 59 + ($cadastroImobiliarioFiltro == null ? 43 : $cadastroImobiliarioFiltro.hashCode());
        List $tiposLaudoSelecionados = this.getTiposLaudoSelecionados();
        result = result * 59 + ($tiposLaudoSelecionados == null ? 43 : ((Object)$tiposLaudoSelecionados).hashCode());
        result = result * 59 + (this.isLaudoDocumentosNaoValidadosFiltro() ? 79 : 97);
        List $listaSolicitacao = this.getListaSolicitacao();
        result = result * 59 + ($listaSolicitacao == null ? 43 : ((Object)$listaSolicitacao).hashCode());
        SolicitacaoAlvaraEntity $solicitacaoSelecionado = this.getSolicitacaoSelecionado();
        result = result * 59 + ($solicitacaoSelecionado == null ? 43 : $solicitacaoSelecionado.hashCode());
        List $listaTipoLaudo = this.getListaTipoLaudo();
        result = result * 59 + ($listaTipoLaudo == null ? 43 : ((Object)$listaTipoLaudo).hashCode());
        String $descricaoAtividades = this.getDescricaoAtividades();
        result = result * 59 + ($descricaoAtividades == null ? 43 : $descricaoAtividades.hashCode());
        String $responsavelTec = this.getResponsavelTec();
        result = result * 59 + ($responsavelTec == null ? 43 : $responsavelTec.hashCode());
        List $listaAtividade = this.getListaAtividade();
        result = result * 59 + ($listaAtividade == null ? 43 : ((Object)$listaAtividade).hashCode());
        String $nomeAtividade = this.getNomeAtividade();
        result = result * 59 + ($nomeAtividade == null ? 43 : $nomeAtividade.hashCode());
        List $listaSocios = this.getListaSocios();
        result = result * 59 + ($listaSocios == null ? 43 : ((Object)$listaSocios).hashCode());
        CadastroMobiliarioEntity $cmcResponsavel = this.getCmcResponsavel();
        result = result * 59 + ($cmcResponsavel == null ? 43 : $cmcResponsavel.hashCode());
        StringBuilder $informacoesAdicionais = this.getInformacoesAdicionais();
        result = result * 59 + ($informacoesAdicionais == null ? 43 : $informacoesAdicionais.hashCode());
        EnderecoCadastroGeralEntity $enderecoImobiliarioPrincipal = this.getEnderecoImobiliarioPrincipal();
        result = result * 59 + ($enderecoImobiliarioPrincipal == null ? 43 : $enderecoImobiliarioPrincipal.hashCode());
        result = result * 59 + (this.isSolicitacoesComAnexoNosLaudosFiltro() ? 79 : 97);
        ContatoPessoaEntity $contatoPessoa = this.getContatoPessoa();
        result = result * 59 + ($contatoPessoa == null ? 43 : $contatoPessoa.hashCode());
        List $listaTipoInscricaoAlvara = this.getListaTipoInscricaoAlvara();
        result = result * 59 + ($listaTipoInscricaoAlvara == null ? 43 : ((Object)$listaTipoInscricaoAlvara).hashCode());
        TipoInscricaoAlvaraEntity $tipoInscricaoAlvaraSelecionado = this.getTipoInscricaoAlvaraSelecionado();
        result = result * 59 + ($tipoInscricaoAlvaraSelecionado == null ? 43 : $tipoInscricaoAlvaraSelecionado.hashCode());
        List $listaNaturezaJuridica = this.getListaNaturezaJuridica();
        result = result * 59 + ($listaNaturezaJuridica == null ? 43 : ((Object)$listaNaturezaJuridica).hashCode());
        NaturezaSolicitacaoAlvaraEntity $naturezaJuridicaSelecionado = this.getNaturezaJuridicaSelecionado();
        result = result * 59 + ($naturezaJuridicaSelecionado == null ? 43 : $naturezaJuridicaSelecionado.hashCode());
        List $listaObservacoesPredefinidas = this.getListaObservacoesPredefinidas();
        result = result * 59 + ($listaObservacoesPredefinidas == null ? 43 : ((Object)$listaObservacoesPredefinidas).hashCode());
        List $listaObservacoesPredefinidasSelecionadas = this.getListaObservacoesPredefinidasSelecionadas();
        result = result * 59 + ($listaObservacoesPredefinidasSelecionadas == null ? 43 : ((Object)$listaObservacoesPredefinidasSelecionadas).hashCode());
        LaudoAlvaraDocumentoEntity $laudoAlvaraDocumento = this.getLaudoAlvaraDocumento();
        result = result * 59 + ($laudoAlvaraDocumento == null ? 43 : $laudoAlvaraDocumento.hashCode());
        List $documentosParaEnviar = this.getDocumentosParaEnviar();
        result = result * 59 + ($documentosParaEnviar == null ? 43 : ((Object)$documentosParaEnviar).hashCode());
        List $documentosDoLaudo = this.getDocumentosDoLaudo();
        result = result * 59 + ($documentosDoLaudo == null ? 43 : ((Object)$documentosDoLaudo).hashCode());
        ObservacaoAndamentoLaudoEntity $observacaoAndamentoLaudo = this.getObservacaoAndamentoLaudo();
        result = result * 59 + ($observacaoAndamentoLaudo == null ? 43 : $observacaoAndamentoLaudo.hashCode());
        AndamentoLaudoAlvaraEntity $andamentoSelecionado = this.getAndamentoSelecionado();
        result = result * 59 + ($andamentoSelecionado == null ? 43 : $andamentoSelecionado.hashCode());
        List $anexosSolicitacaoSelecionada = this.getAnexosSolicitacaoSelecionada();
        result = result * 59 + ($anexosSolicitacaoSelecionada == null ? 43 : ((Object)$anexosSolicitacaoSelecionada).hashCode());
        result = result * 59 + (this.isFlagLaudoPostura() ? 79 : 97);
        result = result * 59 + (this.isFlagLaudoVigilanciaSanitaria() ? 79 : 97);
        result = result * 59 + (this.isFlagLaudoAmbiental() ? 79 : 97);
        ExigenciaRedeSimEntity $exigenciaRedeSim = this.getExigenciaRedeSim();
        result = result * 59 + ($exigenciaRedeSim == null ? 43 : $exigenciaRedeSim.hashCode());
        List $listaExigenciaRedeSim = this.getListaExigenciaRedeSim();
        result = result * 59 + ($listaExigenciaRedeSim == null ? 43 : ((Object)$listaExigenciaRedeSim).hashCode());
        result = result * 59 + (this.isRenderizarBotaoAbrirProcesso() ? 79 : 97);
        String $possuiProcessoFiscalizacao = this.getPossuiProcessoFiscalizacao();
        result = result * 59 + ($possuiProcessoFiscalizacao == null ? 43 : $possuiProcessoFiscalizacao.hashCode());
        result = result * 59 + (this.isSomenteComDocumentosValidados() ? 79 : 97);
        String $assuntoOsmSelecionado = this.getAssuntoOsmSelecionado();
        result = result * 59 + ($assuntoOsmSelecionado == null ? 43 : $assuntoOsmSelecionado.hashCode());
        String $abrirSegundoProcesso = this.getAbrirSegundoProcesso();
        result = result * 59 + ($abrirSegundoProcesso == null ? 43 : $abrirSegundoProcesso.hashCode());
        result = result * 59 + (this.isRenderReativarLaudos() ? 79 : 97);
        result = result * 59 + (this.isRenderCancelarTodosLaudos() ? 79 : 97);
        String $protocoloRedeSim = this.getProtocoloRedeSim();
        result = result * 59 + ($protocoloRedeSim == null ? 43 : $protocoloRedeSim.hashCode());
        AdicionaNumeroConselhoController $adicionaNumeroConselhoController = this.getAdicionaNumeroConselhoController();
        result = result * 59 + ($adicionaNumeroConselhoController == null ? 43 : $adicionaNumeroConselhoController.hashCode());
        AuthenticationProviderAise $authenticationProviderAise = this.getAuthenticationProviderAise();
        result = result * 59 + ($authenticationProviderAise == null ? 43 : $authenticationProviderAise.hashCode());
        EntidadeController $entidadeController = this.getEntidadeController();
        result = result * 59 + ($entidadeController == null ? 43 : $entidadeController.hashCode());
        RequerimentoSolicitacaoAlvaraController $requerimentoSolicitacaoAlvaraController = this.getRequerimentoSolicitacaoAlvaraController();
        result = result * 59 + ($requerimentoSolicitacaoAlvaraController == null ? 43 : $requerimentoSolicitacaoAlvaraController.hashCode());
        SolicitacaoAlvaraController $solicitacaoAlvaraController = this.getSolicitacaoAlvaraController();
        result = result * 59 + ($solicitacaoAlvaraController == null ? 43 : $solicitacaoAlvaraController.hashCode());
        String $motivoCancelamento = this.getMotivoCancelamento();
        result = result * 59 + ($motivoCancelamento == null ? 43 : $motivoCancelamento.hashCode());
        return result;
    }

    public String toString() {
        return "ParecerDosLaudosController(solicitacaoDataModel=" + this.getSolicitacaoDataModel() + ", andamento=" + this.getAndamento() + ", listaAndamentoLaudo=" + this.getListaAndamentoLaudo() + ", laudoSelecionado=" + this.getLaudoSelecionado() + ", situacoesSelecionadas=" + this.getSituacoesSelecionadas() + ", grauRisco=" + this.getGrauRisco() + ", periodoInicial=" + this.getPeriodoInicial() + ", periodoFinal=" + this.getPeriodoFinal() + ", cnpjCpf=" + this.getCnpjCpf() + ", isProvisorio=" + this.getIsProvisorio() + ", dataValidade=" + this.getDataValidade() + ", descricaoDataHoraAtual=" + this.getDescricaoDataHoraAtual() + ", numeroSolicitacao=" + this.getNumeroSolicitacao() + ", cadastroImobiliarioFiltro=" + this.getCadastroImobiliarioFiltro() + ", tiposLaudoSelecionados=" + this.getTiposLaudoSelecionados() + ", laudoDocumentosNaoValidadosFiltro=" + this.isLaudoDocumentosNaoValidadosFiltro() + ", listaSolicitacao=" + this.getListaSolicitacao() + ", solicitacaoSelecionado=" + this.getSolicitacaoSelecionado() + ", listaTipoLaudo=" + this.getListaTipoLaudo() + ", descricaoAtividades=" + this.getDescricaoAtividades() + ", responsavelTec=" + this.getResponsavelTec() + ", listaAtividade=" + this.getListaAtividade() + ", nomeAtividade=" + this.getNomeAtividade() + ", listaSocios=" + this.getListaSocios() + ", cmcResponsavel=" + this.getCmcResponsavel() + ", informacoesAdicionais=" + this.getInformacoesAdicionais() + ", enderecoImobiliarioPrincipal=" + this.getEnderecoImobiliarioPrincipal() + ", solicitacoesComAnexoNosLaudosFiltro=" + this.isSolicitacoesComAnexoNosLaudosFiltro() + ", contatoPessoa=" + this.getContatoPessoa() + ", listaTipoInscricaoAlvara=" + this.getListaTipoInscricaoAlvara() + ", tipoInscricaoAlvaraSelecionado=" + this.getTipoInscricaoAlvaraSelecionado() + ", listaNaturezaJuridica=" + this.getListaNaturezaJuridica() + ", naturezaJuridicaSelecionado=" + this.getNaturezaJuridicaSelecionado() + ", listaObservacoesPredefinidas=" + this.getListaObservacoesPredefinidas() + ", listaObservacoesPredefinidasSelecionadas=" + this.getListaObservacoesPredefinidasSelecionadas() + ", laudoAlvaraDocumento=" + this.getLaudoAlvaraDocumento() + ", documentosParaEnviar=" + this.getDocumentosParaEnviar() + ", documentosDoLaudo=" + this.getDocumentosDoLaudo() + ", observacaoAndamentoLaudo=" + this.getObservacaoAndamentoLaudo() + ", andamentoSelecionado=" + this.getAndamentoSelecionado() + ", anexosSolicitacaoSelecionada=" + this.getAnexosSolicitacaoSelecionada() + ", flagLaudoPostura=" + this.isFlagLaudoPostura() + ", flagLaudoVigilanciaSanitaria=" + this.isFlagLaudoVigilanciaSanitaria() + ", flagLaudoAmbiental=" + this.isFlagLaudoAmbiental() + ", exigenciaRedeSim=" + this.getExigenciaRedeSim() + ", listaExigenciaRedeSim=" + this.getListaExigenciaRedeSim() + ", renderizarBotaoAbrirProcesso=" + this.isRenderizarBotaoAbrirProcesso() + ", possuiProcessoFiscalizacao=" + this.getPossuiProcessoFiscalizacao() + ", somenteComDocumentosValidados=" + this.isSomenteComDocumentosValidados() + ", assuntoOsmSelecionado=" + this.getAssuntoOsmSelecionado() + ", abrirSegundoProcesso=" + this.getAbrirSegundoProcesso() + ", renderReativarLaudos=" + this.isRenderReativarLaudos() + ", renderCancelarTodosLaudos=" + this.isRenderCancelarTodosLaudos() + ", protocoloRedeSim=" + this.getProtocoloRedeSim() + ", adicionaNumeroConselhoController=" + this.getAdicionaNumeroConselhoController() + ", authenticationProviderAise=" + this.getAuthenticationProviderAise() + ", entidadeController=" + this.getEntidadeController() + ", requerimentoSolicitacaoAlvaraController=" + this.getRequerimentoSolicitacaoAlvaraController() + ", solicitacaoAlvaraController=" + this.getSolicitacaoAlvaraController() + ", motivoCancelamento=" + this.getMotivoCancelamento() + ")";
    }
}

