/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.ObservacaoTipoLaudoEntity;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeObservacaoTipoLaudo;
import br.com.elotech.portalarrecadacao.facade.FacadeParecerDoLaudo;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.string.EloStringUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.primefaces.context.RequestContext;
import org.springframework.context.annotation.Scope;

@Scope(value="flow")
@EloController(value="observacaoTipoLaudoController")
public class ObservacaoTipoLaudoController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 492536779862884787L;
    private List<ObservacaoTipoLaudoEntity> observacoes;
    private ObservacaoTipoLaudoEntity observacaoTipoLaudo;
    private ObservacaoTipoLaudoEntity observacaoTipoLaudoPesquisa;
    private List<TipoLaudoEntity> tiposDeLaudo;

    public List<ObservacaoTipoLaudoEntity> getObservacoes() {
        return this.observacoes;
    }

    public void setObservacoes(List<ObservacaoTipoLaudoEntity> observacoes) {
        this.observacoes = observacoes;
    }

    public ObservacaoTipoLaudoEntity getObservacaoTipoLaudoPesquisa() {
        return this.observacaoTipoLaudoPesquisa;
    }

    public void setObservacaoTipoLaudoPesquisa(ObservacaoTipoLaudoEntity observacaoTipoLaudoPesquisa) {
        this.observacaoTipoLaudoPesquisa = observacaoTipoLaudoPesquisa;
    }

    public ObservacaoTipoLaudoEntity getObservacaoTipoLaudo() {
        return this.observacaoTipoLaudo;
    }

    public void setObservacaoTipoLaudo(ObservacaoTipoLaudoEntity observacaoTipoLaudo) {
        this.observacaoTipoLaudo = observacaoTipoLaudo;
    }

    public void iniciar() throws BaseException {
        this.observacaoTipoLaudoPesquisa = new ObservacaoTipoLaudoEntity();
        this.observacoes = this.carregarObservacoes();
        this.carregarTiposDeLaudo();
    }

    public List<TipoLaudoEntity> getTiposDeLaudo() {
        return this.tiposDeLaudo;
    }

    public void setTiposDeLaudo(List<TipoLaudoEntity> tiposDeLaudo) {
        this.tiposDeLaudo = tiposDeLaudo;
    }

    protected List<ObservacaoTipoLaudoEntity> carregarObservacoes() throws BaseException {
        return this.getFacadeObservacaoTipoLaudo().getCarregaObservacaoTipoLaudo();
    }

    private FacadeObservacaoTipoLaudo getFacadeObservacaoTipoLaudo() {
        return (FacadeObservacaoTipoLaudo)SpringContext.getBean(FacadeObservacaoTipoLaudo.class);
    }

    public void salvarObservacaoTipoLaudo() {
        try {
            if (Objects.isNull(this.observacaoTipoLaudo.getTitulo()) || EloStringUtils.isEmpty((String)this.observacaoTipoLaudo.getTitulo())) {
                ShowMessage.addInfoMessage((String)"msgObservacaoDialog", (String)"T\u00edtulo \u00e9 obrigat\u00f3rio.");
            } else if (Objects.isNull(this.observacaoTipoLaudo.getDescricao()) || EloStringUtils.isEmpty((String)this.observacaoTipoLaudo.getDescricao())) {
                ShowMessage.addInfoMessage((String)"msgObservacaoDialog", (String)"Descri\u00e7\u00e3o \u00e9 obrigat\u00f3rio.");
            } else if (Objects.isNull(this.observacaoTipoLaudo.getIdTipoLaudo())) {
                ShowMessage.addInfoMessage((String)"msgObservacaoDialog", (String)"Tipo de laudo \u00e9 obrigat\u00f3rio.");
            } else {
                this.getFacadeObservacaoTipoLaudo().salvarObservacaoTipoLaudo(this.observacaoTipoLaudo);
                RequestContext.getCurrentInstance().execute("dialogNovoObservacaoTipoLaudo.hide()");
                this.observacoes = this.carregarObservacoes();
                ShowMessage.addInfoMessage((String)"msgObservacao", (String)"Registro Salvo com Sucesso!");
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgObservacaoDialog", (String)String.format("%s%s", "Ocorreu uma falha em gravar a observa\u00e7\u00e3o ", e.getMessage()));
        }
    }

    public void removerObservacaoTipoLaudo(ObservacaoTipoLaudoEntity obs) {
        try {
            this.getFacadeObservacaoTipoLaudo().removerObservaocaoTipoLaudo(obs);
            this.observacoes = this.carregarObservacoes();
            ShowMessage.addInfoMessage((String)"msgObservacao", (String)"Registro Exclu\u00eddo com Sucesso!");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgObservacao", (String)String.format("%s%s", "Ocorreu uma falha remover a observa\u00e7\u00e3o ", e.getMessage()));
        }
    }

    public void editarObservaoTipoLaudo(ObservacaoTipoLaudoEntity obs) {
        try {
            this.observacaoTipoLaudo = obs;
            this.observacaoTipoLaudo.setIdTipoLaudo(obs.getIdTipoLaudo());
            this.carregarTiposDeLaudo();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgObservacao", (String)String.format("%s%s", "Ocorreu uma falha ao editar a observa\u00e7\u00e3o ", e.getMessage()));
        }
    }

    public void novoObservacaoTipoLaudo() {
        try {
            this.observacaoTipoLaudo = new ObservacaoTipoLaudoEntity();
            this.carregarTiposDeLaudo();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgObservacao", (String)String.format("%s%s", "Ocorreu uma falha ao criar nova observa\u00e7\u00e3o", e.getMessage()));
        }
    }

    private void carregarTiposDeLaudo() throws BaseException {
        this.tiposDeLaudo = ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).getListaTipoLaudo();
    }

    public SimNaoEnum[] simNaoEnum() {
        return SimNaoEnum.values();
    }

    public void pesquisar() {
        try {
            this.observacoes = ((FacadeObservacaoTipoLaudo)SpringContext.getBean(FacadeObservacaoTipoLaudo.class)).carregarObservacoesPorFiltro(this.observacaoTipoLaudoPesquisa);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgObservacao", (String)String.format("%s%s", "Ocorreu uma falha ao realizar a pesquisa - ", e.getMessage()));
        }
    }

    public void limpar() {
        this.observacaoTipoLaudoPesquisa = new ObservacaoTipoLaudoEntity();
    }
}

