/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoTipoInscricaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeNaturezaSolicitacaoTipoInscricao;
import br.com.elotech.spring.SpringContext;
import java.io.Serializable;
import java.util.List;
import org.springframework.context.annotation.Scope;

@EloController
@Scope(value="flow")
public class NaturezaSolicitacaoTipoInscricaoAlvaraController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 6025440642877741838L;
    private List<NaturezaSolicitacaoTipoInscricaoAlvaraEntity> naturezasSolicitacaoTipoInscricao;

    public List<NaturezaSolicitacaoTipoInscricaoAlvaraEntity> getNaturezasSolicitacaoTipoInscricao() {
        return this.naturezasSolicitacaoTipoInscricao;
    }

    public void setNaturezasSolicitacaoTipoInscricao(List<NaturezaSolicitacaoTipoInscricaoAlvaraEntity> naturezasSolicitacaoTipoInscricao) {
        this.naturezasSolicitacaoTipoInscricao = naturezasSolicitacaoTipoInscricao;
    }

    public void iniciar() {
        try {
            this.carregarDados();
        }
        catch (Exception e) {
            ShowMessage.addErrorMessage((String)"msg", (String)"Falha ao carregar as Naturezas x Tipo Inscri\u00e7\u00e3o.");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void carregarDados() throws BaseException {
        this.naturezasSolicitacaoTipoInscricao = ((FacadeNaturezaSolicitacaoTipoInscricao)SpringContext.getBean(FacadeNaturezaSolicitacaoTipoInscricao.class)).carregarNaturezasSolicitacaoTipoInscricao(null);
    }

    public void ativarOrDesativar(NaturezaSolicitacaoTipoInscricaoAlvaraEntity naturezaSolicitacaoTipoInscricaoAlvara) {
        try {
            naturezaSolicitacaoTipoInscricaoAlvara.setAtivo(!naturezaSolicitacaoTipoInscricaoAlvara.isAtivo());
            ((FacadeNaturezaSolicitacaoTipoInscricao)SpringContext.getBean(FacadeNaturezaSolicitacaoTipoInscricao.class)).salvarNaturezaSolicitacaoTipoInscricao(naturezaSolicitacaoTipoInscricaoAlvara);
            if (naturezaSolicitacaoTipoInscricaoAlvara.isAtivo()) {
                ShowMessage.addInfoMessage((String)"msg", (String)"Configura\u00e7\u00e3o ativada com sucesso.");
            } else {
                ShowMessage.addWarnMessage((String)"msg", (String)"Configura\u00e7\u00e3o desativada com sucesso.");
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)"Erro ao salvar.");
        }
    }
}

