/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeNaturezaSolicitacao;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.spring.SpringContext;
import java.io.Serializable;
import java.util.List;
import org.springframework.context.annotation.Scope;

@EloController(value="naturezaSolicitacaoAlvaraController")
@Scope(value="flow")
public class NaturezaSolicitacaoAlvaraController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 7301645462554798475L;
    private List<NaturezaSolicitacaoAlvaraEntity> naturezasSolicitacao;

    public List<NaturezaSolicitacaoAlvaraEntity> getNaturezasSolicitacao() {
        return this.naturezasSolicitacao;
    }

    public void setNaturezasSolicitacao(List<NaturezaSolicitacaoAlvaraEntity> naturezasSolicitacao) {
        this.naturezasSolicitacao = naturezasSolicitacao;
    }

    public void iniciar() {
        try {
            this.naturezasSolicitacao = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregarTodasNaturezasSolicitacao();
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"msg", (String)"Falha ao carregar as Naturezas.");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void salvar() {
        try {
            ((FacadeNaturezaSolicitacao)SpringContext.getBean(FacadeNaturezaSolicitacao.class)).salvarListaNaturezaSolicitacao(this.naturezasSolicitacao);
            ShowMessage.addInfoMessage((String)"msg", (String)"Salvo com Sucesso.");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)"Erro ao salvar.");
        }
    }
}

